<?php


abstract class BaseMenuItemForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'menu_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Menu'), 'add_empty' => false)),
      'submenu_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Submenu'), 'add_empty' => true)),
      'url_type' => new sfArtWidgetFormInputText(),
      'order' => new sfArtWidgetFormInputText(),
      'json' => new sfWidgetFormTextarea(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'menu_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Menu'))),
      'submenu_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Submenu'), 'required' => false)),
      'url_type' => new sfValidatorInteger(),
      'order' => new sfValidatorInteger(),
      'json' => new sfValidatorString(array('max_length' => 1000, 'required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'MenuItem', 'column' => array('menu_id', 'order')))
    );

    $this->widgetSchema->setNameFormat('menu_item[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'MenuItem';
  }

}
