<?php


abstract class BaseTagForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'articles_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Article')),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'articles_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Article', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('tag[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Tag';
  }

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['articles_list']))
      $this->setDefault('articles_list', $this->object->Articles->getPrimaryKeys());

  }

  protected function doSave($con = null)
  {
    $this->saveArticlesList($con);

    parent::doSave($con);
  }

  public function saveArticlesList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['articles_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Articles->getPrimaryKeys();
    $values = $this->getValue('articles_list');
    
    if (!$this->validatorSchema['articles_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Articles', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Articles', array_values($link));
  }

}
