<?php


abstract class BaseArtConfigurationForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'name' => new sfArtWidgetFormTextarea(),
      'editable' => new sfArtWidgetFormInputText(),
      'widget' => new sfArtWidgetFormTextarea(),
      'validator' => new sfArtWidgetFormTextarea(),
      'renderer' => new sfArtWidgetFormTextarea(),
      'default' => new sfArtWidgetFormTextarea(),
      'order' => new sfArtWidgetFormInputText(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'name' => new sfValidatorString(),
      'editable' => new sfValidatorInteger(array('required' => false)),
      'widget' => new sfValidatorString(array('required' => false)),
      'validator' => new sfValidatorString(array('required' => false)),
      'renderer' => new sfValidatorString(array('required' => false)),
      'default' => new sfValidatorString(array('required' => false)),
      'order' => new sfValidatorInteger(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'ArtConfiguration', 'column' => array('order')))
    );

    $this->widgetSchema->setNameFormat('art_configuration[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArtConfiguration';
  }

}
