<?php


abstract class BaseArtConfigurationTranslationForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'label' => new sfArtWidgetFormInputText(),
      'hint' => new sfArtWidgetFormTextarea(),
      'value' => new sfArtWidgetFormTextarea(),
      'lang' => new sfWidgetFormInputHidden(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'label' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'hint' => new sfValidatorString(array('required' => false)),
      'value' => new sfValidatorString(),
      'lang' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('lang')), 'empty_value' => $this->getObject()->get('lang'), 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('art_configuration_translation[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'ArtConfigurationTranslation';
  }

}
