<?php

/**
 * Param form base class.
 *
 * @method Param getObject() Returns the current form's model object
 *
 * @package    hotel
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrineFormGeneratedTemplate.php 29553 2010-05-20 14:33:00Z Kris.Wallsmith $
 */
abstract class BaseParamForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id'           => new sfWidgetFormInputHidden(),
      'module_id'    => new sfWidgetFormDoctrineChoice(array('model' => $this->getRelatedModelName('Module'), 'add_empty' => false)),
      'unique_name'  => new sfWidgetFormInputText(),
      'validator'    => new sfWidgetFormTextarea(),
      'widget'       => new sfWidgetFormTextarea(),
      'default'      => new sfWidgetFormTextarea(),
      'editable'     => new sfWidgetFormInputText(),
      'layouts_list' => new sfWidgetFormDoctrineChoice(array('multiple' => true, 'model' => 'Layout')),
    ));

    $this->setValidators(array(
      'id'           => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'module_id'    => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Module'))),
      'unique_name'  => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'validator'    => new sfValidatorString(array('required' => false)),
      'widget'       => new sfValidatorString(array('required' => false)),
      'default'      => new sfValidatorString(array('required' => false)),
      'editable'     => new sfValidatorInteger(array('required' => false)),
      'layouts_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Layout', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('param[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setupInheritance();

    parent::setup();
  }

  public function getModelName()
  {
    return 'Param';
  }

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['layouts_list']))
    {
      $this->setDefault('layouts_list', $this->object->Layouts->getPrimaryKeys());
    }

  }

  protected function doSave($con = null)
  {
    $this->saveLayoutsList($con);

    parent::doSave($con);
  }

  public function saveLayoutsList($con = null)
  {
    if (!$this->isValid())
    {
      throw $this->getErrorSchema();
    }

    if (!isset($this->widgetSchema['layouts_list']))
    {
      // somebody has unset this widget
      return;
    }

    if (null === $con)
    {
      $con = $this->getConnection();
    }

    $existing = $this->object->Layouts->getPrimaryKeys();
    $values = $this->getValue('layouts_list');
    if (!is_array($values))
    {
      $values = array();
    }

    $unlink = array_diff($existing, $values);
    if (count($unlink))
    {
      $this->object->unlink('Layouts', array_values($unlink));
    }

    $link = array_diff($values, $existing);
    if (count($link))
    {
      $this->object->link('Layouts', array_values($link));
    }
  }

}
