<?php


abstract class BaseBlacklistForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'user_id' => new sfWidgetFormInputHidden(),
      'ignored_user_id' => new sfWidgetFormInputHidden(),
    ));

    $this->setValidators(array(
      'user_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('user_id')), 'empty_value' => $this->getObject()->get('user_id'), 'required' => false)),
      'ignored_user_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('ignored_user_id')), 'empty_value' => $this->getObject()->get('ignored_user_id'), 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('blacklist[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Blacklist';
  }

}
