<?php


abstract class BaseInternalCategoryForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('sfGuardUser'), 'add_empty' => true)),
      'name' => new sfArtWidgetFormInputText(),
      'order' => new sfArtWidgetFormInputText(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardUser')),
      'internal_messages_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'InternalMessage')),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'required' => false)),
      'name' => new sfValidatorString(array('max_length' => 45)),
      'order' => new sfValidatorInteger(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardUser', 'required' => false)),
      'internal_messages_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'InternalMessage', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('internal_category[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'InternalCategory';
  }

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['users_list']))
      $this->setDefault('users_list', $this->object->Users->getPrimaryKeys());

    if (isset($this->widgetSchema['internal_messages_list']))
      $this->setDefault('internal_messages_list', $this->object->InternalMessages->getPrimaryKeys());

  }

  protected function doSave($con = null)
  {
    $this->saveUsersList($con);
    $this->saveInternalMessagesList($con);

    parent::doSave($con);
  }

  public function saveUsersList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['users_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Users->getPrimaryKeys();
    $values = $this->getValue('users_list');
    
    if (!$this->validatorSchema['users_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Users', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Users', array_values($link));
  }

  public function saveInternalMessagesList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['internal_messages_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->InternalMessages->getPrimaryKeys();
    $values = $this->getValue('internal_messages_list');
    
    if (!$this->validatorSchema['internal_messages_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('InternalMessages', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('InternalMessages', array_values($link));
  }

}
