<?php


abstract class BaseInternalMessageForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'internal_conversation_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('InternalConversation'), 'add_empty' => true)),
      'author_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('sfGuardAuthor'), 'add_empty' => true)),
      'receiver_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('sfGuardUser'), 'add_empty' => true)),
      'is_readed' => new sfArtWidgetFormInputText(),
      'title' => new sfArtWidgetFormInputText(),
      'description' => new sfArtWidgetFormTextarea(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'internal_categories_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'InternalCategory')),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardUser')),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'internal_conversation_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('InternalConversation'), 'required' => false)),
      'author_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardAuthor'), 'required' => false)),
      'receiver_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'required' => false)),
      'is_readed' => new sfValidatorInteger(array('required' => false)),
      'title' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'description' => new sfValidatorString(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
      'internal_categories_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'InternalCategory', 'required' => false)),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardUser', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('internal_message[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'InternalMessage';
  }

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['internal_categories_list']))
      $this->setDefault('internal_categories_list', $this->object->InternalCategories->getPrimaryKeys());

    if (isset($this->widgetSchema['users_list']))
      $this->setDefault('users_list', $this->object->Users->getPrimaryKeys());

  }

  protected function doSave($con = null)
  {
    $this->saveInternalCategoriesList($con);
    $this->saveUsersList($con);

    parent::doSave($con);
  }

  public function saveInternalCategoriesList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['internal_categories_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->InternalCategories->getPrimaryKeys();
    $values = $this->getValue('internal_categories_list');
    
    if (!$this->validatorSchema['internal_categories_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('InternalCategories', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('InternalCategories', array_values($link));
  }

  public function saveUsersList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['users_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Users->getPrimaryKeys();
    $values = $this->getValue('users_list');
    
    if (!$this->validatorSchema['users_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Users', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Users', array_values($link));
  }

}
