<?php


abstract class BaseMessageCenterFileForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'message_center_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('MessageCenter'), 'add_empty' => false)),
      'file' => new sfWidgetFormTextarea(),
      'original_filename' => new sfWidgetFormTextarea(),
      'order' => new sfArtWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'message_center_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('MessageCenter'))),
      'file' => new sfValidatorString(array('max_length' => 500)),
      'original_filename' => new sfValidatorString(array('max_length' => 500)),
      'order' => new sfValidatorInteger(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('message_center_file[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'MessageCenterFile';
  }

}
