<?php


abstract class BaseMessageMultisendHistoryForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'message_center_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('MessageCenter'), 'add_empty' => false)),
      'message_multisend_type_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('MessageMultisendType'), 'add_empty' => false)),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('sfGuardUser'), 'add_empty' => true)),
      'newsletter_user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('NewsletterUser'), 'add_empty' => true)),
      'title' => new sfWidgetFormTextarea(),
      'description' => new sfArtWidgetFormTextarea(),
      'status' => new sfArtWidgetFormInputText(),
      'error' => new sfWidgetFormTextarea(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'message_center_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('MessageCenter'))),
      'message_multisend_type_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('MessageMultisendType'))),
      'user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'required' => false)),
      'newsletter_user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('NewsletterUser'), 'required' => false)),
      'title' => new sfValidatorString(array('max_length' => 1000)),
      'description' => new sfValidatorString(),
      'status' => new sfValidatorInteger(array('required' => false)),
      'error' => new sfValidatorString(array('max_length' => 1000, 'required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('message_multisend_history[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'MessageMultisendHistory';
  }

}
