<?php


abstract class BaseNewsletterUserForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('sfGuardUser'), 'add_empty' => true)),
      'email' => new sfArtWidgetFormInputText(),
      'first_name' => new sfArtWidgetFormInputText(),
      'last_name' => new sfArtWidgetFormInputText(),
      'status' => new sfArtWidgetFormInputText(),
      'message_count' => new sfArtWidgetFormInputText(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUser'), 'required' => false)),
      'email' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'first_name' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'last_name' => new sfValidatorString(array('max_length' => 100, 'required' => false)),
      'status' => new sfValidatorInteger(array('required' => false)),
      'message_count' => new sfValidatorInteger(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorAnd(array(
        new sfValidatorDoctrineUnique(array('model' => 'NewsletterUser', 'column' => array('user_id'))),
        new sfValidatorDoctrineUnique(array('model' => 'NewsletterUser', 'column' => array('email'))),
      ))
    );

    $this->widgetSchema->setNameFormat('newsletter_user[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'NewsletterUser';
  }

}
