<?php


abstract class BaseGameForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'teacher_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Teacher'), 'add_empty' => false)),
      'name' => new sfArtWidgetFormInputText(),
      'status' => new sfArtWidgetFormInputText(),
      'game_data_json' => new sfArtWidgetFormTextarea(),
      'game_controller_class' => new sfArtWidgetFormInputText(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'teacher_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Teacher'))),
      'name' => new sfValidatorString(array('max_length' => 255)),
      'status' => new sfValidatorInteger(array('required' => false)),
      'game_data_json' => new sfValidatorString(array('required' => false)),
      'game_controller_class' => new sfValidatorString(array('max_length' => 125, 'required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('game[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Game';
  }

}
