<?php


abstract class BaseGameTeacherPermissionForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'sf_guard_user_permission_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('sfGuardUserPermission'), 'add_empty' => false)),
      'game_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Game'), 'add_empty' => false)),
      'teacher_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Teacher'), 'add_empty' => false)),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'sf_guard_user_permission_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('sfGuardUserPermission'))),
      'game_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Game'))),
      'teacher_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Teacher'))),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'GameTeacherPermission', 'column' => array('sf_guard_user_permission_id', 'game_id', 'teacher_id')))
    );

    $this->widgetSchema->setNameFormat('game_teacher_permission[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'GameTeacherPermission';
  }

}
