<?php


abstract class BaseLogDecisionForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'round_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Round'), 'add_empty' => false)),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('User'), 'add_empty' => false)),
      'decision' => new sfArtWidgetFormInputText(),
      'old_value' => new sfArtWidgetFormTextarea(),
      'new_value' => new sfArtWidgetFormTextarea(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'round_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Round'))),
      'user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('User'))),
      'decision' => new sfValidatorString(array('max_length' => 255)),
      'old_value' => new sfValidatorString(array('required' => false)),
      'new_value' => new sfValidatorString(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('log_decision[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'LogDecision';
  }

}
