<?php


abstract class BaseLogEventForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'team_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Team'), 'add_empty' => true)),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('User'), 'add_empty' => true)),
      'round_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Round'), 'add_empty' => true)),
      'event' => new sfArtWidgetFormInputText(),
      'text' => new sfArtWidgetFormTextarea(),
      'value' => new sfArtWidgetFormTextarea(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'team_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Team'), 'required' => false)),
      'user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('User'), 'required' => false)),
      'round_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Round'), 'required' => false)),
      'event' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'text' => new sfValidatorString(array('required' => false)),
      'value' => new sfValidatorString(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('log_event[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'LogEvent';
  }

}
