<?php


abstract class BaseMessageForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'team_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Team'), 'add_empty' => false)),
      'user_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('User'), 'add_empty' => false)),
      'round_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Round'), 'add_empty' => true)),
      'status' => new sfArtWidgetFormInputText(),
      'title' => new sfArtWidgetFormTextarea(),
      'category' => new sfArtWidgetFormInputText(),
      'body' => new sfArtWidgetFormTextarea(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'team_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Team'))),
      'user_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('User'))),
      'round_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Round'), 'required' => false)),
      'status' => new sfValidatorInteger(array('required' => false)),
      'title' => new sfValidatorString(array('required' => false)),
      'category' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'body' => new sfValidatorString(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
    ));

    $this->widgetSchema->setNameFormat('message[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Message';
  }

}
