<?php


abstract class BaseRoundForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'team_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Team'), 'add_empty' => false)),
      'round_number' => new sfArtWidgetFormInputText(),
      'status' => new sfArtWidgetFormInputText(),
      'name' => new sfArtWidgetFormInputText(),
      'round_data_json' => new sfArtWidgetFormTextarea(),
      'round_decision_data_json' => new sfArtWidgetFormTextarea(),
      'round_raport_data_json' => new sfArtWidgetFormTextarea(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'team_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Team'))),
      'round_number' => new sfValidatorInteger(),
      'status' => new sfValidatorInteger(array('required' => false)),
      'name' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'round_data_json' => new sfValidatorString(array('required' => false)),
      'round_decision_data_json' => new sfValidatorString(array('required' => false)),
      'round_raport_data_json' => new sfValidatorString(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorDoctrineUnique(array('model' => 'Round', 'column' => array('team_id', 'round_number')))
    );

    $this->widgetSchema->setNameFormat('round[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'Round';
  }

}
