<?php


abstract class BaseTeacherClassForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'teacher_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Teacher'), 'add_empty' => false)),
      'name' => new sfArtWidgetFormInputText(),
      'status' => new sfArtWidgetFormInputText(),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardUser')),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'teacher_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Teacher'))),
      'name' => new sfValidatorString(array('max_length' => 255)),
      'status' => new sfValidatorInteger(array('required' => false)),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardUser', 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('teacher_class[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'TeacherClass';
  }

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['users_list']))
      $this->setDefault('users_list', $this->object->Users->getPrimaryKeys());

  }

  protected function doSave($con = null)
  {
    $this->saveUsersList($con);

    parent::doSave($con);
  }

  public function saveUsersList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['users_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Users->getPrimaryKeys();
    $values = $this->getValue('users_list');
    
    if (!$this->validatorSchema['users_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Users', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Users', array_values($link));
  }

}
