<?php


abstract class BaseUserDetailForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'school' => new sfArtWidgetFormInputText(),
      'game_id' => new sfArtWidgetFormDoctrineJQueryMultiSelect(array('model' => $this->getRelatedModelName('Game'), 'add_empty' => true)),
      'phone' => new sfArtWidgetFormInputText(),
      'status' => new sfArtWidgetFormInputText(),
      'teacher_survey_before' => new sfArtWidgetFormTextarea(),
      'teacher_survey_after' => new sfArtWidgetFormTextarea(),
      'student_survey_before' => new sfArtWidgetFormTextarea(),
      'student_survey_after' => new sfArtWidgetFormTextarea(),
      'student_test_before' => new sfArtWidgetFormTextarea(),
      'student_test_after' => new sfArtWidgetFormTextarea(),
      'teacher_test_grade_before' => new sfArtWidgetFormTextarea(),
      'teacher_test_grade_after' => new sfArtWidgetFormTextarea(),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'school' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'game_id' => new sfValidatorDoctrineChoice(array('model' => $this->getRelatedModelName('Game'), 'required' => false)),
      'phone' => new sfValidatorString(array('max_length' => 45, 'required' => false)),
      'status' => new sfValidatorInteger(array('required' => false)),
      'teacher_survey_before' => new sfValidatorString(array('required' => false)),
      'teacher_survey_after' => new sfValidatorString(array('required' => false)),
      'student_survey_before' => new sfValidatorString(array('required' => false)),
      'student_survey_after' => new sfValidatorString(array('required' => false)),
      'student_test_before' => new sfValidatorString(array('required' => false)),
      'student_test_after' => new sfValidatorString(array('required' => false)),
      'teacher_test_grade_before' => new sfValidatorString(array('required' => false)),
      'teacher_test_grade_after' => new sfValidatorString(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('user_detail[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'UserDetail';
  }

}
