<?php


abstract class BaseUserTeamForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'user_id' => new sfWidgetFormInputHidden(),
      'team_id' => new sfWidgetFormInputHidden(),
      'role' => new sfArtWidgetFormInputText(),
    ));

    $this->setValidators(array(
      'user_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('user_id')), 'empty_value' => $this->getObject()->get('user_id'), 'required' => false)),
      'team_id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('team_id')), 'empty_value' => $this->getObject()->get('team_id'), 'required' => false)),
      'role' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
    ));

    $this->widgetSchema->setNameFormat('user_team[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'UserTeam';
  }

}
