<?php


abstract class BasesfGuardUserForm extends BaseFormDoctrine
{
  public function setup()
  {
    $this->setWidgets(array(
      'id' => new sfWidgetFormInputHidden(),
      'first_name' => new sfArtWidgetFormInputText(),
      'last_name' => new sfArtWidgetFormInputText(),
      'email_address' => new sfArtWidgetFormInputText(),
      'username' => new sfArtWidgetFormInputText(),
      'algorithm' => new sfArtWidgetFormInputText(),
      'salt' => new sfArtWidgetFormInputText(),
      'password' => new sfArtWidgetFormInputText(),
      'is_active' => new sfWidgetFormInputCheckbox(),
      'is_banned' => new sfWidgetFormInputCheckbox(),
      'is_super_admin' => new sfWidgetFormInputCheckbox(),
      'last_login' => new sfArtWidgetFormInputJQueryDateTime(),
      'password_expired' => new sfArtWidgetFormInputJQueryDateTime(),
      'created_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'updated_at' => new sfArtWidgetFormInputJQueryDateTime(),
      'groups_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardGroup')),
      'permissions_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'sfGuardPermission')),
      'teams_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'Team')),
      'message_centers_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'MessageCenter')),
      'internal_messages_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'InternalMessage')),
      'internal_categories_through_internal_message_category_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'InternalCategory')),
      'users_list' => new sfArtWidgetFormDoctrineJQueryMultiselect(array('multiple' => true, 'model' => 'TeacherClass')),
    ));

    $this->setValidators(array(
      'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
      'first_name' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'last_name' => new sfValidatorString(array('max_length' => 255, 'required' => false)),
      'email_address' => new sfValidatorString(array('max_length' => 255)),
      'username' => new sfValidatorString(array('max_length' => 128)),
      'algorithm' => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'salt' => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'password' => new sfValidatorString(array('max_length' => 128, 'required' => false)),
      'is_active' => new sfValidatorBoolean(array('required' => false)),
      'is_banned' => new sfValidatorBoolean(array('required' => false)),
      'is_super_admin' => new sfValidatorBoolean(array('required' => false)),
      'last_login' => new sfValidatorDateTime(array('required' => false)),
      'password_expired' => new sfValidatorDateTime(array('required' => false)),
      'created_at' => new sfValidatorDateTime(),
      'updated_at' => new sfValidatorDateTime(),
      'groups_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardGroup', 'required' => false)),
      'permissions_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'sfGuardPermission', 'required' => false)),
      'teams_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'Team', 'required' => false)),
      'message_centers_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'MessageCenter', 'required' => false)),
      'internal_messages_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'InternalMessage', 'required' => false)),
      'internal_categories_through_internal_message_category_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'InternalCategory', 'required' => false)),
      'users_list' => new sfValidatorDoctrineChoice(array('multiple' => true, 'model' => 'TeacherClass', 'required' => false)),
    ));

    $this->validatorSchema->setPostValidator(
      new sfValidatorAnd(array(
        new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('email_address'))),
        new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('username'))),
      ))
    );

    $this->widgetSchema->setNameFormat('sf_guard_user[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  public function getModelName()
  {
    return 'sfGuardUser';
  }

  public function updateDefaultsFromObject()
  {
    parent::updateDefaultsFromObject();

    if (isset($this->widgetSchema['groups_list']))
      $this->setDefault('groups_list', $this->object->Groups->getPrimaryKeys());

    if (isset($this->widgetSchema['permissions_list']))
      $this->setDefault('permissions_list', $this->object->Permissions->getPrimaryKeys());

    if (isset($this->widgetSchema['teams_list']))
      $this->setDefault('teams_list', $this->object->Teams->getPrimaryKeys());

    if (isset($this->widgetSchema['message_centers_list']))
      $this->setDefault('message_centers_list', $this->object->MessageCenters->getPrimaryKeys());

    if (isset($this->widgetSchema['internal_messages_list']))
      $this->setDefault('internal_messages_list', $this->object->InternalMessages->getPrimaryKeys());

    if (isset($this->widgetSchema['internal_categories_through_internal_message_category_list']))
      $this->setDefault('internal_categories_through_internal_message_category_list', $this->object->InternalCategoriesThroughInternalMessageCategory->getPrimaryKeys());

    if (isset($this->widgetSchema['users_list']))
      $this->setDefault('users_list', $this->object->Users->getPrimaryKeys());

  }

  protected function doSave($con = null)
  {
    $this->saveGroupsList($con);
    $this->savePermissionsList($con);
    $this->saveTeamsList($con);
    $this->saveMessageCentersList($con);
    $this->saveInternalMessagesList($con);
    $this->saveInternalCategoriesThroughInternalMessageCategoryList($con);
    $this->saveUsersList($con);

    parent::doSave($con);
  }

  public function saveGroupsList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['groups_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Groups->getPrimaryKeys();
    $values = $this->getValue('groups_list');
    
    if (!$this->validatorSchema['groups_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Groups', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Groups', array_values($link));
  }

  public function savePermissionsList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['permissions_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Permissions->getPrimaryKeys();
    $values = $this->getValue('permissions_list');
    
    if (!$this->validatorSchema['permissions_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Permissions', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Permissions', array_values($link));
  }

  public function saveTeamsList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['teams_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Teams->getPrimaryKeys();
    $values = $this->getValue('teams_list');
    
    if (!$this->validatorSchema['teams_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Teams', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Teams', array_values($link));
  }

  public function saveMessageCentersList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['message_centers_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->MessageCenters->getPrimaryKeys();
    $values = $this->getValue('message_centers_list');
    
    if (!$this->validatorSchema['message_centers_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('MessageCenters', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('MessageCenters', array_values($link));
  }

  public function saveInternalMessagesList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['internal_messages_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->InternalMessages->getPrimaryKeys();
    $values = $this->getValue('internal_messages_list');
    
    if (!$this->validatorSchema['internal_messages_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('InternalMessages', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('InternalMessages', array_values($link));
  }

  public function saveInternalCategoriesThroughInternalMessageCategoryList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['internal_categories_through_internal_message_category_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->InternalCategoriesThroughInternalMessageCategory->getPrimaryKeys();
    $values = $this->getValue('internal_categories_through_internal_message_category_list');
    
    if (!$this->validatorSchema['internal_categories_through_internal_message_category_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('InternalCategoriesThroughInternalMessageCategory', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('InternalCategoriesThroughInternalMessageCategory', array_values($link));
  }

  public function saveUsersList($con = null)
  {
    if (!$this->isValid())
      throw $this->getErrorSchema();

    if (!isset($this->widgetSchema['users_list']))
      return;

    if (null === $con)
      $con = $this->getConnection();

    $existing = $this->object->Users->getPrimaryKeys();
    $values = $this->getValue('users_list');
    
    if (!$this->validatorSchema['users_list']->getOption('multiple', true))
      $values = (array)$values;
    else if (!is_array($values))
      $values = array();

    $unlink = array_diff($existing, $values);
    
    if (count($unlink))
      $this->object->unlink('Users', array_values($unlink));

    $link = array_diff($values, $existing);
    
    if (count($link))
      $this->object->link('Users', array_values($link));
  }

}
