<?php

/**
 * sfGuardUser form.
 *
 * @package    hotel
 * @subpackage form
 * @author     Your name here
 * @version    SVN: $Id: sfDoctrinePluginFormTemplate.php 23810 2009-11-12 11:07:44Z Kris.Wallsmith $
 */
class sfGuardUserForm extends PluginsfGuardUserForm {

  public function configure() {
    $this->useFields(array(
        'id', 'first_name', 'last_name', 'email_address',
    ));

    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'first_name' => new sfValidatorString(array('max_length' => 255, 'min_length' => 3, 'required' => true)),
        'last_name' => new sfValidatorString(array('max_length' => 255, 'min_length' => 2, 'required' => true)),
        'email_address' => new sfValidatorEmail(array('max_length' => 255)),
    ));
    $this->validatorSchema->setPostValidator(
            new sfValidatorAnd(array(
                new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('email_address'))),
            ))
    );
  }

  public function save($con = null) {
    $this->values['username'] = $this->values['email_address'];

    $group = Doctrine::getTable('sfGuardGroup')->findOneByName('user');
    $this->getObject()->getGroups()->add($group);
    $this->getObject()->setIsActive(1);
    return parent::save($con);
  }

  public function bind(array $taintedValues = null, array $taintedFiles = null) {

     $classId = $this->getUser()->getAttribute('class_id', false);
    
    // zlicza ilosc uczniow dla danej klasy (do ograniczenia w koncie demo)
    $usersCount = Doctrine_Core::getTable('sfGuardUser')->createQuery('u')
            ->leftJoin('u.ClassUser chu')
            ->where('chu.class_id = ?', $classId)
            ->count();

    if (($usersCount == 0 && $this->getUser()->isTeacherDemo()) || !($this->getObject()->isNew() && $this->getUser()->isTeacherDemo())) {
      parent::bind($taintedValues, $taintedFiles);
    } else {
      $validator = new sfValidatorString(array('max_length' => 255));
      $error = new sfValidatorError($validator, _('To jest konto demo, możesz mieć tylko jedną grę.'));
      $e = new sfValidatorErrorSchema($validator, array('name' => $error));

      $this->errorSchema = $e;
    }
  }

}
