<?php

/**
 * Formularz backendowy zmiany artykułu
 * @subpackage artCmsPlugin

 */
class FlatyArticleForm extends PluginFlatyArticleForm {
  public function configure() {
    $this->useFields(array('id', 'unique_name'));

    foreach ($this->getPreferredCulture() as $culture) {
      $this->embedForm($culture, new FlatyArticleTranslationForm($this->getObject()->Translation[$culture]));
    }

    $this->widgetSchema->setLabel('unique_name', 'Nazwa unikalna');
    $this->widgetSchema->setLabels($this->getCultureLabels());

    foreach ($this->getFormFieldSchema() as $name => $field) {
      $this->getWidget($name)->setAttribute('class', 'form-control');
    }

    $this->disableRequiredsFieldText();
    $this->getWidgetSchema()->setFormFormatterName('Flaty');
  }
}
