<?php

/**
 * Formularz rejestracji ucznia do gry
 */
class sfGuardRegisterForm extends PluginsfGuardRegisterForm {

  public function configure() {
    
    $this->setWidgets(array(
        'id' => new sfWidgetFormInputHidden(),
        'game_name' => new sfArtWidgetFormInputText(array('label' => 'Nazwa gry')),
        'first_name' => new sfArtWidgetFormInputText(),
        'last_name' => new sfArtWidgetFormInputText(),
        'email_address' => new sfArtWidgetFormInputText(),
        'password' => new sfArtWidgetFormInputPassword(),
    ));
    
    $this->setValidators(array(
        'id' => new sfValidatorChoice(array('choices' => array($this->getObject()->get('id')), 'empty_value' => $this->getObject()->get('id'), 'required' => false)),
        'game_name' => new hotelGameNameValidator(array('max_length' => 255, 'min_length' => 4, 'required' => true)),
        'first_name' => new sfValidatorString(array('max_length' => 255, 'min_length' => 3, 'required' => true)),
        'last_name' => new sfValidatorString(array('max_length' => 255, 'min_length' => 3, 'required' => true)),
        'email_address' => new sfValidatorEmail(array('max_length' => 255)),
        'password' => new sfValidatorString(array('max_length' => 128, 'min_length' => 6), array('max_length' => 'Hasło nie powinno przekraczać 255 znaków', 'min_length' => 'Hasło jest za krótkie')),
    ));

    
    $this->validatorSchema->setPostValidator(
            new sfValidatorAnd(array(
                new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('email_address')), array('invalid' => 'Podany e-mail istnieje już w naszej bazie. Proszę wybierz inny.')),
                new sfValidatorDoctrineUnique(array('model' => 'sfGuardUser', 'column' => array('username'))),
            ))
    );
    
    $this->mergePostValidator(new sfValidatorSchemaCompare('password', sfValidatorSchemaCompare::EQUAL, 'password_again', array(), array('invalid' => 'Podane hasła muszą być identyczne')));

    $this->widgetSchema['password_again'] = new sfArtWidgetFormInputPassword();
    $this->validatorSchema['password_again'] = clone $this->validatorSchema['password'];
    $this->validatorSchema['password_again']->setOption('required', true);


    $this->widgetSchema->setNameFormat('sf_guard_user_register[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->disableRequiredsFieldText();

    $custom_decorator = new sfWidgetFormSchemaFormatterDefault($this->getWidgetSchema());
    $this->getWidgetSchema()->addFormFormatter('Default', $custom_decorator);
    $this->getWidgetSchema()->setFormFormatterName('Default');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
    $this->setupInheritance();
  }

  /**
   * Dodatkowo zapisuje uzytkownika do grupy teacher lub teacher_demo oraz uzupelnia UserDetails
   * @param type $con
   * @return object
   */
  public function save($con = null) {
    $this->values['username'] = $this->values['email_address'];
    $user = parent::save($con);
    $currentUserId = $user->getId();

    $group = Doctrine::getTable('sfGuardGroup')->findOneByName('user');
    $game = Doctrine::getTable('Game')->findOneByName($this->values['game_name']);
    $this->setUserGroup($currentUserId, $group->getId());
    $this->setUserDetailsData($currentUserId, $game->getId());
    
    return $user;
  }

  /**
   * Ustawia grupę dla tworzonego użytkownika.
   * 
   * @param int $currentUserId
   * @param int $groupId
   */
  public function setUserGroup($currentUserId, $groupId) {
    $userGroup = new SfGuardUserGroup();
    $userGroup->setUserId($currentUserId);
    $userGroup->setGroupId($groupId);
    $userGroup->save();
  }
  
  /**
   * Ustawia dane dla tworzonego użytkownika.
   * Na razie tylko nazwa szkoły.
   * 
   * @param int $currentUserId
   */
  public function setUserDetailsData($currentUserId, $gameId) {
    $ud = new UserDetail();
    $ud->setId($currentUserId);
    $ud->setSchool(null);
    $ud->setGameId($gameId);
    $ud->save();
  }
}