<?php

class sfHotelFormField extends sfFormField {

  public function renderRow($attributes = array(), $label = null, $help = null, $info = null) {

    if (null === $this->parent) {
      throw new LogicException(sprintf('Unable to render the row for "%s".', $this->name));
    }

    $field = $this->parent->getWidget()->renderField($this->name, $this->value, !is_array($attributes) ? array() : $attributes, $this->error);
    $error = $this->error instanceof sfValidatorErrorSchema ? $this->error->getGlobalErrors() : $this->error;

    $help = null === $help ? $this->parent->getWidget()->getHelp($this->name) : $help;
    $info = null === $info ? $this->parent->getWidget()->getInfo($this->name) : $info;

  $decorator = new artWidgetFormSchemaFormatterDefault($this->parent->widgetSchema);

    return strtr($decorator->formatRow($this->renderLabel($label), $field, $error, $help), array('%hidden_fields%' => ''));
  }
  
}