<?php


class artWidgetFormSchemaFormatterDefault extends artWidgetFormSchemaFormatter
{
    protected
        $rowFormat = '
          <div class="fl widget-help %class%-help  %standard%"> 
            %help%
          </div>
          <div class="control-group fl %is_error% %class%  %standard%">
              %label%
              %error%
              <div class="controls">
                  %field%
                  %hidden_fields%
                  <div class="spin"></div>
              </div>
              <div class="fieldInfo">%info%</div>
          </div>
          <div class="clear %class%-clear"></div>',
        $helpFormat = '
            <a title="%help%" 
            data-toggle="tooltip" tooltip="true"
            href="#">
              <i class="hotel-icon-empty">?</i>
            </a>',
        $infoFormat = '%info%',
        $errorRowFormat = '%errors%',
        $errorListFormatInARow = "<div class=\"errors \">\n%errors%</div>\n",
        $errorRowFormatInARow = "<span class='w100 fl'> <i class='icon-error fl'></i> %error%</span>\n",
        $namedErrorRowFormatInARow = "<span class='w100 fl'>%name%: %error%</span>\n",
        $decoratorFormat = '',
        $widgetSchema = null,
        $translationCatalogue = 'messages';


    public function setRowFormat($format)
    {
        $this->rowFormat = $format;
    }

    public function generateLabel($name, $attributes = array())
    {
        $labelName = $this->generateLabelName($name);

        if (false === $labelName) {
            return '';
        }

        if (!isset($attributes['for'])) {
            $attributes['for'] = $this->widgetSchema->generateId($this->widgetSchema->generateName($name));

            if (isset($attributes['class'])) {
                $attributes['class'] .= 'control-label';
            } else {
                $attributes['class'] = 'control-label';
            }
        }

        return $this->widgetSchema->renderContentTag('label', $labelName, $attributes);
    }
}
