<?php

/**
 * Klasa formularza decyzji dla gry Hotel. 
 * Zwiera wszystkie decyzje podejmowane w grze. 
 * Wartość decyzji jest przeliczana podczas podejmownaia decyzji jak równieć podczas przej ścia do nowej rundy. 
 * 
 * @make HotelGameDecision
 * @validate HotelGameValidator
 * @used HotelGameProcess 
 */
class HotelDecisionForm extends BaseDecisionForm {

    public function configure() {
        // DECYZJE WSTĘPNE | RUNDA 1
        
        $userId = $this->gameController->getUserId();
        
        if ($this->gameController->e('ankiety_przed_user_' . $userId, 'decision') && $this->gameController->e('testy_przed_user_' . $userId, 'decision')) {
            $this->setWidget('komiks_rok1', new sfWidgetFormInputHidden(array()));
            $this->setValidator('komiks_rok1', new sfValidatorPass());
            $this->setDefault('komiks_rok1', 1);
        }

        if ($this->gameController->gRN() == 5) {
            $this->setWidget('komiks_rok2', new sfWidgetFormInputHidden(array()));
            $this->setValidator('komiks_rok2', new sfValidatorPass());
            $this->setDefault('komiks_rok2', 1);
        }

        if ($this->gameController->gRN() == 9) {
            $this->setWidget('komiks_rok3', new sfWidgetFormInputHidden(array()));
            $this->setValidator('komiks_rok3', new sfValidatorPass());
            $this->setDefault('komiks_rok3', 1);
        }

        if ($this->gameController->gRN() == 13) {
            $this->setWidget('komiks_rok4', new sfWidgetFormInputHidden(array()));
            $this->setValidator('komiks_rok4', new sfValidatorPass());
            $this->setDefault('komiks_rok4', 1);
        }

        if ($this->gameController->gRN() == 17) {
            $this->setWidget('komiks_koniec', new sfWidgetFormInputHidden(array()));
            $this->setValidator('komiks_koniec', new sfValidatorPass());
            $this->setDefault('komiks_koniec', 1);
        }

        $this->setWidget('badanie_marketingowe_1_tresc', new sfWidgetFormInputHidden(array('default' => 0), array('class' => 'hide')));
        $this->setValidator('badanie_marketingowe_1_tresc', new sfValidatorBoolean());

        $this->setWidget('nazwa_marki', new sfArtWidgetFormInputText());
        $this->setValidator('nazwa_marki', new sfValidatorString(array('required' => true)));

        $fileName = $this->gameController->g('logo_marki', 'decision', FALSE);

        $this->setWidget('logo_marki', new sfHotelWidgetFormImageInput(array(
            'file_src' => ($fileName) ? HotelGameView::getLogoImagePath() . $fileName : '/images/hotel/AAAAAA&text=brak+loga.gif',
            'edit_mode' => true,
            'is_image' => true,
            'with_delete' => false
        )));

        $this->setValidator('logo_marki', new sfArtValidatorFile(array(
            'path' => HotelGameView::getLogoImageAbsolutePath(),
            'max_size' => 4194304,
            'resize_size_width' => sfConfig::get('app_game_logo_width', 250),
            'resize_size_height' => sfConfig::get('app_game_logo_height', 250),
            'required' => false
                ))
        );

        $this->setValidator('logo_marki_delete', new sfValidatorBoolean());

        $wybor_lokalizacji_choices = HotelGameDecision::getLokalizacje();
        $wybor_lokalizacji_widget = new sfHotelWidgetFormChoice(array('choices' => $wybor_lokalizacji_choices));

        $this->setWidget('wybor_lokalizacji', new sfHotelWidgetFormChoice(array('expanded' => true
            , 'choices' => $wybor_lokalizacji_choices, 'multiple' => false
            , 'renderer_options' => array('formatter' => array($wybor_lokalizacji_widget, 'formatter')))));

        $this->setValidator('wybor_lokalizacji', new sfValidatorChoice(array('required' => false, 'choices' => array_keys($wybor_lokalizacji_choices))));
        $this->getWidgetSchema()->setLabel('wybor_lokalizacji', 'Wybór lokalizacji');


        $this->setWidget('wybor_loga', new hotelWidgetLogo(array(), array('style' => 'display: none !important;')));
        $this->setValidator('wybor_loga', new sfValidatorPass());

        $this->setWidget('opis_interfejsu', new sfWidgetFormInputHidden(array('is_hidden' => false)));
        $this->setValidator('opis_interfejsu', new sfValidatorPass());
        $this->setDefault('opis_interfejsu', 1);

        // MODEL ZATRUDNIENIA
        // Pracownicy obslugi
        $this->setWidget('pracownicy_obslugi_stale_liczba', new sfArtWidgetFormInputText());
        $this->setValidator('pracownicy_obslugi_stale_liczba', new hotelValidatorInteger(array('required' => false, 'min' => 0)));

        $this->setWidget('pracownicy_obslugi_stale_wynagrodzenie', new hotelWidgetMoney());
        $this->setValidator('pracownicy_obslugi_stale_wynagrodzenie', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        $this->setWidget('pracownicy_obslugi_stale_motywacja_procent', new sfArtWidgetFormInputText());
        $this->setValidator('pracownicy_obslugi_stale_motywacja_procent', new hotelValidatorNumber(array('required' => false, 'min' => 0, 'max' => 100)));

        $this->setWidget('pracownicy_obslugi_zlecenie_liczba', new sfArtWidgetFormInputText());
        $this->setValidator('pracownicy_obslugi_zlecenie_liczba', new hotelValidatorInteger(array('required' => false, 'min' => 0)));

        $this->setWidget('pracownicy_obslugi_zlecenie_wynagrodzenie', new hotelWidgetMoney());
        $this->setValidator('pracownicy_obslugi_zlecenie_wynagrodzenie', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        $this->setWidget('pracownicy_obslugi_zlecenie_motywacja_procent', new sfArtWidgetFormInputText());
        $this->setValidator('pracownicy_obslugi_zlecenie_motywacja_procent', new hotelValidatorNumber(array('required' => false, 'min' => 0, 'max' => 100)));

        // Pracownicy administracji
        $this->setWidget('pracownicy_administracji_stale_liczba', new sfArtWidgetFormInputText());
        $this->setValidator('pracownicy_administracji_stale_liczba', new hotelValidatorInteger(array('required' => false, 'min' => 0)));

        $this->setWidget('pracownicy_administracji_stale_wynagrodzenie', new hotelWidgetMoney());
        $this->setValidator('pracownicy_administracji_stale_wynagrodzenie', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        $this->setWidget('pracownicy_administracji_stale_motywacja_procent', new sfArtWidgetFormInputText());
        $this->setValidator('pracownicy_administracji_stale_motywacja_procent', new hotelValidatorNumber(array('required' => false, 'min' => 0, 'max' => 100)));

        $this->setWidget('pracownicy_administracji_zlecenie_liczba', new sfArtWidgetFormInputText());
        $this->setValidator('pracownicy_administracji_zlecenie_liczba', new hotelValidatorInteger(array('required' => false, 'min' => 0)));

        $this->setWidget('pracownicy_administracji_zlecenie_wynagrodzenie', new hotelWidgetMoney());
        $this->setValidator('pracownicy_administracji_zlecenie_wynagrodzenie', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        $this->setWidget('pracownicy_administracji_zlecenie_motywacja_procent', new sfArtWidgetFormInputText());
        $this->setValidator('pracownicy_administracji_zlecenie_motywacja_procent', new hotelValidatorNumber(array('required' => false, 'min' => 0, 'max' => 100)));

        // Hotel Pokoje Inwestycje
        // WAZNE: Pokoje musza byc ustawiane przed wyposazeniem (dla walidatorow)
        //dla kupna/sprzedazy pokoi standard/lux
        $widgetP = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getPokojeInwestycje()
            , 'multiple' => false));

        $widgetPL = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getPokojeInwestycje()
            , 'multiple' => false));

        $this->setWidget('pokoje_standard', $widgetP);
        $this->setWidget('pokoje_lux', $widgetPL);

        $this->setValidator('pokoje_standard', new sfHotelValidatorChoice(array('required' => false
            , 'choices' => HotelGameDecision::getPokojeInwestycje()), array('invalid' => 'Nie można kupić takiej ilości pokoi')));
        $this->setValidator('pokoje_lux', new sfHotelValidatorChoice(array('required' => false
            , 'choices' => HotelGameDecision::getPokojeInwestycje()), array('invalid' => 'Nie można kupić takiej ilości pokoi')));

        $pokoje_standard_wyposazenie_choices = HotelGameDecision::getWyposazenieStandard();
        $pokoje_standard_wyposazenie_widget = new sfHotelWidgetFormChoice(array('choices' => $pokoje_standard_wyposazenie_choices));

        $this->setWidget('pokoje_standard_wyposazenie'
                , new sfHotelWidgetFormChoice(
                array('expanded' => true, 'choices' => $pokoje_standard_wyposazenie_choices, 'multiple' => false, 'renderer_options' => array('formatter' => array($pokoje_standard_wyposazenie_widget, 'formatter')))
        ));
        $this->setValidator('pokoje_standard_wyposazenie', new sfValidatorChoice(array('required' => false, 'choices' => array_keys($pokoje_standard_wyposazenie_choices))));
        $this->setDefault('pokoje_standard_wyposazenie', $this->gameController->getGameDecision()->gWS());

        $pokoje_lux_wyposazenie_choices = HotelGameDecision::getWyposazenieLux();
        $pokoje_lux_wyposazenie_widget = new sfHotelWidgetFormChoice(array('choices' => $pokoje_lux_wyposazenie_choices));

        $this->setWidget('pokoje_lux_wyposazenie', new sfHotelWidgetFormChoice(array('expanded' => true, 'choices' => $pokoje_lux_wyposazenie_choices, 'multiple' => false, 'renderer_options' => array('formatter' => array($pokoje_lux_wyposazenie_widget, 'formatter')))));
        $this->setValidator('pokoje_lux_wyposazenie', new sfValidatorChoice(array('required' => false, 'choices' => array_keys($pokoje_lux_wyposazenie_choices))));
        $this->setDefault('pokoje_lux_wyposazenie', $this->gameController->getGameDecision()->gWL());

        //dla decyzji tak/nie
        $widgetYN = new sfHotelWidgetFormBtnChoice(
                array('choices' => $this->gameController->getGameDecision()->getTakNie()
            , 'multiple' => false));

        //dla decyzji kierowniczka
        $widgetKier = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getKierowniczka()
            , 'multiple' => false));


        $this->setWidget('pokoje_standard', new sfHotelWidgetFormInput(array(), array()));
        $this->setWidget('pokoje_lux', new sfHotelWidgetFormInput(array(), array()));

        $this->setWidget('cena_pokoje_standard', new sfArtWidgetFormInputText(array(), array('standard' => 'standard')));
        $this->setValidator('cena_pokoje_standard', new hotelValidatorNumber(array('required' => false, 'min' => 0)));
        $this->setWidget('cena_pokoje_lux', new sfArtWidgetFormInputText(array(), array('standard' => 'lux')));
        $this->setValidator('cena_pokoje_lux', new hotelValidatorNumber(array('required' => false, 'min' => 0)));
        $this->getWidgetSchema()->setLabel('cena_pokoje_standard', 'Cena pokoje Standard');
        $this->getWidgetSchema()->setLabel('cena_pokoje_lux', 'Cena pokoje Delux');

        // MODEL REKLAMY. 
        $reklamy = array(
            'media_lokalne_ulotki',
            'media_lokalne_plakaty',
            'media_lokalne_bilboardy',
            'media_lokalne_prasa',
            'media_lokalne_radio',
            'media_regionalne_prasa',
            'media_regionalne_tv',
            'media_regionalne_radio',
            'media_krajowe_tv',
            'media_krajowe_prasa',
            'media_krajowe_radio',
        );
        $this->setIntegerWidgets($reklamy);

        $strony = HotelGameDecision::getStronaInternetowa();

        $widget = new sfHotelWidgetFormChoice(array('choices' => $strony));

        $this->setWidget('strona_internetowa', new sfHotelWidgetFormChoice(array('expanded' => true, 'multiple' => false,
            'choices' => $strony, 'renderer_options' => array('formatter' => array($widget, 'formatter'))
        )));
        $this->setDefault('strona_internetowa', $this->gameController->getGameDecision()->g('strona_internetowa', 'decision'));

        $this->setValidator('strona_internetowa', new sfValidatorChoice(array('required' => false, 'choices' => array_keys($strony))));


        // BADANIA 
        $badania = array(
            'badanie_marketingowe_popyt_standard',
            'badanie_marketingowe_uslugi_podstawowe',
            'badanie_marketingowe_sezonowosc',
            'badanie_marketingowe_popyt_lux',
            'badanie_marketingowe_reklama_zaawansowana',
            'badanie_marketingowe_konkurencja',
            'badanie_marketingowe_uslugi_zaawansowane_segmentacja'
        );

        $this->setYesNoWidgets2($badania, $widgetYN);

        /** Kredyty */
        $this->setWidget('kredyt_inwestycyjny_kwota', new hotelWidgetMoney(array('default' => 0)));
        $this->setValidator('kredyt_inwestycyjny_kwota', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        $this->setWidget('kredyt_obrotowy_kwota', new hotelWidgetMoney(array('default' => 0)));
        $this->setValidator('kredyt_obrotowy_kwota', new hotelValidatorNumber(array('required' => false, 'min' => 0)));
        $this->setWidget('kredyt_obrotowy_splata', new hotelWidgetMoney(array('default' => 0)));
        $this->setValidator('kredyt_obrotowy_splata', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        $this->setWidget('lokata_kwota', new hotelWidgetMoney(array('default' => 0)));
        $this->setValidator('lokata_kwota', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        $this->setWidget('lokata_splata', new hotelWidgetMoney(array('default' => 0)));
        $this->setValidator('lokata_splata', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        // POZOSTALE USLUGI
        $uslugi = array(
            'taxi',
            'sejf',
            'budzenie',
            'rejestracja_na_stronie_www',
        );

        $this->setYesNoWidgets2($uslugi, $widgetYN);

        $segmentacja = array(
            'wspolpraca_urzad_pracy',
            'wspolpraca_biurami_podrozy',
            'mozliwosc_odebrania_gosci',
            'ochronka_dla_dzieci',
            'business_lounge',
            'sala_konferencyjna',
            'automaty_vendingowe',
            'ekspresy_czajniki',
            'pokoj_zabaw_dla_dzieci',
            'golf',
            'wyciag_narciarski',
            'plaza',
        );
        $this->setYesNoWidgets2($segmentacja, $widgetYN);

        /** Sniadania */
        $this->setWidget('sniadania_kwota', new sfHotelWidgetFormSlider(array('default' => 0), array('min' => 0, 'max' => 15)));
        $this->setValidator('sniadania_kwota', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        /** Sprzatanie outsourcing */
        $this->setWidget('sprzatanie_outsourcing_standard_kwota', new hotelWidgetMoney());
        $this->setValidator('sprzatanie_outsourcing_standard_kwota', new hotelValidatorNumber(array('required' => false, 'min' => 0)));
        $this->setWidget('sprzatanie_outsourcing_lux_kwota', new hotelWidgetMoney(array(), array('standard' => 'lux')));
        $this->setValidator('sprzatanie_outsourcing_lux_kwota', new hotelValidatorNumber(array('required' => false, 'min' => 0)));

        /** Pranie outsourcing */
        $this->setWidget('pranie_outsourcing_standard_kwota', new hotelWidgetMoney());
        $this->setValidator('pranie_outsourcing_standard_kwota', new hotelValidatorNumber(array('required' => false, 'min' => 0)));
        $this->setWidget('pranie_outsourcing_lux_kwota', new hotelWidgetMoney(array(), array('standard' => 'lux')));
        $this->setValidator('pranie_outsourcing_lux_kwota', new hotelValidatorNumber(array('required' => false, 'min' => 0)));
        // $this->widgetSchema->setHelp('pranie_outsourcing_lux_kwota', __t('pranie_outsourcing_lux_info'));
        // EVENTY
        $events = array(
            'event_festiwal_filmowy',
            'event_zimowisko',
            'event_podjazd_dla_niepelnosprawnych',
            'event_pralnia_ekologiczna',
            'event_akcja_charytatywna',
            'event_stop_umowom_smieciowym',
            'event_mikolajkowy_ekspres',
            'event_szkolenie',
        );

        $this->setWidget('event_panele', new sfArtWidgetFormInputText(array('default' => 0)));
        $this->setValidator('event_panele', new hotelValidatorInteger(array('required' => false, 'min' => 0)));

        $this->setYesNoWidgets2($events, $widgetYN);

        // Usługi dla eventów sezonowości
        $uslugiEvents = array(
            'usluga_plaza',
            'usluga_wyciag_narciarski',
            'usluga_golf',
        );
        $this->setYesNoWidgets2($uslugiEvents, $widgetYN);

        $this->setWidget('event_sadzenie_drzew', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getSadzenieDrzew()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetP, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_sadzenie_drzew', new sfValidatorChoice(array('required' => false
            , 'choices' => array_keys(HotelGameDecision::getSadzenieDrzew()))));

        $this->setWidget('event_kierowniczka', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getKierowniczka()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetKier, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_kierowniczka', new sfValidatorChoice(array('required' => false, 'choices' => array_keys(HotelGameDecision::getKierowniczka()))));

        /*         * ANKIETY * */

        $widgetW = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getWahania()
            , 'multiple' => false));
        $this->setWidget('event_wahania', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getWahania()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetW, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_wahania', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getWahania()))));
        // $this->setValidator('event_wahania', new sfValidatorPass());

        $widgetK = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getKoszty()
            , 'multiple' => false));
        $this->setWidget('event_koszty', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getKoszty()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetK, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_koszty', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getKoszty()))));

        $widgetO = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getOdsetki()
            , 'multiple' => false));
        $this->setWidget('event_odsetki', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getOdsetki()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetO, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_odsetki', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getOdsetki()))));

        $widgetK1 = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getKredyt()
            , 'multiple' => false));
        $this->setWidget('event_kredyt', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getKredyt()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetK1, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_kredyt', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getKredyt()))));

        $widgetB = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getBank()
            , 'multiple' => false));
        $this->setWidget('event_bank', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getBank()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetB, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_bank', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getBank()))));

        $widgetZm = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getZmienne()
            , 'multiple' => false));
        $this->setWidget('event_zmienne', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getZmienne()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetZm, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_zmienne', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getZmienne()))));

        $widgetOd = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getOdsetkiK()
            , 'multiple' => false));
        $this->setWidget('event_odsetkik', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getOdsetkiK()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetOd, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_odsetkik', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getOdsetkiK()))));

        $widgetKr = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getKredytowa()
            , 'multiple' => false));
        $this->setWidget('event_kredytowa', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getKredytowa()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetKr, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_kredytowa', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getKredytowa()))));

        $widgetUs = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getUsługi()
            , 'multiple' => false));
        $this->setWidget('event_usługi', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getUsługi()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetUs, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_usługi', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getUsługi()))));

        $widgetSt = new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getStrategia()
            , 'multiple' => false));
        $this->setWidget('event_strategia', new sfHotelWidgetFormBtnChoice(
                array('choices' => HotelGameDecision::getStrategia()
            , 'expanded' => true
            , 'renderer_options' => array('formatter' => array($widgetSt, 'formatter'))
            , 'multiple' => false)));
        $this->setValidator('event_strategia', new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getStrategia()))));


//    for ($i = 1;$i<=13 ;$i++){
//        $this->setWidget('ankieta_przed_'.$i, new sfHotelWidgetFormSlider(array('default' => 4), array('min' => 1, 'max' => 7)));
//        $this->setValidator('ankieta_przed_'.$i, new hotelValidatorNumber(array('required' => false, 'min' => 1)));
//    }
//    
//    for ($i = 1;$i<=22 ;$i++){
//        $this->setWidget('ankieta_po_'.$i, new sfHotelWidgetFormSlider(array('default' => 4), array('min' => 1, 'max' => 7)));
//        $this->setValidator('ankieta_po_'.$i, new hotelValidatorNumber(array('required' => false, 'min' => 1)));
//    }
        for ($i = 1; $i <= 13; $i++) {

            $widgetSt = new sfHotelWidgetFormBtnChoice(
                    array('choices' => HotelGameDecision::getNumb()
                , 'multiple' => false));

            $this->setWidget('ankieta_przed_' . $i, new sfHotelWidgetFormBtnChoice(
                    array('choices' => HotelGameDecision::getNumb()
                , 'expanded' => true
                , 'renderer_options' => array('formatter' => array($widgetSt, 'formatter'))
                , 'multiple' => false)));

            $this->setValidator('ankieta_przed_' . $i, new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getNumb()))));
        }


        for ($i = 1; $i <= 22; $i++) {

            $widgetSt = new sfHotelWidgetFormBtnChoice(
                    array('choices' => HotelGameDecision::getNumb()
                , 'multiple' => false));

            $this->setWidget('ankieta_po_' . $i, new sfHotelWidgetFormBtnChoice(
                    array('choices' => HotelGameDecision::getNumb()
                , 'expanded' => true
                , 'renderer_options' => array('formatter' => array($widgetSt, 'formatter'))
                , 'multiple' => false)));

            $this->setValidator('ankieta_po_' . $i, new sfValidatorChoice(array('required' => true, 'choices' => array_keys(HotelGameDecision::getNumb()))));
        }

        for ($i = 1; $i <= 11; $i++) {
            $this->setWidget('test_przed_' . $i, new sfWidgetFormTextarea(array(), array('standard' => 'standard', 'class' => 'szer')));
            $this->setValidator('test_przed_' . $i, new sfValidatorString(array('required' => true)));
            //$this->setValidator('test_przed_'.$i, new sfValidatorPass());
        }

        for ($i = 1; $i <= 11; $i++) {
            $this->setWidget('test_po_' . $i, new sfWidgetFormTextarea(array(), array('standard' => 'standard', 'class' => 'szer')));
            $this->setValidator('test_po_' . $i, new sfValidatorString(array('required' => true)));
            //$this->setValidator('test_po_'.$i, new sfValidatorPass());
        }


        $this->disableRequiredsFieldText();
        $decorator = new sfWidgetFormSchemaFormatterDefault($this->getWidgetSchema());

        $this->getWidgetSchema()->addFormFormatter('Default', $decorator);
        $this->getWidgetSchema()->setFormFormatterName('Default');
        $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

        $this->setInfoLabels($this->gameController);
        $this->setHelpLabels($this->gameController);
        parent::configure();
    }

    /**
     * Ustawia pola formularza z wigetem wpisania liczby dla wszystkich elementów podanych w tablicy. 
     *  
     * @param array $fields
     */
    public function setNumberWidgets($fields) {

        foreach ($fields as $field) {
            $this->setWidget($field, new sfArtWidgetFormInputText(array('default' => 0)));
            $this->setValidator($field, new hotelValidatorNumber(array('required' => false, 'min' => 0)));
        }
    }

    /**
     * Ustawia pola formularza z wigetem wpisania liczby dla wszystkich elementów podanych w tablicy. 
     *  
     * @param array $fields
     */
    public function setIntegerWidgets($fields) {

        foreach ($fields as $field) {
            $this->setWidget($field, new sfArtWidgetFormInputText(array('default' => 0)));
            $this->setValidator($field, new hotelValidatorInteger(array('required' => false, 'min' => 0)));
        }
    }

    /**
     * Ustawia pola formularza z wigetem wyboru tak nie dla wszystkich elemntów podanych w tablicy. 
     *  
     * @param type $fields
     */
    public function setYesNoWidgets($fields) {

        foreach ($fields as $field) {
            $this->setWidget($field, new sfArtWidgetFormChoice(array('choices' => $this->gameController->getGameDecision()->getTakNie(), 'multiple' => false, 'default' => 0)));
            $this->setValidator($field, new sfValidatorChoice(array('required' => false, 'choices' => array_keys($this->gameController->getGameDecision()->getTakNie()))));
        }
    }

    public function setYesNoWidgets2($fields, $widget) {

        foreach ($fields as $field) {
            $this->setWidget($field, new sfHotelWidgetFormBtnChoice(
                    array('choices' => $this->gameController->getGameDecision()->getTakNie()
                , 'expanded' => true
                , 'default' => 0
                , 'renderer_options' => array('formatter' => array($widget, 'formatter'))
                , 'multiple' => false)
                    )
            );
            $this->setValidator($field, new sfValidatorChoice(array('required' => false
                , 'choices' => array_keys($this->gameController->getGameDecision()->getTakNie()))));
        }
    }

    /**
     * Ustawia podpowiedzi do wszystkich widgetów.
     */
    protected function setInfoLabels(HotelGameController $gc) {

        $fields = $this->getWidgetSchema()->getFields();
        unset($fields['timestamp']
                , $fields['_csrf_token']
                , $fields['wybor_lokalizacji']
                , $fields['cena_pokoje_standard']
                , $fields['cena_pokoje_lux']
                , $fields['pracownicy_obslugi_stale_liczba']
                , $fields['pracownicy_obslugi_stale_wynagrodzenie']
                , $fields['pracownicy_obslugi_stale_motywacja_procent']
                , $fields['pracownicy_obslugi_zlecenie_liczba']
                , $fields['pracownicy_obslugi_zlecenie_wynagrodzenie']
                , $fields['pracownicy_obslugi_zlecenie_motywacja_procent']
                , $fields['pracownicy_administracji_stale_liczba']
                , $fields['pracownicy_administracji_stale_wynagrodzenie']
                , $fields['pracownicy_administracji_stale_motywacja_procent']
                , $fields['pracownicy_administracji_zlecenie_liczba']
                , $fields['pracownicy_administracji_zlecenie_wynagrodzenie']
                , $fields['pracownicy_administracji_zlecenie_motywacja_procent']
        );

        foreach ($fields as $name => $field) {

            $prepareFunction = 'getInfo' . sfInflector::camelize($name);

            $params = sfContext::getInstance()->getRequest()->getParameterHolder()->getAll();

            if (isset($params['decision_form'][$name])) {
                $value = $params['decision_form'][$name];
            } else {
                $value = $gc->g($name, 'decision');
            }

            if (method_exists('HotelGameView', $prepareFunction)) {
                $info = HotelGameView::$prepareFunction($gc, $value, $name);
                $this->widgetSchema->setInfo($name, $info);
            } else {

                if (!$this->widgetSchema->getInfo($name)) {

                    $value = 0;

                    $info = __t($name . '_info', array(), 'game_info');

                    $format = '<span class="hiden" widgetvalue="%s"></span> %s';

                    $this->widgetSchema->setInfo($name, sprintf($format, $value, $info));
                }
            }

            $this->widgetSchema->setLabel($name, __t($name, array(), 'messages'));
        }
    }

    /**
     * Ustawia podpowiedzi do wszystkich widgetów.
     */
    protected function setHelpLabels(HotelGameController $gc) {

        $fields = $this->getWidgetSchema()->getFields();

        unset(
                $fields['timestamp']
                , $fields['_csrf_token']
                , $fields['wybor_lokalizacji']
                , $fields['strona_internetowa']
                , $fields['pokoje_standard_wyposazenie']
                , $fields['pokoje_lux_wyposazenie']
                , $fields['pracownicy_obslugi_stale_liczba']
                , $fields['pracownicy_obslugi_stale_wynagrodzenie']
                , $fields['pracownicy_obslugi_stale_motywacja_procent']
                , $fields['pracownicy_obslugi_zlecenie_liczba']
                , $fields['pracownicy_obslugi_zlecenie_wynagrodzenie']
                , $fields['pracownicy_obslugi_zlecenie_motywacja_procent']
                , $fields['pracownicy_administracji_stale_liczba']
                , $fields['pracownicy_administracji_stale_wynagrodzenie']
                , $fields['pracownicy_administracji_stale_motywacja_procent']
                , $fields['pracownicy_administracji_zlecenie_liczba']
                , $fields['pracownicy_administracji_zlecenie_wynagrodzenie']
                , $fields['pracownicy_administracji_zlecenie_motywacja_procent']
        );
    }

    /**
     * Ustawia pola z widgetow ktore maja byc uzupelniona wartosciami default
     */
    protected function setFieldsWithDefaults() {
        parent::setFieldsWithDefaults();

        if ($this->gameController->gPO() > 0) {
            $this->setDefault('sprzatanie_outsourcing_standard_kwota', 0);
            $this->setDefault('sprzatanie_outsourcing_lux_kwota', 0);
        }

        if ($this->gameController->getGameProcess()->wspEventPralniaEkologiczna() == 1) {
            $this->setDefault('pranie_outsourcing_standard_kwota', 0);
            $this->setDefault('pranie_outsourcing_lux_kwota', 0);
        }
    }

    public function pictureRadioFormatterCallback($widget, $inputs) {
        $rows = array();
        foreach ($inputs as $input) {


            $rows[] = $widget->renderContentTag('li', $input['input']);
        }

        return !$rows ?
                '' :
                $widget->renderContentTag('ul', implode($widget->getOption('separator'), $rows), array('class' => $widget->getOption('class')));
    }

}
