<?php

/**
 * Klasa zarzadzana dla gry Hotel
 *
 */
class HotelGameController extends BaseGameController {

    protected static $prefix = 'Hotel';
    public static $instance;

    public function __construct($teamId = null, $userId = null) {
        self::$instance = parent::__construct($teamId, $userId);
    }

    public static function getInstance() {

        if (!isset(self::$instance)) {
            $c = __CLASS__;

            self::$instance = new $c(sfContext::getInstance()->getUser()->getActiveTeamId(), sfContext::getInstance()->getUser()->getId());
        }

        return self::$instance;
    }

    public function prepareTabHotelCeny() {

        $useFields = array();


        if ($this->rGT(1)) {
            $useFields[] = 'cena_pokoje_standard';
        }

        if ($this->rGT(5)) {
            $useFields[] = 'cena_pokoje_lux';
        };


        if ($this->rGT(2)) {
            $this->partials = array(
                'wykres_cen' => array('gc' => $this)
            );
        }

        return $useFields;
    }

    public function postPrepareTabHotelCeny($form, $useFields) {
        if (!($this->gLPS() > 0) && in_array('cena_pokoje_standard', $useFields)) {
            $form->getWidget('cena_pokoje_standard')->setAttribute('disabled', 'disabled');
        }

        if (!($this->gLPL() > 0) && in_array('cena_pokoje_lux', $useFields)) {
            $form->getWidget('cena_pokoje_lux')->setAttribute('disabled', 'disabled');
        }
    }

    public function prepareTabHotelWyposazenie() {

        $useFields = array();

        if ($this->rGT(1)) {
            $useFields[] = 'pokoje_standard_wyposazenie';
        }

        if ($this->rGT(5)) {
            $useFields[] = 'pokoje_lux_wyposazenie';
        }

        return $useFields;
    }

    public function postPrepareTabHotelWyposazenie($form, $useFields) {
        if (!($this->gLPS() > 0) && in_array('pokoje_standard_wyposazenie', $useFields)) {
            $form->getWidget('pokoje_standard_wyposazenie')->setAttribute('disabled', 'disabled');
        }

        if (!($this->gLPL() > 0) && in_array('pokoje_lux_wyposazenie', $useFields)) {
            $form->getWidget('pokoje_lux_wyposazenie')->setAttribute('disabled', 'disabled');
        }
    }

    public function prepareTabHotelInwestycje() {

        $useFields = array('pokoje_standard');

        if ($this->rGT(4)) {
            $useFields[] = 'pokoje_lux';
        }

        return $useFields;
    }

    public function postPrepareTabHotelInwestycje($form, $useFields) {

        if (in_array('pokoje_lux', $useFields)) {
            $form->getWidget('pokoje_lux')->setAttribute('standard', 'lux');
        }
    }

    public function postPrepareTabHotelObslugaStandard($form, $useFields) {

        if ($this->g('event_pralnia_ekologiczna', 'decision', 0) || (!($this->gLPS() > 0) && in_array('pranie_outsourcing_standard_kwota', $useFields))) {
            $form->getWidget('pranie_outsourcing_standard_kwota')->setAttribute('disabled', 'disabled');
        }

        if ($this->gPO() > 0 || (!($this->gLPS() > 0) && in_array('sprzatanie_outsourcing_standard_kwota', $useFields))) {
            $form->getWidget('sprzatanie_outsourcing_standard_kwota')->setAttribute('disabled', 'disabled');
        }
    }

    public function postPrepareTabHotelObslugaLux($form, $useFields) {

        if ($this->g('event_pralnia_ekologiczna', 'decision', 0) || (!($this->gLPL() > 0) && in_array('pranie_outsourcing_lux_kwota', $useFields))) {
            $form->getWidget('pranie_outsourcing_lux_kwota')->setAttribute('disabled', 'disabled');
        }

        if ($this->gPO() > 0 || (!($this->gLPL() > 0) && in_array('sprzatanie_outsourcing_lux_kwota', $useFields))) {
            $form->getWidget('sprzatanie_outsourcing_lux_kwota')->setAttribute('disabled', 'disabled');
        }
    }

    public function prepareTabHotelObslugaStandard() {

        $useFields = array();

        if ($this->rGT(1)) {
            $useFields[] = 'sprzatanie_outsourcing_standard_kwota';
            $useFields[] = 'pranie_outsourcing_standard_kwota';
        }

        return $useFields;
    }

    public function prepareTabHotelObslugaLux() {

        $useFields = array();

        if ($this->rGT(5)) {
            $useFields[] = 'sprzatanie_outsourcing_lux_kwota';
            $useFields[] = 'pranie_outsourcing_lux_kwota';
        }


        return $useFields;
    }

    public function prepareTabHotelPromocja() {

        $useFields = array();

        if ($this->rGT(1)) {
            $useFields[] = 'strona_internetowa';
        }

        if ($this->rEQ(4) || $this->rEQ(5)) {
            $useFields[] = 'media_lokalne_ulotki';
            $useFields[] = 'media_lokalne_plakaty';
        }

        return $useFields;
    }

//    public function postPrepareTabHotelUslugiPodstawowe($form, $useFields) {
//      if (isset($form['usluga_wyciag_narciarski']) && !$this->getGameProcess()->isUslugaEventActive('usluga_wyciag_narciarski')) {
//        $form->getWidget('usluga_wyciag_narciarski')->setAttribute('disabled', 'disabled');
//      }
//      if (isset($form['usluga_plaza']) && !$this->getGameProcess()->isUslugaEventActive('usluga_plaza')) {
//        $form->getWidget('usluga_plaza')->setAttribute('disabled', 'disabled');
//      }
//      if (isset($form['usluga_golf']) && !$this->getGameProcess()->isUslugaEventActive('usluga_golf')) {
//        $form->getWidget('usluga_golf')->setAttribute('disabled', 'disabled');
//      }
//    }

    public function prepareTabHotelUslugiPodstawowe() {

        $useFields = array();

        if ($this->rGT(3)) {
            $useFields[] = 'sniadania_kwota';
        }

        if ($this->rGT(2)) {
            $useFields[] = 'taxi';
            $useFields[] = 'sejf';
            $useFields[] = 'budzenie';
            $useFields[] = 'rejestracja_na_stronie_www';
        }

        if ($this->rGT(5)) {
            $useFields[] = 'usluga_wyciag_narciarski';
        }
        if ($this->rGT(6)) {
            $useFields[] = 'usluga_plaza';
        }
        if ($this->rGT(7)) {
            $useFields[] = 'usluga_golf';
        }


        return $useFields;
    }

    public function prepareTabHotelUslugiZaawansowane() {
        $useFields = array();

        if ($this->rGT(13)) {
            $useFields[] = 'pokoj_zabaw_dla_dzieci';
            $useFields[] = 'ochronka_dla_dzieci';
            $useFields[] = 'sala_konferencyjna';
            $useFields[] = 'wspolpraca_urzad_pracy';
            $useFields[] = 'wspolpraca_biurami_podrozy';
            $useFields[] = 'mozliwosc_odebrania_gosci';
            $useFields[] = 'business_lounge';
            $useFields[] = 'ekspresy_czajniki';
            $useFields[] = 'automaty_vendingowe';
        }

        return $useFields;
    }

    public function prepareTabHotelZatrudnienie() {
        $useFields = array();

        if ($this->rGT(8)) {
            $useFields[] = 'pracownicy_obslugi_stale_liczba';
            $useFields[] = 'pracownicy_obslugi_stale_wynagrodzenie';
            $useFields[] = 'pracownicy_obslugi_stale_motywacja_procent';
            $useFields[] = 'pracownicy_obslugi_zlecenie_liczba';
            $useFields[] = 'pracownicy_obslugi_zlecenie_wynagrodzenie';
            $useFields[] = 'pracownicy_obslugi_zlecenie_motywacja_procent';
        }

        if ($this->rGT(9)) {
            $useFields[] = 'pracownicy_administracji_stale_liczba';
            $useFields[] = 'pracownicy_administracji_stale_wynagrodzenie';
            $useFields[] = 'pracownicy_administracji_stale_motywacja_procent';
            $useFields[] = 'pracownicy_administracji_zlecenie_liczba';
            $useFields[] = 'pracownicy_administracji_zlecenie_wynagrodzenie';
            $useFields[] = 'pracownicy_administracji_zlecenie_motywacja_procent';
        }

        return $useFields;
    }

    public function postPrepareTabHotelZatrudnienie($form, $useFields) {
        $this->noForm = true;
        $this->partials = array(
            'zatrudnienie' => array('gc' => $this, 'form' => $form)
        );
    }

    public function prepareTabBankKredyty() {
        $useFields = array();

        if ($this->rGT(4)) {
            $useFields[] = 'kredyt_obrotowy_kwota';
            $useFields[] = 'kredyt_obrotowy_splata';

            if ($this->rLT(9) && $this->g('kredyt_inwestycyjny_kwota', 'last_decision') == 0) {
                $useFields[] = 'kredyt_inwestycyjny_kwota';
            }
        }

        return $useFields;
    }

    public function postPrepareTabBankKredyty($form, $useFields) {
        $this->noForm = true;
        $this->partials = array(
            'bank_kredyty' => array()
        );
    }

    public function prepareTabBankLokata() {

        $useFields = array();

        if ($this->rGT(4)) {
            $useFields[] = 'lokata_kwota';
            $useFields[] = 'lokata_splata';
        }

        return $useFields;
    }

    public function postPrepareTabBankLokata($form, $useFields) {
        $this->noForm = true;
        $this->partials = array(
            'bank_lokata' => array()
        );
    }

    public function prepareTabAgencjaBadaniaMarketingowe() {
        $useFields = array();
        $useFields[] = 'badanie_marketingowe_popyt_standard';

        if ($this->rGT(2)) {
            $useFields[] = 'badanie_marketingowe_uslugi_podstawowe';
        }

        if ($this->rGT(4)) {
            $useFields[] = 'badanie_marketingowe_sezonowosc';
        }

        if ($this->rGT(5)) {
            $useFields[] = 'badanie_marketingowe_popyt_lux';
            $useFields[] = 'badanie_marketingowe_reklama_zaawansowana';
        }

        if ($this->rGT(12)) {
            $useFields[] = 'badanie_marketingowe_konkurencja';
        }

        if ($this->rGT(13)) {
            $useFields[] = 'badanie_marketingowe_uslugi_zaawansowane_segmentacja';
        }

        return $useFields;
    }

    public function postPrepareTabAgencjaBadaniaMarketingowe($form, $useFields) {
        foreach ($useFields as $nazwa) {
            if ($this->getGameProcess()->hasResearch($nazwa)) {
                $form->getWidget($nazwa)->setAttribute('disabled', 'disabled');
            }
        }
    }

    public function prepareTabAgencjaMediaLokalne() {

        $useFields = array();

        if ($this->rGT(5)) {
            $useFields[] = 'media_lokalne_bilboardy';
            $useFields[] = 'media_lokalne_prasa';
            $useFields[] = 'media_lokalne_radio';
        }

        return $useFields;
    }

    public function prepareTabAgencjaMediaRegionalne() {
        $useFields = array();

        if ($this->rGT(5)) {
            $useFields[] = 'media_regionalne_radio';
            $useFields[] = 'media_regionalne_tv';
            $useFields[] = 'media_regionalne_prasa';
        }

        return $useFields;
    }

    public function prepareTabAgencjaMediaKrajowe() {
        $useFields = array();

        if ($this->rGT(12)) {
            $useFields[] = 'media_krajowe_radio';
            $useFields[] = 'media_krajowe_tv';
            $useFields[] = 'media_krajowe_prasa';
        }

        return $useFields;
    }

    public function prepareTabUrzadPracyInformacje() {
        $useFields = array();

        if ($this->rGT(8)) {
            // Zwracamy cokolwiek zeby bylo ze jest zakladka i tak tego nie uzywamy w partialu
            $useFields[] = 'pokoje_standard';
        }

        return $useFields;
    }

    public function postPrepareTabUrzadPracyInformacje($form, $useFields) {
        $uniqueName = 'urzad-pracy-informacje';

        $article = Doctrine::getTable('Article')->findOneByUniqueName($uniqueName);

        if (!$article) {
            throw new sfException('Brak artykułu o unique_name "' . $uniqueName . '".');
        }

        $description = $this->getGameMessage()->prepareStringWithParams($article->getDescription());
        $this->noForm = true;
        $this->partials = array(
            'urzad_pracy_informacje' => array('articleId' => $article->getId(), 'description' => $description)
        );
    }

    public function prepareTabUrzadPracyStawkiPlac() {
        $useFields = array();

        if ($this->rGT(8)) {
            // Zwracamy cokolwiek zeby bylo ze jest zakladka i tak tego nie uzywamy w partialu
            $useFields[] = 'pokoje_standard';
        }

        return $useFields;
    }

    public function postPrepareTabUrzadPracyStawkiPlac($form, $useFields) {
        $uniqueName = 'urzad-pracy-stawki-plac';
        $article = Doctrine::getTable('Article')->findOneByUniqueName($uniqueName);
        if (!$article) {
            throw new sfException('Brak artykułu o unique_name "' . $uniqueName . '".');
        }

        $description = $this->getGameMessage()->prepareStringWithParams($article->getDescription());
        $this->noForm = true;
        $this->partials = array(
            'urzad_pracy_stawki_plac' => array('articleId' => $article->getId(), 'description' => $description)
        );
    }

    public function prepareTabRatuszAktualneProjekty() {
        $useFields = array();

        if ($this->rEQ(2)) {
            $useFields[] = 'event_festiwal_filmowy';
        }
        if ($this->rEQ(6)) {
            $useFields[] = 'wyciag_narciarski';
        }
        if ($this->rEQ(7)) {
            $useFields[] = 'plaza';
        }
        if ($this->rEQ(8)) {
            $useFields[] = 'event_zimowisko';
            $useFields[] = 'golf';
        }
        if ($this->rEQ(10)) {
            $useFields[] = 'event_stop_umowom_smieciowym';
        }
        if ($this->rEQ(11)) {
            $useFields[] = 'event_kierowniczka';
        }
        if ($this->rEQ(11)) {
            $useFields[] = 'event_akcja_charytatywna';
        }
        if ($this->rEQ(12)) {
            $useFields[] = 'event_pralnia_ekologiczna';
            $useFields[] = 'event_szkolenie';
            $useFields[] = 'event_podjazd_dla_niepelnosprawnych';
        }
        if ($this->rEQ(15)) {
            $useFields[] = 'event_mikolajkowy_ekspres';
        }

        if ($this->rGT(6)) {
            // Zostaja zawsze po wprowadzeniu bo mozemy kupic je kiedy chcemy
            $useFields[] = 'event_panele';
        }
        if ($this->rGT(5) && $this->rLT(9) && $this->g('event_sadzenie_drzew', 'last_decision') < 3) {
            $useFields[] = 'event_sadzenie_drzew';
        }

        return $useFields;
    }

    public function prepareTabRatuszHistoriaProjektow() {
        $useFields = array();

        if ($this->rGT(2)) {
            $useFields[] = 'event_festiwal_filmowy';

            if ($this->rGT(8) || ($this->g('event_sadzenie_drzew', 'last_decision') == 3 && $this->rGT(6))) {
                $useFields[] = 'event_sadzenie_drzew';
            }
        }

        if ($this->rGT(6)) {
            $useFields[] = 'wyciag_narciarski';
        }
        if ($this->rGT(7)) {
            $useFields[] = 'plaza';
        }
        if ($this->rGT(8)) {
            $useFields[] = 'event_zimowisko';
            $useFields[] = 'golf';
        }
        if ($this->rGT(10)) {
            $useFields[] = 'event_stop_umowom_smieciowym';
        }
        if ($this->rGT(11)) {
            $useFields[] = 'event_kierowniczka';
        }

        if ($this->rGT(11)) {
            $useFields[] = 'event_akcja_charytatywna';
        }

        if ($this->rGT(12)) {
            $useFields[] = 'event_pralnia_ekologiczna';
            $useFields[] = 'event_szkolenie';
            $useFields[] = 'event_podjazd_dla_niepelnosprawnych';
        }

        if ($this->rGT(15)) {
            $useFields[] = 'event_mikolajkowy_ekspres';
        }

        return $useFields;
    }

    public function postPrepareTabRatuszHistoriaProjektow($form, $useFields) {
        foreach ($useFields as $field) {
            $form->getWidget($field)->setAttribute('disabled', 'disabled');
        }
    }

    /**
     * Zwraca nazwe zakladki jaka ma sie domyslnie wyswietlic
     * @return string Unikalna nazwa zakladki
     * @throws sfException
     */
    public function getTabUniqueName() {

        if (!$this->e('ankiety_przed_user_' . $this->userId, 'decision')) {
                $user = Doctrine::getTable('UserDetail')->findOneById($this->userId);
		if ($user->getStudentSurveyBefore() === null) {
			return 'ankieta_przed';
		}
        }

        if (!$this->e('testy_przed_user_' . $this->userId, 'decision')) {
		$user = Doctrine::getTable('UserDetail')->findOneById($this->userId);
                if ($user->getStudentTestBefore() === null) {
                        return 'test_przed';
                }
//            return 'test_przed';
        }

        if ($this->rEQ(1)) {
            if (!$this->e('komiks_rok1', 'decision')) {
                return 'komiks_rok1';
            }

            if (!($this->g('nazwa_marki', 'decision', false))) {
                return 'tworzenie_marki';
            }

            if (!$this->e('badanie_marketingowe_popyt_standard', 'decision')) {
                return 'badanie_marketingowe_popyt_standard';
            }

            if (!$this->g('badanie_marketingowe_1_tresc', 'decision') && $this->g('badanie_marketingowe_popyt_standard', 'decision')) {
                return 'b_m_tresc';
            }
        }

        if (!$this->e('wybor_lokalizacji', 'decision')) {
            return 'wybor_lokalizacji';
        }

        if ($this->rEQ(5)) {
            if (!$this->e('komiks_rok2', 'decision')) {
                return 'komiks_rok2';
            }
        }

        if ($this->rEQ(9)) {
            if (!$this->e('komiks_rok3', 'decision')) {
                return 'komiks_rok3';
            }
        }

        if ($this->rEQ(13)) {
            if (!$this->e('komiks_rok4', 'decision')) {
                return 'komiks_rok4';
            }
        }

        if ($this->rEQ(17)) {


            if (!$this->e('ankiety_po_user_' . $this->userId, 'decision')) {
                return 'ankieta_po';
            }

            if (!$this->e('testy_po_user_' . $this->userId, 'decision')) {
                return 'test_po';
            }
            if (!$this->e('komiks_koniec', 'decision')) {
                return 'komiks_koniec';
            }
        }

        return 'mapa';
    }

    /**
     * Kazda z funkcji operuje na obiekcie formularza i ustawia uzywane pola
     * na podstawie parametrow gry lub ogolnie przyjetych zalozen.
     * W przypadku proby otworzenia zakladki w nieodpowiednim stanie gry funkcja
     * zwraca false. Moze dodatkowo ustawiac zmienna partials.
     */
    protected function prepareTabMapa() {

        $this->partials = array(
            'mapa' => array()
        );

        return array();
    }

    protected function postPrepareTabMapa($form, $useFields) {
        $this->partials = array(
            'mapa' => array()
        );
    }

    protected function prepareTabAnkietaPrzed($form) {

        $useFields = array();

        for ($i = 1; $i <= 13; $i++) {
            $useFields[] = 'ankieta_przed_' . $i;
        }

        return $useFields;
    }

    protected function prepareTabAnkietaPo($form) {

        $useFields = array();

        for ($i = 1; $i <= 22; $i++) {
            $useFields[] = 'ankieta_po_' . $i;
        }

        return $useFields;
    }

    protected function prepareTabTestPrzed($form) {

        $useFields = array();

        for ($i = 1; $i <= 2; $i++) {
            $useFields[] = 'test_przed_' . $i;
        }
        $useFields[] = 'event_wahania';
        $useFields[] = 'event_koszty';
        for ($i = 3; $i <= 4; $i++) {
            $useFields[] = 'test_przed_' . $i;
        }
        $useFields[] = 'event_odsetki';
        $useFields[] = 'event_kredyt';
        $useFields[] = 'event_bank';
        for ($i = 5; $i <= 11; $i++) {
            $useFields[] = 'test_przed_' . $i;
        }

        return $useFields;
    }

    protected function prepareTabTestPo($form) {

        $useFields = array();

        for ($i = 1; $i <= 2; $i++) {
            $useFields[] = 'test_po_' . $i;
        }
        $useFields[] = 'event_zmienne';
        for ($i = 3; $i <= 4; $i++) {
            $useFields[] = 'test_po_' . $i;
        }
        $useFields[] = 'event_odsetkik';
        $useFields[] = 'event_kredytowa';
        $useFields[] = 'event_usługi';
        for ($i = 5; $i <= 10; $i++) {
            $useFields[] = 'test_po_' . $i;
        }
        $useFields[] = 'event_strategia';
        $useFields[] = 'test_po_11';

        return $useFields;
    }

    protected function prepareTabKomiksRok1($form) {

        $this->partials = array(
            'komiks_rok1' => array()
        );

        return array('komiks_rok1');
    }

    protected function prepareTabKomiksRok2($form) {

        $this->partials = array(
            'komiks_rok2' => array()
        );

        return array('komiks_rok2');
    }

    protected function prepareTabKomiksRok3($form) {

        $this->partials = array(
            'komiks_rok3' => array()
        );

        return array('komiks_rok3');
    }

    protected function prepareTabKomiksRok4($form) {

        $this->partials = array(
            'komiks_rok4' => array()
        );

        return array('komiks_rok4');
    }

    protected function prepareTabKomiksKoniec($form) {

        $this->partials = array(
            'komiks_koniec' => array()
        );

        return array('komiks_koniec');
    }

    protected function prepareTabTworzenieMarki($form) {
        $this->partials = array(
            'logo_firmy' => array('gc' => $this)
        );
        $useFields = array();
        $useFields[] = 'nazwa_marki';
//        $useFields[] = 'logo_marki';
        $useFields[] = 'wybor_loga';
        return $useFields;
    }

    protected function postPrepareTabTworzenieMarki($form, $useFields) {
        
    }

    protected function prepareTabOpisInterfejsu($form) {

        $this->partials = array(
            'opis_interfejsu' => array()
        );

        return array('opis_interfejsu');
    }

    protected function prepareTabBadanieMarketingowePopytStandard($form) {

        if (!$this->rEQ(1)) {
            return array();
        }

        return array('badanie_marketingowe_popyt_standard');
    }

    protected function prepareTabBMTresc($form) {

        $this->s('badanie_marketingowe_1_tresc', TRUE, 'decision');

        $messages = Doctrine::getTable('Message')->findByUserId($this->getUserId());
        
//        foreach ($messages as $messageSingle) {
//            if ($messageSingle->getTitle() == 'Badanie marketingowe - charakterystyka rynku hotelarskiego w Pekunii') {
//                $message = $messageSingle->toArray();
//            }
//        }

        $message = $messages->getLast()->toArray();

        $this->partials = array(
            'badanie_marketingowe_1_tresc' => array(
                'message' => $message
            )
        );

        return array('badanie_marketingowe_1_tresc');
    }

    protected function prepareTabWyborLokalizacji($form) {

        return array('wybor_lokalizacji');
    }

    /**
     * @param type $form
     * @return boolean
     */
    protected function prepareTabZakladkaTestowa($form) {
        $this->partials = array(
            'zakladka_testowa' => array('gameController' => $this)
        );

        return array();
    }

    protected function prepareTabListaDecyzji() {
        return array('pokoje_standard');
    }

    protected function postPrepareTabListaDecyzji($form, $useFields) {
        $this->partials = array(
            'lista_decyzji' => array('gameController' => $this)
        );
    }

}
