<?php

/**
 * Klasa podejmowania decyzji z formularza dla gry Hotel
 */
class HotelGameDecision extends BaseGameDecision {

    /**
     * g pobiera,
     * s zapisuje.
     */
    public function __construct(BaseGameController $gameController) {
        parent::__construct($gameController);

        $this->logger = sfContext::getInstance()->getLogger();
    }

    /** ANKIETY */
    public function makeAnkietaPrzed1($value) {
        $this->AnkietyPrzed(1, $value);
    }

    public function makeAnkietaPrzed2($value) {
        $this->AnkietyPrzed(2, $value);
    }

    public function makeAnkietaPrzed3($value) {
        $this->AnkietyPrzed(3, $value);
    }

    public function makeAnkietaPrzed4($value) {
        $this->AnkietyPrzed(4, $value);
    }

    public function makeAnkietaPrzed5($value) {
        $this->AnkietyPrzed(5, $value);
    }

    public function makeAnkietaPrzed6($value) {
        $this->AnkietyPrzed(6, $value);
    }

    public function makeAnkietaPrzed7($value) {
        $this->AnkietyPrzed(7, $value);
    }

    public function makeAnkietaPrzed8($value) {
        $this->AnkietyPrzed(8, $value);
    }

    public function makeAnkietaPrzed9($value) {
        $this->AnkietyPrzed(9, $value);
    }

    public function makeAnkietaPrzed10($value) {
        $this->AnkietyPrzed(10, $value);
    }

    public function makeAnkietaPrzed11($value) {
        $this->AnkietyPrzed(11, $value);
    }

    public function makeAnkietaPrzed12($value) {
        $this->AnkietyPrzed(12, $value);
    }

    public function makeAnkietaPrzed13($value) {
        $this->AnkietyPrzed(13, $value);
    }

    public function makeAnkietaPo1($value) {
        $this->AnkietyPo(1, $value);
    }

    public function makeAnkietaPo2($value) {
        $this->AnkietyPo(2, $value);
    }

    public function makeAnkietaPo3($value) {
        $this->AnkietyPo(3, $value);
    }

    public function makeAnkietaPo4($value) {
        $this->AnkietyPo(4, $value);
    }

    public function makeAnkietaPo5($value) {
        $this->AnkietyPo(5, $value);
    }

    public function makeAnkietaPo6($value) {
        $this->AnkietyPo(6, $value);
    }

    public function makeAnkietaPo7($value) {
        $this->AnkietyPo(7, $value);
    }

    public function makeAnkietaPo8($value) {
        $this->AnkietyPo(8, $value);
    }

    public function makeAnkietaPo9($value) {
        $this->AnkietyPo(9, $value);
    }

    public function makeAnkietaPo10($value) {
        $this->AnkietyPo(10, $value);
    }

    public function makeAnkietaPo11($value) {
        $this->AnkietyPo(11, $value);
    }

    public function makeAnkietaPo12($value) {
        $this->AnkietyPo(12, $value);
    }

    public function makeAnkietaPo13($value) {
        $this->AnkietyPo(13, $value);
    }

    public function makeAnkietaPo14($value) {
        $this->AnkietyPo(14, $value);
    }

    public function makeAnkietaPo15($value) {
        $this->AnkietyPo(15, $value);
    }

    public function makeAnkietaPo16($value) {
        $this->AnkietyPo(16, $value);
    }

    public function makeAnkietaPo17($value) {
        $this->AnkietyPo(17, $value);
    }

    public function makeAnkietaPo18($value) {
        $this->AnkietyPo(18, $value);
    }

    public function makeAnkietaPo19($value) {
        $this->AnkietyPo(19, $value);
    }

    public function makeAnkietaPo20($value) {
        $this->AnkietyPo(20, $value);
    }

    public function makeAnkietaPo21($value) {
        $this->AnkietyPo(21, $value);
    }

    public function makeAnkietaPo22($value) {
        $this->AnkietyPo(22, $value);
    }

    public function makeTestPrzed1($value) {
        $this->TestyPrzed(1, $value);
    }

    public function makeTestPrzed2($value) {
        $this->TestyPrzed(2, $value);
    }

    public function makeEventWahania($value) {
        $this->TestyPrzed(3, $value);
    }

    public function makeEventKoszty($value) {
        $this->TestyPrzed(4, $value);
    }

    public function makeTestPrzed3($value) {
        $this->TestyPrzed(5, $value);
    }

    public function makeTestPrzed4($value) {
        $this->TestyPrzed(6, $value);
    }

    public function makeEventOdsetki($value) {
        $this->TestyPrzed(7, $value);
    }

    public function makeEventKredyt($value) {
        $this->TestyPrzed(8, $value);
    }

    public function makeEventBank($value) {
        $this->TestyPrzed(9, $value);
    }

    public function makeTestPrzed5($value) {
        $this->TestyPrzed(10, $value);
    }

    public function makeTestPrzed6($value) {
        $this->TestyPrzed(11, $value);
    }

    public function makeTestPrzed7($value) {
        $this->TestyPrzed(12, $value);
    }

    public function makeTestPrzed8($value) {
        $this->TestyPrzed(13, $value);
    }

    public function makeTestPrzed9($value) {
        $this->TestyPrzed(14, $value);
    }

    public function makeTestPrzed10($value) {
        $this->TestyPrzed(15, $value);
    }

    public function makeTestPrzed11($value) {
        $this->TestyPrzed(16, $value);
    }

    public function makeTestPo1($value) {
        $this->TestyPo(1, $value);
    }

    public function makeTestPo2($value) {
        $this->TestyPo(2, $value);
    }

    public function makeEventZmienne($value) {
        $this->TestyPo(3, $value);
    }

    public function makeTestPo3($value) {
        $this->TestyPo(4, $value);
    }

    public function makeTestPo4($value) {
        $this->TestyPo(5, $value);
    }

    public function makeEventOdsetkik($value) {
        $this->TestyPo(6, $value);
    }

    public function makeEventKredytowa($value) {
        $this->TestyPo(7, $value);
    }

    public function makeEventUsługi($value) {
        $this->TestyPo(8, $value);
    }

    public function makeTestPo5($value) {
        $this->TestyPo(9, $value);
    }

    public function makeTestPo6($value) {
        $this->TestyPo(10, $value);
    }

    public function makeTestPo7($value) {
        $this->TestyPo(11, $value);
    }

    public function makeTestPo8($value) {
        $this->TestyPo(12, $value);
    }

    public function makeTestPo9($value) {
        $this->TestyPo(13, $value);
    }

    public function makeTestPo10($value) {
        $this->TestyPo(14, $value);
    }

    public function makeEventStrategia($value) {
        $this->TestyPo(15, $value);
    }

    public function makeTestPo11($value) {
        $this->TestyPo(16, $value);
    }

    public function AnkietyPrzed($numer, $value) {
        $this->s('ankiety_przed_user_' . $this->gameController->getUserId(), 1, 'decision');
        $this->gameController->getGameData()->save(true);
        //  $this->s('ankiety_przed_'.$numer, $value, 'decision');
        $user = Doctrine::getTable('UserDetail')->findOneById($this->gameController->getUserId());
        $ankiety = $user->getStudentSurveyBeforeTeamArray($this->gameController->getTeamId());

        if (!isset($ankiety[$this->gameController->getUserId()])) {
            $ankiety[$this->gameController->getUserId()] = array();
        }

        $ankiety[$this->gameController->getUserId()]['ankiety_przed_' . $numer] = $value;

        $ankietaJson [$this->gameController->getTeamId()] = $ankiety;

        //$this->s('ankiety_przed', $ankiety, 'game');
        $user->setStudentSurveyBefore(json_encode($ankietaJson));
        $user->save();
    }

    public function AnkietyPo($numer, $value) {
        $this->s('ankiety_po_user_' . $this->gameController->getUserId(), 1, 'decision');
        $this->gameController->getGameData()->save(true);
        //   $this->s('ankiety_po_'.$numer, $value, 'decision');
        // $ankiety = $this->g('ankiety_po', 'game');
        $user = Doctrine::getTable('UserDetail')->findOneById($this->gameController->getUserId());

        $ankiety = $user->getStudentSurveyAfterTeamArray($this->gameController->getTeamId());
        if (!isset($ankiety[$this->gameController->getUserId()])) {
            $ankiety[$this->gameController->getUserId()] = array();
        }

        $ankiety[$this->gameController->getUserId()]['ankiety_po_' . $numer] = $value;

        //$this->s('ankiety_po', $ankiety, 'game');
        $ankietaJson [$this->gameController->getTeamId()] = $ankiety;

        $user->setStudentSurveyAfter(json_encode($ankietaJson));
        $user->save();
    }

    public function TestyPrzed($numer, $value) {
        $this->s('testy_przed_user_' . $this->gameController->getUserId(), 1, 'decision');
        $this->gameController->getGameData()->save(true);
//    $this->s('test_przed_'.$numer, $value, 'decision');
        // $testy = $this->g('test_przed', 'game');
        $user = Doctrine::getTable('UserDetail')->findOneById($this->gameController->getUserId());

        $testy = $user->getStudentTestBeforeTeamArray($this->gameController->getTeamId());
        if (!isset($testy[$this->gameController->getUserId()])) {
            $testy[$this->gameController->getUserId()] = array();
        }

        $testy[$this->gameController->getUserId()]['test_przed_' . $numer] = $value;

        //$this->s('test_przed', $testy, 'game');
        $ankietaJson [$this->gameController->getTeamId()] = $testy;

        $user->setStudentTestBefore(json_encode($ankietaJson));
        $user->save();
    }

    public function TestyPo($numer, $value) {
        $this->s('testy_po_user_' . $this->gameController->getUserId(), 1, 'decision');
        $this->gameController->getGameData()->save(true);
        //  $this->s('test_po_'.$numer, $value, 'decision');
        //$testy = $this->g('testy_po', 'game');
        $user = Doctrine::getTable('UserDetail')->findOneById($this->gameController->getUserId());
        $testy = $user->getStudentTestAfterTeamArray($this->gameController->getTeamId());
        if (!isset($testy[$this->gameController->getUserId()])) {
            $testy[$this->gameController->getUserId()] = array();
        }

        $testy[$this->gameController->getUserId()]['test_po_' . $numer] = $value;

        // $this->s('test_po', $testy, 'game');
        $ankietaJson [$this->gameController->getTeamId()] = $testy;

        $user->setStudentTestAfter(json_encode($ankietaJson));
        $user->save();
    }

    public function makeRejestracjaNaStronieWww($value) {
        $this->s('rejestracja_na_stronie_www', $value, 'decision');
    }

    /** Zarzadzanie pokojami */
    public function makePokojeStandard($value) {
        $staraDecyzja = $this->g('pokoje_standard', 'decision');
        if ($value == $staraDecyzja) {
            // Brak zmiany
            return true;
        } else {
            if ($staraDecyzja != 0) {
                // Sprowadzamy do stanu 0
                if ($staraDecyzja > 0) {
                    // Mielismy kupione pokoje w tej rundzie, sprowadzamy do 0
                    $this->cB($this->getGameProcess()->getKosztPokoiStandard($staraDecyzja));

                    $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|modernizacja|kupno_pokoje_standard', 0);
                    $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inwestycje', 0);
                } else {
                    // Sprzedalismy pokoje w tej rundzie, sprowadzamy do 0
                    $this->cB(-$this->getGameProcess()->getZyskSprzedazyPokoiStandard(-$staraDecyzja));
                    $this->cLPS(-$staraDecyzja);

                    $this->getGameProcess()->setRaportEntryToParse('finansowy', 'przychody|nadzwyczajne|sprzedaz_pokoje_standard', 0);
                    $this->getGameProcess()->setRaportEntryToParse('kpir', 'wplywy|operacyjne|nadzwyczajne', 0);
                }
            }

            // Zmieniamy z stanu 0
            if ($value > 0) {
                // Kupujemy X pokoi
                $koszt = $this->getGameProcess()->getKosztPokoiStandard($value);
                $this->cB(-$koszt);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|modernizacja|kupno_pokoje_standard', $koszt);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inwestycje', $koszt);
            } else {
                // Sprzedajemy X pokoi
                $koszt = $this->getGameProcess()->getZyskSprzedazyPokoiStandard(-$value);
                $this->cB($koszt);
                $this->cLPS($value);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'przychody|nadzwyczajne|sprzedaz_pokoje_standard', $koszt);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wplywy|operacyjne|nadzwyczajne', $koszt);
            }

            $this->s('pokoje_standard', $value, 'decision');

            return true;
        }
    }

    public function makePokojeStandardWyposazenie($value) {
        $staraDecyzja = $this->gWS();
        // Decyzja z ostatniej rundy
        $decyzjaLR = $this->g('pokoje_standard_wyposazenie', 'last_decision');
        $liczbaPokoiStandard = $this->gLPS() + max(0, $this->g('pokoje_standard', 'decision'));
        if ($value == $staraDecyzja) {
            // Brak zmiany
            return true;
        } else {
            // Sprowadzamy wyposazenie do stanu z poprzedniej rundy
            if ($staraDecyzja > $decyzjaLR) {
                // Zwracamy zainwestowane pieniadze
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $staraDecyzja) - $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $decyzjaLR);
                $this->cB($koszt);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|modernizacja|kupno_wyposazenia_standard', 0);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inwestycje', 0);
            } else {
                // Odejmujemy zysk ze sprzedazy pokoi
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $staraDecyzja) - $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $decyzjaLR);
                $koszt *= $this->g('wspolczynnik|likwidacji_wyposazenia', 'game');
                $this->cB($koszt);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'przychody|nadzwyczajne|sprzedaz_wyposazenia_standard', 0);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wplywy|operacyjne|nadzwyczajne', 0);
            }

            // Zmieniamy wyposazenie
            if ($value > $decyzjaLR) {
                // Kupujemy wyposazenie na wyzszy poziom
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $decyzjaLR) - $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $value);

                $this->cB($koszt);
                $this->sWS($value);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|modernizacja|kupno_wyposazenia_standard', -$koszt);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inwestycje', -$koszt);
            } else {
                // Sprzedajemy wyposazenie
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $decyzjaLR) - $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $value);
                // Kwote mnozymy przez wspolczynnik likwidacji wyposazenia
                $koszt *= $this->g('wspolczynnik|likwidacji_wyposazenia', 'game');
                $this->cB($koszt);
                $this->sWS($value);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'przychody|nadzwyczajne|sprzedaz_wyposazenia_standard', $koszt);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wplywy|operacyjne|nadzwyczajne', $koszt);
            }
        }

        return true;
    }

    public function makePokojeLux($value) {
        $staraDecyzja = $this->g('pokoje_lux', 'decision');
        if ($value == $staraDecyzja) {
            // Brak zmiany
            return true;
        } else {
            if ($staraDecyzja != 0) {
                // Sprowadzamy do stanu 0
                if ($staraDecyzja > 0) {
                    // Mielismy kupione pokoje w tej rundzie, sprowadzamy do 0
                    $this->cB($this->getGameProcess()->getKosztPokoiLux($staraDecyzja));

                    $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|modernizacja|kupno_pokoje_lux', 0);
                    $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inwestycje', 0);
                } else {
                    // Sprzedalismy pokoje w tej rundzie, sprowadzamy do 0
                    $this->cB(-$this->getGameProcess()->getZyskSprzedazyPokoiLux(-$staraDecyzja));
                    $this->cLPL(-$staraDecyzja);

                    $this->getGameProcess()->setRaportEntryToParse('finansowy', 'przychody|nadzwyczajne|sprzedaz_pokoje_lux', 0);
                    $this->getGameProcess()->setRaportEntryToParse('kpir', 'wplywy|operacyjne|nadzwyczajne', 0);
                }
            }

            // Zmieniamy z stanu 0
            if ($value > 0) {
                // Kupujemy X pokoi
                $koszt = $this->getGameProcess()->getKosztPokoiLux($value);
                $this->cB(-$koszt);
                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|modernizacja|kupno_pokoje_lux', $koszt);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inwestycje', $koszt);
            } else {
                // Sprzedajemy X pokoi
                $koszt = $this->getGameProcess()->getZyskSprzedazyPokoiLux(-$value);
                $this->cB($koszt);
                $this->cLPL($value);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'przychody|nadzwyczajne|sprzedaz_pokoje_lux', $koszt);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wplywy|operacyjne|nadzwyczajne', $koszt);
            }

            $this->s('pokoje_lux', $value, 'decision');

            return true;
        }
    }

    public function makePokojeLuxWyposazenie($value) {
        $staraDecyzja = $this->gWL();
        // Decyzja z ostatniej rundy
        $decyzjaLR = $this->g('pokoje_lux_wyposazenie', 'last_decision');
        $liczbaPokoiLux = $this->gLPL() + max(0, $this->g('pokoje_lux', 'decision'));
        if ($value == $staraDecyzja) {
            // Brak zmiany
            return true;
        } else {
            // Sprowadzamy wyposazenie do stanu z poprzedniej rundy
            if ($staraDecyzja > $decyzjaLR) {
                // Zwracamy zainwestowane pieniadze
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $staraDecyzja) - $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $decyzjaLR);
                $this->cB($koszt);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|modernizacja|kupno_wyposazenia_lux', 0);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inwestycje', 0);
            } else {
                // Odejmujemy zysk ze sprzedazy pokoi
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $staraDecyzja) - $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $decyzjaLR);
                $koszt *= $this->g('wspolczynnik|likwidacji_wyposazenia', 'game');
                $this->cB($koszt);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'przychody|nadzwyczajne|sprzedaz_wyposazenia_lux', 0);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wplywy|operacyjne|nadzwyczajne', 0);
            }

            // Zmieniamy wyposazenie
            if ($value > $decyzjaLR) {
                // Kupujemy wyposazenie na wyzszy poziom
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $decyzjaLR) - $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $value);
                $this->cB($koszt);
                $this->sWL($value);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|modernizacja|kupno_wyposazenia_lux', -$koszt);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inwestycje', -$koszt);
            } else {
                // Sprzedajemy wyposazenie
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $decyzjaLR) - $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $value);
                // Kwote mnozymy przez wspolczynnik likwidacji wyposazenia
                $koszt *= $this->g('wspolczynnik|likwidacji_wyposazenia', 'game');
                $this->cB($koszt);
                $this->sWL($value);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'przychody|nadzwyczajne|sprzedaz_wyposazenia_lux', $koszt);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wplywy|operacyjne|nadzwyczajne', $koszt);
            }
        }
    }

    /** Zarzadzanie pokojami - KONIEC */
    public function makeKomiksRok1($value) {
        $this->s('komiks_rok1', 1, 'decision');
    }

    public function makeKomiksRok2($value) {
        $this->s('komiks_rok2', 1, 'decision');
    }

    public function makeKomiksRok3($value) {
        $this->s('komiks_rok3', 1, 'decision');
    }

    public function makeKomiksRok4($value) {
        $this->s('komiks_rok4', 1, 'decision');
    }

    public function makeKomiksKoniec($value) {
        $this->s('komiks_koniec', 1, 'decision');
    }

    public function makeBadanieMarketingowe1Tresc($value) {
        
    }

    public function makeNazwaMarki($value) {
        $this->s('nazwa_marki', $value, 'decision');
        try {
            $this->getGameData()->getTeam()->setName($value);
            $this->getGameData()->getTeam()->save();
        } catch (Exception $ex) {

        }
    }

    public function makeLogoMarki($value) {
        $this->s('logo_marki', $value, 'decision');
    }

    public function makeWyborLoga($value) {
        $this->s('wybor_loga', $value, 'decision');
    }

    public function makeOpisInterfejsu($value) {
        $this->s('opis_interfejsu', 1, 'decision');
    }

    public function makeWyborLokalizacji($value) {
        $this->s('wybor_lokalizacji', $value, 'decision');
        $this->s('wybor_lokalizacji', $value, 'round');
    }

    /** Eventy */
    public function makeEventSadzenieDrzew($value) {
        $nowyKoszt = $this->getGameProcess()->getKosztSadzenieDrzew($value);
        // Koszt lub ilosc pieniedzy do zwrotu
        $koszt = $nowyKoszt - $this->getGameProcess()->getKosztSadzenieDrzew($this->g('event_sadzenie_drzew', 'decision'));

        $this->cB(-$koszt);

        $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|obywatelska|event_sadzenie_drzew', $nowyKoszt);
        $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inne_wydatki', $nowyKoszt);
        $this->getGameProcess()->setKosztMarza('event_sadzenie_drzew_r' . $this->gRN(), $nowyKoszt, 'razem');

        $this->s('event_sadzenie_drzew', $value, 'decision');
    }

    public function makeEventPanele($value) {
        $nowyKoszt = $value * $this->g('eventy|panele|koszt', 'game');
        // Koszt lub ilosc pieniedzy do zwrotu
        $koszt = $nowyKoszt - ($this->g('event_panele', 'decision', 0) * $this->g('eventy|panele|koszt', 'game'));

        $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|modernizacja|event_panele', $nowyKoszt);
        $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inwestycje', $nowyKoszt);
        $this->getGameProcess()->setKosztMarza('event_panele_r' . $this->gRN(), $nowyKoszt, 'razem');

        $this->cB(-$koszt);
        $this->s('event_panele', $value, 'decision');
    }

    public function makeEventZimowisko($value) {
        $koszt = $this->g('eventy|zimowisko', 'game');
        $this->makeKosztJednorazowy($koszt, $value, 'event_zimowisko', 'koszty|obywatelska|event_zimowisko', 'wyplywy|operacyjne|inne_wydatki', 'event_zimowisko');
    }

    public function makeEventPodjazdDlaNiepelnosprawnych($value) {
        $koszt = $this->g('eventy|podjazd_dla_niepelnosprawnych', 'game');
        return $this->makeKosztJednorazowy($koszt, $value, 'event_podjazd_dla_niepelnosprawnych', 'koszty|modernizacja|event_podjazd_dla_niepelnosprawnych', 'wyplywy|operacyjne|inwestycje', 'event_podjazd_dla_niepelnosprawnych');
    }

    public function makeEventPralniaEkologiczna($value) {
        $koszt = $this->g('eventy|pralnia_ekologiczna|koszt', 'game');
        return $this->makeKosztJednorazowy($koszt, $value, 'event_pralnia_ekologiczna', 'koszty|modernizacja|event_pralnia_ekologiczna', 'wyplywy|operacyjne|inwestycje', 'event_pralnia_ekologiczna');
    }

    public function makeEventAkcjaCharytatywna($value) {
        $koszt = $this->g('eventy|akcja_charytatywna', 'game');
        return $this->makeKosztJednorazowy($koszt, $value, 'event_akcja_charytatywna', 'koszty|obywatelska|event_akcja_charytatywna', 'wyplywy|operacyjne|inne_wydatki', 'event_akcja_charytatywna');
    }

    public function makeEventMikolajkowyEkspres($value) {
        $koszt = $this->g('eventy|mikolajkowy_ekspres|koszt', 'game');
        return $this->makeKosztJednorazowy($koszt, $value, 'event_mikolajkowy_ekspres', 'koszty|obywatelska|event_mikolajkowy_ekspres', 'wyplywy|operacyjne|inne_wydatki', 'event_mikolajkowy_ekspres');
    }

    public function makeEventStopUmowomSmieciowym($value) {
        $this->s('event_stop_umowom_smieciowym', $value, 'decision');
    }

    public function makeEventKierowniczka($value) {
        $this->s('event_kierowniczka', $value, 'decision');
    }

    public function makeEventSzkolenie($value) {
        $koszt = $this->g('eventy|szkolenie', 'game');
        return $this->makeKosztJednorazowy($koszt, $value, 'event_szkolenie', 'koszty|modernizacja|event_szkolenie', 'wyplywy|operacyjne|inne_wydatki', 'event_szkolenie');
    }

    public function makeGolf($value) {
        $koszt = $this->g('sezonowosc|koszt|golf', 'game');
        return $this->makeKosztJednorazowy($koszt, $value, 'golf', 'koszty|obywatelska|golf', 'wyplywy|operacyjne|inne_wydatki', 'golf');
    }

    public function makePlaza($value) {
        $koszt = $this->g('sezonowosc|koszt|plaza', 'game');
        return $this->makeKosztJednorazowy($koszt, $value, 'plaza', 'koszty|obywatelska|plaza', 'wyplywy|operacyjne|inne_wydatki', 'plaza');
    }

    public function makeWyciagNarciarski($value) {
        $koszt = $this->g('sezonowosc|koszt|wyciag_narciarski', 'game');
        return $this->makeKosztJednorazowy($koszt, $value, 'wyciag_narciarski', 'koszty|obywatelska|wyciag_narciarski', 'wyplywy|operacyjne|inne_wydatki', 'wyciag_narciarski');
    }

    public function makeUslugaPlaza($value) {
        $this->s('usluga_plaza', $value, 'decision');
    }

    public function makeUslugaWyciagNarciarski($value) {
        $this->s('usluga_wyciag_narciarski', $value, 'decision');
    }

    public function makeUslugaGolf($value) {
        $this->s('usluga_golf', $value, 'decision');
    }

    /**
     * Funkcja robi make dla kosztu jednorazowego. Przyjmuje koszt, podjeta decyzje oraz 
     * nazwe decyzje w ktorej jest przechowywana zmienna.
     * @param float $koszt
     * @param boolean $decision
     * @param strong $decisionName
     */
    public function makeKosztJednorazowy($koszt, $decision, $decisionName, $raportFinansowyWhere = false, $raportOperacyjnyWhere = false, $marzaWhere = false) {
        $oldDecision = $this->g($decisionName, 'decision', false);
        if ($oldDecision) {
            // Jesli byla podjeta decyzja zwroc koszt
            $this->cB($koszt);
            if ($raportFinansowyWhere) {
                $this->getGameProcess()->setRaportEntryToParse('finansowy', $raportFinansowyWhere, 0);
            }
            if ($raportOperacyjnyWhere) {
                $this->getGameProcess()->setRaportEntryToParse('kpir', $raportOperacyjnyWhere, 0);
            }
            if ($marzaWhere) {
                $this->getGameProcess()->setKosztMarza($marzaWhere, 0, 'razem');
            }
        }

        if ($decision) {
            // Odejmij koszt jesli decyzja jest pozytywna
            $this->cB(-$koszt);
            if ($raportFinansowyWhere) {
                $this->getGameProcess()->setRaportEntryToParse('finansowy', $raportFinansowyWhere, $koszt);
            }
            if ($raportOperacyjnyWhere) {
                $this->getGameProcess()->setRaportEntryToParse('kpir', $raportOperacyjnyWhere, $koszt);
            }
            if ($marzaWhere) {
                $this->getGameProcess()->setKosztMarza($marzaWhere, $koszt, 'razem');
            }
        }

        $this->s($decisionName, $decision, 'decision');
    }

    /* Segmentacja */

    public function makeWspolpracaUrzadPracy($value) {

        $this->s('wspolpraca_urzad_pracy', $value, 'decision');
    }

    public function makeWspolpracaBiuramiPodrozy($value) {

        $this->s('wspolpraca_biurami_podrozy', $value, 'decision');
    }

    public function makeMozliwoscOdebraniaGosci($value) {

        $this->s('mozliwosc_odebrania_gosci', $value, 'decision');
    }

    public function makeOchronkaDlaDzieci($value) {

        $this->s('ochronka_dla_dzieci', $value, 'decision');
    }

    public function makeBusinessLounge($value) {

        $this->s('business_lounge', $value, 'decision');
    }

    public function makeSalaKonferencyjna($value) {

        $this->s('sala_konferencyjna', $value, 'decision');
    }

    public function makeAutomatyVendingowe($value) {

        $this->s('automaty_vendingowe', $value, 'decision');
    }

    public function makeEkspresyCzajniki($value) {

        $this->s('ekspresy_czajniki', $value, 'decision');
    }

    public function makePokojZabawDlaDzieci($value) {

        $this->s('pokoj_zabaw_dla_dzieci', $value, 'decision');
    }

    public function makeBudzenie($value) {

        $this->s('budzenie', $value, 'decision');
    }

    public function makeTaxi($value) {

        $this->s('taxi', $value, 'decision');
    }

    public function makeSejf($value) {

        $this->s('sejf', $value, 'decision');
    }

    /* Koniec - Segmentacja */

    //koniec decyzje dla POZOSTALE USLUGI

    public function makeStronaInternetowa($value) {
        if (!($this->g('kupiona_strona_internetowa', 'round'))) {
            // Nigdy nie kupiono strony, przeliczamy koszt jednorazowy
            $koszt = $this->g('strona_internetowa|koszt_jednorazowy', 'game');

            $decision = $this->g('strona_internetowa', 'decision');
            if ($decision > 0) {
                // Podjal decyzje o kupnie, to zwracamy mu koszt - wracamy do stanu brak strony
                $this->cB($koszt);
                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|marketingowe|strona_internetowa', 0);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inne_wydatki', 0);
                $this->getGameProcess()->setKosztMarza('kupno_strona_internetowa_r' . $this->gRN(), 0, 'razem');
            }
            if ($value > 0) {
                // Pobieramy koszt
                $this->cB(-$koszt);

                $this->getGameProcess()->setRaportEntryToParse('finansowy', 'koszty|marketingowe|strona_internetowa', $koszt);
                $this->getGameProcess()->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inne_wydatki', $koszt);
                $this->getGameProcess()->setKosztMarza('kupno_strona_internetowa_r' . $this->gRN(), $koszt, 'razem');
            }
        }

        // Jak nie ma strony internetowej to anulowanie usługi rejestracji. 
        if ($value == 0) {
            $this->s('rejestracja_na_stronie_www', 0, 'decision');
        }

        $this->s('strona_internetowa', $value, 'decision');
    }

    /** Sprzatanie outsourcing */
    public function makeSprzatanieOutsourcingStandardKwota($value) {
        $this->s('sprzatanie_outsourcing_standard_kwota', number_format($value, 2, '.', ''), 'decision');
    }

    public function makeSprzatanieOutsourcingLuxKwota($value) {
        $this->s('sprzatanie_outsourcing_lux_kwota', number_format($value, 2, '.', ''), 'decision');
    }

    /** Pranie outsourcing */
    public function makePranieOutsourcingStandardKwota($value) {
        $this->s('pranie_outsourcing_standard_kwota', number_format($value, 2, '.', ''), 'decision');
    }

    public function makePranieOutsourcingLuxKwota($value) {
        $this->s('pranie_outsourcing_lux_kwota', number_format($value, 2, '.', ''), 'decision');
    }

    public function makeSniadaniaKwota($value) {
        $this->s('sniadania_kwota', $value, 'decision');
    }

    public function makeMediaLokalneUlotki($value) {
        $this->s('media_lokalne_ulotki', $value, 'decision');
    }

    public function makeMediaLokalnePlakaty($value) {
        $this->s('media_lokalne_plakaty', $value, 'decision');
    }

    public function makeMediaLokalneBilboardy($value) {
        $this->s('media_lokalne_bilboardy', $value, 'decision');
    }

    public function makeMediaLokalnePrasa($value) {
        $this->s('media_lokalne_prasa', $value, 'decision');
    }

    public function makeMediaLokalneRadio($value) {
        $this->s('media_lokalne_radio', $value, 'decision');
    }

    public function makeMediaRegionalneRadio($value) {
        $this->s('media_regionalne_radio', $value, 'decision');
    }

    public function makeMediaRegionalneTv($value) {
        $this->s('media_regionalne_tv', $value, 'decision');
    }

    public function makeMediaRegionalnePrasa($value) {
        $this->s('media_regionalne_prasa', $value, 'decision');
    }

    public function makeMediaKrajoweRadio($value) {
        $this->s('media_krajowe_radio', $value, 'decision');
    }

    public function makeMediaKrajoweTv($value) {
        $this->s('media_krajowe_tv', $value, 'decision');
    }

    public function makeMediaKrajowePrasa($value) {
        $this->s('media_krajowe_prasa', $value, 'decision');
    }

    public function makeBadanieMarketingowePopytStandard($value) {
        $status = HotelGameMessage::NOT_READ;
        if (!$this->e('wybor_lokalizacji', 'decision')) {
            $status = HotelGameMessage::READ;
        }
        $this->getGameProcess()->buyResearch('badanie_marketingowe_popyt_standard', $value, $status);
    }

    public function makeBadanieMarketingoweUslugiPodstawowe($value) {
        $this->getGameProcess()->buyResearch('badanie_marketingowe_uslugi_podstawowe', $value);
    }

    public function makeBadanieMarketingoweSezonowosc($value) {
        $this->getGameProcess()->buyResearch('badanie_marketingowe_sezonowosc', $value);
    }

    public function makeBadanieMarketingowePopytLux($value) {
        $this->getGameProcess()->buyResearch('badanie_marketingowe_popyt_lux', $value);
    }

    public function makeBadanieMarketingoweReklamaZaawansowana($value) {
        $this->getGameProcess()->buyResearch('badanie_marketingowe_reklama_zaawansowana', $value);
    }

    public function makeBadanieMarketingoweKonkurencja($value) {
        $this->getGameProcess()->buyResearch('badanie_marketingowe_konkurencja', $value);
    }

    public function makeBadanieMarketingoweUslugiZaawansowaneSegmentacja($value) {
        $this->getGameProcess()->buyResearch('badanie_marketingowe_uslugi_zaawansowane_segmentacja', $value);
    }

    public function makeEventFestiwalFilmowy($value) {
        $this->s('event_festiwal_filmowy', $value, 'decision');
    }

    /** Zatrudnienie */
    public function makePracownicyObslugiStaleLiczba($value) {
        $this->s('pracownicy_obslugi_stale_liczba', $value, 'decision');
    }

    public function makePracownicyObslugiStaleWynagrodzenie($value) {
        $this->s('pracownicy_obslugi_stale_wynagrodzenie', number_format($value, 2, '.', ''), 'decision');
    }

    public function makePracownicyObslugiStaleMotywacjaProcent($value) {
        $this->s('pracownicy_obslugi_stale_motywacja_procent', $value, 'decision');
    }

    public function makePracownicyObslugiZlecenieLiczba($value) {
        $this->s('pracownicy_obslugi_zlecenie_liczba', $value, 'decision');
    }

    public function makePracownicyObslugiZlecenieWynagrodzenie($value) {
        $this->s('pracownicy_obslugi_zlecenie_wynagrodzenie', number_format($value, 2, '.', ''), 'decision');
    }

    public function makePracownicyObslugiZlecenieMotywacjaProcent($value) {
        $this->s('pracownicy_obslugi_zlecenie_motywacja_procent', $value, 'decision');
    }

    public function makePracownicyAdministracjiStaleLiczba($value) {
        $this->s('pracownicy_administracji_stale_liczba', $value, 'decision');
    }

    public function makePracownicyAdministracjiStaleWynagrodzenie($value) {
        $this->s('pracownicy_administracji_stale_wynagrodzenie', number_format($value, 2, '.', ''), 'decision');
    }

    public function makePracownicyAdministracjiStaleMotywacjaProcent($value) {
        $this->s('pracownicy_administracji_stale_motywacja_procent', $value, 'decision');
    }

    public function makePracownicyAdministracjiZlecenieLiczba($value) {
        $this->s('pracownicy_administracji_zlecenie_liczba', $value, 'decision');
    }

    public function makePracownicyAdministracjiZlecenieWynagrodzenie($value) {
        $this->s('pracownicy_administracji_zlecenie_wynagrodzenie', number_format($value, 2, '.', ''), 'decision');
    }

    public function makePracownicyAdministracjiZlecenieMotywacjaProcent($value) {
        $this->s('pracownicy_administracji_zlecenie_motywacja_procent', $value, 'decision');
    }

    /** Kredyty */
    public function makeKredytInwestycyjnyKwota($value) {
        $rata = $this->getGameProcess()->getKredytInwestycyjnyRata($value);

        $this->s('kredyt_inwestycyjny_rata', $rata, 'round');
        $this->s('kredyt_inwestycyjny_ilosc_rat', $this->g('kredyty|inwestycyjny|okres', 'game'), 'round');

        if ($this->g('kredyt_inwestycyjny_kwota', 'round') > 0) {
            $this->cB($value - $this->g('kredyt_inwestycyjny_kwota', 'round'));
        } else {
            $this->cB($value);
        }

        $this->s('kredyt_inwestycyjny_kwota', number_format($value, 2, '.', ''), 'round');
        $this->s('kredyt_inwestycyjny_kwota', number_format($value, 2, '.', ''), 'decision');
    }

    public function makeKredytObrotowyKwota($value) {
        $kwota = $this->g('kredyt_obrotowy_kwota', 'round');

        $this->cB($value);

        $this->s('kredyt_obrotowy_kwota', number_format(($kwota + $value), 2, '.', ''), 'round');
        $this->s('kredyt_obrotowy_kwota', number_format(0, 2, '.', ''), 'decision');
    }

    public function makeKredytObrotowySplata($value) {
        $kwota = $this->g('kredyt_obrotowy_kwota', 'round');

        $this->cB(-$value);

        $this->s('kredyt_obrotowy_kwota', number_format(($kwota - $value), 2, '.', ''), 'round');
        $this->s('kredyt_obrotowy_kwota', number_format(0, 2, '.', ''), 'decision');
    }

    /** Lokaty */
    public function makeLokataKwota($value) {
        $kwota = $this->g('lokata_kwota', 'round');

        $this->s('lokata_kwota', number_format(($kwota + $value), 2, '.', ''), 'round');
        $this->cB(-$value);
    }

    public function makeLokataSplata($value) {
        $kwota = $this->g('lokata_kwota', 'round');

        $this->s('lokata_kwota', number_format(($kwota - $value), 2, '.', ''), 'round');
        $this->cB($value);
    }

    /** Lokaty - KONIEC */
    public function makeCenaPokojeStandard($value) {
        $this->s('cena_pokoje_standard', $value, 'decision');
    }

    public function makeCenaPokojeLux($value) {
        $this->s('cena_pokoje_lux', $value, 'decision');
    }

    public static function getPokojeInwestycje() {
        return array(
            -100, -95, -90, -85, -80, -75, -70, -65, -60, -55, -50, -45, -40, -35, -30, -25, -20, -15, -10, -5,
            0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100
        );
    }

    public static function getWyposazenieStandard() {
        return array(
            0 => array('icon' => 'one', 'log_label' => 'Podstawowe', 'label' => __t('<b>Podstawowe:</b> Podwójne łóżko, stolik, 2 krzesła, wieszak, szafka nocna. Meble i przedmioty używane.')),
            1 => array('icon' => 'two', 'log_label' => 'Średnie', 'label' => __t('<b>Średnie:</b> Podwójne łóżko, komoda, stolik, 3 krzesła, szafa wnękowa, telewizor plazmowy 32”. Meble i przedmioty nowe.')),
            2 => array('icon' => 'three', 'log_label' => 'Wysokie', 'label' => __t('<b>Wysokie:</b> Łóżko z wygodnym materacem, stolik kawowy, 2 fotele, żyrandol, lustro, szafa wnękowa, telewizor plazmowy 45”, Internet. Meble i przedmioty nowe o podwyższonym standardzie.')),
        );
    }

    public static function getWyposazenieLux() {
        return array(
            0 => array('icon' => 'one', 'log_label' => 'Podstawowe'
                , 'label' => __t('<b>Podstawowe:</b> Podwójne łóżko z antyalergicznym, bardzo wygodnym materacem, duży stół, dwa eleganckie krzesła, telewizor LCD 32”. Meble w nowoczesnym stylu.')),
            1 => array('icon' => 'two', 'log_label' => 'Średnie'
                , 'label' => __t('<b>Średnie:</b> Łóżko, stół, szafa, krzesła oraz fotele wykonane z dębowego drewna,  skórzana kanapa, telewizor LCD 42”. Pomimo że, wnętrze wykończone jest w zabytkowym stylu to wszystkie przedmioty są nowe oraz starannie wykończone.')),
            2 => array('icon' => 'three', 'log_label' => 'Wysokie'
                , 'label' => __t('<b>Wysokie:</b> Królewskie łoże  z baldachimem, osobna garderoba, bardzo wygodny  skórzany komplet wypoczynkowy,  telewizor plazmowy 60” z zestawem kina domowego. Meble i przedmioty nowe, o znacznie podwyższonym standardzie.')),
        );
    }

    public static function getLokalizacje() {
        return array(
            0 => array('icon' => 'one', 'log_label' => 'Przedmieścia', 'label' => __t('<b>Przedmieścia:</b> rejon miasta, który nie ma atrakcji przyciągających tłumy. Noclegu w tym miejscu szukają ludzie oszczędni, którym nie zależy na najwyższym komforcie i jakości. Z drugiej strony na przedmieściach ceny wynajmu pomieszczeń dla Twojego hotelu są zdecydowanie niższe niż w innych dzielnicach. Podobnie z opłatami za media.')),
            1 => array('icon' => 'two', 'log_label' => 'Śródmieście', 'label' => __t('<b>Śródmieście:</b> wyśrodkowane wskaźniki z pozostałych dwóch dzielnic. Hotel warto umieścić w śródmieściu, jeżeli nie planujesz przyciągnąć najbogatszych/najoszczędniejszych klientów i będziesz w stanie opłacić rachunki średniej wielkości.')),
            2 => array('icon' => 'three', 'log_label' => 'Centrum', 'label' => __t('<b>Centrum:</b> hotel położony w centrum gwarantuje dużą liczbę klientów, również tych najbogatszych. Niestety wiąże się to z wysokimi cenami wynajmu i mediów, które należy uwzględnić każdego miesiąca.')),
        );
    }

    public static function getRemont() {
        return array(
            '25%',
            '50%',
            '75%',
            '100%'
        );
    }

    public static function getStronaInternetowa() {
        return array(
            0 => array('icon' => 'null', 'log_label' => 'Brak strony', 'label' => __t('<b>Brak strony internetowej</b>')),
            1 => array('icon' => 'null', 'log_label' => 'Podstawowa', 'label' => __t('<b>Podstawowa strona internetowa:</b> strona internetowa z podstawowymi informacjami na temat hotelu: adres, cennik, kilka zdjęć. Skromna szata graficzna. Trudno ją znaleźć przez wyszukiwarkę.')),
            2 => array('icon' => 'one', 'log_label' => 'Rozszerzona', 'label' => __t('<b>Podst + pozycjonowanie:</b> jw. + pozycjonowanie w wynikach wyszukiwarki internetowej, łatwiejsze odnajdywanie strony.')),
            3 => array('icon' => 'two', 'log_label' => 'Profesjonalna', 'label' => __t('<b>Podst + pozyc + social media:</b> jw. + budowa i obsługa społeczności dotycząca usług i działalności hotelu.')),
        );
    }

    public function getTakNie() {
        return array(
            'Nie',
            'Tak'
        );
    }

    public static function getSadzenieDrzew() {
        return array(
            '0' => '0%',
            '1' => '33%',
            '2' => '66%',
            '3' => '100%'
        );
    }

    public static function getKierowniczka() {
        return array(
            '0' => 'Brak',
            '1' => 'Wersja 1',
            '2' => 'Wersja 2',
        );
    }

    public static function getWahania() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
            '4' => 'E',
        );
    }

    public static function getKoszty() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
        );
    }

    public static function getOdsetki() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
        );
    }

    public static function getKredyt() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
        );
    }

    public static function getBank() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
        );
    }

    public static function getZmienne() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
        );
    }

    public static function getOdsetkiK() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
        );
    }

    public static function getKredytowa() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
        );
    }

    public static function getUsługi() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
        );
    }

    public static function getStrategia() {
        return array(
            '0' => 'A',
            '1' => 'B',
            '2' => 'C',
            '3' => 'D',
            '4' => 'E'
        );
    }

    public static function getNumb() {
        return array(
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '5' => '5',
            '6' => '6',
            '7' => '7'
        );
    }

}
