<?php

/**
 * Klasa bazowa dla gry Hotel, udostepnia metody dostepowe do stanu gry oraz klas przeznaczonych
 * do zarzadzania poszczegolnymi elementami
 */
abstract class HotelGameFunctions extends BaseGameFunctions {

  const FIRST_ROUND = 1;
  const LAST_ROUND = 17;
  const WSP_NULL = 0;
  const COSTS_NULL = 0;
  const DEMAND_NULL = 0;
  const DEFAULT_LOCATION = 0;
  const SERVICES_COUNT = 3;
  const MEDIA_TYPE_COUNT = 3;
  const WEB_SERVICES_COUNT = 3;
  const MEDIA_LOKALNE_START = 6;
  const MEDIA_REGIONALNE_START = 6;
  const MEDIA_KRAJOWE_START = 13;

  public function getRoundName() {
    
    $rok = $this->getYear();
    $kw = $this->getKwartalRzymski();
    return $kw . '/' . $rok;
  }
  
  /**
   * Zwraca kwartal w postaci rzymskiej liczby na podstawie kwartalu
   * @return string 
   */
  public function getKwartalRzymski() {
    $kw = $this->getKwartal();
    switch ($kw) {
      case 1: $kw = 'I';
        break;
      case 2: $kw = 'II';
        break;
      case 3: $kw = 'III';
        break;
      case 4: $kw = 'IV';
        break;
    }
    
    return $kw;
  }
  
  /**
   * Zwraca poprzedni kwartal w postaci rzymskiej liczby na podstawie kwartalu
   * @return string 
   */
  public function getPoprzedniKwartalRzymski() {
    $kw = $this->getPoprzedniKwartal();
    switch ($kw) {
      case 1: $kw = 'I';
        break;
      case 2: $kw = 'II';
        break;
      case 3: $kw = 'III';
        break;
      case 4: $kw = 'IV';
        break;
    }
    
    return $kw;
  }
  
  /**
   * Zwraca rok dzialania firmy na podstawie rundy
   * @return integer
   */
  public function getYear() {
    return (floor(($this->gRN() - 1 ) / 4)) + 1;
  }
  
  /**
   * Zwraca poprzedni rok dzialania firmy na podstawie rundy
   * @return integer
   */
  public function getLastYear() {
    return (floor(($this->gRN() - 1 - 1 ) / 4)) + 1;
  }

  /**
   * Zwraca balans. Zaokragla kwote do calosci przy $format = true
   * @param boolean $format Czy zaokaglac kwote
   * @return float 
   */
  public function gB($format = false) {
    if ($format) {
      return artNumber::getKwotaNotacjaPolska($this->g('balans', 'round'));
    } else {
      return $this->g('balans', 'round');
    }
  }

  /**
   * Ustawia balans
   * @param float $value Nowa wartosc balansu
   */
  public function sB($value) {
    $this->s('balans', $value, 'round');
  }

  /**
   * Zmienia balans o podana wartosc
   * @param float $value Zmiana balansu
   */
  public function cB($value) {
    $this->s('balans', $this->gB() + $value, 'round');
  }

  /**
   * Zwraca lokalizacje
   * @return int
   */
  public function gL() {
    
    if (!$this->e('wybor_lokalizacji', 'round')){
      return HotelGameController::DEFAULT_LOCATION;
    }
    
    return $this->g('wybor_lokalizacji', 'round');
  }

  /**
   * Zwraca poziom wyposazenia pokoi standard
   * @return int
   */
  public function gWS() {
    return $this->g('pokoje_standard_wyposazenie', 'decision');
  }

  /**
   * Zwraca poziom wyposazenia pokoi lux
   * @return int
   */
  public function gWL() {
    return $this->g('pokoje_lux_wyposazenie', 'decision');
  }

  /**
   * Ustawia poziom wyposazenia pokoi standard
   * @param int $value
   */
  public function sWS($value) {
    $this->s('pokoje_standard_wyposazenie', $value, 'decision');
  }

  /**
   * Ustawia poziom wyposazenia pokoi lux
   * @param int $value
   */
  public function sWL($value) {
    $this->s('pokoje_lux_wyposazenie', $value, 'decision');
  }

  /**
   * Zwraca liczbe pokoi standard
   * @return int
   */
  public function gLPS() {
    return $this->g('pokoje_standard', 'round');
  }

  /**
   * Ustawia liczbe pokoi standard
   * @param int $value
   */
  public function sLPS($value) {
    $this->s('pokoje_standard', $value, 'round');
  }

  /**
   * Zmienia liczbe pokoi standard o podana wartosc
   * @param int $value
   */
  public function cLPS($value) {
    $this->s('pokoje_standard', $this->g('pokoje_standard', 'round') + $value, 'round');
  }

  /**
   * Zwraca liczbe pokoi lux
   * @return int
   */
  public function gLPL() {
    return $this->g('pokoje_lux', 'round');
  }

  /**
   * Ustawia liczbe pokoi lux
   * @param int $value
   */
  public function sLPL($value) {
    $this->s('pokoje_lux', $value, 'round');
  }
  
  /**
   * Zwraca cene pokoi standard
   * @return int
   */
  public function gCPS() {
    return $this->g('cena_pokoje_standard', 'decision', 0);
  }
  
  /**
   * Zwraca cene pokoi lux
   * @return int
   */
  public function gCPL() {
    return $this->g('cena_pokoje_lux', 'decision', 0);
  }

  /**
   * Zmienia liczbe pokoi lux o podana wartosc
   * @param int $value
   */
  public function cLPL($value) {
    $this->s('pokoje_lux', $this->g('pokoje_lux', 'round') + $value, 'round');
  }

  /**
   * Zwraca numer aktualnej rundy
   * @return int 
   */
  public function gRN() {;
    return $this->getGameData()->getRoundNumber();
  }

  /**
   * Sprawdza czy runda jest wyzsza niz podany numer rundy
   * (Round Greater Then)
   * Zakres $roundNumber - od 1 do 16
   * @param int $roundNumber Numer rundy (od 1 do 16)
   * @return boolean 
   */
  public function rGT($roundNumber) {
    if ($roundNumber < self::FIRST_ROUND || $roundNumber > self::LAST_ROUND) {
      throw new sfException('Podany numer rundy "' . $roundNumber . '" do porownania jest poza zakresem.');
    }
    // Odejmujemy 1 bo FIRST_ROUND = 1
    if ($this->gRN() > (self::FIRST_ROUND + $roundNumber - 1)) {
      return true;
    } else {
      return false;
    }
  }

  /**
   * Sprawdza czy runda jest nizsza niz podany numer rundy
   * (Round Lower Then)
   * Zakres $roundNumber - od 1 do 16
   * @param int $roundNumber Numer rundy (od 1 do 16)
   * @return boolean 
   */
  public function rLT($roundNumber) {
    if ($roundNumber < self::FIRST_ROUND || $roundNumber > self::LAST_ROUND) {
      throw new sfException('Podany numer rundy "' . $roundNumber . '" do porownania jest poza zakresem.');
    }
    // Odejmujemy 1 bo FIRST_ROUND = 1
    if ($this->gRN() < (self::FIRST_ROUND + $roundNumber - 1)) {
      return true;
    } else {
      return false;
    }
  }

  /**
   * Sprawdza czy runda jest rowna podanemu numerowi rundy
   * (Round Equal)
   * Zakres $roundNumber - od 1 do 16
   * @param int $roundNumber Numer rundy (od 1 do 16)
   * @return boolean 
   */
  public function rEQ($roundNumber) {
    if ($roundNumber < self::FIRST_ROUND || $roundNumber > self::LAST_ROUND) {
      throw new sfException('Podany numer rundy "' . $roundNumber . '" do porownania jest poza zakresem.');
    }
    if ((self::FIRST_ROUND + $roundNumber - 1) == $this->gRN()) {
      return true;
    } else {
      return false;
    }
  }

  /**
   * Zwraca ilosc pracownikow obslugi w sumie
   * @return int 
   */
  public function gPO() {
    return ($this->gPOS() + $this->gPOZ());
  }

  /**
   * Zwraca ilosc pracownikow administracji
   * @return int 
   */
  public function gPA() {
    return ($this->gPAS() + $this->gPAZ());
  }

  /**
   * Zwraca ilosc pracownikow obslugi na stale
   * @return int 
   */
  public function gPOS() {
    return $this->g('pracownicy_obslugi_stale_liczba', 'decision', 0);
  }
  
  /**
   * Zwraca ilosc pracownikow obslugi na zlecenie
   * @return int 
   */
  public function gPOZ() {
    return $this->g('pracownicy_obslugi_zlecenie_liczba', 'decision', 0);
  }

  /**
   * Zwraca ilosc pracownikow administracji na stale
   * @return int 
   */
  public function gPAS() {
    return $this->g('pracownicy_administracji_stale_liczba', 'decision', 0);
  }
  
  /**
   * Zwraca ilosc pracownikow administracji na zlecenie
   * @return int 
   */
  public function gPAZ() {
    return $this->g('pracownicy_administracji_zlecenie_liczba', 'decision', 0);
  }

  /**
   * Zwraca aktualny kwartal. Mozliwe wartosci to:
   * 1 - zima
   * 2 - wiosna
   * 3 - lato
   * 4 - jesien
   * @return int
   */
  public function getKwartal() {
    return ((($this->gRN() - 1) % 4) + 1);
  }
  
  /**
   * Zwraca poprzedni kwartal. Mozliwe wartosci to:
   * 1 - zima
   * 2 - wiosna
   * 3 - lato
   * 4 - jesien
   * @return int
   */
  public function getPoprzedniKwartal() {
    return ((($this->gRN() - 1 - 1) % 4) + 1);
  }
  
  /**
   * Zwraca nazwe kwartalu na podstawie funkcji getKwartal()
   * @return string 
   */
  public function getKwartalNazwa() {
    $name = 'Pusty kwartał';
    switch ($this->getKwartal()) {
      case 1: $name = 'Zima';
        break;
      case 2: $name = 'Wiosna';
        break;
      case 3: $name = 'Lato';
        break;
      case 4: $name = 'Jesień';
        break;
    }
    
    return $name;
  }

  /**
   * Zwraca procentowa wartosc oblozenia pokoi standard.
   * @return float
   */
  public function gPOSProc() {
    if ($this->rEQ(1)) {
      return 0;
    } else {
      return $this->g('pokoje_oblozone_standard_procent', 'last_round');
    }
  }

  /**
   * Zwraca procentowa wartosc oblozenia pokoi lux.
   * @return float
   */
  public function gPOLProc() {
    if ($this->rEQ(1)) {
      return 0;
    } else {
      return $this->g('pokoje_oblozone_lux_procent', 'last_round');
    }
  }

  public static function format_money_value($value, $withNbsp = true) {
    
    if(is_string($value)){
      $value = (int) $value;
    }
    
    if ($withNbsp) {
      return str_replace(" ", "&nbsp;", number_format($value, 2, ',', ' ') . ' PLN');
    } else {
      return number_format($value, 2, ',', ' ') . ' PLN';
    }
  }
  
  public static function format_money_value_color($value) {
    $className = 'number_zero';
    
    if ($value < 0)
      $className = 'number_negative';
    
    if ($value > 0)
      $className = 'number_positive';
    
    return '<span class="'.$className.'">'.self::format_money_value($value).'</span>';
  }

  public function formatMoneyValue($value) {
    return self::format_money_value($value);
  }
  
  public function formatMoneyValueColor($value) {
    return self::format_money_value_color($value);
  }
  
  /**
   * Zwraca miejsce druzyny w rankingu dla poprzedniej rundy
   * @return string
   */
  public function getRankingMiejsce() {
    return $this->g('ranking|runda_'.($this->gRN() - 1).'|'.$this->getGameData()->getTeam()->getId().'|pozycja', 'game');
  }
  
  /**
   * Zwraca wartosc druzyny w rankingu dla poprzedniej rundy
   * @return string
   */
  public function getRankingWartosc() {
    return $this->g('ranking|runda_'.($this->gRN() - 1).'|'.$this->getGameData()->getTeam()->getId().'|wartosc_rankingu', 'game');
  }

  public function getLocalizationName($kwartal = true) {
    $id = $this->gL();

    if ($id == null)
      return 'Brak wybranej lokalizacji';

    switch ($id) {
      case 0: $name = 'Przedmieścia';
        break;
      case 1: $name = 'Śródmieście';
        break;
      case 2: $name = 'Centrum';
        break;
      default: $name = 'Brak wybranej lokalizacji';
    }
    
    if ($kwartal)
      return $name.' ('.$this->getKwartalNazwa().')';
    else
      return $name;
  }
  
  /**
   * Set tester table. Tablica wyswietlana w panelu testera
   * @param type $path
   * @param type $value
   */
  public function sTT($path, $value, $array = null) {
    $pathArray = explode('|', $path);
    
    $isNull = is_null($array);
    if ($isNull) {
      $array = $this->g('tester_table', 'raport', array());
    }
    
    if (count($pathArray) > 1) {
      $key = $pathArray[0];
      unset($pathArray[0]);
      if (!isset($array[$key])) {
        $array[$key] = array();
      }
      $array[$key] = $this->sTT(implode('|', $pathArray), $value, $array[$key]);
    } else {
      $array[$pathArray[0]] = $value;
    }
    
    if ($isNull) {
      $this->s('tester_table', $array, 'raport');
    } else {
      return $array;
    }
  }
  
  /**
   * Zamienia nam tablice jednopoziomowa na stringa => [X, X, X]
   * @param array $array
   */
  public function aTS(array $array) {
    return '['.implode(', ', $array).']';
  }
}
