<?php

/**
 * Klasa zwierająca metody służace do obsługi wiadomosci w grze.
 *
 */
class HotelGameMessage extends BaseGameMessage {

  const EVENT_CATEGORY = "event";
  const CATEGORY = "Wiadomości";

  /**
   * Ustawia EVENT z partiala
   *
   * @param $message= array('partial' => 'Unikalna nazwa partiala')
   * @param $params
   */
  public function setEvent($partial, $uniqueName, $status = HotelGameMessage::NOT_READ) {
    
    $message = array();
    $message['type'] = 'partial';
    $message['partial'] = $partial;
    $message['status'] = $status;
    $message['title'] = 'Jakis tytul';
    $message['category'] = self::EVENT_CATEGORY;
    $message['application'] = 'frontend'; 
    $message['unique_name'] = $uniqueName;
    $sentTo = array('type' => 'team');

    return $this->sendMessage($message, array(), $sentTo);
  }
  
  /**
   * Ustawia Wiadomosc z partiala
   *
   */
  public function setMessage($uniqueName, $status = HotelGameMessage::NOT_READ) {
    
    $message = array();
    $message['type'] = 'partial';
    $message['status'] = $status;
    $message['partial'] = 'message/message_simple';
    $message['params'] = array('uniqueName' => $uniqueName);
    $message['category'] = self::CATEGORY;
    $message['application'] = 'frontend'; 
    $message['unique_name'] = $uniqueName;
    $sentTo = array('type' => 'team');

    return $this->sendMessage($message, array(), $sentTo);
  }
  /**
   * Zwraca parametry gry wykorzystywane w wiadomosciach
   * @return array 
   */
  public function getMessageParams() {
    return array(
      'płaca_minimalna' => self::format_money_value(($this->getGameProcess()->getPlacaMinimalnaPracownicyObslugi() + $this->getGameProcess()->getPlacaMinimalnaPracownicyAdministracji()) / 2),
      'minimalna_oferta_obsługa' => self::format_money_value($this->getGameProcess()->getPlacaMinimalnaPracownicyObslugi()),
      'średnia_oferta_obsługa' => self::format_money_value($this->getGameProcess()->getPlacaSredniaPracownicyObslugi()),
      'minimalna_oferta_administracja' => self::format_money_value($this->getGameProcess()->getPlacaMinimalnaPracownicyAdministracji()),
      'średnia_oferta_administracja' => self::format_money_value($this->getGameProcess()->getPlacaSredniaPracownicyAdministracji()),
      'kredyt_karny_kwota' => self::format_money_value($this->g('kredyt_karny_kwota', 'round')),
      'kredyt_karny_odsetki' => $this->g('kredyty|karny|odsetki', 'game') * 100,
    );
  }
}