<?php

/**
 * Klasa zarzadzania procesem gry dla gry Hotel
 */
class HotelGameProcess extends BaseGameProcess {

    /**
     * Konstruktor. 
     * 
     * @param BaseGameController $gameController
     * Division by zero w R6->R7 jest division by ZERO w ~763 w Hotel gAME Process
     * 1500 tez notice
     * Panele słoneczne są rypnięte jak mam mniej kasy to nei da się kupić
     */
    public function __construct(BaseGameController $gameController) {
        parent::__construct($gameController);
    }

    /**
     * Funkcja popytu.
     *
     * @param $a
     * @param $b
     * @param $c
     * @param $t
     * @param int $x
     * @return int
     * $this->demand($af, $b, $c, $tf, $cena);
     */
    protected function demand($a, $b, $c, $t, $x = 0) {
        $popyt = $a * pow(($x + $c), $t) - $b;
        return $popyt;
    }

    /**
     * Funkcja zwraca poczatkowe wartosci dla 'game_data_json' wstawiane podczas aktywacji gry.
     * 
     * @return array Tablica z danymi gry
     */
    public static function getGameJsonData() {
        return static::prepareMathModel();
    }

    /**
     * Funkcja zwraca poczatkowe wartosci rundy dla 'round_data_json' wstawiane podczas tworzenia pierwszej rundy.
     * 
     * @return array Tablica PHP z danymi gry
     */
    public static function getFirstRoundDataJson() {
        return sfConfig::get('game_first_round');
    }

    /**
     * Funkcja zwraca poczatkowe wartosci rundy dla 'round_decision_data_json' wstawiane podczas tworzenia pierwszej rundy.
     * 
     * @return array Tablica PHP z danymi gry
     */
    public static function getFirstRoundDecisionDataJson() {
        return sfConfig::get('game_first_round_decisions');
    }

    /**
     * Funkcja zwraca poczatkowe wartosci rundy dla 'round_raport_data_json' wstawiane podczas tworzenia pierwszej rundy.
     * @return array Tablica PHP z danymi gry
     */
    public static function getFirstRoundRaportDataJson() {
        return array(
            'finansowy' => array(),
            'finansowy_head' => array(),
            'operacyjny' => array(),
            'kpir' => array(),
            'marza' => array(
                'standard' => array(),
                'lux' => array(),
                'razem' => array(),
                'standard_suma' => 0,
                'lux_suma' => 0,
                'razem_suma' => 0,
            ),
        );
    }

    /**
     * Funkcja przygotowuje tablice z modelem matematycznym. 
     * 
     * @return type
     */
    public static function prepareMathModel() {
        return sfConfig::get('game_math_model');
    }

    /**
     * Funkcja aktywuje gre. Dodaje runde 0 dla kazdej druzyny. Uzupelnia dane
     * gry o 'game_data_json' i 'game_controller_class' oraz zmienia jej status na 1 (aktywna).
     *
     * @param int $gameId ID Gry
     * @param string $gameControllerClass Klasa kontrolera grys
     * @throws sfException 
     */
    public static function activateGame($gameId, $gameControllerClass, $gameDataClass) {
        $game = Doctrine::getTable('Game')->findOneById($gameId);

        if (!$game) {
            throw new sfException('Gra o id "' . $gameId . '" nie istnieje.');
        }
        if ($game->isActive() || $game->isArchive()) {
            throw new sfException('Gra o id "' . $gameId . '" została już zainicjalizowana.');
        }

        $teams = Doctrine::getTable('Team')->findByGameId($gameId);
        if ($teams->count() == 0) {
            throw new sfException('Gra o id "' . $gameId . '" nie posiada przypisanych drużyn.');
        }

        $game->setGameControllerClass($gameControllerClass);
        if (!$game->isPrepared()) {
            $game->setGameDataJson($gameDataClass::arrayToJson(static::getGameJsonData()));
        }

        $game->setStatus(Game::ACTIVE);
        $game->save();

        foreach ($teams as $team) {
                        self::createFirstRound($team, $gameDataClass, $gameDataClass::jsonToArray($game->getGameDataJson()));
            $gameController = new $gameControllerClass($team->getId());
            $gameController->getGameProcess()->calculateRoundStart();
            $gameController->getGameData()->save(true);
            self::sendCommandToNginx($team->getId());
        }
    }

    /**
     * Funkcja przechodzi do nastepnej rundy dla zespolow w calej grze
     * @param type $gameId
     * @param type $gameControllerClass 
     */
    public static function moveToNextRoundForGame($gameId, $gameControllerClass) {
        $teams = Doctrine::getTable('Team')->findByGameId($gameId);
        $gameController = null;

        foreach ($teams as $team) {
            $gameController = new $gameControllerClass($team->getId());
            $gameController->getGameProcess()->moveToNextRound();
        }
        // GC potrzebny do pobrania game
        self::obliczOceneRankingowa($gameController);
        $gameController = null;

        foreach ($teams as $team) {
            $gameController = new $gameControllerClass($team->getId());
            $gameController->getGameProcess()->calculateRoundStart();
            $gameController->getGameData()->save(true);

            self::sendCommandToNginx($team->getId());
        }
    }

    public static function sendCommandToNginx($teamID) {
        $channel = md5("arteneo_team_$teamID");
        $host = $_SERVER['HTTP_HOST'];
        $curlRequest = new sfCurl("http://$host/pub?id=$channel");

        $timestamp = sfContext::getInstance()->getRequest()->getCookie('timestamp', md5(time()));
        $symfony = sfContext::getInstance()->getRequest()->getCookie('symfony', null);

        $array = array(
            'timestamp' => $timestamp,
            'symfony' => $symfony,
            'sender' => sfContext::getInstance()->getUser()->getId(),
            'reload' => FALSE,
            'map_change' => TRUE,
            'host' => $host,
            'channel' => $channel
        );

        $curlRequest->setPost(json_encode($array));
        $curlRequest->createCurl();

        if ($curlRequest->getHttpStatus() != 200) {
            //throw new sfException("CURL NGINX Request FAILED !"); 
        }
    }

    /**
     * Funkcja przechodzi do nastepnej rundy dla zespolu
     */
    public function moveToNextRound() {
        if ($this->getGameData()->getRoundNumber() >= self::LAST_ROUND) {
            throw new sfException('Brak nastepnej rundy.');
        }
        $this->getGameData()->getRound()->setStatus(Round::INACTIVE);
        // Zapisujemy recznie obiekt rundy
        $this->getGameData()->getRound()->save();
        // Przeliczenie rundy
        $this->nextRound();

        $this->getGameData()->setMode(BaseGameData::FORCE_SAVE);
        $this->getGameData()->save(true);

        // Przeszlismy do nastepnej rundy
        // WAZNE: Nie zapisywac teraz obiektu rundy do DB
        // Dane beda tylko w obiekcie i zostana przeniesione do nastepnej rundy
        // Zmieniamy numer rundy na nastepna
        // W ten sposob symulujemy przeliczenie danych ale na poczatku nastepnej rundy
        // -- Nie dziala, zapisije sie w obu rundach --
//    $this->getGameData()->getRound()->setRoundNumber($this->gRN() + 1);
//    $this->getGameData()->setMode(HotelGameData::FORCE_SAVE);
//    $this->calculateRoundStart();
//    $this->getGameData()->save(false);
//    $this->getGameData()->getRound()->setRoundNumber($this->gRN() - 1);
        // Tworzymy obiekt nowej rundy
        $newRound = new Round();
        $newRound->setStatus(Round::ACTIVE);
        $newRound->setTeam($this->getGameData()->getTeam());
        $newRound->setRoundNumber($this->gRN() + 1);
        $newRound->setRoundDataJson($this->getGameData()->getRound()->getRoundDataJson());
        $newRound->setRoundRaportDataJson($this->getGameData()->getRound()->getRoundRaportDataJson());
        $gameControllerClass = get_class($this->gameController);
        $gameDataClass = $gameControllerClass::getClass('BaseGameData');
        $this->setDefaultDecisions($newRound, $gameDataClass);
        $newRound->setName('Runda ' . $newRound->getRoundNumber());
        $newRound->save();

                $this->getGameLog()->save();
    }

    /**
     * Funkcja przelicza dane dla poczatku rundy
     */
    public function calculateRoundStart() {
        $this->getGameView()->prepareBuildingsAndSquares();
        $this->prepareRaports();
        $this->setEvents();

        if ($this->rEQ(1)) {
            $this->sB($this->g('kapital_zalozycielski', 'game') + $this->dofinansowanie());
        }
    }

    /**
     * Funkcja ustawia wartości domyślne decyzji po przeliczeniu wyników aktualnej rundy. 
     *  
     * @param type $round
     */
    protected function setDefaultDecisions($round, $gameDataClass) {
        $decisions = $gameDataClass::jsonToArray($this->getGameData()->getRound()->getRoundDecisionDataJson());
        $decisions['pokoje_standard'] = 0;
        $decisions['pokoje_lux'] = 0;
        $round->setRoundDecisionDataJson($gameDataClass::arrayToJson($decisions));
    }

    /**
     * Funkcja przejścia do następnej rundy. 
     */
    protected function nextRound() {
        $this->s('tester_table', array(), 'raport');
        // Przeliczenie nowego stanu gry. 
        $this->calculate();

        if ($this->rGT(1) && $this->gLPS() > 0 && $this->gCPS() == 0) {
            $this->getGameMessage()->setMessage('cena-zero-standard');
        }

        if ($this->rGT(1) && $this->gLPL() > 0 && $this->gCPL() == 0) {
            $this->getGameMessage()->setMessage('cena-zero-lux');
        }

        // Obliczenia juz po przeliczeniu rundy
        $this->postCalculate();
        // Dodatkowe wiadomosci w zaleznosci od stanu gry
        $this->sendAdditionalMessages();
    }

    /**
     * Wysyla dodatkowie wiadomosci po przeliczeniu rundy
     */
    protected function sendAdditionalMessages() {
        $this->getGameMessage()->setMessage('runda-' . $this->gRN());

        if ($this->rEQ(3)) {
            $this->getGameMessage()->setMessage('sniadania');
        }

        if ($this->rGT(1) && $this->g('kredyt_karny_kwota', 'round') > 0) {
            $this->getGameMessage()->setMessage('kredyt-karny');
        }

        if ($this->rEQ(2) && $this->gLPS() == 0) {
            $this->getGameMessage()->setMessage('brak-pokoi');
        }

        if ($this->rEQ(2)) {
            $this->getGameMessage()->setMessage('uwaga-badanie-marketingowe-uslugi-podstawowe');
        }

        if ($this->rEQ(4)) {
            $this->getGameMessage()->setMessage('uwaga-badanie-marketingowe-sezonowosc');
        }

        if ($this->rEQ(5)) {
            $this->getGameMessage()->setMessage('uwaga-badanie-marketingowe-popyt-lux');
            $this->getGameMessage()->setMessage('uwaga-badanie-marketingowe-reklama-zaawansowana');
        }

        if ($this->rEQ(12)) {
            $this->getGameMessage()->setMessage('uwaga-badanie-marketingowe-konkurencja');
        }

        if ($this->rEQ(13)) {
//        $this->getGameMessage()->setMessage('wzrost-placy-sredniej');
            $this->getGameMessage()->setMessage('uwaga-badanie-marketingowe-uslugi-zaawansowane-segmentacja');
        }
    }

    /**
     * Obliczenia juz po przeliczeniu rundy 
     */
    protected function postCalculate() {
        $archive = $this->g('archiveDecision', 'round', array());
        $archive['runda_' . $this->gRN()]['cena_pokoje_standard'] = $this->g('cena_pokoje_standard', 'decision');
        $archive['runda_' . $this->gRN()]['cena_pokoje_lux'] = $this->g('cena_pokoje_lux', 'decision');
        $this->s('archiveDecision', $archive, 'round');

        if ($this->g('strona_internetowa', 'decision')) {
            // Ustawiamy flage ze kupiono strone internetowa
            $this->s('kupiona_strona_internetowa', 1, 'round');
        }

        $this->calculateRaports();

        // Pokoje w budowie przechodza jako pokoje juz dostepne
        $pokojeStandardBudowa = max(0, $this->g('pokoje_standard', 'decision'));
        $this->logI('F(' . __FUNCTION__ . '): Wybudowano nowych pokoi standard:', $pokojeStandardBudowa);
        $this->cLPS($pokojeStandardBudowa);
        $this->s('pokoje_standard', 0, 'decision');
        $this->s('pokoje_standard_wybudowano', $pokojeStandardBudowa, 'round');

        $pokojeLuxBudowa = max(0, $this->g('pokoje_lux', 'decision'));
        $this->logI('F(' . __FUNCTION__ . '): Wybudowano nowych pokoi lux:', $pokojeLuxBudowa);
        $this->cLPL($pokojeLuxBudowa);
        $this->s('pokoje_lux', 0, 'decision');
        $this->s('pokoje_lux_wybudowano', $pokojeLuxBudowa, 'round');

        $wspSatysfakcji = (($this->g('wspolczynnik_zadowolenie_klienta_standard', 'round') + $this->g('wspolczynnik_zadowolenie_klienta_lux', 'round')) / 2) + $this->g('wspolczynnik_zadowolenia_pracownikow', 'round') + 1;
        $wspZZ = $this->wspZrownowazonegoRozwoju() + 1;

        // Ranking
        $ranking = array(
            'nazwa_firmy' => $this->g('nazwa_marki', 'decision', 'Brak nazwy'),
            'wynik_ekonomiczny_firmy' => $this->getWynikEkonomicznyFirmy(),
            'wsp_zrownowazonego_rozwoju' => max(1, $wspZZ),
            'wsp_satysfakcji' => max(1, $wspSatysfakcji),
        );

        $game = $this->getAll('game');
        $game['ranking']['runda_' . $this->gRN()][$this->getGameData()->getTeam()->getId()] = $ranking;
        $this->setAll($game, 'game');
    }

    public function getWynikEkonomicznyFirmy() {
        $wynik = ($this->getZyskownoscFirmy() + $this->getWartoscUdzialow()) * $this->wspZadluzeniaFirmy();

        return $wynik;
    }

    public function wspZadluzeniaFirmy() {
        $ratio = $this->getZadluzenieFirmy() / $this->getWartoscFirmy();
        $wsp = 1;

        if ($ratio > 1) {
            $wsp = 0.75;
        }

        if ($ratio > 2) {
            $wsp = 0.5;
        }

        return $wsp;
    }

    public function getZyskownoscFirmy() {
        return $this->g('zysk', 'round') / $this->g('liczba_udzialow', 'game');
    }

    public function getWartoscUdzialow() {
        return $this->getWartoscFirmy() / $this->g('liczba_udzialow', 'game');
    }

    /**
     * Funkcja ustawia eventy ktore mialy trwac tylko jedna runde
     * jako nieaktywne
     */
    protected function resetEvents() {
        $this->s('event_mistrzostwa', 0, 'round');
    }

    /**
     * Ustawia eventy dla nowej rundy. | Wysyła wiadomości z partiali /apps/frontend/events/templates
     * 
     * @return boolean
     */
    public function setEvents() {
        $this->resetEvents();

        if ($this->rEQ(3)) {
            $this->s('event_podwyzka_cen_wody', 1, 'round');
        }
        if ($this->rEQ(6)) {
            $this->getGameMessage()->setMessage('projekty-wladz-samorzadowych');
        }
        if ($this->rEQ(7)) {
            $this->s('event_mistrzostwa', 1, 'round');
            $this->getGameMessage()->setEvent('events/panele_sloneczne', 'panele-sloneczne');
        }
        if ($this->rEQ(8)) {
            $this->getGameMessage()->setEvent('events/zimowisko', 'zimowisko');
            $this->s('event_oplata_klimatyczna', 1, 'round');
        }
        if ($this->rEQ(10)) {
            $this->getGameMessage()->setEvent('events/stop_umowom_smieciowym', 'stop-umowom-smieciowym');
        }
        if ($this->rEQ(11)) {
            $this->s('event_podwyzka_placy_minimalnej', 1, 'round');
            $this->getGameMessage()->setEvent('events/podwyzka_placy_min', 'podwyzka-placy-minimalnych');
            $this->getGameMessage()->setEvent('events/kierowniczka', 'kierowniczka');
            $this->getGameMessage()->setMessage('akcja-charytatywna');
        }
        if ($this->rEQ(12)) {
            $this->getGameMessage()->setEvent('events/pralnia_eko', 'pralnia-ekologiczna');
            $this->getGameMessage()->setEvent('events/szkolenie', 'szkolenie');
            $this->getGameMessage()->setEvent('events/podjazd_niepelnosprawni', 'podjazd-dla-niepelnosprawnych');
        }
        if ($this->rEQ(13)) {
            $this->s('event_konkurencja', 1, 'round');
            $this->s('event_podwyzka_placy_sredniej', 1, 'round');
            $this->getGameMessage()->setEvent('events/podwyzka_placy_sredniej', 'podwyzka-placy-sredniej');
        }
        if ($this->rEQ(15)) {
            $this->s('event_agresywna_konkurencja', 1, 'round');
            $this->s('event_fundusz_remontowy', 1, 'round');
            $this->getGameMessage()->setEvent('events/mikolajkowy', 'mikolajkowy-eskpres');
//      $this->getGameMessage()->setEvent('events/fundusz_remontowy', 'fundusz-remontowy');
            $this->getGameMessage()->setMessage('zaciekly-konkurent');
        }
    }

    /**
     * Kupuje dane badania. Wysyla wiadomosc, zapisuje ze badania zostaly kupione
     * oraz odlicza koszt badan od balansu
     * @param string $nazwa Nazwa badan (zgodna z game.yml)
     */
    public function buyResearch($nazwa, $decision, $status = HotelGameMessage::NOT_READ) {
        if (!$this->hasResearch($nazwa)) {
            if ($decision) {
                $this->getGameMessage()->setMessage($nazwa, $status);
                $koszt = $this->getResearchCost($nazwa);
                $this->cB(-$koszt);

                // Wszystkie badania ida do jednej kategorii
                $this->addRaportFinansowyEntry('koszty|marketingowe|badania', $koszt);
                $this->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|inne_wydatki', $koszt, true);
            }

            $this->s($nazwa, $decision, 'round');
            // Dla widgetu
            $this->s($nazwa, $decision, 'decision');
        }
    }

    public function hasMap() {
        return ($this->g('mapa', 'game', false) && $this->g('mapa', 'round', true));
    }

    public function hasMapHd() {
        return ($this->hasMap() && $this->g('mapa_hd', 'round', true));
    }

    public function hasMusic() {
        return ($this->g('muzyka', 'game', false) && $this->g('muzyka', 'round', true));
    }

    /**
     * Sprawdza czy zespol ma wykupione dane badania
     * @param boolean $nazwa 
     */
    public function hasResearch($nazwa) {
        return $this->g($nazwa, 'round', false);
    }

    /**
     * Zwraca koszt badan. Pobiera z game.yml "badania|$nazwa"
     * @param string $nazwa Nazwa badan (zgodna z game.yml)
     * @return float Koszt badan
     */
    public function getResearchCost($nazwa) {
        return $this->g('badania|' . $nazwa, 'game');
    }

    /**
     * Funkcja sprawdza czy wprowadzony zostal dany event
     * @return boolean
     */
    public function hasEventPodwyzkaCenWody() {
        return $this->g('event_podwyzka_cen_wody', 'round', false);
    }

    /**
     * Funkcja sprawdza czy wprowadzony zostal dany event
     * @return boolean
     */
    public function hasEventOplataKlimatyczna() {
        return $this->g('event_oplata_klimatyczna', 'round', false);
    }

    /**
     * Funkcja sprawdza czy wprowadzony zostal dany event
     * @return boolean
     */
    public function hasEventMistrzostwa() {
        return $this->g('event_mistrzostwa', 'round', false);
    }

    /**
     * Funkcja sprawdza czy wprowadzony zostal dany event
     * @return boolean
     */
    public function hasEventKonkurencja() {
        return $this->g('event_konkurencja', 'round', false);
    }

    /**
     * Funkcja sprawdza czy wprowadzony zostal dany event
     * @return boolean
     */
    public function hasEventAgresywnaKonkurencja() {
        return $this->g('event_agresywna_konkurencja', 'round', false);
    }

    /**
     * Funkcja sprawdza czy wprowadzony zostal dany event
     * @return boolean
     */
    public function hasEventFunduszRemontowy() {
        return $this->g('event_fundusz_remontowy', 'round', false);
    }

    /**
     * Funkcja sprawdza czy wprowadzony zostal dany event
     * @return boolean
     */
    public function hasEventPodwyzkaPlacyMinimalnej() {
        return $this->g('event_podwyzka_placy_minimalnej', 'round', false);
    }

    /**
     * Funkcja sprawdza czy wprowadzony zostal dany event
     * @return boolean
     */
    public function hasEventPodwyzkaPlacySredniej() {
        return $this->g('event_podwyzka_placy_sredniej', 'round', false);
    }

    public function isUslugaEventActive($name) {
        if ($name == 'usluga_golf') {
            if ($this->rGT(7) && $this->getKwartal() != 1) {
                return true;
            }
        }
        if ($name == 'usluga_wyciag_narciarski') {
            if ($this->rGT(5) && ($this->getKwartal() == 1 || $this->getKwartal() == 4)) {
                return true;
            }
        }
        if ($name == 'usluga_plaza') {
            if ($this->rGT(6) && ($this->getKwartal() == 3 || $this->getKwartal() == 4)) {
                return true;
            }
        }

        return false;
    }

    public function isUslugaEventAccepted($name) {
        return $this->isUslugaEventActive($name) && $this->g($name, 'decision', false);
    }

    /**
     * Zwraca współczynnik sadzenie drzew [Event], Wpływa na popyt.
     * 
     * @return float
     */
    protected function wspEventSadzenieDrzew() {
        $value = $this->g('event_sadzenie_drzew', 'decision', 0);
        $wsp = $value / 3;

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik event sadzenia drzew:', $wsp);
        return $wsp;
    }

    /**
     * Zwraca koszt za udzial w evencie kierowniczka
     * 
     * @return float
     */
    protected function kosztEventKierowniczka() {
        $koszt = 0;
        $wersja = $this->g('event_kierowniczka', 'decision', 0);
        if ($wersja > 0) {
            $koszt = $this->g('eventy|kierowniczka|wersja_' . $wersja . '|koszt', 'game');
        }

        $this->logK('F(' . __FUNCTION__ . '): Koszt event kierowniczka:', $koszt);
        return $koszt;
    }

    public function wspEventMistrzostwa() {
        $wsp = self::WSP_NULL;

        if ($this->hasEventMistrzostwa()) {
            $wsp = 1;
        }

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik event mistrzostwa:', $wsp);
        return $wsp;
    }

    public function wspEventPanele() {
        $wsp = self::WSP_NULL;

        if ($this->g('event_panele', 'decision') > 0) {
            $wsp = 1;
        }

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik event panele:', $wsp);
        return $wsp;
    }

    public function wspEventZimowisko() {
        $wsp = $this->g('event_zimowisko', 'decision', self::WSP_NULL);

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik event zimowisko:', $wsp);
        return $wsp;
    }

    public function wspEventPodjazdDlaNiepelnosprawnych() {
        $wsp = $this->g('event_podjazd_dla_niepelnosprawnych', 'decision', self::WSP_NULL);

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik event podjazd dla niepelnosprawnych:', $wsp);
        return $wsp;
    }

    public function wspEventPralniaEkologiczna() {
        $wsp = $this->g('event_pralnia_ekologiczna', 'decision', self::WSP_NULL);

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik event pralnia ekologiczna:', $wsp);
        return $wsp;
    }

    public function wspEventAkcjaCharytatywna() {
        $wsp = $this->g('event_akcja_charytatywna', 'decision', self::WSP_NULL);

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik event akcja charytatywna:', $wsp);
        return $wsp;
    }

    public function wspEventStopUmowomSmieciowym() {
        $decyzja = $this->g('event_stop_umowom_smieciowym', 'decision', false);

        if ($decyzja && (($this->gPO() + $this->gPA()) > 0)) {
            $procent = $this->g('eventy|stop_umowom_smieciowym', 'game');

            if (ceil($this->gPO() * $procent) < $this->gPOZ() ||
                    ceil($this->gPA() * $procent) < $this->gPAZ()) {
                $wsp = -1;
            } else {
                $wsp = 1;
            }
        } else {
            $wsp = 0;
        }

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik event stop umowom smieciowym:', $wsp);
        return $wsp;
    }

    public function wspEventKierowniczka() {
        $wsp = self::WSP_NULL;
        $wersja = $this->g('event_kierowniczka', 'decision', 0);
        if ($wersja != 0) {
            $wsp = $this->g('eventy|kierowniczka|wersja_' . $wersja . '|wspolczynnik', 'game');
        }

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik kierowniczka:', $wsp);
        return $wsp;
    }

    public function wspEventSzkolenie() {
        $wsp = $this->g('event_szkolenie', 'decision', self::WSP_NULL);

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik event szkolenie:', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik sprzatania outsourcing standard
     *
     * @return float
     */
    protected function wspSprzatanieOutsourcingStandard() {
        $kwota = $this->g('sprzatanie_outsourcing_standard_kwota', 'decision');
        $wsp = self::WSP_NULL;
        if ($kwota > 0 && $this->gPO() == 0) {
            $pokojeOblozoneStandard = 0;
            if ($this->getGameData()->hasLastRound()) {
                $pokojeOblozoneStandard = $this->g('pokoje_oblozone_standard', 'last_round');
            }

            $kss = $this->g('koszty_bazowe|pokoje_nieoblozone|sprzatanie', 'game');
            $kss = $kss[$this->gL()];
            $ksso = $this->g('koszty_bazowe|pokoje_oblozone|sprzatanie', 'game');
            $ksso = $ksso[$this->gL()];
            $ks = $this->gLPS() * $kss + $pokojeOblozoneStandard * $ksso;
            $rspmin = $this->g('sprzatanie_outsourcing_standard|rmin', 'game') * $ks;
            $rspmax = $this->g('sprzatanie_outsourcing_standard|rmax', 'game') * $ks;
            $wsp = (min(array($kwota, $rspmax)) - $rspmin) / ($rspmax - $rspmin);
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik sprzątanie outsourcing standard: ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik sprzatania outsourcing lux
     *
     * @return float
     */
    protected function wspSprzatanieOutsourcingLux() {
        $kwota = $this->g('sprzatanie_outsourcing_lux_kwota', 'decision');
        $wsp = self::WSP_NULL;
        if ($kwota > 0 && $this->gPO() == 0) {
            $pokojeOblozoneLux = 0;
            if ($this->getGameData()->hasLastRound()) {
                $pokojeOblozoneLux = $this->g('pokoje_oblozone_lux', 'last_round');
            }

            $kss = $this->g('koszty_bazowe|pokoje_nieoblozone|sprzatanie', 'game');
            $kss = $kss[$this->gL()] * $this->getWspLux();
            $ksso = $this->g('koszty_bazowe|pokoje_oblozone|sprzatanie', 'game');
            $ksso = $ksso[$this->gL()] * $this->getWspLux();

            $ks = $this->gLPL() * $kss + $pokojeOblozoneLux * $ksso;
            $rspmin = $this->g('sprzatanie_outsourcing_lux|rmin', 'game') * $ks;
            $rspmax = $this->g('sprzatanie_outsourcing_lux|rmax', 'game') * $ks;

            $wsp = (min(array($kwota, $rspmax)) - $rspmin) / ($rspmax - $rspmin);
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik sprzątanie outsourcing lux: ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik prania outsourcing standard
     *
     * @return float
     */
    protected function wspPranieOutsourcingStandard() {

        $kwota = $this->g('pranie_outsourcing_standard_kwota', 'decision');
        $wsp = $this->wspEventPralniaEkologiczna();

        // Jak $wsp = 1 to znaczy ze mamy pralnie ekologiczna i nie ma co liczyc
        if ($kwota > 0 && $wsp != 1 && $this->gLPS() > 0) {
            $pokojeOblozoneStandard = 0;
            if ($this->getGameData()->hasLastRound()) {
                $pokojeOblozoneStandard = $this->g('pokoje_oblozone_standard', 'last_round');
            }

            $kss = $this->g('koszty_bazowe|pokoje_nieoblozone|pranie', 'game');
            $kss = $kss[$this->gL()];

            $ksso = $this->g('koszty_bazowe|pokoje_oblozone|pranie', 'game');
            $ksso = $ksso[$this->gL()];

            $ks = $this->gLPS() * $kss + $pokojeOblozoneStandard * $ksso;
            if ($ks > 0) {
                $rspmin = $this->g('pranie_outsourcing_standard|rmin', 'game') * $ks;
                $rspmax = $this->g('pranie_outsourcing_standard|rmax', 'game') * $ks;

                $wsp = (min(array($kwota, $rspmax)) - $rspmin) / ($rspmax - $rspmin);
            }
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pranie outsourcing standard: ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik prania outsourcing lux
     *
     * @return float
     */
    public function wspPranieOutsourcingLux() {
        $kwota = $this->g('pranie_outsourcing_lux_kwota', 'decision');
        $wsp = $this->wspEventPralniaEkologiczna();

        // Jak $wsp = 1 to znaczy ze mamy pralnie ekologiczna i nie ma co liczyc
        if ($kwota > 0 && $wsp != 1 && $this->gLPL() > 0) {
            $pokojeOblozoneLux = 0;
            if ($this->getGameData()->hasLastRound()) {
                $pokojeOblozoneLux = $this->g('pokoje_oblozone_lux', 'last_round');
            }

            $kss = $this->g('koszty_bazowe|pokoje_nieoblozone|pranie', 'game');
            $kss = $kss[$this->gL()];

            $ksso = $this->g('koszty_bazowe|pokoje_oblozone|pranie', 'game');
            $ksso = $ksso[$this->gL()];

            $ks = ($this->gLPL() * $kss + $pokojeOblozoneLux * $ksso) * $this->getWspLux();
            if ($ks > 0) {
                $rspmin = $this->g('pranie_outsourcing_lux|rmin', 'game') * $ks;
                $rspmax = $this->g('pranie_outsourcing_lux|rmax', 'game') * $ks;

                $wsp = (min($kwota, $rspmax) - $rspmin) / ($rspmax - $rspmin);
            }
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pranie outsourcing lux: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik wyposażenia dla pokoi standard.
     *
     * @return float
     */
    protected function wspWyposazenieStandard() {
        $wsp = self::WSP_NULL;
        $suma = $this->g('wyposazenie|koszt_wyposazenie_' . $this->gWS(), 'game');

        if ($this->gLPS() > 0) {
            $wsp = $suma / $this->g('wyposazenie|koszt_wyposazenie_2', 'game');
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik wyposazenia standard: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik wyposażenia dla pokoi lux.
     *
     * @return float
     */
    protected function wspWyposazenieLux() {
        $wsp = self::WSP_NULL;
        $suma = 0;

        switch ($this->gWL()) {
            case 1;
                $suma = $this->g('wyposazenie|koszt_wyposazenie_1', 'game');
                break;
            case 2;
                $suma = $this->g('wyposazenie|koszt_wyposazenie_2', 'game');
                break;
        }

        if ($this->gLPL() > 0) {
            // Nie ma sensu mnozyc przez wspolczynnik lux bo nic nie zmieni
            $wsp = $suma / $this->g('wyposazenie|koszt_wyposazenie_2', 'game');
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik wyposazenia lux: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik strony internetowej.
     * Zapisuje w 'round' w 'wsp_strona_internetowa'
     * 
     * @return float
     */
    protected function wspStronaInternetowa() {
        if (!$this->e('strona_internetowa', 'decision')) {
            if ($this->getGameData()->getRoundNumber() > (self::FIRST_ROUND + 1)) {
                $this->s('wsp_strona_internetowa', self::WSP_NULL, 'round');
            }
            return self::WSP_NULL;
        }

        $strona = $this->g('strona_internetowa', 'decision');
        $dzielnik = $this->g('strona_internetowa|koszt_kwartalny|portale_spolecznosciowe', 'game');
        $dzielna = 0;

        switch ($strona) {
            case 1:
                $dzielna = $this->g('strona_internetowa|koszt_kwartalny|strona_internetowa', 'game');
                break;
            case 2:
                $dzielna = $this->g('strona_internetowa|koszt_kwartalny|pozycjonowanie', 'game');
                break;
            case 3:
                $dzielna = $this->g('strona_internetowa|koszt_kwartalny|portale_spolecznosciowe', 'game');
                break;
        }

        $wspInternetu = $dzielna / $dzielnik;


        if ($this->hasEfektPamieci() && $this->rGT(2)) {
            $wspInternetu = (2 * $wspInternetu + $this->g('wsp_strona_internetowa', 'last_round')) / 3;
        }

        $this->s('wsp_strona_internetowa', $wspInternetu, 'round');

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik strona internetowa: ', $wspInternetu);
        return $wspInternetu;
    }

    public function wspRejestracjaNaStronieWww() {

        $wsp = $this->g('rejestracja_na_stronie_www', 'decision', self::WSP_NULL);
        $this->logW('F(' . __FUNCTION__ . '):  Wspolczynnik uslugi rejestracji na stronie www : ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza wspolczynnik rachunek woda
     * 
     * @return float 
     */
    protected function wspRachunekWoda() {
        $wsp = self::WSP_NULL;

        if ($this->rLT(3)) {
            $wsp = -1;
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik rachunek woda: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik Usług.
     *
     * @return float
     */
    protected function wspUslugi() {
        $array = array(
            $this->g('sejf', 'decision', 0),
            $this->g('taxi', 'decision', 0),
            $this->g('budzenie', 'decision', 0),
        );

        $wsp = array_sum($array) / self::SERVICES_COUNT;
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik uslugi: ', $wsp);
        return $wsp;
    }

    public function iloscUslug() {
        $array = array(
            $this->g('sejf', 'decision', 0),
            $this->g('taxi', 'decision', 0),
            $this->g('budzenie', 'decision', 0),
        );

        return array_sum($array);
    }

    /**
     * Oblicza współczynnik śniadania.
     *
     * @return float
     */
    protected function wspSniadanieStandard() {
        $sniadaniaArray = $this->g('sniadania', 'game');
        $kmin = $sniadaniaArray['min'];
        $kmax = $sniadaniaArray['max'];
        $cena = $this->g('sniadania_kwota', 'decision');

        if ($cena == 0) {
            $wsp = self::WSP_NULL;
        } else {
            $wsp = (min($cena, $kmax) - $kmin) / ($kmax - $kmin);
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik sniadania standard: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik śniadania dla pokoju LUX.
     *
     * @return float
     */
    protected function wspSniadanieLux() {

        $sniadaniaArray = $this->g('sniadania_lux', 'game');
        $kmin = $sniadaniaArray['min'];
        $kmax = $sniadaniaArray['max'];
        $cena = $this->g('sniadania_kwota', 'decision');

        if ($cena == 0) {
            $wsp = self::WSP_NULL;
        } else {
            $wsp = (min($cena, $kmax) - $kmin) / ($kmax - $kmin);
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik sniadania lux: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik mediów lokalnych standard.
     * Zapisuje go w 'round' w 'wsp_media_lokalne_standard'
     *
     * @return float
     */
    protected function wspMediaLokalneStandard() {
        $wsp = self::WSP_NULL;
        $useLastWsp = false;

        if ($this->gRN() > self::MEDIA_LOKALNE_START) {
            // Korzystamy z poprzednio wyliczonego wspolczynnika
            $useLastWsp = true;
        }

        $wsp = $this->obliczMedia('bilboardy', 'lokalne', 'standard', $useLastWsp) + $this->obliczMedia('prasa', 'lokalne', 'standard', $useLastWsp) + $this->obliczMedia('radio', 'lokalne', 'standard', $useLastWsp);

        $this->s('wsp_media_lokalne_standard', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik media lokalne standard: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik mediów lokalnych lux.
     * Zapisuje go w 'round' w 'wsp_media_lokalne_lux'
     *
     * @return float
     */
    protected function wspMediaLokalneLux() {
        $wsp = self::WSP_NULL;
        $useLastWsp = false;

        if ($this->gRN() > self::MEDIA_REGIONALNE_START) {
            // Korzystamy z poprzednio wyliczonego wspolczynnika
            $useLastWsp = true;
        }

        $wsp = $this->obliczMedia('bilboardy', 'lokalne', 'lux', $useLastWsp) + $this->obliczMedia('prasa', 'lokalne', 'lux', $useLastWsp) + $this->obliczMedia('radio', 'lokalne', 'lux', $useLastWsp);

        $this->s('wsp_media_lokalne_lux', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik media lokalne lux: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik mediów regionalnych standard.
     * Zapisuje go w 'round' w 'wsp_media_regionalne_standard'
     *
     * @return float
     */
    protected function wspMediaRegionalneStandard() {
        $wsp = self::WSP_NULL;
        $useLastWsp = false;

        if ($this->gRN() > self::MEDIA_REGIONALNE_START) {
            // Korzystamy z poprzednio wyliczonego wspolczynnika
            $useLastWsp = true;
        }

        $wsp = $this->obliczMedia('tv', 'regionalne', 'standard', $useLastWsp) + $this->obliczMedia('prasa', 'regionalne', 'standard', $useLastWsp) + $this->obliczMedia('radio', 'regionalne', 'standard', $useLastWsp);

        $this->s('wsp_media_regionalne_standard', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik media regionalne standard: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik mediów regionalnych lux.
     * Zapisuje go w 'round' w 'wsp_media_regionalne_lux'
     *
     * @return float
     */
    protected function wspMediaRegionalneLux() {
        $wsp = self::WSP_NULL;
        $useLastWsp = false;

        if ($this->gRN() > self::MEDIA_REGIONALNE_START) {
            // Korzystamy z poprzednio wyliczonego wspolczynnika
            $useLastWsp = true;
        }

        $wsp = $this->obliczMedia('tv', 'regionalne', 'lux', $useLastWsp) + $this->obliczMedia('prasa', 'regionalne', 'lux', $useLastWsp) + $this->obliczMedia('radio', 'regionalne', 'lux', $useLastWsp);

        $this->s('wsp_media_regionalne_lux', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik media regionalne lux: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik mediów krajowych standard.
     * Zapisuje go w 'round' w 'wsp_media_krajowe_standard'
     *
     * @return float
     */
    protected function wspMediaKrajoweStandard() {
        $wsp = self::WSP_NULL;
        $useLastWsp = false;

        if ($this->gRN() > self::MEDIA_KRAJOWE_START) {
            // Korzystamy z poprzednio wyliczonego wspolczynnika
            $useLastWsp = true;
        }

        $wsp = $this->obliczMedia('tv', 'krajowe', 'standard', $useLastWsp) + $this->obliczMedia('prasa', 'krajowe', 'standard', $useLastWsp) + $this->obliczMedia('radio', 'krajowe', 'standard', $useLastWsp);

        $this->s('wsp_media_krajowe_standard', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik media krajowe standard: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik mediów krajowych lux.
     * Zapisuje go w 'round' w 'wsp_media_krajowe_lux'
     *
     * @return float
     */
    protected function wspMediaKrajoweLux() {
        $wsp = self::WSP_NULL;
        $useLastWsp = false;

        if ($this->gRN() > self::MEDIA_KRAJOWE_START) {
            // Korzystamy z poprzednio wyliczonego wspolczynnika
            $useLastWsp = true;
        }

        $wsp = $this->obliczMedia('tv', 'krajowe', 'lux', $useLastWsp) + $this->obliczMedia('prasa', 'krajowe', 'lux', $useLastWsp) + $this->obliczMedia('radio', 'krajowe', 'lux', $useLastWsp);

        $this->s('wsp_media_krajowe_lux', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik media krajowe lux: ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca optymalny wynik dla kupna reklam krajowych standard
     * @return float
     */
    protected function getMediaKrajoweStandardOptymalne() {
        return 22.94;
    }

    /**
     * Zwraca optymalny wynik dla kupna reklam krajowych lux
     * @return float
     */
    protected function getMediaKrajoweLuxOptymalne() {
        return 22.31;
    }

    /**
     * Oblicza wspolczynnik reklamy w zaleznosci od podanych parametrow. 
     * Podane parametry sa wykorzystywane bezposrednio do wczytania danych o obliczanych mediach,
     * takze musi byc zachowana spojnosc parametrow z game.yml
     * 
     * @param string $type Typ reklamy 'ulotki', 'plakaty', 'bilboardy', 'prasa', 'radio' lub 'tv'
     * @param string $range Zakres reklamy 'lokalne', 'regionalne' lub 'krajowe'
     * @param string $roomType Typ pokoju 'standard' lub 'lux'
     * @param boolean $useLastWsp Czy ma zostac uzyty wzor wykorzystujacy wspolczynnik z poprzedniej rundy
     * @return float
     */
    protected function obliczMedia($type, $range, $roomType, $useLastWsp) {
        $x = $this->g('media_' . $range . '_' . $type, 'decision', 0);
        if ($x > 0) {
            $a = $this->g('media|wspolczynniki|' . $type . '|a', 'game');
            $b = $this->g('media|wspolczynniki|' . $type . '|b', 'game');
            $n = $this->g('media|wspolczynniki|' . $type . '|n', 'game');
            $s = $this->g('media|mnozniki|' . $roomType . '|' . $range . '|' . $type, 'game');

            $wsp = $s * ( ($a * pow($x, $n) + $b) / ($a * pow($x, $n) + $b + 100) );

            if ($useLastWsp && $this->hasEfektPamieci()) {
                $oldWsp = $this->g('wsp_media_' . $range . '_' . $type, 'last_round');
                $wsp = ((2 * $wsp) + $oldWsp) / 3;
            }
            $this->logW('F(' . __FUNCTION__ . '):  Wykorzystane zmienne kolejno [x,a,b,n,s] : [' . $x . ',' . $a . ',' . $b . ',' . $n . ',' . $s . ']:', 'N/A');
        } else {
            $wsp = self::WSP_NULL;
        }

        $this->s('wsp_media_' . $range . '_' . $type, $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik media ' . $type . ' ' . $range . ' ' . $roomType . ' : ', $wsp);

        return $wsp;
    }

    /**
     * Oblicza współczynnik ulotek standard
     *
     * @return float
     */
    protected function wspUlotkiStandard() {
        $wsp = self::WSP_NULL;
        if ($this->gRN() == (self::FIRST_ROUND + 3) || $this->gRN() == (self::FIRST_ROUND + 4)) {
            $wsp = $this->obliczMedia('ulotki', 'lokalne', 'standard', false);
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik ulotki standard: ', $wsp);

        return $wsp;
    }

    /**
     * Oblicza współczynnik ulotek lux
     *
     * @return float
     */
    protected function wspUlotkiLux() {
        $wsp = self::WSP_NULL;
        if ($this->gRN() == (self::FIRST_ROUND + 3) || $this->gRN() == (self::FIRST_ROUND + 4)) {
            $wsp = $this->obliczMedia('ulotki', 'lokalne', 'lux', false);
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik ulotki lux: ', $wsp);

        return $wsp;
    }

    /**
     * Oblicza współczynnik plakatów standard.
     *
     * @return float
     */
    protected function wspPlakatyStandard() {
        $wsp = self::WSP_NULL;
        if ($this->gRN() == (self::FIRST_ROUND + 3) || $this->gRN() == (self::FIRST_ROUND + 4)) {
            $wsp = $this->obliczMedia('plakaty', 'lokalne', 'standard', false);
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik plakaty standard: ', $wsp);

        return $wsp;
    }

    /**
     * Oblicza współczynnik plakatów lux.
     *
     * @return float
     */
    protected function wspPlakatyLux() {
        $wsp = self::WSP_NULL;
        if ($this->gRN() == (self::FIRST_ROUND + 3) || $this->gRN() == (self::FIRST_ROUND + 4)) {
            $wsp = $this->obliczMedia('plakaty', 'lokalne', 'lux', false);
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik plakaty lux: ', $wsp);

        return $wsp;
    }

    /**
     * Zwraca kwartalne koszty za strone internetowa
     * @return float
     */
    public function getKosztStronaInternetowa($strona = null) {
        if (is_null($strona)) {
            $strona = $this->g('strona_internetowa', 'decision');
        }

        $koszt = self::COSTS_NULL;
        switch ($strona) {
            case 1:
                $koszt = $this->g('strona_internetowa|koszt_kwartalny|strona_internetowa', 'game');
                break;
            case 2:
                $koszt = $this->g('strona_internetowa|koszt_kwartalny|pozycjonowanie', 'game');
                break;
            case 3:
                $koszt = $this->g('strona_internetowa|koszt_kwartalny|portale_spolecznosciowe', 'game');
                break;
        }

        $this->logK('F(' . __FUNCTION__ . '):  Koszt strona internetowa : ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca place minimalna dla pracownikow obslugi
     * @return float
     */
    public function getPlacaMinimalnaPracownicyObslugi() {
        $placaMinimalna = $this->g('zatrudnienie|pracownicy_obslugi|placa_minimalna', 'game');
        if ($this->hasEventPodwyzkaPlacyMinimalnej()) {
            $placaMinimalna *= $this->g('eventy|podwyzka_placy_minimalnej|pracownicy_obslugi', 'game');
        }

        return $placaMinimalna;
    }

    /**
     * Zwraca place srednia dla pracownikow obslugi
     * @return float
     */
    public function getPlacaSredniaPracownicyObslugi() {
        $placaSrednia = $this->getPlacaMinimalnaPracownicyObslugi() * $this->g('zatrudnienie|pracownicy_obslugi|placa_srednia_mnoznik', 'game');
        if ($this->hasEventPodwyzkaPlacySredniej()) {
            $placaSrednia *= $this->g('eventy|podwyzka_placy_sredniej|pracownicy_obslugi', 'game');
        }

        return $placaSrednia;
    }

    /**
     * Zwraca place minimalna dla pracownikow administracji
     * @return float
     */
    public function getPlacaMinimalnaPracownicyAdministracji() {
        $placaMinimalna = $this->g('zatrudnienie|pracownicy_administracji|placa_minimalna', 'game');
        if ($this->hasEventPodwyzkaPlacyMinimalnej()) {
            $placaMinimalna *= $this->g('eventy|podwyzka_placy_minimalnej|pracownicy_administracji', 'game');
        }

        return $placaMinimalna;
    }

    /**
     * Zwraca place srednia dla pracownikow administracji
     * @return float
     */
    public function getPlacaSredniaPracownicyAdministracji() {
        $placaSrednia = $this->getPlacaMinimalnaPracownicyAdministracji() * $this->g('zatrudnienie|pracownicy_administracji|placa_srednia_mnoznik', 'game');
        if ($this->hasEventPodwyzkaPlacySredniej()) {
            $placaSrednia *= $this->g('eventy|podwyzka_placy_sredniej|pracownicy_obslugi', 'game');
        }

        return $placaSrednia;
    }

    public function getWspLux() {
        return $this->g('wspolczynnik|lux|' . $this->gL(), 'game');
    }

    public function getKosztPracPracownikowObslugi() {
        $kosztWsp = $this->g('zatrudnienie|pracownicy_obslugi|koszt_prac_wsp', 'game');
        $kosztWspLux = $this->g('zatrudnienie|pracownicy_obslugi|koszt_prac_wsp_lux', 'game');

        $kosztStandard = $this->gLPS() *
                ($this->g('koszty_bazowe|pokoje_oblozone|pracownicy_obslugi|' . $this->gL(), 'game') + $this->g('koszty_bazowe|pokoje_oblozone|sprzatanie|' . $this->gL(), 'game'));
        $kosztLux = $kosztWspLux * $this->getWspLux() * $this->gLPL() *
                ($this->g('koszty_bazowe|pokoje_oblozone|pracownicy_obslugi|' . $this->gL(), 'game') + $this->g('koszty_bazowe|pokoje_oblozone|sprzatanie|' . $this->gL(), 'game'));

        $kosztStandard *= $kosztWsp;
        $kosztLux *= $kosztWsp;
        $kosztPrac = $kosztStandard + $kosztLux;

        $this->sTT('pracownicy|obslugi|koszt_prac', $kosztPrac);
        $this->sTT('pracownicy|obslugi|koszt_prac_standard', $kosztStandard);
        $this->sTT('pracownicy|obslugi|koszt_prac_lux', $kosztLux);
        return $kosztPrac;
    }

    public function getMinimalnaLiczbaPracownikowObslugi() {
        $kosztPrac = $this->getKosztPracPracownikowObslugi();
        $minimalnaLiczba = floor($kosztPrac / ($this->getPlacaSredniaPracownicyObslugi() * 3)) + 1;

        $this->sTT('pracownicy|obslugi|minimalna_liczba', $minimalnaLiczba);
        return $minimalnaLiczba;
    }

    /**
     * Oblicza współczynnik liczby pracowników obsługi. 
     * 
     * @return type
     */
    public function wspPracownicyObslugiLiczba() {
        $wsp = 0;

        if ($this->gPO() > 0) {
            $minLiczbaWsp = $this->g('zatrudnienie|pracownicy_obslugi|min_liczba_wsp', 'game');
            $minimalnaLiczbaPracownikow = $this->getMinimalnaLiczbaPracownikowObslugi();
            $wsp = min(( ($this->gPO() - $minLiczbaWsp * $minimalnaLiczbaPracownikow) / ($minLiczbaWsp * $minimalnaLiczbaPracownikow)), 1.3);
        }

        $this->sTT('pracownicy|obslugi|liczba', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy obslugi liczba: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik wynagrodzenia pracowników obsługi. 
     * 
     * @return type
     */
    public function wspPracownicyObslugiWynagrodzenie() {
        $wspWynagrodzenie = 0;

        if ($this->gPO() > 0) {
            $placaStale = $this->g('pracownicy_obslugi_stale_wynagrodzenie', 'decision');
            $placaZlecenie = $this->g('pracownicy_obslugi_zlecenie_wynagrodzenie', 'decision');
            $placaMinimalna = $this->getPlacaMinimalnaPracownicyObslugi();
            $placaSrednia = $this->getPlacaSredniaPracownicyObslugi();

            $wspPlaca = (1.22 * ($placaStale * $this->gPOS() + $placaZlecenie * $this->gPOZ() * 0.8)) / $this->gPO();
            $wspWynagrodzenie = (min($wspPlaca, ($placaMinimalna + $placaSrednia)) - $placaSrednia) / ($placaMinimalna * 0.6);
        }

        $this->sTT('pracownicy|obslugi|wynagrodzenie', $wspWynagrodzenie);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy obslugi wynagrodzenie: ', $wspWynagrodzenie);
        return $wspWynagrodzenie;
    }

    public function getMinimalnaLiczbaPracownikowAdministracji() {
        $wspN = $this->g('zatrudnienie|pracownicy_administracji|minimalnie_pracownikow_na_pokoj|' . $this->gL(), 'game');
        $minimalnaLiczba = max(floor(($this->gLPS() + $this->gLPS()) / $wspN), 2);

        $this->sTT('pracownicy|administracji|minimalna_liczba', $minimalnaLiczba);
        return $minimalnaLiczba;
    }

    /**
     * Oblicza współczynnik liczby pracowników administracji. 
     * 
     * @return type
     */
    public function wspPracownicyAdministracjiLiczba() {
        $wsp = 0;

        if ($this->gPA() > 0) {
            $minimalnaLiczbaPracownikow = $this->getMinimalnaLiczbaPracownikowAdministracji();
            $wsp = min(( ($this->gPA() - $minimalnaLiczbaPracownikow) / $minimalnaLiczbaPracownikow), 1.3);
        }

        $this->sTT('pracownicy|administracji|liczba', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy administracji liczba: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik wynagrodzenia pracowników administracji. 
     * 
     * @return float
     */
    public function wspPracownicyAdministracjiWynagrodzenie() {
        $wspWynagrodzenie = 0;

        if ($this->gPA() > 0) {
            $placaStale = $this->g('pracownicy_administracji_stale_wynagrodzenie', 'decision');
            $placaZlecenie = $this->g('pracownicy_administracji_zlecenie_wynagrodzenie', 'decision');
            $placaMinimalna = $this->getPlacaMinimalnaPracownicyAdministracji();
            $placaSrednia = $this->getPlacaSredniaPracownicyAdministracji();

            $wspPlaca = (1.22 * ($placaStale * $this->gPAS() + $placaZlecenie * $this->gPAZ() * 0.8)) / $this->gPA();
            $wspWynagrodzenie = (min($wspPlaca, ($placaMinimalna + $placaSrednia)) - $placaSrednia) / $placaMinimalna;
        }

        $this->sTT('pracownicy|administracji|wynagrodzenie', $wspWynagrodzenie);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy administracji wynagrodzenie: ', $wspWynagrodzenie);
        return $wspWynagrodzenie;
    }

    /**
     * Nie uzywane w popycie
     * @return float
     */
    public function wspPracownicyWynagrodzenie() {
        $wsp = $this->wspPracownicyObslugiWynagrodzenie() + $this->wspPracownicyAdministracjiWynagrodzenie();

        if ($this->gPO() > 0 && $this->gPA() > 0) {
            // Jesli zatrudnione oba sektory to srednia
            $wsp /= 2;
        }

        $this->sTT('pracownicy|wynagrodzenie_razem', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy (razem) wynagrodzenie: ', $wsp);
        return $wsp;
    }

    /**
     * Nie uzywane w popycie
     * @return float
     */
    public function wspPracownicyLiczba() {
        $wsp = $this->wspPracownicyObslugiLiczba() + $this->wspPracownicyAdministracjiLiczba();

        if ($this->gPO() > 0 && $this->gPA() > 0) {
            // Jesli zatrudnione oba sektory to srednia
            $wsp /= 2;
        }

        $this->sTT('pracownicy|liczba_razem', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy (razem) liczba: ', $wsp);
        return $wsp;
    }

    /**
     * Nie uzywane w popycie
     * @return int
     */
    public function wspPracownicyZlecenie() {
        $wsp = $this->wspPracownicyObslugiZlecenie() + $this->wspPracownicyAdministracjiZlecenie();

        if ($this->gPO() > 0 && $this->gPA() > 0) {
            // Jesli zatrudnione oba sektory to srednia
            $wsp /= 2;
        }

        $this->sTT('pracownicy|zlecenie_razem', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy zlecenie (razem): ', $wsp);
        return $wsp;
    }

    /**
     * Obliczna wspolczynnik pracownikow obslugi pracujacych na zlecenie
     * @return float
     */
    public function wspPracownicyObslugiZlecenie() {
        $wsp = 0;

        if ($this->gPO() > 0) {
            $wsp = ($this->gPOS() - $this->gPOZ()) / $this->getMinimalnaLiczbaPracownikowObslugi();
        }

        $this->sTT('pracownicy|obslugi|zlecenie', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy obslugi zlecenie: ', $wsp);
        return $wsp;
    }

    /**
     * Obliczna wspolczynnik pracownikow administracji pracujacych na zlecenie
     * @return float
     */
    public function wspPracownicyAdministracjiZlecenie() {
        $wsp = 0;

        if ($this->gPA() > 0) {
            $wsp = ($this->gPAS() - $this->gPAZ()) / $this->getMinimalnaLiczbaPracownikowAdministracji();
        }

        $this->sTT('pracownicy|administracji|zlecenie', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy administracji zlecenie: ', $wsp);
        return $wsp;
    }

    /**
     * Współczynnik motywacji ze względu na procent pracowników otrzymujących pieniądze.
     *  
     * @return type
     */
    public function wspMotywacjaProcent() {
        $wsp = $this->wspPracownicyObslugiMotywacjaProcent() + $this->wspPracownicyAdministracjiMotywacjaProcent();

        if ($this->gPO() > 0 && $this->gPA() > 0) {
            // Jesli zatrudnione oba sektory to srednia
            $wsp /= 2;
        }

        $this->sTT('pracownicy|motywacja_razem', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik motywacji procent: ', $wsp);
        return $wsp;
    }

    /**
     * Wspolczynnik motywacji procentowej dla pracownikow obslugi
     * @return float 
     */
    public function wspPracownicyObslugiMotywacjaProcent() {
        $wsp = self::WSP_NULL;

        if ($this->gPO() > 0) {
            // Bierzemy srednia premie tutaj
            $premiaStale = $this->g('pracownicy_obslugi_stale_motywacja_procent', 'decision');
            $premiaZlecenie = $this->g('pracownicy_obslugi_zlecenie_motywacja_procent', 'decision');

            $max = $this->g('motywacja|procent_max', 'game');
            $dzielnik = $this->g('motywacja|procent_dzielnik', 'game');

            $wspMotywacjiStale = min($premiaStale / $dzielnik, $max);
            $wspMotywacjiZlecenie = min($premiaZlecenie / $dzielnik, $max);
            $wspDzielnik = 0;

            if ($this->gPOS() > 0) {
                $wspDzielnik += 1;
            }
            if ($this->gPOZ() > 0) {
                $wspDzielnik += 1;
            }

            $wsp = ($wspMotywacjiStale + $wspMotywacjiZlecenie) / $wspDzielnik;
        }

        $this->sTT('pracownicy|obslugi|motywacja', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy obslugi motywacja procent: ', $wsp);
        return $wsp;
    }

    /**
     * Wspolczynnik motywacji procentowej dla pracownikow administracji
     * @return float 
     */
    public function wspPracownicyAdministracjiMotywacjaProcent() {
        $wsp = self::WSP_NULL;

        if ($this->gPA() > 0) {
            // Bierzemy srednia premie tutaj
            $premiaStale = $this->g('pracownicy_administracji_stale_motywacja_procent', 'decision');
            $premiaZlecenie = $this->g('pracownicy_administracji_zlecenie_motywacja_procent', 'decision');

            $max = $this->g('motywacja|procent_max', 'game');
            $dzielnik = $this->g('motywacja|procent_dzielnik', 'game');

            $wspMotywacjiStale = min($premiaStale / $dzielnik, $max);
            $wspMotywacjiZlecenie = min($premiaZlecenie / $dzielnik, $max);
            $wspDzielnik = 0;

            if ($this->gPAS() > 0) {
                $wspDzielnik += 1;
            }
            if ($this->gPAZ() > 0) {
                $wspDzielnik += 1;
            }

            $wsp = ($wspMotywacjiStale + $wspMotywacjiZlecenie) / $wspDzielnik;
        }

        $this->sTT('pracownicy|administracji|motywacja', $wsp);
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik pracownicy administracji motywacja procent: ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca współczynnik eventu mikołajkowy ekspres
     * @return float
     */
    protected function wspEventMikolajowyEkspres() {
        $wsp = 1;

        if ($this->g('event_mikolajkowy_ekspres', 'decision', false) && $this->gRN() == (self::FIRST_ROUND + 13)) {
            $wsp = $this->g('eventy|mikolajkowy_ekspres|wspolczynnik', 'game');
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik mikołajkowy ekspres : ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca współczynnik eventu festiwal filmowy
     * @return float
     */
    protected function wspEventFestiwalFilmowy() {
        $wsp = self::WSP_NULL;

        if ($this->g('event_festiwal_filmowy', 'decision', false) && $this->gRN() == (self::FIRST_ROUND + 1)) {
            $wsp = 1;
        }

        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik festiwal filmowy : ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik decyzja o zatrudnieniu.
     * Rowny 1 jesli mamy zatrudnionych pracownikow obslugi lub administracji.
     * @return float
     */
    protected function wspZatrudnienieDecyzja() {
        $wsp = self::WSP_NULL;

        if (($this->gPO() + $this->gPA()) > 0) {
            $wsp = 1;
        }
        $this->logW('F(' . __FUNCTION__ . '):  Wspołczynnik decyzja o zatrudnieniu : ', $wsp);
        return $wsp;
    }

    /**
     * Sprawdza czy podany koszt jest zbyt wysoki w porownaniu z naszymi aktualnymi wydatkami
     * @param float $koszt
     * @return boolean
     */
    public function isCostUnreasonable($koszt) {
        if ($this->rGT(1) && $koszt > $this->g('raport_finansowy_koszt_suma', 'last_round')) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Oblicza i zwraca przychód jaki generuje popyt na pokoje standard i lux oraz przychod z lokaty.
     * Ustawia go dodatkowo w 'round' w 'przychod'
     * @return float
     */
    protected function przychod() {
        $cenaPokojuStandard = $this->g('cena_pokoje_standard', 'decision');
        $cenaPokojuLux = $this->g('cena_pokoje_lux', 'decision');

        $przychodStandard = $this->g('popyt_standard', 'round') * $cenaPokojuStandard;
        $przychodLux = $this->g('popyt_lux', 'round') * $cenaPokojuLux;
        $przychodLokata = $this->przychodLokata();

        $przychod = $przychodStandard + $przychodLux + $przychodLokata;

        $this->s('przychod_standard', $przychodStandard, 'round');
        $this->s('przychod_lux', $przychodLux, 'round');
        $this->s('przychod', $przychod, 'round');

        $this->addRaportFinansowyEntry('przychody|sprzedaz|pokoje_standard', $przychodStandard);
        $this->addRaportFinansowyEntry('przychody|sprzedaz|pokoje_lux', $przychodLux);
        $this->addRaportFinansowyEntry('przychody|finansowe|lokata', $przychodLokata);

        $this->setRaportEntryToParse('kpir', 'wplywy|operacyjne|sprzedaz', $przychodStandard, true);
        $this->setRaportEntryToParse('kpir', 'wplywy|operacyjne|sprzedaz', $przychodLux, true);
        $this->setRaportEntryToParse('kpir', 'wplywy|finansowe|lokata', $przychodLokata, true);

        $this->logI('F(' . __FUNCTION__ . '):  Przychod standard : ', $przychodStandard);
        $this->logI('F(' . __FUNCTION__ . '):  Przychod lux : ', $przychodLux);
        $this->logI('F(' . __FUNCTION__ . '):  Przychod lokata : ', $przychodLokata);
        $this->logI('F(' . __FUNCTION__ . '):  Przychod suma : ', $przychod);
        return $przychod;
    }

    /**
     * Przygotowuje raporty
     */
    protected function prepareRaports() {
        $raport = $this->getAll('raport');
        $raport = $this->addRaportFinansowyHead($raport);
        $raport['finansowy'] = $this->addRaportFinansowyEmptyEntries($raport['finansowy']);

        $this->setAll($raport, 'raport');
    }

    /**
     * Wykonuje obliczenia na raportach 
     */
    protected function calculateRaports() {
        $this->addKpirKredytLokata();
        $this->parseRaportFinansowyEntries();
        $this->parseRaportKpirEntries();
        $this->sumKosztMarza();

        $raport = $this->getAll('raport');
        $raport['finansowy'] = $this->sumRaportFinansowy($raport['finansowy']);
        $raport['operacyjny']['runda_' . $this->gRN()] = $this->calculateRaportOperacyjny();

        $this->setAll($raport, 'raport');

        $sumaFinansowy = -$raport['finansowy']['koszty']['values'][$this->getYear()]['items'][$this->getKwartalRzymski()];
        $this->s('raport_finansowy_koszt_suma', -$sumaFinansowy, 'round');

        if (isset($raport['finansowy']['przychody']['values'][$this->getYear()]['items'][$this->getKwartalRzymski()])) {
            $sumaFinansowy += $raport['finansowy']['przychody']['values'][$this->getYear()]['items'][$this->getKwartalRzymski()];
        }
        $this->s('status_bar_saldo', $sumaFinansowy, 'round');
        $this->addRaportFinansowyEntry('suma', $sumaFinansowy);

        $raport = $this->getAll('raport');
        $raport['finansowy'] = $this->sumRaportFinansowy($raport['finansowy']);
        $raport['finansowy'] = $this->sortRaport($raport['finansowy'], $this->getSortedRaportFinansowyArray());
        $this->setAll($raport, 'raport');
    }

    protected function sumKosztMarza() {
        $types = array('standard', 'lux', 'razem');
        $raport = $this->getAll('raport');

        foreach ($types as $type) {
            $raport['marza'][$type . '_suma'] = array_sum($raport['marza'][$type]);
        }

        $this->setAll($raport, 'raport');
    }

    protected function calculateRaportOperacyjny() {
        $raport = array();

        $raport['zatrudnienie']['liczba_zatrudnionych'] = ($this->gPO() + $this->gPA());
        $raport['zatrudnienie']['liczba_zatrudnionych_obsluga'] = $this->gPO();
        $raport['zatrudnienie']['liczba_zatrudnionych_administracja'] = $this->gPA();

        if (($this->gPO() + $this->gPA()) > 0) {
            $raport['satysfakcja']['satysfakcja_pracownikow'] = $this->getStatysfakcjaPracownikow();
        } else {
            $raport['satysfakcja']['satysfakcja_pracownikow'] = 'brak_pracownikow';
        }

        $raport['firma']['wartosc_zadluzenia'] = $this->getZadluzenieFirmy();
        $raport['firma']['majatek_firmy'] = $this->getMajatekFirmy();
        $raport['firma']['skumulowany_zysk'] = $this->g('skumulowany_zysk', 'round');
        $raport['firma']['wartosc_udzialow'] = $this->getWartoscUdzialow();

        if ($this->gLPS() > 0) {
            $raport['oblozenie']['pokoje_oblozone_standard'] = $this->g('pokoje_oblozone_standard_procent', 'round');
            $raport['jakosc']['jakosc_pokoju_standard'] = $this->getJakoscPokojuStandard();
            $raport['satysfakcja']['satysfakcja_klientow_standard'] = $this->getStatysfakcjaKlientaStandard();
            $raport['marketing']['efektywnosc_marketingu_standard'] = $this->getEfektywnoscMarketinguStandard();
            $raport['marza']['marza_standard'] = $this->getMarzaStandard();
        } else {
            $brakPokoiStandard = 'brak_pokoi_standard';
            $raport['oblozenie']['pokoje_oblozone_standard'] = $brakPokoiStandard;
            $raport['jakosc']['jakosc_pokoju_standard'] = $brakPokoiStandard;
            $raport['satysfakcja']['satysfakcja_klientow_standard'] = $brakPokoiStandard;
            $raport['marketing']['efektywnosc_marketingu_standard'] = $brakPokoiStandard;
            $raport['marza']['marza_standard'] = $brakPokoiStandard;
        }

        if ($this->gLPL() > 0) {
            $raport['oblozenie']['pokoje_oblozone_lux'] = $this->g('pokoje_oblozone_lux_procent', 'round');
            $raport['jakosc']['jakosc_pokoju_lux'] = $this->getJakoscPokojuLux();
            $raport['satysfakcja']['satysfakcja_klientow_lux'] = $this->getStatysfakcjaKlientaLux();
            $raport['marketing']['efektywnosc_marketingu_lux'] = $this->getEfektywnoscMarketinguLux();
            $raport['marza']['marza_lux'] = $this->getMarzaLux();
        } else {
            $brakPokoiLux = 'brak_pokoi_lux';
            $raport['oblozenie']['pokoje_oblozone_lux'] = $brakPokoiLux;
            $raport['jakosc']['jakosc_pokoju_lux'] = $brakPokoiLux;
            $raport['satysfakcja']['satysfakcja_klientow_lux'] = $brakPokoiLux;
            $raport['marketing']['efektywnosc_marketingu_lux'] = $brakPokoiLux;
            $raport['marza']['marza_lux'] = $brakPokoiLux;
        }

        if ($this->hasEventKonkurencja()) {
            $raport['konkurencja']['konkurencja_standard'] = $this->getRaportKonkurencjaStandard();
            $raport['konkurencja']['konkurencja_lux'] = $this->getRaportKonkurencjaLux();
        } else {
            $raport['konkurencja']['konkurencja_standard'] = 'brak_konkurencji';
            $raport['konkurencja']['konkurencja_lux'] = 'brak_konkurencji';
        }

        $raport = $this->sortRaportOperacyjny($raport, $this->getSortedRaportOperacyjnyArray());

        return $raport;
    }

    public function getRaportKonkurencjaStandard() {
        $P = $this->g('konkurencja_raport_popyt_standard', 'round', 0);
        $r = $this->wspKonkurencjaStandard();
        $const = $this->g('eventy|konkurencja_raport', 'game');
        $p1 = ((1 - $r) / $r) * $P + $const['p1'][2] * 90;
        $p2 = $const['p2'][0] * $P + $const['p2'][1] * $p1 + $const['p2'][2] * 90;
        $p3 = $const['p3'][0] * $P + $const['p3'][1] * $p1 + $const['p3'][2] * 90;

        return array(
            'p1' => $p1,
            'p2' => $p2,
            'p3' => $p3,
        );
    }

    public function getRaportKonkurencjaLux() {
        $P = $this->g('konkurencja_raport_popyt_lux', 'round', 0);
        $r = $this->wspKonkurencjaLux();
        $const = $this->g('eventy|konkurencja_raport', 'game');
        $p1 = ((1 - $r) / $r) * $P + $const['p1'][2] * 90;
        $p2 = $const['p2'][0] * $P + $const['p2'][1] * $p1 + $const['p2'][2] * 90;
        $p3 = $const['p3'][0] * $P + $const['p3'][1] * $p1 + $const['p3'][2] * 90;

        return array(
            'p1' => $p1,
            'p2' => $p2,
            'p3' => $p3,
        );
    }

    public function getStatysfakcjaPracownikow() {
        $value = $this->wspZadowoleniaPracownikow() * 100;

        return min(100, max(1, ($value)));
    }

    public function getStatysfakcjaKlientaStandard() {
        if ($this->rGT(3)) {
            $value = $this->wspZadowolenieKlientaStandard() * 100;

            return min(100, max(1, ($value)));
        } else {
            return 'brak_satysfakcji_klienta_standard';
        }
    }

    public function getStatysfakcjaKlientaLux() {
        if ($this->rGT(3)) {
            $value = $this->wspZadowolenieKlientaLux() * 100;

            return min(100, max(1, ($value)));
        } else {
            return 'brak_satysfakcji_klienta_lux';
        }
    }

    public function getMarzaStandard() {
        $marza = 0;

        if ($this->gLPS() > 0) {
            $kosztStandard = $this->g('marza|standard_suma', 'raport');
            $share = $this->gLPS() / ($this->gLPS() + $this->gLPL());
            $koszt = $share * $this->g('marza|razem_suma', 'raport') + $kosztStandard;
            $marza = ($this->g('przychod_standard', 'round') - $koszt) / $this->gLPS();
        }

        return $marza;
    }

    public function getMarzaLux() {
        $marza = 0;

        if ($this->gLPL() > 0) {
            $kosztLux = $this->g('marza|lux_suma', 'raport');
            $share = $this->gLPL() / ($this->gLPS() + $this->gLPL());
            $koszt = $share * $this->g('marza|razem_suma', 'raport') + $kosztLux;

            $marza = ($this->g('przychod_lux', 'round') - $koszt) / $this->gLPL();
        }

        return $marza;
    }

    public function getEfektywnoscMarketinguStandard() {
        if ($this->rGT(12)) {
            $value = ( 3 * $this->wspMediaKrajoweStandard() + 2 * $this->wspMediaRegionalneStandard() + 1 * $this->wspMediaLokalneStandard()) * 10 / 6;
        } elseif ($this->rGT(5)) {
            $value = (2 * $this->wspMediaRegionalneStandard() + 1 * $this->wspMediaLokalneStandard()) * 100 / 15;
        } else {
            return 'brak_efektywnosci_marketingu_standard';
        }

        return min(100, max(1, ($value)));
    }

    public function getEfektywnoscMarketinguLux() {
        if ($this->rGT(12)) {
            $value = ( 3 * $this->wspMediaKrajoweLux() + 2 * $this->wspMediaRegionalneLux() + 1 * $this->wspMediaLokalneLux()) * 10 / 6;
        } elseif ($this->rGT(5)) {
            $value = (2 * $this->wspMediaRegionalneLux() + 1 * $this->wspMediaLokalneLux()) * 100 / 15;
        } else {
            return 'brak_efektywnosci_marketingu_lux';
        }

        return min(100, max(1, ($value)));
    }

    public function getJakoscPokojuStandard() {
        if ($this->rGT(2)) {
            $wartosc = $this->wspWyposazenieStandard() + $this->wspPranieOutsourcingStandard();
            if ($this->gPO() > 0) {
                $wartosc += $this->wspPracownicyObslugiLiczba();
            } else {
                $wartosc += $this->wspSprzatanieOutsourcingStandard();
            }
            $suma = 3;
            if ($this->rGT(3)) {
                $wartosc += $this->wspUslugi();
                $suma++;
            }
            if ($this->rGT(4)) {
                $wartosc += $this->wspSniadanieStandard();
                $suma++;
            }
            return min(100, max(1, $wartosc * 100 / $suma));
        } else {
            return 'brak_jakosci_pokoju_standard';
        }
    }

    public function getJakoscPokojuLux() {
        if ($this->rGT(2)) {
            $wartosc = $this->wspWyposazenieLux() + $this->wspPranieOutsourcingLux();
            if ($this->gPO() > 0) {
                $wartosc += $this->wspPracownicyObslugiLiczba();
            } else {
                $wartosc += $this->wspSprzatanieOutsourcingStandard();
            }
            $suma = 3;
            if ($this->rGT(3)) {
                $wartosc += $this->wspUslugi();
                $suma++;
            }
            if ($this->rGT(4)) {
                $wartosc += $this->wspSniadanieLux();
                $suma++;
            }
            return min(100, max(1, $wartosc * 100 / $suma));
        } else {
            return 'brak_jakosci_pokoju_lux';
        }
    }

    protected function addRaportFinansowyEmptyEntries($raport) {
        foreach ($raport as $element => &$data) {
            // Jesli nie ma wpisu lub ich liczba jest mniejsza niz numer kwartalu
            if (!isset($data['values'][$this->getYear()]['items']) || count($data['values'][$this->getYear()]['items']) < $this->getKwartal()) {
                $data['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] = 0;
            }

            if (count($data['values'][$this->getYear()]['items']) < $this->getKwartal()) {
                throw new sfException('Raport finansowy w "' . $element . '" ma za malo danych.');
            }

            $data['values'][$this->getYear()]['sum'] = 0;

            if (isset($data['items'])) {
                $data['items'] = $this->addRaportFinansowyEmptyEntries($data['items']);
            }
        }

        return $raport;
    }

    protected function sumRaportFinansowy($raport) {

        foreach ($raport as $element => &$data) {
            $data['values'][$this->getYear()]['sum'] = array_sum($data['values'][$this->getYear()]['items']);

            if (isset($data['items'])) {
                $data['items'] = $this->sumRaportFinansowy($data['items']);
            }
        }

        return $raport;
    }

    protected function addRaportFinansowyHead($raport) {
        $raport['finansowy_head'][$this->getYear()][] = $this->getKwartalRzymski();

        return $raport;
    }

    protected function getRaportNames() {
        return array('finansowy', 'operacyjny', 'kpir');
    }

    protected function existRaportEntry($raport, $where) {
        if (!in_array($raport, $this->getRaportNames())) {
            throw new sfException('Raport "' . $raport . '" nie istnieje.');
        }


        $whereElements = explode('|', $where);
        $whereString = $raport . '|' . $whereElements[0];
        unset($whereElements[0]);

        foreach ($whereElements as $element) {
            $whereString .= '|items|' . $element;
        }

        return $this->e($whereString, 'raport');
    }

    /**
     * Zwraca tablice z czystym wpisem na podstawie finansowy_head
     * @return array 
     */
    protected function getCleanRaportFinansowyEntry() {
        $cleanEntry = array();

        $head = $this->g('finansowy_head', 'raport');
        foreach ($head as $year => $quarters) {
            foreach ($quarters as $quarter) {
                $cleanEntry[$year]['items'][$quarter] = 0;
            }

            $cleanEntry[$year]['sum'] = 0;
        }

        return $cleanEntry;
    }

    /**
     * Przygotowuje czysty wpis dla danego elementu (wypelnia zerami)
     * @param string $raport Typ raportu
     * @param string $where Gdzie umiescic czysty wpis
     * @throws sfException 
     */
    protected function prepareCleanRaportFinansowyEntry($where) {
        $raportData = $this->getAll('raport');

        $whereElements = explode('|', $where);
        $depth = count($whereElements);

        switch ($depth) {
            case 1:
                $raportData['finansowy'][$whereElements[0]]['values'] = $this->getCleanRaportFinansowyEntry();
                break;
            case 2:
                $raportData['finansowy'][$whereElements[0]]['items'][$whereElements[1]]['values'] = $this->getCleanRaportFinansowyEntry();
                if (!isset($raportData['finansowy'][$whereElements[0]]['values'])) {
                    $raportData['finansowy'][$whereElements[0]]['values'] = $this->getCleanRaportFinansowyEntry();
                }
                break;
            case 3:
                $raportData['finansowy'][$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]]['values'] = $this->getCleanRaportFinansowyEntry();
                if (!isset($raportData['finansowy'][$whereElements[0]]['values'])) {
                    $raportData['finansowy'][$whereElements[0]]['values'] = $this->getCleanRaportFinansowyEntry();
                }
                if (!isset($raportData['finansowy'][$whereElements[0]]['items'][$whereElements[1]]['values'])) {
                    $raportData['finansowy'][$whereElements[0]]['items'][$whereElements[1]]['values'] = $this->getCleanRaportFinansowyEntry();
                }
                break;
            case 4:
                $raportData['finansowy'][$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]]['items'][$whereElements[3]]['values'] = $this->getCleanRaportFinansowyEntry();
                if (!isset($raportData['finansowy'][$whereElements[0]]['values'])) {
                    $raportData['finansowy'][$whereElements[0]]['values'] = $this->getCleanRaportFinansowyEntry();
                }
                if (!isset($raportData['finansowy'][$whereElements[0]]['items'][$whereElements[1]]['values'])) {
                    $raportData['finansowy'][$whereElements[0]]['items'][$whereElements[1]]['values'] = $this->getCleanRaportFinansowyEntry();
                }
                if (!isset($raportData['finansowy'][$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]]['values'])) {
                    $raportData['finansowy'][$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]]['values'] = $this->getCleanRaportFinansowyEntry();
                }
                break;
            default:
                throw new sfException('Miejsce "' . $where . '" nie istnieje w danym raporcie.');
                break;
        }

        $this->setAll($raportData, 'raport');
    }

    protected function setRaportEntry($raport, $where, $value, $addValue) {
        if (!in_array($raport, $this->getRaportNames())) {
            throw new sfException('Raport "' . $raport . '" nie istnieje.');
        }

        $raportData = $this->getAll('raport');

        $whereElements = explode('|', $where);
        $depth = count($whereElements);

        switch ($depth) {
            case 1:
                if ($addValue) {
                    $raportData[$raport][$whereElements[0]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                } else {
                    $raportData[$raport][$whereElements[0]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] = $value;
                }
                break;
            case 2:
                if ($addValue) {
                    $raportData[$raport][$whereElements[0]]['items'][$whereElements[1]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                } else {
                    $raportData[$raport][$whereElements[0]]['items'][$whereElements[1]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] = $value;
                }
                $raportData[$raport][$whereElements[0]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                break;
            case 3:
                if ($addValue) {
                    $raportData[$raport][$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                } else {
                    $raportData[$raport][$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] = $value;
                }
                $raportData[$raport][$whereElements[0]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                $raportData[$raport][$whereElements[0]]['items'][$whereElements[1]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                break;
            case 4:
                if ($addValue) {
                    $raportData[$raport][$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]]['items'][$whereElements[3]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                } else {
                    $raportData[$raport][$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]]['items'][$whereElements[3]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] = $value;
                }
                $raportData[$raport][$whereElements[0]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                $raportData[$raport][$whereElements[0]]['items'][$whereElements[1]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                $raportData[$raport][$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]]['values'][$this->getYear()]['items'][$this->getKwartalRzymski()] += $value;
                break;
            default:
                throw new sfException('Miejsce "' . $where . '" nie istnieje w danym raporcie.');
                break;
        }

        $this->setAll($raportData, 'raport');
    }

    protected function parseRaportFinansowyEntries() {
        $entries = $this->g('finansowy_to_parse', 'raport', array());

        foreach ($entries as $where => $value) {
            $this->addRaportFinansowyEntry($where, $value);
        }

        $this->s('finansowy_to_parse', array(), 'raport');
    }

    protected function addKpirKredytLokata() {
        // Dodajemy wplywy i wyplywy z kredytow i lokat
        $karny = $this->g('kredyt_karny_kwota', 'round');
        if ($this->rGT(1)) {
            $karny -= $this->g('kredyt_karny_kwota', 'last_round');
        }

        if ($karny > 0) {
            $this->setRaportEntryToParse('kpir', 'wplywy|finansowe|kredyt_karny', $karny, true);
        } else {
            $this->setRaportEntryToParse('kpir', 'wyplywy|finansowe|kredyt_karny', abs($karny), true);
        }

        // Kredyt inwestycyjny w funkcji jego obliczania

        $obrotowy = $this->g('kredyt_obrotowy_kwota', 'round');
        if ($this->rGT(1)) {
            $obrotowy -= $this->g('kredyt_obrotowy_kwota', 'last_round');
        }

        if ($obrotowy > 0) {
            $this->setRaportEntryToParse('kpir', 'wplywy|finansowe|kredyt_obrotowy', $obrotowy, true);
        } else {
            $this->setRaportEntryToParse('kpir', 'wyplywy|finansowe|kredyt_obrotowy', abs($obrotowy), true);
        }

        $lokata = $this->g('lokata_kwota', 'round');
        if ($this->rGT(1)) {
            $lokata -= $this->g('lokata_kwota', 'last_round');
        }

        if ($lokata < 0) {
            $this->setRaportEntryToParse('kpir', 'wplywy|finansowe|lokata', abs($lokata), true);
        } else {
            $this->setRaportEntryToParse('kpir', 'wyplywy|finansowe|lokata', $lokata, true);
        }
    }

    protected function parseRaportKpirEntries() {
        $entries = $this->g('kpir_to_parse', 'raport');
        $raport = array();

        foreach ($entries as $where => $value) {
            if ($value > 0) {
                $whereElements = explode('|', $where);
                if (!isset($raport[$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]])) {
                    $raport[$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]] = $value;
                } else {
                    $raport[$whereElements[0]]['items'][$whereElements[1]]['items'][$whereElements[2]] += $value;
                }

                if (!isset($raport[$whereElements[0]]['items'][$whereElements[1]]['sum'])) {
                    $raport[$whereElements[0]]['items'][$whereElements[1]]['sum'] = $value;
                } else {
                    $raport[$whereElements[0]]['items'][$whereElements[1]]['sum'] += $value;
                }

                if (!isset($raport[$whereElements[0]]['sum'])) {
                    $raport[$whereElements[0]]['sum'] = $value;
                } else {
                    $raport[$whereElements[0]]['sum'] += $value;
                }
            }
        }

        // Dodajemy wartosci salda poczatkowe i salda po
        if ($this->rGT(1)) {
            $raport['saldo_poczatkowe']['sum'] = $this->g('balans', 'last_round');
        } else {
            $raport['saldo_poczatkowe']['sum'] = $this->g('kapital_zalozycielski', 'game');
        }

        $wplywy = 0;
        if (isset($raport['wplywy']['sum'])) {
            $wplywy = $raport['wplywy']['sum'];
        }

        $wyplywy = 0;
        if (isset($raport['wyplywy']['sum'])) {
            $wyplywy = $raport['wyplywy']['sum'];
        }

        $raport['saldo_koncowe']['sum'] = $raport['saldo_poczatkowe']['sum'] + $wplywy - $wyplywy;

        $raport = $this->sortRaport($raport, $this->getSortedRaportKpirArray());

        $this->s('kpir', $raport, 'raport');
        $this->s('kpir_to_parse', array(), 'raport');
    }

    protected function getSortedRaportKpirArray() {
        return array(
            'saldo_poczatkowe',
            'wplywy' => array(
                'operacyjne' => array(
                    'sprzedaz',
                    'finansowe',
                    'nadzwyczajne',
                ),
                'finansowe' => array(
                    'kredyt_obrotowy',
                    'kredyt_inwestycyjny',
                    'kredyt_karny',
                    'lokata',
                    'doplata',
                    'dotacje',
                ),
            ),
            'wyplywy' => array(
                'operacyjne' => array(
                    'stale',
                    'zmienne',
                    'inwestycje',
                    'inne_wydatki',
                    'odsetki',
                ),
                'finansowe' => array(
                    'kredyt_obrotowy',
                    'kredyt_inwestycyjny',
                    'kredyt_karny',
                    'lokata',
                    'kara',
                ),
            ),
            'saldo_koncowe'
        );
    }

    protected function getSortedRaportOperacyjnyArray() {
        return array(
            'oblozenie' => array(
                'pokoje_oblozone_standard',
                'pokoje_oblozone_lux',
            ),
            'jakosc' => array(
                'jakosc_pokoju_standard',
                'jakosc_pokoju_lux',
            ),
            'zatrudnienie' => array(
                'liczba_zatrudnionych',
                'liczba_zatrudnionych_obsluga',
                'liczba_zatrudnionych_administracja',
            ),
            'satysfakcja' => array(
                'satysfakcja_pracownikow',
                'satysfakcja_klientow_standard',
                'satysfakcja_klientow_lux',
            ),
            'marketing' => array(
                'efektywnosc_marketingu_standard',
                'efektywnosc_marketingu_lux',
            ),
            'marza' => array(
                'marza_standard',
                'marza_lux',
            ),
            'konkurencja' => array(
                'konkurencja_standard',
                'konkurencja_lux',
            ),
            'firma' => array(
                'wartosc_zadluzenia',
                'majatek_firmy',
                'skumulowany_zysk',
                'wartosc_udzialow',
            ),
        );
    }

    protected function sortRaport($data, $sorted) {
        $newData = array();

        foreach ($sorted as $key => $value) {
            if (is_array($value)) {
                if (isset($data[$key])) {
                    $newData[$key] = $data[$key];
                    // Nadpisujemy kolejnosc
                    $newData[$key]['items'] = $this->sortRaport($data[$key]['items'], $value);
                }
            } else {
                if (isset($data[$value])) {
                    $newData[$value] = $data[$value];
                }
            }
        }

        return $newData;
    }

    protected function sortRaportOperacyjny($data, $sorted) {
        $newData = array();

        foreach ($sorted as $key => $value) {
            if (is_array($value)) {
                if (isset($data[$key])) {
                    $newData[$key] = $data[$key];
                    // Nadpisujemy kolejnosc
                    $newData[$key] = $this->sortRaportOperacyjny($data[$key], $value);
                }
            } else {
                if (isset($data[$value])) {
                    $newData[$value] = $data[$value];
                }
            }
        }

        return $newData;
    }

    protected function getSortedRaportFinansowyArray() {
        return array(
            'przychody' => array(
                'sprzedaz' => array(
                    'pokoje_standard',
                    'pokoje_lux',
                ),
                'finansowe' => array(
                    'dotacje',
                    'lokata',
                    'doplata',
                ),
                'nadzwyczajne' => array(
                    'oszczednosci_panele',
                    'sprzedaz_pokoje_standard',
                    'sprzedaz_pokoje_lux',
                    'sprzedaz_wyposazenia_standard',
                    'sprzedaz_wyposazenia_lux',
                ),
            ),
            'koszty' => array(
                'bezposrednie' => array(
                    'dzierzawa',
                    'obsluga' => array(
                        'sprzatanie_standard',
                        'pranie_standard',
                        'sprzatanie_lux',
                        'pranie_lux',
                    ),
                    'media' => array(
                        'woda',
                        'prad',
                    ),
                    'stale',
                    'pracownicy_administracji',
                    'pracownicy_obslugi',
                    'inne_i_podatki',
                    'sniadania',
                ),
                'marketingowe' => array(
                    'strona_internetowa',
                    'ulotki',
                    'plakaty',
                    'reklama_regionalna' => array(
                        'radio',
                        'tv',
                        'prasa',
                    ),
                    'reklama_lokalna' => array(
                        'bilboardy',
                        'prasa',
                        'radio',
                    ),
                    'reklama_krajowa' => array(
                        'radio',
                        'tv',
                        'prasa',
                    ),
                    'badania',
                ),
                'finansowe' => array(
                    'kredyt_obrotowy',
                    'kredyt_inwestycyjny',
                    'kredyt_karny',
                    'kara',
                ),
                'zatrudnienie' => array(
                    'pracownicy_obslugi',
                    'pracownicy_administracji',
                ),
                'modernizacja' => array(
                    'event_panele',
                    'kupno_wyposazenia_standard',
                    'kupno_pokoje_standard',
                    'kupno_wyposazenia_lux',
                    'kupno_pokoje_lux',
                    'event_pralnia_ekologiczna',
                    'pralnia_ekologiczna',
                    'event_podjazd_dla_niepelnosprawnych',
                    'uslugi',
                ),
                'obywatelska' => array(
                    'event_festiwal_filmowy',
                    'event_sadzenie_drzew',
                    'plaza',
                    'golf',
                    'wyciag_narciarski',
                    'event_mikolajkowy_ekspres',
                ),
            ),
            'suma'
        );
    }

    public function setRaportEntryToParse($raport, $where, $value, $addValue = false) {
        if (!in_array($raport, $this->getRaportNames())) {
            throw new sfException('Raport "' . $raport . '" nie istnieje.');
        }

        $raportData = $this->getAll('raport');

        // Nie mozemy zastosowac $this->s() poniewaz $where zawiera "|"
        if ($addValue && isset($raportData[$raport . '_to_parse'][$where])) {
            $raportData[$raport . '_to_parse'][$where] += $value;
        } else {
            $raportData[$raport . '_to_parse'][$where] = $value;
        }

        $this->setAll($raportData, 'raport');
    }

    public function addRaportFinansowyEntry($where, $value, $addValue = true) {
        $added = false;

        if ($this->existRaportEntry('finansowy', $where)) {
            $this->setRaportEntry('finansowy', $where, $value, $addValue);
            $added = true;
        } else {
            if ($value != 0) {
                $this->prepareCleanRaportFinansowyEntry($where);
                $this->setRaportEntry('finansowy', $where, $value, $addValue);
                $added = true;
            }
        }

        return $added;
    }

    public function setKosztMarza($what, $value, $type = 'razem') {
        $types = array('standard', 'lux', 'razem');
        if (!in_array($type, $types)) {
            throw new sfException('Typ kosztu marzy "' . $type . '" nie istnieje.');
        } else {
            $marza = $this->g('marza', 'raport');
            $marza[$type][$what] = $value;
            $this->s('marza', $marza, 'raport');
        }
    }

    /**
     * Zwraca sumę wszystkich wydatków kwartalnych. 
     * 
     * @return float
     */
    protected function wydatki() {

        $array = array(
            $this->getKosztStronaInternetowa(),
            $this->kosztSprzatanieOutsourcingStandard(),
            $this->kosztSprzatanieOutsourcingLux(),
            $this->kosztPranieOutsourcingStandard(),
            $this->kosztPranieOutsourcingLux(),
            $this->kosztPralniaEkologiczna(),
            $this->kosztyBazowe(true),
            $this->kosztUslugi(),
            $this->kosztMedia(true),
            $this->kosztSniadanie(),
            $this->kosztPracownicyObslugi(),
            $this->kosztPracownicyAdministracji(),
            $this->kosztPracownicyObslugiMotywacjaProcent(),
            $this->kosztPracownicyAdministracjiMotywacjaProcent(),
            $this->kosztKredytInwestycyjny(),
            $this->kosztKredytObrotowy(),
            $this->kosztEventKierowniczka(),
            $this->kosztEventFestiwalFilmowy(),
            $this->kosztEventFunduszRemontowy(),
            $this->kosztEventOplataKlimatyczna(),
        );

        $nazwyFinansowy = array(
            'koszty|marketingowe|strona_internetowa',
            'koszty|bezposrednie|obsluga|sprzatanie_standard',
            'koszty|bezposrednie|obsluga|sprzatanie_lux',
            'koszty|bezposrednie|obsluga|pranie_standard',
            'koszty|bezposrednie|obsluga|pranie_lux',
            'koszty|modernizacja|pralnia_ekologiczna',
            false, // @see kosztyBazowe()
            'koszty|modernizacja|uslugi',
            false, // @see kosztMedia()
            'koszty|bezposrednie|sniadania',
            'koszty|zatrudnienie|pracownicy_obslugi',
            'koszty|zatrudnienie|pracownicy_administracji',
            'koszty|zatrudnienie|pracownicy_obslugi', // Dodajemy motywacje obslugi do kosztow pracownikow obslugi
            'koszty|zatrudnienie|pracownicy_administracji', // Dodajemy motywacje obslugi do kosztow pracownikow obslugi
            false,
            'koszty|finansowe|kredyt_obrotowy',
            'koszty|zatrudnienie|pracownicy_administracji', // Dodajemy koszt kierowniczki do admnistriacji
            'koszty|obywatelska|event_festiwal_filmowy',
            'koszty|modernizacja|event_fundusz_remontowy',
            'koszty|bezposrednie|event_oplata_klimatyczna'
        );

        $nazwyKpir = array(
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|zmienne',
            false, // @see kosztyBazowe()
            'wyplywy|operacyjne|stale',
            false, // @see kosztMedia()
            'wyplywy|operacyjne|zmienne',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale', // Dodajemy motywacje obslugi do kosztow pracownikow obslugi
            'wyplywy|operacyjne|stale', // Dodajemy motywacje obslugi do kosztow pracownikow obslugi
            'wyplywy|operacyjne|odsetki',
            'wyplywy|operacyjne|odsetki',
            'wyplywy|operacyjne|stale', // Dodajemy koszt kierowniczki do admnistriacji
            'wyplywy|operacyjne|inne_wydatki',
            'wyplywy|operacyjne|inne_wydatki',
            'wyplywy|operacyjne|inne_wydatki'
        );

        $nazwyOperacyjny = array(
            'strona_internetowa' => 'razem',
            'sprzatanie_standard' => 'standard',
            'sprzatanie_lux' => 'lux',
            'pranie_standard' => 'standard',
            'pranie_lux' => 'lux',
            'pralnia_ekologiczna' => 'razem',
            'koszty_bazowe' => false,
            'uslugi' => 'razem',
            'koszty_media' => false,
            'sniadania' => 'razem',
            'pracownicy_obslugi' => 'razem',
            'pracownicy_administracji' => 'razem',
            'motywacja_obsluga' => 'razem',
            'motywacja_administracji' => 'razem',
            'kredyt_inwestycyjny' => 'razem',
            'kredyt_obrotowy' => 'razem',
            'pracownicy_administracji' => 'razem',
            'event_festiwal_filmowy' => 'razem',
            'event_fundusz_remontowy' => 'razem',
            'event_oplata_klimatyczna' => 'razem',
        );

        $wydatki = array_sum($array);
        foreach ($nazwyFinansowy as $index => $where) {
            if ($where) {
                $this->addRaportFinansowyEntry($where, $array[$index]);
            }
        }

        foreach ($nazwyKpir as $index => $where) {
            if ($where) {
                $this->setRaportEntryToParse('kpir', $where, $array[$index], true);
            }
        }

        $index = 0;
        foreach ($nazwyOperacyjny as $where => $type) {
            if ($type) {
                $this->setKosztMarza($where, $array[$index], $type);
            }
            $index++;
        }


        $this->s('wydatki', $wydatki, 'round');
        $this->logI('F(' . __FUNCTION__ . '):  Wydatki : ', $wydatki);
        return $wydatki;
    }

    public function kosztEventOplataKlimatyczna() {
        $koszt = self::COSTS_NULL;

        if ($this->hasEventOplataKlimatyczna()) {
            $koszt = ($this->g('popyt_standard', 'round', 0) + $this->g('popyt_lux', 'round', 0)) * $this->g('eventy|oplata_klimatyczna', 'game');
        }

        $this->logK('F(' . __FUNCTION__ . '):  Koszt eventu oplata klimatyczna : ', $koszt);
        return $koszt;
    }

    public function kosztPralniaEkologiczna() {
        $koszt = self::COSTS_NULL;

        if ($this->wspEventPralniaEkologiczna() == 1) {
            $pokojeOblozoneLux = 0;
            $pokojeOblozoneStandard = 0;
            if ($this->getGameData()->hasLastRound()) {
                $pokojeOblozoneLux = $this->g('pokoje_oblozone_lux', 'last_round');
                $pokojeOblozoneStandard = $this->g('pokoje_oblozone_standard', 'last_round');
            }

            $kss = $this->g('koszty_bazowe|pokoje_nieoblozone|pranie', 'game');
            $kss = $kss[$this->gL()];

            $ksso = $this->g('koszty_bazowe|pokoje_oblozone|pranie', 'game');
            $ksso = $ksso[$this->gL()];

            $ks = $this->gLPS() * $kss + $pokojeOblozoneStandard * $ksso + ($this->gLPL() * $kss + $pokojeOblozoneLux * $ksso) * $this->g('wspolczynniki|lux', 'game');

            $koszt = $ks * $this->g('eventy|pralnia_ekologiczna|mnoznik_kosztu_kwartalnego', 'game');
        }

        $this->logK('F(' . __FUNCTION__ . '): Koszt kwartalny pralni ekologocznej : ', $koszt);

        return $koszt;
    }

    /**
     * Zwraca koszt motywacji procentowej
     * @return float
     */
    public function kosztMotywacjaProcent() {
        $koszt = $this->kosztPracownicyObslugiMotywacjaProcent() + $this->kosztPracownicyadministracjiMotywacjaProcent();
        $this->logK('F(' . __FUNCTION__ . '): Koszt motywacji procentowej : ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt motywacji procentowej pracownikow obslugi
     * @return float
     */
    public function kosztPracownicyObslugiMotywacjaProcent() {
        $koszt = $this->kosztPracownicyObslugiStaleMotywacjaProcent() + $this->kosztPracownicyObslugiZlecenieMotywacjaProcent();

        $this->logK('F(' . __FUNCTION__ . '): Koszt motywacji procentowej pracownikow obslugi: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt motywacji procentowej pracownikow obslugi stale
     * @return float
     */
    public function kosztPracownicyObslugiStaleMotywacjaProcent() {
        $koszt = 0;
        if ($this->gPOS() > 0) {
            $procent = $this->g('pracownicy_obslugi_stale_motywacja_procent', 'decision') / 100;
            $koszt = $this->g('pracownicy_obslugi_stale_wynagrodzenie', 'decision') * $procent * $this->gPOS() * 3;
        }

        $this->logK('F(' . __FUNCTION__ . '): Koszt motywacji procentowej pracownikow obslugi stale: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt motywacji procentowej pracownikow obslugi
     * @return float
     */
    public function kosztPracownicyObslugiZlecenieMotywacjaProcent() {
        $koszt = 0;
        if ($this->gPOZ() > 0) {
            $procent = $this->g('pracownicy_obslugi_zlecenie_motywacja_procent', 'decision') / 100;
            $koszt = $this->g('pracownicy_obslugi_zlecenie_wynagrodzenie', 'decision') * $procent * $this->gPOZ() * 3;
        }

        $this->logK('F(' . __FUNCTION__ . '): Koszt motywacji procentowej pracownikow obslugi zlecenie: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt motywacji procentowej pracownikow administracji
     * @return float
     */
    public function kosztPracownicyAdministracjiMotywacjaProcent() {
        $koszt = $this->kosztPracownicyAdministracjiStaleMotywacjaProcent() + $this->kosztPracownicyAdministracjiZlecenieMotywacjaProcent();

        $this->logK('F(' . __FUNCTION__ . '): Koszt motywacji procentowej pracownikow administracji: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt motywacji procentowej pracownikow administracji stale
     * @return float
     */
    public function kosztPracownicyAdministracjiStaleMotywacjaProcent() {
        $koszt = 0;
        if ($this->gPAS() > 0) {
            $procent = $this->g('pracownicy_administracji_stale_motywacja_procent', 'decision') / 100;
            $koszt = $this->g('pracownicy_administracji_stale_wynagrodzenie', 'decision') * $procent * $this->gPAS() * 3;
        }

        $this->logK('F(' . __FUNCTION__ . '): Koszt motywacji procentowej pracownikow administracji stale: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt motywacji procentowej pracownikow administracji
     * @return float
     */
    public function kosztPracownicyAdministracjiZlecenieMotywacjaProcent() {
        $koszt = 0;
        if ($this->gPAZ() > 0) {
            $procent = $this->g('pracownicy_administracji_zlecenie_motywacja_procent', 'decision') / 100;
            $koszt = $this->g('pracownicy_administracji_zlecenie_wynagrodzenie', 'decision') * $procent * $this->gPAZ() * 3;
        }

        $this->logK('F(' . __FUNCTION__ . '): Koszt motywacji procentowej pracownikow administracji zlecenie: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt mediów razem (lokalne, regionalne i krajowe)
     * @return float 
     */
    public function kosztMedia($addRaportEntries = false) {
        $tablicaKosztu = array(
            $this->g('media_lokalne_bilboardy', 'decision') * $this->g('media|koszty|lokalne|bilboardy', 'game'),
            $this->g('media_lokalne_prasa', 'decision') * $this->g('media|koszty|lokalne|prasa', 'game'),
            $this->g('media_lokalne_radio', 'decision') * $this->g('media|koszty|lokalne|radio', 'game'),
            $this->g('media_regionalne_prasa', 'decision') * $this->g('media|koszty|regionalne|prasa', 'game'),
            $this->g('media_regionalne_radio', 'decision') * $this->g('media|koszty|regionalne|radio', 'game'),
            $this->g('media_regionalne_tv', 'decision') * $this->g('media|koszty|regionalne|tv', 'game'),
            $this->g('media_krajowe_prasa', 'decision') * $this->g('media|koszty|krajowe|prasa', 'game'),
            $this->g('media_krajowe_radio', 'decision') * $this->g('media|koszty|krajowe|radio', 'game'),
            $this->g('media_krajowe_tv', 'decision') * $this->g('media|koszty|krajowe|tv', 'game'),
        );
        // Potrzebna do logow
        $tablicaNazwRaportowFinansowy = array(
            'koszty|marketingowe|reklama_lokalna|bilboardy',
            'koszty|marketingowe|reklama_lokalna|prasa',
            'koszty|marketingowe|reklama_lokalna|radio',
            'koszty|marketingowe|reklama_regionalna|prasa',
            'koszty|marketingowe|reklama_regionalna|radio',
            'koszty|marketingowe|reklama_regionalna|tv',
            'koszty|marketingowe|reklama_krajowa|prasa',
            'koszty|marketingowe|reklama_krajowa|radio',
            'koszty|marketingowe|reklama_krajowa|tv',
        );

        // Potrzebna do logow
        $tablicaSTT = array(
            'koszty|reklama_lokalna|bilboardy',
            'koszty|reklama_lokalna|prasa',
            'koszty|reklama_lokalna|radio',
            'koszty|reklama_regionalna|prasa',
            'koszty|reklama_regionalna|radio',
            'koszty|reklama_regionalna|tv',
            'koszty|reklama_krajowa|prasa',
            'koszty|reklama_krajowa|radio',
            'koszty|reklama_krajowa|tv',
        );

        $tablicaNazwRaportowKpir = array(
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
            'wyplywy|operacyjne|stale',
        );

        if ($this->rEQ(4) || $this->rEQ(5)) {
            // W rundzie 4 i 5 dochodza koszty plakatow i ulotek
            $tablicaKosztu[] = $this->g('media_lokalne_ulotki', 'decision') * $this->g('media|koszty|lokalne|ulotki', 'game');
            $tablicaKosztu[] = $this->g('media_lokalne_plakaty', 'decision') * $this->g('media|koszty|lokalne|plakaty', 'game');
            $tablicaNazwRaportowFinansowy[] = 'koszty|marketingowe|ulotki';
            $tablicaNazwRaportowFinansowy[] = 'koszty|marketingowe|plakaty';
            $tablicaSTT[] = 'koszty|marketingowe|ulotki';
            $tablicaSTT[] = 'koszty|marketingowe|plakaty';
            $tablicaNazwRaportowKpir[] = 'wyplywy|operacyjne|stale';
            $tablicaNazwRaportowKpir[] = 'wyplywy|operacyjne|stale';
        }

//        Mnozenie kosztow wylaczone. Zmiany koniec lipca
//        if ($this->hasEventKonkurencja()) {
//            // Zwiekszenie koszut reklam po wejsciu konkurencji
//            for ($i = 0; $i < count($tablicaKosztu); $i++) {
//                $tablicaKosztu[$i] *= $this->g('eventy|konkurencja_reklama_mnoznik', 'game');
//            }
//        }

        if ($addRaportEntries) {
            foreach ($tablicaKosztu as $index => $koszt) {
                $this->addRaportFinansowyEntry($tablicaNazwRaportowFinansowy[$index], $koszt, false);
                $this->setRaportEntryToParse('kpir', $tablicaNazwRaportowKpir[$index], $koszt, true);
                $this->sTT($tablicaSTT[$index], $koszt);
            }
        }

        $koszt = array_sum($tablicaKosztu);

        $this->logK('F(' . __FUNCTION__ . '):  Koszt wszystkich mediow : ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt utrzymania pracownikow obslugi
     * @return float
     */
    public function kosztPracownicyObslugi() {
        $koszt = $this->kosztPracownicyObslugiStale() + $this->kosztPracownicyObslugiZlecenie();

        $this->logK('F(' . __FUNCTION__ . '):  Koszt pracownicy obslugi : ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt utrzymania pracownikow obslugi na stale
     * @return float
     */
    public function kosztPracownicyObslugiStale() {
        $koszt = $this->gPOS() * $this->g('pracownicy_obslugi_stale_wynagrodzenie', 'decision') * 3;

        $this->logK('F(' . __FUNCTION__ . '):  Koszt pracownicy obslugi stale: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt utrzymania pracownikow obslugi na zlecenie
     * @return float
     */
    public function kosztPracownicyObslugiZlecenie() {
        $koszt = $this->gPOZ() * $this->g('pracownicy_obslugi_zlecenie_wynagrodzenie', 'decision') * 3;

        $this->logK('F(' . __FUNCTION__ . '):  Koszt pracownicy obslugi zlecenie: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt utrzymania pracownikow administracji
     * @return float
     */
    public function kosztPracownicyAdministracji() {
        $koszt = $this->kosztPracownicyAdministracjiStale() + $this->kosztPracownicyAdministracjiZlecenie();

        $this->logK('F(' . __FUNCTION__ . '):  Koszt pracownicy administracji : ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt utrzymania pracownikow administracji na stale
     * @return float
     */
    public function kosztPracownicyAdministracjiStale() {
        $koszt = $this->gPAS() * $this->g('pracownicy_administracji_stale_wynagrodzenie', 'decision') * 3;

        $this->logK('F(' . __FUNCTION__ . '):  Koszt pracownicy administracji stale: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt utrzymania pracownikow administracji zlecenie
     * @return float
     */
    public function kosztPracownicyAdministracjiZlecenie() {
        $koszt = $this->gPAZ() * $this->g('pracownicy_administracji_zlecenie_wynagrodzenie', 'decision') * 3;

        $this->logK('F(' . __FUNCTION__ . '):  Koszt pracownicy administracji zlecenie: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt eventu festiwal filmowy
     * 
     * @return float
     */
    public function kosztEventFestiwalFilmowy() {
        $koszt = self::COSTS_NULL;
        if ($this->gRN() == (self::FIRST_ROUND + 1) && $this->g('event_festiwal_filmowy', 'decision', false)) {
            // W drugiej rundzie sa tylko pokoje standard
            $koszt = $this->g('eventy|festiwal_filmowy|koszt', 'game') * $this->getKosztPokoiStandard($this->gLPS());
        }
        $this->logK('F(' . __FUNCTION__ . '): Koszt eventu festiwal filmowy: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt eventu fundusz remontowy
     * @return float
     */
    protected function kosztEventFunduszRemontowy() {
        $koszt = self::COSTS_NULL;
        if ($this->hasEventFunduszRemontowy()) {
            $koszt = $this->g('eventy|fundusz_remontowy', 'game') *
                    ($this->getKosztBudowyPokoiStandard($this->gLPS()) + $this->getKosztBudowyPokoiLux($this->gLPL()));
        }

        $this->logK('F(' . __FUNCTION__ . '): Koszt eventu fundusz remontowy: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt usług dodatkowych w hotelu
     * 
     * @return type
     */
    public function kosztUslugi() {
        $cenaUslug = $this->g('uslugi', 'game');
        $koszt = self::COSTS_NULL;

        foreach ($cenaUslug as $nazwa => $cena) {
            if ($this->g($nazwa, 'decision', false)) {
                $koszt += $cena;
                $this->sTT('koszty|uslugi|' . $nazwa, $cena);
            }
        }

        $uslugiSezonowosc = array('plaza', 'wyciag_narciarski', 'golf');
        foreach ($uslugiSezonowosc as $usluga) {
            if ($this->isUslugaEventAccepted('usluga_' . $usluga)) {
                $ceny = $this->g('sezonowosc|koszt|usluga_' . $usluga, 'game');
                if ($this->g($usluga, 'decision', false)) {
                    $cena = $ceny[1];
                } else {
                    $cena = $ceny[0];
                }
                $this->sTT('koszty|uslugi|' . $usluga, $cena);
                $koszt += $cena;
            }
        }

        $this->logK('F(' . __FUNCTION__ . '):  Koszt usług wraz z sezonowoscia: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt śniadania dla wszystkich pokoi w hotelu.
     * 
     * @return float
     */
    protected function kosztSniadanie() {
        $koszt = self::COSTS_NULL;
        $cena = $this->g('sniadania_kwota', 'decision');

        if ($cena > 0) {
            $kosztZaPokoj = $this->g('sniadania|koszt_za_pokoj', 'game');
            $iloscPokoi = $this->gLPS() + $this->gLPL();
            $koszt = (($this->g('pokoje_oblozone_standard', 'round') + $this->g('pokoje_oblozone_lux', 'round')) * $cena + ($iloscPokoi) * $kosztZaPokoj) * sfConfig::get('game_hotel_dni_w_kwartale', 90);
        }

        $this->logK('F(' . __FUNCTION__ . '):  Koszt śniadania : ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca rate kredytu inwestycyjnego dla danej kwoty
     * @param float $kwota
     * @return float 
     */
    public function getKredytInwestycyjnyRata($kwota) {
        $n = $this->g('kredyty|inwestycyjny|okres', 'game');
        $r = $this->g('kredyty|inwestycyjny|odsetki', 'game');
        $q = 1 + $r / 4; // 4 kwartaly mamy w roku
        return $kwota * pow($q, $n) * (($q - 1) / (pow($q, $n) - 1));
    }

    /**
     * Zwraca oprocentowanie kredytu obrotowego dla danej kwoty
     * @param float $kwota
     * @return float 
     */
    public function getKredytObrotowyOprocentowanie($kwota) {
        $rataOdsetkowa = $this->g('kredyty|obrotowy|odsetki_1', 'game');
        if ($kwota > 0) {
            $wartosc = $this->getWartoscFirmy();
            $ratio = $kwota / $wartosc;
            if ($ratio <= 0.5) {
                $odsetki = $this->g('kredyty|obrotowy|odsetki_1', 'game');
            } elseif ($ratio > 0.5 && $ratio <= 1) {
                $odsetki = $this->g('kredyty|obrotowy|odsetki_2', 'game');
            } elseif ($ratio > 1) {
                $odsetki = $this->g('kredyty|obrotowy|odsetki_3', 'game');
            }
            $rataOdsetkowa = $odsetki;
        }

        return $rataOdsetkowa;
    }

    /**
     * Zwraca rate kredytu obrotowego dla danej kwoty
     * @param float $kwota
     * @return float 
     */
    public function getKredytObrotowyRata($kwota) {
        $rataOdsetkowa = 0;
        if ($kwota > 0) {
            $odsetki = $this->getKredytObrotowyOprocentowanie($kwota);
            $rataOdsetkowa = ($odsetki / 4) * $kwota;
        }

        return $rataOdsetkowa;
    }

    /**
     * Zwraca koszt kredytu inwestycyjnego (rate kredytu).
    
     * @return float
     */
    public function kosztKredytInwestycyjny() {
        return $this->g('kredyt_inwestycyjny_rata', 'round');
    }

    /**
     * Zwraca odsetki kredytu inwestycyjnego. Wykorzystywany w raporcie finansowym
     */
    public function getKredytInwestycyjnyOdsetki() {
        $kwota = $this->g('kredyt_inwestycyjny_kwota', 'round');
        return $kwota * ($this->g('kredyty|inwestycyjny|odsetki', 'game') / 4);
    }

    public function getZdolnoscKredytObrotowy() {
        return max($this->g('kredyty|obrotowy|max_mnoznik', 'game') * $this->getGameProcess()->getWartoscFirmy(), 0);
    }

    public function getZdolnoscKredytInwestycyjny() {
        return max($this->g('kredyty|inwestycyjny|max_mnoznik', 'game') * $this->getGameProcess()->getWartoscFirmy(), 0);
    }

    /**
     * Zwraca koszt kredytu obrotowego (rate kredytu).
    
     * @return float
     */
    public function kosztKredytObrotowy() {
        $kwota = $this->g('kredyt_obrotowy_kwota', 'round');
        $rataOdsetkowa = 0;
        $this->logK('F(' . __FUNCTION__ . '):  Kwota kredytu obrotowego : ', $kwota);
        if (!is_null($kwota) && $kwota > 0) {
            $rataOdsetkowa = $this->getKredytObrotowyRata($kwota);
        }

        $this->sTT('bank|kredyt_obrotowy|kwota', $kwota);
        $this->sTT('bank|kredyt_obrotowy|rata', $rataOdsetkowa);

        $this->logK('F(' . __FUNCTION__ . '):  Rata kredytu obrotowego : ', $rataOdsetkowa);

        return $rataOdsetkowa;
    }

    /**
     * Zwraca koszt kredytu karnego (rate kredytu).
     * Zapisuje rate w 'kredyt_karny_rata' w 'round'
     * 
    
     * @return float
     */
    public function kosztKredytKarny($addRaportEntries = false) {
        $rata = $this->g('kredyt_karny_kwota', 'round') * ($this->g('kredyty|karny|odsetki', 'game') / 4);

        if ($addRaportEntries) {
            $this->addRaportFinansowyEntry('koszty|finansowe|kredyt_karny', $rata);
            $this->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|odsetki', $rata, true);
        }

        $this->s('kredyt_karny_rata', $rata, 'round');
        $this->logK('F(' . __FUNCTION__ . '):  Rata kredytu karnego : ', $rata);
        return $rata;
    }

    /**
     * Zmniejsza ilosc rat do splaty o 1, zeruje wartosci w przypadku ostatniej raty
    
     */
    protected function obliczKredytInwestycyjny() {
        $kwota = $this->g('kredyt_inwestycyjny_kwota', 'round');
        $rata = $this->kosztKredytInwestycyjny();
        $iloscRat = $this->g('kredyt_inwestycyjny_ilosc_rat', 'round');
        if ($iloscRat == $this->g('kredyty|inwestycyjny|okres', 'game')) {
            // Raportujemy wplyw z kredytu tylko podczas zaciagania
            $this->setRaportEntryToParse('kpir', 'wplywy|finansowe|kredyt_inwestycyjny', abs($kwota), true);
        }
        if ($iloscRat > 0) {
            $iloscRat--;
            $this->s('kredyt_inwestycyjny_ilosc_rat', $iloscRat, 'round');
            $odsetki = $this->getKredytInwestycyjnyOdsetki();
            $this->addRaportFinansowyEntry('koszty|finansowe|kredyt_inwestycyjny', $odsetki);
            if ($iloscRat == 0) {
                // Jesli to ostatnia rata zerujemy kwote kredytu i rate
                $this->s('kredyt_inwestycyjny_kwota', 0, 'round');
                $this->s('kredyt_inwestycyjny_rata', 0, 'round');
            } else {
                // Jesli nie to zmiejszamy, ale dodajemy odsetki
                $this->sTT('bank|kredyt_inwestycyjny|odsetki', $odsetki);
                $this->s('kredyt_inwestycyjny_kwota', $kwota - $rata + $odsetki, 'round');
            }
        }

        $this->sTT('bank|kredyt_inwestycyjny|kwota', $kwota);
        $this->sTT('bank|kredyt_inwestycyjny|rata', $rata);
        $this->sTT('bank|kredyt_inwestycyjny|kwota_po_splacie', $this->g('kredyt_inwestycyjny_kwota', 'round'));
        $this->sTT('bank|kredyt_inwestycyjny|ilosc_rat_po_splacie', $iloscRat);

        $this->logK('F(' . __FUNCTION__ . '):  Kwota kredytu inwestycyjnego : ', $this->g('kredyt_inwestycyjny_kwota', 'round'));
        $this->logK('F(' . __FUNCTION__ . '):  Rata kredytu inwestycyjnego : ', $rata);
        $this->logK('F(' . __FUNCTION__ . '):  Ilosc rat pozostalych do splaty: ', $iloscRat);
    }

    /**
     * Jesli balans < 0, zaciaga kredyt karny.
     * Jesli balans > wart_pocz, splaca automatycznie kredyt karny.
     * Zmiena stan gry.
    
     */
    protected function obliczKredytKarny() {
        $kwota = $this->g('kredyt_karny_kwota', 'round');
        $wartoscPoczatkowa = $this->g('kredyty|karny|wartosc_poczatkowa', 'game');
        $kwotaKredytu = 0;

        $this->sTT('bank|kredyt_karny|kwota', $kwota);
        $this->sTT('bank|kredyt_karny|wartosc_poczatkowa', $wartoscPoczatkowa);
        // Zaciagamy kredyt
        if ($this->gB() < 0) {
            // Splacamy rate kredytu jesli mamy
            $rata = $this->kosztKredytKarny(true);
            $this->sTT('bank|kredyt_karny|rata', $rata);
            $this->cB(-$rata);
            // Zaciagamy kredyt bo balans mamy ujemny
            // Zaciagamy do jakiejs dodatniej wartosci poczatkowej
            $kwotaKredytu = abs($this->gB()) + $wartoscPoczatkowa;
            if (!is_null($kwota) && $kwota > 0) {
                // Jesli mielismy kredyt, trzeba go zwiekszyc
                $kwotaKredytu += $kwota;
            }
            $this->s('kredyt_karny_kwota', $kwotaKredytu, 'round');

            $this->sTT('bank|kredyt_karny|kwota_po_splacie', $kwotaKredytu);
            $kwota = $kwotaKredytu;
            $this->sB($wartoscPoczatkowa);
        }

        // Splacamy kredyt automatycznie
        if ($this->gB() > $wartoscPoczatkowa && $kwota > 0) {
            $kapitalSplaty = $this->gB() - $wartoscPoczatkowa;
            if ($kapitalSplaty > $kwota) {
                // Splacamy calosc
                $doSplaty = $kwota;
            } else {
                // Splacamy czesc
                $doSplaty = $kapitalSplaty;
            }

            $kwotaPoSplacie = $kwota - $doSplaty;
            $this->s('kredyt_karny_kwota', $kwotaPoSplacie, 'round');

            $this->sTT('bank|kredyt_karny|kwota_splacona', $doSplaty);
            $this->sTT('bank|kredyt_karny|kwota_po_splacie', $kwotaPoSplacie);

            $this->cB(-$doSplaty);

            $rata = $this->kosztKredytKarny(true);
            $this->sTT('bank|kredyt_karny|rata', $rata);
            $this->cB(-$rata);

            if ($this->gB() < 0) {
                $doZaciagniecia = $wartoscPoczatkowa - $this->gB();
                $this->s('kredyt_karny_kwota', $this->g('kredyt_karny_kwota', 'round') + $doZaciagniecia, 'round');
                $this->sB($wartoscPoczatkowa);
            }
            $this->sTT('bank|kredyt_karny|kwota_ostateczna', $this->g('kredyt_karny_kwota', 'round'));
        }

        $this->logK('F(' . __FUNCTION__ . '):  Kwota kredytu karnego po przeliczeniu : ', $kwota);
    }

    /**
     * Zwraca odsetki roczne z lokaty dla podanej kwoty
     * @param float $kwota
     * @return float 
     */
    public function getLokataOdsetkiRoczne($kwota) {
        $odsetki = $this->g('lokata|odsetki_1', 'game') / 4;
        if ($kwota > 100000) {
            $odsetki = $this->g('lokata|odsetki_2', 'game') / 4;
        }
        if ($kwota > 200000) {
            $odsetki = $this->g('lokata|odsetki_3', 'game') / 4;
        }

        return $odsetki;
    }

    /**
     * Zwraca odsetki z lokaty dla podanej kwoty
     * @param float $kwota
     * @return float 
     */
    public function getLokataOdsetki($kwota) {
        $rata = $kwota * $this->getLokataOdsetkiRoczne($kwota);

        return max(0, $rata);
    }

    /**
     * Zwraca przychod z lokaty
     * @return float
     */
    public function przychodLokata() {
        $kwota = $this->g('lokata_kwota', 'round');
        $odsetki = $this->getLokataOdsetki($kwota);

        $this->sTT('bank|lokata|kwota', $kwota);
        $this->sTT('bank|lokata|odsetki', $odsetki);

        $this->logI('F(' . __FUNCTION__ . '):  Kwota lokaty : ', $kwota);
        $this->logI('F(' . __FUNCTION__ . '):  Odsetki z lokaty : ', $odsetki);

        return $odsetki;
    }

    /**
     * Zwraca majatek firmy na ktory sklada sie
     * + koszt inwestycji w pokoje z wyposazeniem
     * + gotowka
     * + inne inwestycje (pralnia, podjazd, panele)
     * 
     * @return float 
     */
    public function getMajatekFirmy() {
        $inwestycje = $this->getKosztPokoiLux($this->gLPL() + $this->g('pokoje_lux', 'decision')) + $this->getKosztPokoiStandard($this->gLPS() + $this->g('pokoje_standard', 'decision'));

        if ($this->wspEventPralniaEkologiczna() == 1) {
            $inwestycje += $this->g('eventy|pralnia_ekologiczna|koszt', 'game');
        }
        if ($this->wspEventPodjazdDlaNiepelnosprawnych() == 1) {
            $inwestycje += $this->g('eventy|podjazd_dla_niepelnosprawnych|koszt', 'game');
        }

        $inwestycje += $this->g('eventy|panele|koszt', 'game') * $this->g('event_panele', 'decision');

        $majatek = $inwestycje + $this->gB();
        $majatek += $this->g('lokata_kwota', 'round');
        $this->logI('F(' . __FUNCTION__ . '):  Majatek firmy: ', $majatek);

        return $majatek;
    }

    /**
     * Zwraca zadluzenie na ktore skladaja sie kwoty kredytow
     * + obrotowy
     * + inwestycyjny
     * + karny
     * @return float
     */
    public function getZadluzenieFirmy() {
        $zadluzenie = $this->g('kredyt_obrotowy_kwota', 'round', 0) + $this->g('kredyt_inwestycyjny_kwota', 'round', 0) + $this->g('kredyt_karny_kwota', 'round', 0);

        $this->logI('F(' . __FUNCTION__ . '):  Zadluzenie firmy: ', $zadluzenie);
        return $zadluzenie;
    }

    /**
     * Zwraca wartosc firmy na ktory sklada sie
     * + majatek firmy @see getMajatekFirmy()
     * - zadluzenie @see getZadluzenieFirmy()
     * + prognoza (zmiana_salda z ostatniej rundy * 4)
     * @return float 
     */
    public function getWartoscFirmy() {
        $wartosc = $this->getMajatekFirmy();
        // Odliczamy zadluzenie
        $wartosc -= $this->getZadluzenieFirmy();
        // Dodajemy prognoze
        if ($this->rGT(1)) {
            $wartosc += ($this->g('zmiana_saldo', 'last_round') * 4);
        }

        $this->logI('F(' . __FUNCTION__ . '):  Wartosc firmy: ', $wartosc);

        return $wartosc;
    }

    protected function saldo() {
        $saldoPrzed = $this->gB();

        $wydatki = $this->wydatki();
        $przychod = $this->przychod();

        $zysk = $przychod - $wydatki;
        $kapital = $this->kapital();

        $saldo = $kapital - $wydatki + $przychod;

        $this->s('zmiana_salda', ($saldo - $saldoPrzed), 'round');
        $this->s('zysk', max(0, $zysk), 'round');
        $this->s('skumulowany_zysk', ($this->g('skumulowany_zysk', 'round') + $zysk), 'round');

        $this->logI('F(' . __FUNCTION__ . '): Wydatki :', $wydatki);
        $this->logI('F(' . __FUNCTION__ . '): Przychod :', $przychod);
        $this->logI('F(' . __FUNCTION__ . '): Kapital :', $kapital);
        $this->logI('F(' . __FUNCTION__ . '): Nowe saldo :', $saldo);

        return $saldo;
    }

    /**
     * Wielkość kapitału. [ oszczędności | dofinansowania | balans ]
     * 
     * @return type
     */
    protected function kapital() {
        $dofinansowanie = $this->dofinansowanie();
        $oszczednosciEventPanele = $this->oszczednosciEventPanele();

        $kapitalArray = array(
            $this->gB()
            , $dofinansowanie
            , $oszczednosciEventPanele
        );

        $this->addRaportFinansowyEntry('przychody|finansowe|dotacje', $dofinansowanie);
        $this->addRaportFinansowyEntry('przychody|nadzwyczajne|oszczednosci_panele', $oszczednosciEventPanele);
        $this->setRaportEntryToParse('kpir', 'wplywy|finansowe|dotacje', $dofinansowanie, true);
        $this->setRaportEntryToParse('kpir', 'wplywy|operacyjne|nadzwyczajne', $oszczednosciEventPanele, true);

        $kapital = array_sum($kapitalArray);

        $this->s('kapital', $kapital, 'round');

        $this->logI('F(' . __FUNCTION__ . '):  Kapital : ', $kapital);
        return $kapital;
    }

    /**
     * Oszczędności na prądzie, || Event panele, 
     * 
     * @return float
     */
    protected function oszczednosciEventPanele() {
        $oszczednosci = $this->g('eventy|panele|oszczednosci', 'game') * $this->g('event_panele', 'decision');

        $this->logI('F(' . __FUNCTION__ . '):  Oszczednosci event panele : ', $oszczednosci);
        return $oszczednosci;
    }

    /**
     * Oblicza koszty bazowe dla pokoi [ pranie | sprzątanie | woda | prąd | itp.]
     * 
     * @see wydatki();
     * @return float
     */
    protected function kosztyBazowe($addRaportEntries = false) {
        $kosztyStale = $this->kosztyStale($addRaportEntries);
        $kosztyStandard = $this->kosztyPokojeStandard($addRaportEntries);
        $kosztyLux = $this->kosztyPokojeLux($addRaportEntries);

        $koszt = $kosztyStale + $kosztyStandard + $kosztyLux;
        $this->logK('F(' . __FUNCTION__ . '):  Koszty bazowe: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszty stale dla pokoi standard i lux oraz dzierzawe
     * @return float 
     */
    protected function kosztyStale($addRaportEntries = false) {
        $kosztyStandard = $this->g('koszty_bazowe|koszty_stale_standard|' . $this->gL(), 'game');
        $dzierzawaStandard = 0;
        $kosztyLux = 0;
        $dzierzawaLux = 0;


        if ($this->gLPS() > 0) {
            $dzierzawaStandard = $this->g('koszty_bazowe|koszty_dzierzawa|' . $this->gL(), 'game') * $this->gLPS();
        }

        if ($this->gLPL() > 0) {
            $kosztyLux = $this->g('koszty_bazowe|koszty_stale_lux|' . $this->gL(), 'game');
            $dzierzawaLux = $this->g('koszty_bazowe|koszty_dzierzawa|' . $this->gL(), 'game') * $this->getWspLux() * $this->gLPL();
        }

        $dzierzawa = $dzierzawaStandard + $dzierzawaLux;
        $koszty = $kosztyStandard + $kosztyLux + $dzierzawa;

        if ($addRaportEntries) {
            $this->addRaportFinansowyEntry('koszty|bezposrednie|stale', ($kosztyStandard + $kosztyLux));
            $this->addRaportFinansowyEntry('koszty|bezposrednie|dzierzawa', $dzierzawa);
            $this->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|stale', $koszty, true);

            $this->setKosztMarza('koszty_stale_standard', $kosztyStandard, 'standard');
            $this->setKosztMarza('koszty_stale_lux', $kosztyLux, 'lux');
        }

        $this->sTT('koszty|standard|stale|dierzawa', $dzierzawaStandard);
        $this->sTT('koszty|lux|stale|dierzawa', $dzierzawaLux);
        $this->sTT('koszty|standard|stale|bazowe', $kosztyStandard);
        $this->sTT('koszty|lux|stale|bazowe', $kosztyLux);

        $this->logK('F(' . __FUNCTION__ . '):  Koszty stałe : ', $koszty);
        return $koszty;
    }

    /**
     * Zwraca koszty dla pokoi standard oblozonych i nieoblozonych
     * @return float 
     */
    public function kosztyPokojeStandard($addRaportEntries = false) {
        $tablicaKosztyNieoblozone = $this->g('koszty_bazowe|pokoje_nieoblozone', 'game');
        $tablicaKosztyOblozone = $this->g('koszty_bazowe|pokoje_oblozone', 'game');
        $kosztNieoblozone = array();
        $kosztOblozone = array();

        // Wylaczenie czesci kosztow
        if ($this->gPO() > 0 || $this->g('sprzatanie_outsourcing_standard_kwota', 'decision') > 0) {
            unset($tablicaKosztyNieoblozone['sprzatanie']);
            unset($tablicaKosztyOblozone['sprzatanie']);
        }
        if ($this->gPO() > 0) {
            unset($tablicaKosztyNieoblozone['pracownicy_obslugi']);
            unset($tablicaKosztyOblozone['pracownicy_obslugi']);
        }

        if ($this->gPA() > 0) {
            unset($tablicaKosztyNieoblozone['pracownicy_administracji']);
            unset($tablicaKosztyOblozone['pracownicy_administracji']);
        }

        if ($this->g('pranie_outsourcing_standard_kwota', 'decision') > 0 || $this->wspEventPralniaEkologiczna() == 1) {
            unset($tablicaKosztyNieoblozone['pranie']);
            unset($tablicaKosztyOblozone['pranie']);
        }

        if ($this->hasEventPodwyzkaCenWody()) {
            $tablicaKosztyNieoblozone['woda'][$this->gL()] *= $this->g('eventy|podwyzka_cen_wody', 'game');
            $tablicaKosztyOblozone['woda'][$this->gL()] *= $this->g('eventy|podwyzka_cen_wody', 'game');
        }

        // Pokoje nieoblozone - liczymy dla wszystkich pokoi
        foreach ($tablicaKosztyNieoblozone as $nazwa => $pozycjaKosztowa) {
            $kosztNieoblozone[$nazwa] = $pozycjaKosztowa[$this->gL()] * $this->gLPS();
            $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje standard nieoblozone [' . $nazwa . '] : ', $kosztNieoblozone[$nazwa]);
            $this->sTT('koszty|standard|nieoblozone|' . $nazwa, $kosztNieoblozone[$nazwa]);
        }

        // Pokoje oblozone
        foreach ($tablicaKosztyOblozone as $nazwa => $pozycjaKosztowa) {
            $kosztOblozone[$nazwa] = $pozycjaKosztowa[$this->gL()] * $this->g('pokoje_oblozone_standard', 'round');
            $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje standard oblozone [' . $nazwa . '] : ', $kosztOblozone[$nazwa]);
            $this->sTT('koszty|standard|oblozone|' . $nazwa, $kosztOblozone[$nazwa]);
        }

        $koszt = array_sum($kosztNieoblozone) + array_sum($kosztOblozone);

        if ($addRaportEntries) {
            if (isset($kosztOblozone['pranie'])) {
                $this->addRaportFinansowyEntry('koszty|bezposrednie|obsluga_pokoi|pranie_standard', ($kosztNieoblozone['pranie'] + $kosztOblozone['pranie']));
            }
            if (isset($kosztOblozone['sprzatanie'])) {
                $this->addRaportFinansowyEntry('koszty|bezposrednie|obsluga_pokoi|sprzatanie_standard', ($kosztNieoblozone['sprzatanie'] + $kosztOblozone['sprzatanie']));
            }

            $this->addRaportFinansowyEntry('koszty|bezposrednie|media|woda', ($kosztNieoblozone['woda'] + $kosztOblozone['woda']));
            $this->addRaportFinansowyEntry('koszty|bezposrednie|media|prad', ($kosztNieoblozone['prad'] + $kosztOblozone['prad']));

            $this->addRaportFinansowyEntry('koszty|bezposrednie|inne_i_podatki', ($kosztNieoblozone['inne_i_podatki'] + $kosztOblozone['inne_i_podatki']));

            if (isset($kosztOblozone['pracownicy_obslugi'])) {
                $this->addRaportFinansowyEntry('koszty|bezposrednie|pracownicy_obslugi', ($kosztNieoblozone['pracownicy_obslugi'] + $kosztOblozone['pracownicy_obslugi']));
            }

            if (isset($kosztOblozone['pracownicy_administracji'])) {
                $this->addRaportFinansowyEntry('koszty|bezposrednie|pracownicy_administracji', ($kosztNieoblozone['pracownicy_administracji'] + $kosztOblozone['pracownicy_administracji']));
            }

            $this->setKosztMarza('koszty_pokoje_standard', $koszt, 'standard');
            $this->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|zmienne', $koszt, true);
        }

        $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje standard oblozone: ', array_sum($kosztOblozone));
        $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje standard nieoblozone: ', array_sum($kosztNieoblozone));
        $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje standard suma: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszty dla pokoi lux oblozonych i nieoblozonych
     * @return float 
     */
    protected function kosztyPokojeLux($addRaportEntries = false) {
        $tablicaKosztyNieoblozone = $this->g('koszty_bazowe|pokoje_nieoblozone', 'game');
        $tablicaKosztyOblozone = $this->g('koszty_bazowe|pokoje_oblozone', 'game');
        $kosztNieoblozone = array();
        $kosztOblozone = array();

        // Wylaczenie czesci kosztow
        if ($this->gPO() > 0 || $this->g('sprzatanie_outsourcing_lux_kwota', 'decision') > 0) {
            unset($tablicaKosztyNieoblozone['sprzatanie']);
            unset($tablicaKosztyOblozone['sprzatanie']);
        }

        if ($this->gPO() > 0) {
            unset($tablicaKosztyNieoblozone['pracownicy_obslugi']);
            unset($tablicaKosztyOblozone['pracownicy_obslugi']);
        }

        if ($this->gPA() > 0) {
            unset($tablicaKosztyNieoblozone['pracownicy_administracji']);
            unset($tablicaKosztyOblozone['pracownicy_administracji']);
        }

        if ($this->g('pranie_outsourcing_lux_kwota', 'decision') > 0 || $this->wspEventPralniaEkologiczna() == 1) {
            unset($tablicaKosztyNieoblozone['pranie']);
            unset($tablicaKosztyOblozone['pranie']);
        }

        if ($this->hasEventPodwyzkaCenWody()) {
            $tablicaKosztyNieoblozone['woda'][$this->gL()] *= $this->g('eventy|podwyzka_cen_wody', 'game');
            $tablicaKosztyOblozone['woda'][$this->gL()] *= $this->g('eventy|podwyzka_cen_wody', 'game');
        }

        // Pokoje nieoblozone - liczymy dla wszystkich pokoi
        foreach ($tablicaKosztyNieoblozone as $nazwa => $pozycjaKosztowa) {
            $kosztNieoblozone[$nazwa] = $pozycjaKosztowa[$this->gL()] * $this->gLPL();
            $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje lux nieoblozone [' . $nazwa . '] : ', $kosztNieoblozone[$nazwa]);
            $this->sTT('koszty|lux|nieoblozone|' . $nazwa, $kosztNieoblozone[$nazwa]);
        }

        // Pokoje oblozone
        foreach ($tablicaKosztyOblozone as $nazwa => $pozycjaKosztowa) {
            $kosztOblozone[$nazwa] = $pozycjaKosztowa[$this->gL()] * $this->gLPL() * $this->getWspLux();
            $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje lux oblozone [' . $nazwa . '] : ', $kosztOblozone[$nazwa]);
            $this->sTT('koszty|lux|oblozone|' . $nazwa, $kosztOblozone[$nazwa]);
        }

        $koszt = array_sum($kosztNieoblozone) + array_sum($kosztOblozone);

        if ($addRaportEntries) {
            if (isset($kosztOblozone['pranie'])) {
                $this->addRaportFinansowyEntry('koszty|bezposrednie|obsluga_pokoi|pranie_lux', ($kosztNieoblozone['pranie'] + $kosztOblozone['pranie']));
            }
            if (isset($kosztOblozone['sprzatanie'])) {
                $this->addRaportFinansowyEntry('koszty|bezposrednie|obsluga_pokoi|sprzatanie_lux', ($kosztNieoblozone['sprzatanie'] + $kosztOblozone['sprzatanie']));
            }

            $this->addRaportFinansowyEntry('koszty|bezposrednie|media|woda', ($kosztNieoblozone['woda'] + $kosztOblozone['woda']));
            $this->addRaportFinansowyEntry('koszty|bezposrednie|media|prad', ($kosztNieoblozone['prad'] + $kosztOblozone['prad']));

            $this->addRaportFinansowyEntry('koszty|bezposrednie|inne_i_podatki', ($kosztNieoblozone['inne_i_podatki'] + $kosztOblozone['inne_i_podatki']));

            if (isset($kosztOblozone['pracownicy_obslugi'])) {
                $this->addRaportFinansowyEntry('koszty|bezposrednie|pracownicy_obslugi', ($kosztNieoblozone['pracownicy_obslugi'] + $kosztOblozone['pracownicy_obslugi']));
            }

            if (isset($kosztOblozone['pracownicy_administracji'])) {
                $this->addRaportFinansowyEntry('koszty|bezposrednie|pracownicy_administracji', ($kosztNieoblozone['pracownicy_administracji'] + $kosztOblozone['pracownicy_administracji']));
            }

            $this->setKosztMarza('koszty_pokoje_lux', $koszt, 'lux');
            $this->setRaportEntryToParse('kpir', 'wyplywy|operacyjne|zmienne', $koszt, true);
        }

        $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje lux oblozone: ', array_sum($kosztOblozone));
        $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje lux nieoblozone: ', array_sum($kosztNieoblozone));
        $this->logK('F(' . __FUNCTION__ . '):  Koszty pokoje lux suma: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt sprzatania outsourcing standard
     * @return float
     */
    protected function kosztSprzatanieOutsourcingStandard() {
        $koszt = self::COSTS_NULL;

        if ($this->gPO() == 0) {
            // Jesli nie ma pracownikow obslugi
            $koszt = $this->g('sprzatanie_outsourcing_standard_kwota', 'decision');
        }

        $this->logK('F(' . __FUNCTION__ . '):  Koszt sprzatania outsourcing standard: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt sprzatania outsourcing lux
     * @return float
     */
    protected function kosztSprzatanieOutsourcingLux() {
        $koszt = self::COSTS_NULL;

        if ($this->gPO() == 0) {
            // Jesli nie ma pracownikow obslugi
            $koszt += $this->g('sprzatanie_outsourcing_lux_kwota', 'decision');
        }

        $this->logK('F(' . __FUNCTION__ . '):  Koszt sprzatania outsourcing lux: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt prania outsourcing standard
     * @return float
     */
    protected function kosztPranieOutsourcingStandard() {
        $koszt = self::COSTS_NULL;
        if ($this->wspEventPralniaEkologiczna() != 1) {
            $koszt = $this->g('pranie_outsourcing_standard_kwota', 'decision');
        }
        $this->logK('F(' . __FUNCTION__ . '):  Koszt prania outsourcing standard: ', $koszt);
        return $koszt;
    }

    /**
     * Zwraca koszt prania outsourcing lux
     * @return float
     */
    protected function kosztPranieOutsourcingLux() {
        $koszt = self::COSTS_NULL;
        if ($this->wspEventPralniaEkologiczna() != 1) {
            $koszt += $this->g('pranie_outsourcing_lux_kwota', 'decision');
        }
        $this->logK('F(' . __FUNCTION__ . '):  Koszt prania outsourcing lux: ', $koszt);
        return $koszt;
    }

    /**
     * Oblicza nowy stan gry przed przejściem do następnej rundy.
     */
    protected function calculate() {
        $this->obliczWspolczynnikiSegmentacji();

        $this->popytPokojeStandard();
        $this->popytPokojeLux();

        $this->obliczPokojeOblozoneStandard();
        $this->obliczPokojeOblozoneLux();

        $this->sB($this->saldo());

        $this->obliczKredytInwestycyjny();
        $this->obliczKredytKarny();
    }

    /**
     * Oblicza ilosc oblozonych pokoi standard.
     * Wynik ustawia w:
     * 'round' w 'pokoje_oblozone_standard'
     * 'round' w 'pokoje_nieoblozone_standard'
     * 'round' w 'pokoje_oblozone_standard_procent'
     * 'round' w 'pokoje_nieoblozone_standard_procent'
     */
    protected function obliczPokojeOblozoneStandard() {
        $iloscPokoi = $this->gLPS();
        $pokojeNieoblozone = $iloscPokoi - ($this->g('popyt_standard', 'round') / sfConfig::get('game_hotel_dni_w_kwartale', 90));
        $pokojeOblozone = $iloscPokoi - $pokojeNieoblozone;
        $this->s('pokoje_oblozone_standard', $pokojeOblozone, 'round');
        $this->s('pokoje_nieoblozone_standard', $pokojeNieoblozone, 'round');

        $this->s('pokoje_oblozone_standard_procent', 0, 'round');
        $this->s('pokoje_nieoblozone_standard_procent', 0, 'round');
        if ($iloscPokoi > 0) {
            $this->s('pokoje_oblozone_standard_procent', ($pokojeOblozone / $iloscPokoi) * 100, 'round');
            $this->s('pokoje_nieoblozone_standard_procent', ($pokojeNieoblozone / $iloscPokoi) * 100, 'round');
        }

        $this->logI('F(' . __FUNCTION__ . '): Pokoje standard oblozone: ', $pokojeOblozone);
        $this->logI('F(' . __FUNCTION__ . '): Pokoje standard nieoblozone', $pokojeNieoblozone);
    }

    /**
     * Oblicza ilosc oblozonych pokoi lux.
     * Wynik ustawia w:
     * 'round' w 'pokoje_oblozone_lux'
     * 'round' w 'pokoje_nieoblozone_lux'
     * 'round' w 'pokoje_oblozone_lux_procent'
     * 'round' w 'pokoje_nieoblozone_lux_procent'
     */
    protected function obliczPokojeOblozoneLux() {
        $iloscPokoi = $this->gLPL();
        $pokojeNieoblozone = $iloscPokoi - ($this->g('popyt_lux', 'round') / sfConfig::get('game_hotel_dni_w_kwartale', 90));
        $pokojeOblozone = $iloscPokoi - $pokojeNieoblozone;
        $this->s('pokoje_oblozone_lux', $pokojeOblozone, 'round');
        $this->s('pokoje_nieoblozone_lux', $pokojeNieoblozone, 'round');

        $this->s('pokoje_oblozone_lux_procent', 0, 'round');
        $this->s('pokoje_nieoblozone_lux_procent', 0, 'round');
        if ($iloscPokoi > 0) {
            $this->s('pokoje_oblozone_lux_procent', ($pokojeOblozone / $iloscPokoi) * 100, 'round');
            $this->s('pokoje_nieoblozone_lux_procent', ($pokojeNieoblozone / $iloscPokoi) * 100, 'round');
        }

        $this->logI('F(' . __FUNCTION__ . '): Pokoje lux oblozone: ', $pokojeOblozone);
        $this->logI('F(' . __FUNCTION__ . '): Pokoje lux nieoblozone', $pokojeNieoblozone);
    }

    /**
     * Zwraca kwotę dofinansowania w kolejnych rundach. 
     * 
     * @return type
     */
    public function dofinansowanie() {
        if (sfConfig::get('game_hotel_dofinansowanie', true)) {
            switch ($this->getGameData()->getRoundNumber()) {
                case self::FIRST_ROUND:
                    return $this->g('dofinansowania|dofinansowanie_1', 'game');
                    break;
                case self::FIRST_ROUND + 1:
                    return $this->g('dofinansowania|dofinansowanie_2', 'game');
                    break;
                case self::FIRST_ROUND + 2:
                    return $this->g('dofinansowania|dofinansowanie_3', 'game');
                    break;
                case self::FIRST_ROUND + 3:
                    return $this->g('dofinansowania|dofinansowanie_4', 'game');
                    break;
                default:
                    return 0;
                    break;
            }
        } else {
            return 0;
        }
    }

    /**
     * Zwraca koszt budowy podanej ilosci pokoi razem z wyposazeniem ich do aktualnego poziomu wyposazenia
     * @param int $ilosc
     * @return float
     */
    public function getKosztPokoiStandard($ilosc) {
        $kosztWyposazenia = $this->getKosztWyposazeniaPokoiStandard($ilosc);
        $kosztBudowy = $this->getKosztBudowyPokoiStandard($ilosc);

        return $kosztBudowy + $kosztWyposazenia;
    }

    /**
     * Zwraca koszt budowy podanej ilosci pokoi standard
     * @param int $ilosc
     * @return float
     */
    public function getKosztBudowyPokoiStandard($ilosc) {
        return $this->g('koszt_inwestycji_standard|' . $this->gL(), 'game') * $this->g('inwestycja_z_efektem_skali|a', 'game') * pow($ilosc, $this->g('inwestycja_z_efektem_skali|t', 'game'));
    }

    /**
     * Zwraca koszt wyposazenia podanej ilosci pokoi standard do poziomu podanego wyposazenia (kumulacyjnie).
     * Jesli nie podamy poziomu wyposazenia, zostanie uzyty aktualny poziom wyposazenia pokoi
     * @param int $ilosc Ilosc pokoi do wyposazenia
     * @param int $poziom Poziom wyposazenia
     * @return float 
     */
    public function getKosztWyposazeniaPokoiStandard($ilosc, $poziom = null) {
        if (is_null($poziom)) {
            $poziom = $this->gWS();
        }

        switch ($poziom) {
            case 0:
                return $ilosc * $this->g('wyposazenie|koszt_wyposazenie_0', 'game');
                break;
            case 1:
                return $ilosc * $this->g('wyposazenie|koszt_wyposazenie_1', 'game');
                break;
            case 2:
                return $ilosc * $this->g('wyposazenie|koszt_wyposazenie_2', 'game');
                break;
        }
    }

    /**
     * Zwraca zysk ze sprzedazy podanej ilosci pokoi standard razem z wyposazeniem
     * @param int $ilosc
     * @return float 
     */
    public function getZyskSprzedazyPokoiStandard($ilosc) {
        return $this->g('wspolczynnik|likwidacji_pokoju', 'game') * $this->getKosztBudowyPokoiStandard($ilosc) + $this->g('wspolczynnik|likwidacji_wyposazenia', 'game') * $this->getKosztWyposazeniaPokoiStandard($ilosc);
    }

    /**
     * Zwraca koszt budowy podanej ilosci pokoi lux razem z wyposazeniem ich do aktualnego poziomu wyposazenia
     * @param int $ilosc
     * @return float
     */
    public function getKosztPokoiLux($ilosc) {
        $kosztWyposazenia = $this->getKosztWyposazeniaPokoiLux($ilosc);
        $kosztBudowy = $this->getKosztBudowyPokoiLux($ilosc);

        return $kosztBudowy + $kosztWyposazenia;
    }

    /**
     * Zwraca koszt budowy podanej ilosci pokoi lux
     * @param int $ilosc
     * @return float
     */
    public function getKosztBudowyPokoiLux($ilosc) {
        return $this->g('koszt_inwestycji_lux|' . $this->gL(), 'game') * $this->g('inwestycja_z_efektem_skali|a', 'game') * pow($ilosc, $this->g('inwestycja_z_efektem_skali|t', 'game'));
    }

    /**
     * Zwraca koszt wyposazenia podanej ilosci pokoi lux do poziomu podanego wyposazenia (kumulacyjnie).
     * Jesli nie podamy poziomu wyposazenia, zostanie uzyty aktualny poziom wyposazenia pokoi
     * @param int $ilosc Ilosc pokoi do wyposazenia
     * @param int $poziom Poziom wyposazenia
     * @return float 
     */
    public function getKosztWyposazeniaPokoiLux($ilosc, $poziom = null) {
        if (is_null($poziom)) {
            $poziom = $this->gWL();
        }

        return $this->g('wspolczynnik|wyposazenia_lux', 'game') * $this->getKosztWyposazeniaPokoiStandard($ilosc, $poziom);
    }

    /**
     * Zwraca zysk ze sprzedazy podanej ilosci pokoi lux razem z wyposazeniem
     * @param int $ilosc
     * @return float 
     */
    public function getZyskSprzedazyPokoiLux($ilosc) {
        return $this->g('wspolczynnik|likwidacji_pokoju', 'game') * $this->getKosztBudowyPokoiLux($ilosc) + $this->g('wspolczynnik|likwidacji_wyposazenia', 'game') * $this->getKosztWyposazeniaPokoiLux($ilosc);
    }

    /**
     * Zwraca koszt eventu sadzenia drzew na podstawie podanego stopnia zaangazowania (0 - 3)
     * @param int $value Stopien zaangazowania
     * @return float
     */
    public function getKosztSadzenieDrzew($value) {
        $koszt = $this->g('eventy|sadzenie_drzew', 'game');
        $koszt *= ($value / 3);
        return $koszt;
    }

    /**
     * Zwraca koszt eventu kierownczki na podstawie podanej wersji (0-2)
     * @param int $value Wersja
     * @return float
     */
    public function getKosztKierowniczka($value) {
        $koszt = self::COSTS_NULL;
        if ($value > 0) {
            $koszt = $this->g('eventy|kierowniczka|wersja_' . $value . '|koszt', 'game');
        }
        return $koszt;
    }

    /**
     * Zwraca nazwy segmentow w tablicy
     * @return array
     */
    public function getSegmentacjaNazwy() {
        return array(
            0 => 'oszczedni',
            1 => 'globtroterzy',
            2 => 'rodziny',
            3 => 'biznesmeni'
        );
    }

    /**
     * Oblicza wspolczynniki segmentacji oraz zadowolenia segmentow z reklamy
     * Ustawia je w 'round'. Wykorzystane nazwy zmiennych na dole funkcji 
     */
    public function obliczWspolczynnikiSegmentacji() {
        // Kolejno: Oszczedni, Globtroterzy, Rodziny, Biznesmeni
        $wsp = array(0, 0, 0, 0);
        $wspReklama = array(0, 0, 0, 0);
        $wspZadowolenie = array(0, 0, 0, 0);
        $nazwy = $this->getSegmentacjaNazwy();
        if ($this->gRN() >= (self::FIRST_ROUND + 13)) {
            $UM = $this->g('wspolpraca_urzad_pracy', 'decision', 0);
            $BP = $this->g('wspolpraca_biurami_podrozy', 'decision', 0);
            $indeksZadowolenie = 3;
            if ($UM && $BP) {
                $indeksZadowolenie = 1;
            } elseif ($UM) {
                $indeksZadowolenie = 0;
            } elseif ($BP) {
                $indeksZadowolenie = 2;
            }

            foreach ($nazwy as $indeks => $nazwa) {
                // Wspolczynnik zadowolenia
                $zadowolenie = $this->g('segmentacja|' . $nazwa . '|zadowolenie|' . $indeksZadowolenie, 'game');

                // Wspolczynnik uslug
                if ($nazwa == 'oszczedni') {
                    $wartoscUslugi = $this->g('segmentacja|' . $nazwa . '|uslugi|wartosc', 'game');
                } else {
                    $wartoscUslugi = 0;
                    $uslugi = $this->g('segmentacja|' . $nazwa . '|uslugi', 'game');
                    $sumaWartosciUslug = 0;

                    foreach ($uslugi as $usluga => $wartosc) {
                        if ($this->g($usluga, 'decision', false)) {
                            $wartoscUslugi += $wartosc;
                        }
                        $sumaWartosciUslug += $wartosc;
                    }

                    $wartoscUslugi = $wartoscUslugi / $sumaWartosciUslug;
                }

                // Wspolczynnik reklamy
                $reklamy = $this->g('segmentacja|' . $nazwa . '|reklama', 'game');
                $wartoscReklamy = 0;
                $sumaWartosciReklam = 0;

                foreach ($reklamy as $reklama => $wartosc) {
                    if ($this->g($reklama, 'decision', false)) {
                        $wartoscReklamy += $wartosc;
                    }
                    $sumaWartosciReklam += $wartosc;
                }

                $wartoscReklamy = $wartoscReklamy / $sumaWartosciReklam;

                // Koncowe wartosci
                $wsp[$indeks] = $zadowolenie * (($wartoscReklamy + $wartoscUslugi) / 2);
                $wspReklama[$indeks] = $wartoscReklamy;
                $wspZadowolenie[$indeks] = $zadowolenie;
            }
        }

        // Ustawianie wyliczonych zmiennych
        foreach ($nazwy as $indeks => $nazwa) {
            $this->s('segmentacja_' . $nazwa, $wsp[$indeks], 'round');

            $this->sTT('segmentacja|' . $nazwa, $wsp[$indeks]);
            $this->s('segmentacja_reklama_' . $nazwa, $wspReklama[$indeks], 'round');
            $this->s('segmentacja_zadowolenie_' . $nazwa, $wspZadowolenie[$indeks], 'round');
        }
    }

    /**
     * Zwraca wspolczynnik A dla segmentacji brany pod uwage w obliczniu popytu standard
     * @return float
     */
    protected function getSegmentacjaStandard() {
        $segmentacjaPopyt = $this->g('segmentacja|popyt_standard', 'game');

        $a = 0;
        $b = 0;
        $c = 0;
        $sumaA = 0;
        foreach ($segmentacjaPopyt as $popyt) {
            $sumaA += $popyt['a'][$this->gL()];
        }
        // Dodanie wplywu segmentacji
        foreach ($this->getSegmentacjaNazwy() as $nazwa) {
            $a += $this->g('segmentacja_' . $nazwa, 'round') * $segmentacjaPopyt['segmentacja_' . $nazwa]['a'][$this->gL()];
            $b += $this->g('segmentacja_' . $nazwa, 'round') * $segmentacjaPopyt['segmentacja_' . $nazwa]['b'][$this->gL()];
            $c += $this->g('segmentacja_' . $nazwa, 'round') * $segmentacjaPopyt['segmentacja_' . $nazwa]['c'][$this->gL()];
        }

        $a = $a / $sumaA;
        // b sie nie zmienia
        $c = $c / 10;

        $this->logW('F(' . __FUNCTION__ . '): Segmentacja standard współczynniki [a,b,c] - [' . $a . ',' . $b . ',' . $c . ']:', 'N/A');
        $wplyw = array(
            'a' => $a,
            'b' => $b,
            'c' => $c,
        );
        return $wplyw;
    }

    /**
     * Zwraca wspolczynnik A dla segmentacji brany pod uwage w obliczniu popytu lux
     * @return float
     */
    protected function getSegmentacjaLux() {
        $segmentacjaPopyt = $this->g('segmentacja|popyt_lux', 'game');

        $a = 0;
        $b = 0;
        $c = 0;
        $sumaA = 0;
        foreach ($segmentacjaPopyt as $popyt) {
            $sumaA += $popyt['a'][$this->gL()];
        }
        // Dodanie wplywu segmentacji
        foreach ($this->getSegmentacjaNazwy() as $nazwa) {
            $a += $this->g('segmentacja_' . $nazwa, 'round') * $segmentacjaPopyt['segmentacja_' . $nazwa]['a'][$this->gL()];
            $b += $this->g('segmentacja_' . $nazwa, 'round') * $segmentacjaPopyt['segmentacja_' . $nazwa]['b'][$this->gL()];
            $c += $this->g('segmentacja_' . $nazwa, 'round') * $segmentacjaPopyt['segmentacja_' . $nazwa]['c'][$this->gL()];
        }

        $a = $a / $sumaA;
        // b sie nie zmienia
        $c = $c / 10;

        $this->logW('F(' . __FUNCTION__ . '): Segmentacja lux współczynniki [a,b,c] - [' . $a . ',' . $b . ',' . $c . ']:', 'N/A');
        $wplyw = array(
            'a' => $a,
            'b' => $b,
            'c' => $c,
        );
        return $wplyw;
    }

    /**
     * Zwraca współczynnik sezonowości.
     * (uwzgledniany od rundy 5, wczesniej = 1)
     * 
     * @return float
     */
    public function wspSezonowosc() {
        $wsp = 1;

        if ($this->rGT(4)) {
            $wsp = $this->g('sezonowosc|wspolczynnik|q' . $this->getKwartal(), 'game');
        }

        $this->logW('F(' . __FUNCTION__ . '): Współczynnik sezonowość :', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik uslugi plaza
     * @return float
     */
    public function wspUslugaPlaza() {

        $wsp = self::WSP_NULL;

        if ($this->isUslugaEventActive('usluga_plaza') && $this->isUslugaEventAccepted('usluga_plaza')) {
            $wsp = 1;
        }

        $this->logW('F(' . __FUNCTION__ . '): Współczynnik uslugi plaza: ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik usluga_wyciag_narciarski
     * @return float
     */
    public function wspUslugaWyciagNarciarski() {

        $wsp = self::WSP_NULL;

        if ($this->isUslugaEventActive('usluga_wyciag_narciarski') && $this->isUslugaEventAccepted('usluga_wyciag_narciarski')) {
            $wsp = 1;
        }

        $this->logW('F(' . __FUNCTION__ . '): Współczynnik uslugi wyciag narciarski : ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik uslugi golfa
     * @return float
     */
    public function wspUslugaGolf() {

        $wsp = self::WSP_NULL;

        if ($this->isUslugaEventActive('usluga_golf') && $this->isUslugaEventAccepted('usluga_golf')) {
            $wsp = 1;
        }

        $this->logW('F(' . __FUNCTION__ . '): Współczynnik uslugi golf: ', $wsp);
        return $wsp;
    }

    /**
     * Oblicza współczynnik listków (wybranych eventów), | Brany pod uwagę przy ocenie końcowej. 
     * 
     * @return float
     */
    public function wspListkow() {
        $wsp = self::WSP_NULL;

        if ($this->rGT(5)) {

            $sumaListkow = $this->wspEventPanele() +
                    $this->g('event_pralnia_ekologiczna', 'decision') +
                    $this->g('event_sadzenie_drzew', 'decision') +
                    $this->g('event_akcja_charytatywna', 'decision') +
                    $this->g('event_podjazd_dla_niepelnosprawnych', 'decision') +
                    $this->g('event_stop_umowom_smieciowym', 'decision') +
                    $this->g('event_zimowisko', 'decision') +
                    $this->g('plaza', 'decision') +
                    $this->g('wyciag_narciarski', 'decision');

            $wsp = (min(6, $sumaListkow)) / 6;
        }

        $this->sTT('wspolczynniki|listki', $wsp);
        $this->logW('F(' . __FUNCTION__ . '): Współczynnik listków: ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik zadowolenia pracownikow.
     * 
     * @return float Wspolczynnik zadowolenia pracownikow
     */
    public function wspZadowoleniaPracownikow() {
        $wsp = self::WSP_NULL;
        $sumaPracownikow = $this->gPA() + $this->gPO();

        if ($this->rGT(8) && $sumaPracownikow > 0) {
            $wartosciWspolczynnikow = array(
                $this->wspPracownicyLiczba(),
                $this->wspPracownicyWynagrodzenie(),
                $this->wspPracownicyZlecenie(),
                $this->wspEventStopUmowomSmieciowym(),
                $this->wspEventSzkolenie(),
                $this->wspMotywacjaProcent(),
                $this->wspEventKierowniczka(),
            );
            $wagi = $this->g('zadowolenie_pracownikow|wagi_wspolczynnikow', 'game');
            $macierz = $this->g('zadowolenie_pracownikow|macierz_wspolczynnikow|runda_' . $this->gRN(), 'game');

            $this->sTT('wspolczynniki_macierzowe|zadowolenie_pracownikow|wagi', $this->aTS($wagi));
            $this->sTT('wspolczynniki_macierzowe|zadowolenie_pracownikow|macierz', $this->aTS($macierz));
            $this->sTT('wspolczynniki_macierzowe|zadowolenie_pracownikow|wspolczynniki', $this->aTS($wartosciWspolczynnikow));

            $sumaWag = 0;
            foreach ($wartosciWspolczynnikow as $index => $value) {
                $wsp += $wagi[$index] * $macierz[$index] * $value;
                $sumaWag += $wagi[$index] * $macierz[$index];
            }
            $wsp = $wsp / $sumaWag;
        }

        $this->sTT('wspolczynniki_macierzowe|zadowolenie_pracownikow|wartosc', $wsp);

        $this->s('wspolczynnik_zadowolenia_pracownikow', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '): Współczynnik zadowolenia pracownikow: ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik wspolpracy lokalnej.
     * 
     * @return float wsp wspolpracy lokalnej
     */
    public function wspWspolpracyLokalnej() {
        $wsp = self::WSP_NULL;
        if ($this->rGT(8)) {
            $wartosciWspolczynnikow = array(
                $this->wspZadowoleniaPracownikow(),
                $this->wspEventAkcjaCharytatywna(),
                $this->g('golf', 'decision', 0),
                $this->g('wyciag_narciarski', 'decision', 0),
                $this->g('plaza', 'decision', 0),
                $this->wspEventZimowisko(),
            );
            $wagi = $this->g('wspolpraca_lokalna|wagi_wspolczynnikow', 'game');
            $macierz = $this->g('wspolpraca_lokalna|macierz_wspolczynnikow|runda_' . $this->gRN(), 'game');

            $this->sTT('wspolczynniki_macierzowe|wspolpraca_lokalna|wagi', $this->aTS($wagi));
            $this->sTT('wspolczynniki_macierzowe|wspolpraca_lokalna|macierz', $this->aTS($macierz));
            $this->sTT('wspolczynniki_macierzowe|wspolpraca_lokalna|wspolczynniki', $this->aTS($wartosciWspolczynnikow));

            $sumaWag = 0;
            foreach ($wartosciWspolczynnikow as $index => $value) {
                $wsp += $wagi[$index] * $macierz[$index] * $value;
                $sumaWag += $wagi[$index] * $macierz[$index];
            }
            $wsp = $wsp / $sumaWag;
        }

        $this->sTT('wspolczynniki_macierzowe|wspolpraca_lokalna|wartosc', $wsp);

        $this->s('wspolczynnik_wspolpracy_lokalnej', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '): Współczynnik wspolpracy lokalnej: ', $wsp);
        return $wsp;
    }

    /**
     * Zwraca wspolczynnik zrownowazonego rozwoju
     * @return float
     */
    public function wspZrownowazonegoRozwoju() {
        $wsp = self::WSP_NULL;
        if ($this->rGT(6)) {
            $wsp = (2 * $this->wspWspolpracyLokalnej() + $this->wspListkow()) / 3;
        }

        $this->sTT('wspolczynniki|zrownowazonego_rozwoju', $wsp);
        $this->s('wspolczynnik_zrownowazonego_rozwoju', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '): Współczynnik zrownowazonego rozwoju: ', $wsp);
        return $wsp;
    }

    /**
     * Wspolczynnik zadowolenia klienta standard
     * @return float
     */
    public function wspZadowolenieKlientaStandard() {
        $wsp = self::WSP_NULL;
        if ($this->rGT(3)) {
            $wagi = $this->g('zadowolenie_klienta|wagi_wspolczynnikow', 'game');
            $macierz = $this->g('zadowolenie_klienta|macierz_wspolczynnikow|runda_' . $this->gRN(), 'game');

            if (($this->gPO() + $this->gPA()) == 0) {
                // Nie mamy pracownikow to wspolczynniki zadowolenia i liczby pracownikow
                // nie powinnny byc brane pod uwage
                $macierz[1] = 0;
                $macierz[2] = 0;
            }
            if ($this->gPO() > 0) {
                // Jesli mamy pracownikow obslugi to nie bierzemy pod uwage 
                // wspolczynnika sprzatania outsourcing
                $macierz[5] = 0;
            }

            $sumaWag = 0;

            $wartosciWspolczynnikow = array(
                $this->wspZrownowazonegoRozwoju(),
                $this->wspZadowoleniaPracownikow(),
                $this->wspPracownicyLiczba(),
                $this->wspWyposazenieStandard(),
                $this->wspUslugi(),
                $this->wspSprzatanieOutsourcingStandard(),
                $this->wspPranieOutsourcingStandard(),
                $this->wspSniadanieStandard(),
                $this->wspZatrudnienieDecyzja(),
            );

            $this->sTT('wspolczynniki_macierzowe|zadowolenie_klienta_standard|wagi', $this->aTS($wagi));
            $this->sTT('wspolczynniki_macierzowe|zadowolenie_klienta_standard|macierz', $this->aTS($macierz));
            $this->sTT('wspolczynniki_macierzowe|zadowolenie_klienta_standard|wspolczynniki', $this->aTS($wartosciWspolczynnikow));

            foreach ($wartosciWspolczynnikow as $index => $value) {
                $wsp += $wagi[$index] * $macierz[$index] * $value;
                $sumaWag += $wagi[$index] * $macierz[$index];
            }

            $wsp = $wsp / $sumaWag;

            if ($this->hasEfektPamieci()) {
                $wspLR = $this->g('wspolczynnik_zadowolenie_klienta_standard', 'last_round');
                $wsp = (2 * $wsp + $wspLR) / 3;
            }
        }

        $this->sTT('wspolczynniki_macierzowe|zadowolenie_klienta_standard|wartosc', $wsp);

        $this->s('wspolczynnik_zadowolenie_klienta_standard', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '):  Wspolczynnik zadowolenia klienta standard : ', $wsp);

        return $wsp;
    }

    /**
     * Wspolczynnik zadowolenia klienta lux
     * @return int
     */
    public function wspZadowolenieKlientaLux() {
        $wsp = self::WSP_NULL;
        // Poprawki wersja 1.1 arbitralnie w R5 ustawiamy 1
        if ($this->gRN() == (self::FIRST_ROUND + 4)) {
            $wsp = 1;
        }

        if ($this->gRN() >= (self::FIRST_ROUND + 5)) {
            $wagi = $this->g('zadowolenie_klienta|wagi_wspolczynnikow', 'game');
            $macierz = $this->g('zadowolenie_klienta|macierz_wspolczynnikow|runda_' . $this->gRN(), 'game');

            if (($this->gPO() + $this->gPA()) == 0) {
                // Nie mamy pracownikow to wspolczynniki zadowolenia i liczby pracownikow
                // nie powinnny byc brane pod uwage
                $macierz[1] = 0;
                $macierz[2] = 0;
            }
            if ($this->gPO() > 0) {
                // Jesli mamy pracownikow obslugi to nie bierzemy pod uwage 
                // wspolczynnika sprzatania outsourcing
                $macierz[5] = 0;
            }

            $sumaWag = 0;

            $wartosciWspolczynnikow = array(
                $this->wspZrownowazonegoRozwoju(),
                $this->wspZadowoleniaPracownikow(),
                $this->wspPracownicyLiczba(),
                $this->wspWyposazenieLux(),
                $this->wspUslugi(),
                $this->wspSprzatanieOutsourcingLux(),
                $this->wspPranieOutsourcingLux(),
                $this->wspSniadanieLux(),
                $this->wspZatrudnienieDecyzja(),
            );

            $this->sTT('wspolczynniki_macierzowe|zadowolenie_klienta_lux|wagi', $this->aTS($wagi));
            $this->sTT('wspolczynniki_macierzowe|zadowolenie_klienta_lux|macierz', $this->aTS($macierz));
            $this->sTT('wspolczynniki_macierzowe|zadowolenie_klienta_lux|wspolczynniki', $this->aTS($wartosciWspolczynnikow));

            foreach ($wartosciWspolczynnikow as $index => $value) {
                $wsp += $wagi[$index] * $macierz[$index] * $value;
                $sumaWag += $wagi[$index] * $macierz[$index];
            }

            $wsp = $wsp / $sumaWag;

            if ($this->hasEfektPamieci()) {
                $wspLR = $this->g('wspolczynnik_zadowolenie_klienta_lux', 'last_round');
                $wsp = (2 * $wsp + $wspLR) / 3;
            }
        }


        $this->sTT('wspolczynniki_macierzowe|zadowolenie_klienta_lux|wartosc', $wsp);

        $this->s('wspolczynnik_zadowolenie_klienta_lux', $wsp, 'round');
        $this->logW('F(' . __FUNCTION__ . '):  Wspolczynnik zadowolenia klienta lux : ', $wsp);

        return $wsp;
    }

    public function hasEfektPamieci() {
        return $this->g('efekt_pamieci', 'game', false);
    }

    /**
     * Funkcja oblicza miejsce i wartosc rankingu dla druzyn. 
     * Korzysta z dodanych wartosci do 'game'
     * @see postCalculate 
     */
    public static function obliczOceneRankingowa($gc) {

        $gc->getGameData()->setMode(HotelGameData::FORCE_SAVE);

        $ranking = $gc->g('ranking', 'game');
        $runda = $gc->gRN();
        $wartoscRankingu = array();
        foreach ($ranking['runda_' . $runda] as $druzyna => $wartosci) {
            // Dodanie ocen z wspolczynnikow
            $wartoscRankingu[$druzyna] = max(0.1, round($wartosci['wynik_ekonomiczny_firmy'] * $wartosci['wsp_zrownowazonego_rozwoju'] * $wartosci['wsp_satysfakcji'], 2));
        }

        // Posortowane wyliczone rankingi od najwyzszego do najnizszego
        arsort($wartoscRankingu);
        $i = 0;
        $staraWartosc = -1;
        foreach ($wartoscRankingu as $druzyna => $wartosc) {
            if ($staraWartosc != $wartosc) {
                // Pamietamy o miejscach ex aequo
                $i++;
            }
            $ranking['runda_' . $runda][$druzyna]['pozycja'] = $i;
            $ranking['runda_' . $runda][$druzyna]['wartosc_rankingu'] = $wartosc;
            $staraWartosc = $wartosc;
        }


        $gc->s('ranking', $ranking, 'game');
        $gc->getGameData()->save(false);
        // Zapisujemy tylko obiekt gry
        $gc->getGameData()->getGame()->save();
    }

    public function wspWielkoscHoteluStandard() {
        $tablicaH = $this->g('popyt_standard_' . $this->gL() . '|h', 'game');
        $wspH = min(1, (($this->gLPS() + $tablicaH[0]) / ($tablicaH[1] + $tablicaH[2])));

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik wielkosci hotelu standard', $wspH);
        return $wspH;
    }

    public function wspWielkoscHoteluLux() {
        $tablicaH = $this->g('popyt_lux_' . $this->gL() . '|h', 'game');
        $wspH = min(1, (($this->gLPL() + $tablicaH[0]) / ($tablicaH[1] + $tablicaH[2])));

        $this->logW('F(' . __FUNCTION__ . '): Wspolczynnik wielkosci hotelu lux', $wspH);
        return $wspH;
    }

    public function wspAgresywnaKonkurencjaStandard() {
        $wsp = 1;
        if ($this->hasEventAgresywnaKonkurencja() && $this->gLPS() > 0) {
            $media = $this->wspMediaLokalneStandard() + $this->wspMediaRegionalneStandard() + $this->wspMediaKrajoweStandard();

            $wsp = ($media + $this->wspMediaKrajoweStandard() * 6) / ($media + $this->getMediaKrajoweStandardOptymalne() * 7);
            $wsp = max($wsp, $this->g('eventy|konkurencja_agresywna_wsp_min', 'game'));
        }

        $this->logW('F(' . __FUNCTION__ . '):  Współczynnik konkurencji agresywnej standard: ', $wsp);
        return $wsp;
    }

    public function wspAgresywnaKonkurencjaLux() {
        $wsp = 1;
        if ($this->hasEventAgresywnaKonkurencja() && $this->gLPL() > 0) {
            $media = $this->wspMediaLokalneLux() + $this->wspMediaRegionalneLux() + $this->wspMediaKrajoweLux();

            $wsp = ($media + $this->wspMediaKrajoweLux() * 6) / ($media + $this->getMediaKrajoweLuxOptymalne() * 7);
            $wsp = max($wsp, $this->g('eventy|konkurencja_agresywna_wsp_min', 'game'));
        }

        $this->logW('F(' . __FUNCTION__ . '):  Współczynnik konkurencji agresywnej lux: ', $wsp);
        return $wsp;
    }

    public function wspKonkurencjaStandard() {
        $wsp = 1;

        if ($this->hasEventKonkurencja()) {
            $cenaKonkurencji = $this->g('eventy|konkurencja_standard|' . $this->gL(), 'game');
            $cena = $this->g('cena_pokoje_standard', 'decision');
            $wsp = min((($cena + $cenaKonkurencji)) / (2 * $cena), 1);
        }

        return $wsp;
    }

    public function wspKonkurencjaLux() {
        $wsp = 1;

        if ($this->hasEventKonkurencja()) {
            $cenaKonkurencji = $this->g('eventy|konkurencja_lux|' . $this->gL(), 'game');
            $cena = $this->g('cena_pokoje_lux', 'decision');
            $wsp = min((($cena + $cenaKonkurencji)) / (2 * $cena), 1);
        }

        return $wsp;
    }

    public function getEventPaneleMax() {
        return 1 + floor(($this->gLPS() + $this->gLPL()) / 15);
    }

    public function nauczycielDoplata($kwota) {
        $this->cB($kwota);
        $this->addRaportFinansowyEntry('przychody|finansowe|doplata', $kwota);
        $this->setRaportEntryToParse('kpir', 'wplywy|finansowe|doplata', $kwota, true);
    }

    public function nauczycielKara($kwota) {
        $this->cB(-$kwota);
        $this->addRaportFinansowyEntry('koszty|finansowe|kara', $kwota);
        $this->setRaportEntryToParse('kpir', 'wyplywy|finansowe|kara', $kwota, true);
    }

    /**
     * Oblicza i ustawia popyt na pokoje standard.
     * Wynik jest zapisany w 'round' w 'popyt_standard'
     */
    protected function popytPokojeStandard() {
        $cena = $this->gCPS();
        if ($cena == 0) {
            $this->s('popyt_standard', 0, 'round');
            return;
        }

        $iloscPokoi = $this->gLPS();

        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Cena pokoju standard:', $cena);
        $lokalizacja = $this->gL();
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Lokalizacja:', $lokalizacja);

        $podstawaPopyt = $this->g('popyt_standard_' . $lokalizacja, 'game');

        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Podstawa A:', $podstawaPopyt['a']);
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Podstawa B:', $podstawaPopyt['b']);
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Podstawa C:', $podstawaPopyt['c']);
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Podstawa T:', $podstawaPopyt['t']);


        $wspolczynniki = array(
            'rachunek_woda',
            'strona_internetowa',
            'rejestracja_na_stronie_www',
            'plakaty_standard',
            'ulotki_standard',
            'media_lokalne_standard',
            'media_regionalne_standard',
            'media_krajowe_standard',
            'sprzatanie_outsourcing_standard',
            'pranie_outsourcing_standard',
            'pracownicy_administracji_liczba',
            'uslugi',
            'pracownicy_obslugi_wynagrodzenie',
            'pracownicy_obslugi_zlecenie',
            'pracownicy_administracji_wynagrodzenie',
            'pracownicy_administracji_zlecenie',
            'zatrudnienie_decyzja',
            'event_sadzenie_drzew',
            'event_panele',
            'event_zimowisko',
            'event_podjazd_dla_niepelnosprawnych',
            'event_pralnia_ekologiczna',
            'event_akcja_charytatywna',
            'event_stop_umowom_smieciowym',
        );

        $wspolczynnikiLokalizacja = array(
            'sniadanie_standard',
            'wyposazenie_standard',
            'usluga_plaza',
            'usluga_wyciag_narciarski',
            'event_mistrzostwa',
            'event_szkolenie',
            'event_festiwal_filmowy',
            'pracownicy_obslugi_liczba',
            'motywacja_procent',
            'zadowolenie_klienta_standard',
        );

        $popytArray = $this->g('funkcja_popytu_standard', 'game');

        $a = array();
        $b = array();
        $c = array();

        foreach ($wspolczynniki as $wsp) {
            // Nazwa funkcji do pobrania wspolczynnika
            $wspFunction = 'wsp' . sfInflector::camelize($wsp);
            $wspVal = $this->$wspFunction();
            $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Wspolczynnik ' . $wsp . ': ', $wspVal);
            // Dodanie wartosci do tablic sumujacych
            $wspBazowyA = $this->g('funkcja_popytu_standard|' . $wsp . '|a', 'game');
            $wspBazowyB = $this->g('funkcja_popytu_standard|' . $wsp . '|b', 'game');
            $wspBazowyC = $this->g('funkcja_popytu_standard|' . $wsp . '|c', 'game');
            $a[] = $wspVal * $wspBazowyA;
            $b[] = $wspVal * $wspBazowyB;
            $c[] = $wspVal * $wspBazowyC;
            $this->sTT('popyt|standard|wspolczynniki|' . $wsp, $wspVal . ' [a: ' . $wspBazowyA . ', b: ' . $wspBazowyB . ',c: ' . $wspBazowyC . ']');
        }

        // Wspolczynniki ktorych wplyw na funkcje popytu zalezy dodatkowo od lokalizacji
        foreach ($wspolczynnikiLokalizacja as $wsp) {
            // Nazwa funkcji do pobrania wspolczynnika
            $wspFunction = 'wsp' . sfInflector::camelize($wsp);
            $wspVal = $this->$wspFunction();
            $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Wspolczynnik ' . $wsp . ': ', $wspVal);
            // Dodanie wartosci do tablic sumujacych
            $wspBazowyA = $this->g('funkcja_popytu_standard|' . $wsp . '|a|' . $this->gL(), 'game');
            $wspBazowyB = $this->g('funkcja_popytu_standard|' . $wsp . '|b|' . $this->gL(), 'game');
            $wspBazowyC = $this->g('funkcja_popytu_standard|' . $wsp . '|c|' . $this->gL(), 'game');
            $a[] = $wspVal * $wspBazowyA;
            $b[] = $wspVal * $wspBazowyB;
            $c[] = $wspVal * $wspBazowyC;
            $this->sTT('popyt|standard|wspolczynniki|' . $wsp, $wspVal . ' [a: ' . $wspBazowyA . ', b: ' . $wspBazowyB . ',c: ' . $wspBazowyC . ']');
        }

        $wspA = array();

        foreach ($popytArray as $item) {
            if (is_array($item['a'])) {
                array_push($wspA, $item['a'][$this->gL()]);
            } else {
                array_push($wspA, $item['a']);
            }
        }

        $sumWspA = array_sum($wspA) / 1.5;
        $this->sTT('popyt|standard|obliczenia|suma_wszystkich_A', $sumWspA);

        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Suma wszystkich A z wpływu funkcji popytu dzielone przez 1.5 :', $sumWspA);
        $segmentacja = $this->getSegmentacjaStandard();

        $this->sTT('popyt|standard|segmentacja|a', $segmentacja['a']);
        $this->sTT('popyt|standard|segmentacja|b', $segmentacja['b']);
        $this->sTT('popyt|standard|segmentacja|c', $segmentacja['c']);

        if ($this->rGT(13)) {
            $a = 1 + (array_sum($a) / ($sumWspA) + $segmentacja['a']) / 2;
            $b = (array_sum($b) + $segmentacja['b']) / 2;
            $c = (array_sum($c) / 10 + $segmentacja['c']) / 2;
        } else {
            $a = 1 + array_sum($a) / ($sumWspA) + $segmentacja['a'];
            $b = array_sum($b) + $segmentacja['b'];
            $c = array_sum($c) / 10 + $segmentacja['c'];
        }
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Wpływ decyzji na popyt A:', $a);
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Wpływ decyzji na popyt B:', $b);
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Wpływ decyzji na popyt C:', $c);
        $b = $podstawaPopyt['b'] - $b;
        $c = max($podstawaPopyt['c'] - $c, 0.5);
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Końcowe B:', $b);
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Końcowe C:', $c);

        $this->sTT('popyt|standard|obliczenia|koncowe_a', $a);
        $this->sTT('popyt|standard|obliczenia|koncowe_b', $b);
        $this->sTT('popyt|standard|obliczenia|koncowe_c', $c);

        $wspH = $this->wspWielkoscHoteluStandard();
        $this->sTT('popyt|standard|obliczenia|wielkosc_hotelu', $wspH);
        $popyt = $wspH * $a * $this->demand($podstawaPopyt['a'], $b, $c, $podstawaPopyt['t'], $cena);
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Popyt z funkcji bez współczynników D i ograniczeń:', $popyt);

        $this->sTT('popyt|standard|wyniki|popyt_bez_mnoznikow_bezposrednich_i_ograniczen', $popyt);

        $wspSezonowosc = $this->wspSezonowosc();
        $this->sTT('popyt|standard|mnozniki_bezposrednie|sezonowosc', $wspSezonowosc);
        $this->logP('F(' . __FUNCTION__ . '): Współczynniki bezpośrednio modyfikujące funkcję popytu (D) | Sezonowość :', $wspSezonowosc);

        $wspMikolajkowyEkspres = $this->wspEventMikolajowyEkspres();
        $this->sTT('popyt|standard|mnozniki_bezposrednie|event_mikolajkowy_ekspres', $wspMikolajkowyEkspres);
        $this->logP('F(' . __FUNCTION__ . '): Współczynniki bezpośrednio modyfikujące funkcję popytu (D) | Event mikołajkowy ekspres :', $wspMikolajkowyEkspres);

        $wspKonkurencjiAgresywna = $this->wspAgresywnaKonkurencjaStandard();
        $this->sTT('popyt|standard|mnozniki_bezposrednie|konkurencja_agresywna', $wspKonkurencjiAgresywna);

        $wspKonkurencji = $this->wspKonkurencjaStandard();
        $this->sTT('popyt|standard|mnozniki_bezposrednie|konkurencja', $wspKonkurencji);

        $this->logP('F(' . __FUNCTION__ . '): Współczynniki bezpośrednio modyfikujące funkcję popytu (D) | Wspolczynnik konkurencji standard:', $wspKonkurencji);

        $popyt = $popyt * $wspMikolajkowyEkspres * $wspSezonowosc * $wspKonkurencji * $wspKonkurencjiAgresywna;
        $this->logP("$popyt | $wspMikolajkowyEkspres | $wspSezonowosc | $wspKonkurencji", $popyt);

        $this->sTT('popyt|standard|wyniki|popyt_nieograniczony', $popyt);
        $this->s('konkurencja_raport_popyt_standard', $popyt, 'round');

        $this->logI('F(' . __FUNCTION__ . '): Popyt standard nieograniczony :', $popyt);
        $dni = sfConfig::get('game_hotel_dni_w_kwartale', 90);
        $popyt = max(0, min($iloscPokoi * $dni, $popyt));

        $this->sTT('popyt|standard|wyniki|popyt_koncowy', $popyt);
        $this->logP('F(' . __FUNCTION__ . '): Popyt standard | Popyt końcowy:', $popyt);

        $this->s('popyt_standard', $popyt, 'round');
    }

    /**
     * Oblicza i ustawia popyt na pokoje lux.
     * Wynik jest zapisany w 'round' w 'popyt_lux'
     */
    protected function popytPokojeLux() {
        $cena = $this->gCPL();
        if ($this->rLT(6) || $cena == 0) {
            // Popyt lux zaczynamy liczyc przy przejsciu z 6 do 7 rundy i gry mamy cene
            $this->s('popyt_lux', 0, 'round');
            return;
        }

        $iloscPokoi = $this->gLPL();
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Cena pokoju lux:', $cena);
        $lokalizacja = $this->gL();
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Lokalizacja:', $lokalizacja);

        $podstawaPopyt = $this->g('popyt_lux_' . $lokalizacja, 'game');
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Podstawa A:', $podstawaPopyt['a']);
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Podstawa B:', $podstawaPopyt['b']);
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Podstawa C:', $podstawaPopyt['c']);
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Podstawa T:', $podstawaPopyt['t']);

        $wspolczynniki = array(
            'rachunek_woda',
            'strona_internetowa',
            'rejestracja_na_stronie_www',
            'plakaty_lux',
            'ulotki_lux',
            'sprzatanie_outsourcing_lux',
            'pranie_outsourcing_lux',
            'pracownicy_administracji_liczba',
            'uslugi',
            'media_lokalne_lux',
            'media_regionalne_lux',
            'media_krajowe_lux',
            'pracownicy_obslugi_wynagrodzenie',
            'pracownicy_obslugi_zlecenie',
            'pracownicy_administracji_wynagrodzenie',
            'pracownicy_administracji_zlecenie',
            'zatrudnienie_decyzja',
            'event_sadzenie_drzew',
            'event_panele',
            'event_zimowisko',
            'event_podjazd_dla_niepelnosprawnych',
            'event_pralnia_ekologiczna',
            'event_akcja_charytatywna',
            'event_stop_umowom_smieciowym',
        );

        $wspolczynnikiLokalizacja = array(
            'sniadanie_lux',
            'wyposazenie_lux',
            'usluga_golf',
            'usluga_plaza',
            'usluga_wyciag_narciarski',
            'event_mistrzostwa',
            'event_szkolenie',
            'event_festiwal_filmowy',
            'pracownicy_obslugi_liczba',
            'motywacja_procent',
            'zadowolenie_klienta_lux',
        );

        $popytArray = $this->g('funkcja_popytu_lux', 'game');

        $a = array();
        $b = array();
        $c = array();

        foreach ($wspolczynniki as $wsp) {
            // Nazwa funkcji do pobrania wspolczynnika
            $wspFunction = 'wsp' . sfInflector::camelize($wsp);
            $wspVal = $this->$wspFunction();
            $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Wspolczynnik ' . $wsp . ': ', $wspVal);
            // Dodanie wartosci do tablic sumujacych
            $wspBazowyA = $this->g('funkcja_popytu_lux|' . $wsp . '|a', 'game');
            $wspBazowyB = $this->g('funkcja_popytu_lux|' . $wsp . '|b', 'game');
            $wspBazowyC = $this->g('funkcja_popytu_lux|' . $wsp . '|c', 'game');
            $a[] = $wspVal * $wspBazowyA;
            $b[] = $wspVal * $wspBazowyB;
            $c[] = $wspVal * $wspBazowyC;
            $this->sTT('popyt|lux|wspolczynniki|' . $wsp, $wspVal . ' [a: ' . $wspBazowyA . ', b: ' . $wspBazowyB . ',c: ' . $wspBazowyC . ']');
        }

        // Wspolczynniki ktorych wplyw na funkcje popytu zalezy dodatkowo od lokalizacji
        foreach ($wspolczynnikiLokalizacja as $wsp) {
            // Nazwa funkcji do pobrania wspolczynnika
            $wspFunction = 'wsp' . sfInflector::camelize($wsp);
            $wspVal = $this->$wspFunction();
            $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Wspolczynnik ' . $wsp . ': ', $wspVal);
            // Dodanie wartosci do tablic sumujacych
            $wspBazowyA = $this->g('funkcja_popytu_lux|' . $wsp . '|a|' . $this->gL(), 'game');
            $wspBazowyB = $this->g('funkcja_popytu_lux|' . $wsp . '|b|' . $this->gL(), 'game');
            $wspBazowyC = $this->g('funkcja_popytu_lux|' . $wsp . '|c|' . $this->gL(), 'game');
            $a[] = $wspVal * $wspBazowyA;
            $b[] = $wspVal * $wspBazowyB;
            $c[] = $wspVal * $wspBazowyC;
            $this->sTT('popyt|lux|wspolczynniki|' . $wsp, $wspVal . ' [a: ' . $wspBazowyA . ', b: ' . $wspBazowyB . ',c: ' . $wspBazowyC . ']');
        }

        $wspA = array();

        foreach ($popytArray as $item) {
            if (is_array($item['a'])) {
                array_push($wspA, $item['a'][$this->gL()]);
            } else {
                array_push($wspA, $item['a']);
            }
        }

        $sumWspA = array_sum($wspA) / 1.5;
        $this->sTT('popyt|lux|obliczenia|suma_wszystkich_A', $sumWspA);

        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Suma wszystkich A z wpływu funkcji popytu dzielone przez 2 :', $sumWspA);
        $segmentacja = $this->getSegmentacjaLux();
        $this->sTT('popyt|lux|segmentacja|a', $segmentacja['a']);
        $this->sTT('popyt|lux|segmentacja|b', $segmentacja['b']);
        $this->sTT('popyt|lux|segmentacja|c', $segmentacja['c']);

        if ($this->rGT(13)) {
            $a = 1 + (array_sum($a) / ($sumWspA) + $segmentacja['a']) / 2;
            $b = (array_sum($b) + $segmentacja['b']) / 2;
            $c = (array_sum($c) / 10 + $segmentacja['c']) / 2;
        } else {
            $a = 1 + array_sum($a) / ($sumWspA) + $segmentacja['a'];
            $b = array_sum($b) + $segmentacja['b'];
            $c = array_sum($c) / 10 + $segmentacja['c'];
        }

        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Wpływ decyzji na popyt A:', $a);
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Wpływ decyzji na popyt B:', $b);
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Wpływ decyzji na popyt C:', $c);
        $b = $podstawaPopyt['b'] - $b;
        $c = max($podstawaPopyt['c'] - $c, 0.5);
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Końcowe B:', $b);
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Końcowe C:', $c);

        $this->sTT('popyt|lux|obliczenia|koncowe_a', $a);
        $this->sTT('popyt|lux|obliczenia|koncowe_b', $b);
        $this->sTT('popyt|lux|obliczenia|koncowe_c', $c);

        $wspH = $this->wspWielkoscHoteluLux();
        $this->sTT('popyt|lux|obliczenia|wielkosc_hotelu', $wspH);
        $popyt = $wspH * $a * $this->demand($podstawaPopyt['a'], $b, $c, $podstawaPopyt['t'], $cena);
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Popyt z funkcji bez współczynników D i ograniczeń:', $popyt);

        $this->sTT('popyt|lux|wyniki|popyt_bez_mnoznikow_bezposrednich_i_ograniczen', $popyt);

        $wspSezonowosc = $this->wspSezonowosc();
        $this->sTT('popyt|lux|mnozniki_bezposrednie|sezonowosc', $wspSezonowosc);
        $this->logP('F(' . __FUNCTION__ . '): Współczynniki bezpośrednio modyfikujące funkcję popytu (D) | Sezonowość :', $wspSezonowosc);

        $wspMikolajkowyEkspres = $this->wspEventMikolajowyEkspres();
        $this->sTT('popyt|lux|mnozniki_bezposrednie|event_mikolajkowy_ekspres', $wspMikolajkowyEkspres);
        $this->logP('F(' . __FUNCTION__ . '): Współczynniki bezpośrednio modyfikujące funkcję popytu (D) | Event mikołajkowy ekspres :', $wspMikolajkowyEkspres);

        $wspKonkurencjiAgresywna = $this->wspAgresywnaKonkurencjaLux();
        $this->sTT('popyt|lux|mnozniki_bezposrednie|konkurencja_agresywna', $wspKonkurencjiAgresywna);

        $wspKonkurencji = $this->wspKonkurencjaLux();
        $this->sTT('popyt|lux|mnozniki_bezposrednie|konkurencja', $wspKonkurencji);

        $this->logP('F(' . __FUNCTION__ . '): Współczynniki bezpośrednio modyfikujące funkcję popytu (D) | Wspolczynnik konkurencji lux:', $wspKonkurencji);

        $popyt = $popyt * $wspMikolajkowyEkspres * $wspSezonowosc * $wspKonkurencji * $wspKonkurencjiAgresywna;
        $this->sTT('popyt|lux|wyniki|popyt_nieograniczony', $popyt);
        $this->s('konkurencja_raport_popyt_lux', $popyt, 'round');


        $popyt = max(0, min($iloscPokoi * sfConfig::get('game_hotel_dni_w_kwartale', 90), $popyt));
        $this->sTT('popyt|lux|wyniki|popyt_koncowy', $popyt);
        $this->logP('F(' . __FUNCTION__ . '): Popyt lux | Popyt końcowy:', $popyt);

        $this->s('popyt_lux', $popyt, 'round');
    }

}
