<?php

/**
 * Klasa walidacji decyzji z formularza dla gry Hotel
 */
class HotelGameValidator extends BaseGameValidator {

    private $mathModel;

    public function __construct(BaseGameController $gameController) {
        parent::__construct($gameController);

        $this->mathModel = $this->getGameProcess()->prepareMathModel();
    }

    public function validateRejestracjaNaStronieWww($value) {

        $decision = $this->g('strona_internetowa', 'decision');

        if ($decision == 0 && $value == 1) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie posiadasz wykupionej strony internetowej', array('value' => $value));
            return $error;
        }

        return true;
    }
    
    public function validateNazwaMarki($value) {
        if (mb_strlen($value) > 14) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Nazwa hotelu nie może przekraczać 14 znaków', array('value' => $value));
            return $error;
        }

        return true;
    }

    public function validateWyborLoga($value) {
        if (strpos($value, 'logo-question.png')) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie wprowadziłeś własnego loga', array('value' => $value));
            return $error;
        }

        if (!is_file(sfConfig::get('sf_web_dir').$value)) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Wprowadzone logo nie zostało poprawnie zapisane. Spróbuj ponownie lub wybierz gotowy logotyp.', array('value' => $value));
            return $error;
        }

        return true;
    }

    /** Zarzadzanie pokojami */
    public function validatePokojeStandard($value) {
        $staraDecyzja = $this->g('pokoje_standard', 'decision');
        if ($value == $staraDecyzja) {
            // Brak zmiany
            // Dla walidatora wyposazenia
            $this->s('pokoje_standard_zmiana', false, 'decision');
            return true;
        } else {
            if ($staraDecyzja != 0) {
                // Sprowadzamy do stanu 0
                if ($staraDecyzja > 0) {
                    // Mielismy kupione pokoje w tej rundzie, sprowadzamy do 0
                    $this->cB($this->getGameProcess()->getKosztPokoiStandard($staraDecyzja));
                } else {
                    // Sprzedalismy pokoje w tej rundzie
                    $this->cB(-$this->getGameProcess()->getZyskSprzedazyPokoiStandard(-$staraDecyzja));
                    $this->cLPS(-$staraDecyzja);
                }
            }

            // Zmieniamy z stanu 0
            if ($value > 0) {
                // Kupujemy X pokoi
                if ($this->gB() < $this->getGameProcess()->getKosztPokoiStandard($value)) {
                    $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz kupić takiej liczby pokoi. Masz za mało pieniędzy.', array('value' => $value));
                    return $error;
                }

                $this->cB(-$this->getGameProcess()->getKosztPokoiStandard($value));
            } else {
                // Sprzedajemy X pokoi
                if ($this->gLPS() < -$value) {
                    $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz sprzedać większej liczby pokoi niż posiadasz.', array('value' => $value));
                    return $error;
                }

                $this->cB($this->getGameProcess()->getZyskSprzedazyPokoiStandard(-$value));
                $this->cLPS($value);
            }

            // Ustawiamy ilosc kupionych pokoi
            $this->s('pokoje_standard', $value, 'decision');
            // Dla walidatora wyposazenia
            $this->s('pokoje_standard_zmiana', true, 'decision');

            return true;
        }
    }

    public function validatePokojeStandardWyposazenie($value) {
        if ($this->gLPS() == 0 && $value != 0) {
            // Brak pokoi nie ma co kupowac wyposazenia
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz zmodernizować wyposażenia, ponieważ nie posiadasz pokoi Standard.', array('value' => $value));
            return $error;
        }

        $staraDecyzja = $this->gWS();
        // Decyzja z ostatniej rundy
        $decyzjaLR = $this->g('pokoje_standard_wyposazenie', 'last_decision');
        $liczbaPokoiStandard = $this->gLPS() + max(0, $this->g('pokoje_standard', 'decision'));
        if ($value == $staraDecyzja) {
            // Brak zmiany
            return true;
        } else {
            if ($this->g('pokoje_standard_zmiana', 'decision')) {
                // W jednym zapisie probujemy zmienic ilosc pokoi i wyposazenie
                $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz zmienić wyposażenia i kupić/sprzedać pokoi jednocześnie. Kolejność podjęcia decyzji ma znaczenie!', array('value' => $value));
                return $error;
            }
            // Sprowadzamy wyposazenie do stanu z poprzedniej rundy
            if ($staraDecyzja > $decyzjaLR) {
                // Zwracamy zainwestowane pieniadze
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $staraDecyzja) - $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $decyzjaLR);
                $this->cB($koszt);
            } else {
                // Odejmujemy zysk ze sprzedazy pokoi
                $koszt = ($this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $decyzjaLR) - $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $staraDecyzja)) * $this->g('wspolczynnik|likwidacji_wyposazenia', 'game');

                if ($this->gB() < $koszt) {
                    $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $value));
                    return $error;
                }
                $this->cB(-$koszt);
            }

            // Zmieniamy wyposazenie
            if ($value > $decyzjaLR) {
                // Kupujemy wyposazenie na wyzszy poziom
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $value) - $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $decyzjaLR);

                if ($this->gB() < $koszt) {
                    $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $value));
                    return $error;
                }

                $this->cB(-$koszt);
                $this->sWS($value);
            } else {
                // Sprzedajemy wyposazenie
                $koszt = ($this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $decyzjaLR) - $this->getGameProcess()->getKosztWyposazeniaPokoiStandard($liczbaPokoiStandard, $value)) * $this->g('wspolczynnik|likwidacji_wyposazenia', 'game');

                $this->cB($koszt);
                $this->sWS($value);
            }

            return true;
        }
    }

    public function validatePokojeLux($value) {
        $staraDecyzja = $this->g('pokoje_lux', 'decision');
        if ($value == $staraDecyzja) {
            // Brak zmiany
            // Dla walidatora wyposazenia
            $this->s('pokoje_lux_zmiana', false, 'decision');
            return true;
        } else {
            if ($staraDecyzja != 0) {
                // Sprowadzamy do stanu 0
                if ($staraDecyzja > 0) {
                    // Mielismy kupione pokoje w tej rundzie, sprowadzamy do 0
                    $this->cB($this->getGameProcess()->getKosztPokoiLux($staraDecyzja));
                } else {
                    // Sprzedalismy pokoje w tej rundzie
                    $this->cB(-$this->getGameProcess()->getZyskSprzedazyPokoiLux(-$staraDecyzja));
                    $this->cLPL(-$staraDecyzja);
                }
            }

            // Zmieniamy z stanu 0
            if ($value > 0) {
                // Kupujemy X pokoi
                if ($this->gB() < $this->getGameProcess()->getKosztPokoiLux($value)) {
                    $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz kupić takiej liczby pokoi. Masz za mało pieniędzy.', array('value' => $value));
                    return $error;
                }

                $this->cB(-$this->getGameProcess()->getKosztPokoiLux($value));
            } else {
                // Sprzedajemy X pokoi
                if ($this->gLPL() < -$value) {
                    $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz sprzedać większej liczby pokoi niż posiadasz.', array('value' => $value));
                    return $error;
                }

                $this->cB($this->getGameProcess()->getZyskSprzedazyPokoiLux(-$value));
                $this->cLPL($value);
            }

            // Ustawiamy ilosc kupionych pokoi
            $this->s('pokoje_lux', $value, 'decision');
            // Dla walidatora wyposazenia
            $this->s('pokoje_lux_zmiana', true, 'decision');

            return true;
        }
    }

    public function validatePokojeLuxWyposazenie($value) {
        if ($this->gLPL() == 0 && $value != 0) {
            // Brak pokoi nie ma co kupowac wyposazenia
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz zmodernizować wyposażenia, ponieważ nie posiadasz pokoi Delux.', array('value' => $value));
            return $error;
        }

        $staraDecyzja = $this->gWL();
        // Decyzja z ostatniej rundy
        $decyzjaLR = $this->g('pokoje_lux_wyposazenie', 'last_decision');
        $liczbaPokoiLux = $this->gLPL() + max(0, $this->g('pokoje_lux', 'decision'));
        if ($value == $staraDecyzja) {
            // Brak zmiany
            return true;
        } else {
            if ($this->g('pokoje_lux_zmiana', 'decision')) {
                // W jednym zapisie probujemy zmienic ilosc pokoi i wyposazenie
                $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz zmienić wyposażenia i kupić/sprzedać pokoi jednocześnie. Kolejność podjęcia decyzji ma znaczenie!', array('value' => $value));
                return $error;
            }
            // Sprowadzamy wyposazenie do stanu z poprzedniej rundy
            if ($staraDecyzja > $decyzjaLR) {
                // Zwracamy zainwestowane pieniadze
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $staraDecyzja) - $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $decyzjaLR);
                $this->cB($koszt);
            } else {
                // Odejmujemy zysk ze sprzedazy pokoi
                $koszt = ($this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $decyzjaLR) - $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $staraDecyzja)) * $this->g('wspolczynnik|likwidacji_wyposazenia', 'game');

                if ($this->gB() < $koszt) {
                    $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $value));
                    return $error;
                }
                $this->cB(-$koszt);
            }

            // Zmieniamy wyposazenie
            if ($value > $decyzjaLR) {
                // Kupujemy wyposazenie na wyzszy poziom
                $koszt = $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $value) - $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $decyzjaLR);

                if ($this->gB() < $koszt) {
                    $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $value));
                    return $error;
                }
                $this->cB(-$koszt);
                $this->sWL($value);
            } else {
                // Sprzedajemy wyposazenie
                $koszt = ($this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $decyzjaLR) - $this->getGameProcess()->getKosztWyposazeniaPokoiLux($liczbaPokoiLux, $value)) * $this->g('wspolczynnik|likwidacji_wyposazenia', 'game');

                $this->cB($koszt);
                $this->sWL($value);
            }

            return true;
        }
    }

    /** Zarzadzanie pokojami - KONIEC */

    /** Eventy */
    public function validateEventSadzenieDrzew($value) {
        if ($value < $this->g('eventy_sadzenie_drzew', 'last_round')) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz zmniejszyć zaangażowania w wydarzenie.', array('value' => $value));
            return $error;
        }
        // Koszt lub ilosc pieniedzy do zwrotu
        $koszt = $this->getGameProcess()->getKosztSadzenieDrzew($value) - $this->getGameProcess()->getKosztSadzenieDrzew($this->g('event_sadzenie_drzew', 'decision'));

        if ($this->gB() < $koszt) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $koszt));
            return $error;
        }

        $this->cB(-$koszt);

        $this->s('event_sadzenie_drzew', $value, 'decision');
        return true;
    }

    public function validateEventPanele($value) {
        if ($value > $this->getGameProcess()->getEventPaneleMax()) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Twój rozmiar hotelu nie pozwala na zakup takiej ilości paneli słonecznych.', array('value' => $value));
            return $error;
        }
        if ($value < $this->g('event_panele', 'last_decision')) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz sprzedać paneli słonecznych.', array('value' => $value));
            return $error;
        }
        // Koszt lub ilosc pieniedzy do zwrotu
        $koszt = ($value - $this->g('event_panele', 'decision', 0)) * $this->g('eventy|panele|koszt', 'game');

        if ($this->gB() < $koszt) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $koszt));
            return $error;
        }

        $this->cB(-$koszt);

        $this->s('event_panele', $value, 'decision');
        return true;
    }

    public function validateEventZimowisko($value) {
        $koszt = $this->g('eventy|zimowisko', 'game');
        return $this->validateKosztJednorazowy($koszt, $value, 'event_zimowisko');
    }

    public function validateEventPodjazdDlaNiepelnosprawnych($value) {
        $koszt = $this->g('eventy|podjazd_dla_niepelnosprawnych', 'game');
        return $this->validateKosztJednorazowy($koszt, $value, 'event_podjazd_dla_niepelnosprawnych');
    }

    public function validateEventPralniaEkologiczna($value) {
        $koszt = $this->g('eventy|pralnia_ekologiczna|koszt', 'game');
        return $this->validateKosztJednorazowy($koszt, $value, 'event_pralnia_ekologiczna');
    }

    public function validateEventAkcjaCharytatywna($value) {
        $koszt = $this->g('eventy|akcja_charytatywna', 'game');
        return $this->validateKosztJednorazowy($koszt, $value, 'event_akcja_charytatywna');
    }

    public function validateEventMikolajkowyEkspres($value) {
        $koszt = $this->g('eventy|mikolajkowy_ekspres|koszt', 'game');
        return $this->validateKosztJednorazowy($koszt, $value, 'event_mikolajkowy_ekspres');
    }

//
//  public function validateEventKierowniczka($value) {
//    $koszt = $this->getGameProcess()->getKosztKierowniczka($value);
//    $decision = $this->g('event_kierowniczka', 'decision', 0);
//    // Zwracamy koszt za poprzednia decyzje
//    $this->cB($this->getGameProcess()->getKosztKierowniczka($decision));
//
//    if ($this->gB() < $koszt) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $value));
//      return $error;
//    }
//
//    $this->cB(-$koszt);
//    $this->s('event_kierowniczka', $value, 'decision');
//    return true;
//  }

    public function validateEventSzkolenie($value) {
        $koszt = $this->g('eventy|szkolenie', 'game');
        return $this->validateKosztJednorazowy($koszt, $value, 'event_szkolenie');
    }

    public function validateGolf($value) {
        $koszt = $this->g('sezonowosc|koszt|golf', 'game');
        return $this->validateKosztJednorazowy($koszt, $value, 'golf');
    }

    public function validatePlaza($value) {
        $koszt = $this->g('sezonowosc|koszt|plaza', 'game');
        return $this->validateKosztJednorazowy($koszt, $value, 'plaza');
    }

    public function validateWyciagNarciarski($value) {
        $koszt = $this->g('sezonowosc|koszt|wyciag_narciarski', 'game');
        return $this->validateKosztJednorazowy($koszt, $value, 'wyciag_narciarski');
    }

    /**
     * Funkcja waliduje koszt jednorazowy. Przyjmuje koszt, podjeta decyzje oraz 
     * nazwe decyzje w ktorej jest przechowywana zmienna.
     * @param float $koszt
     * @param boolean $decision
     * @param strong $decisionName
     * @return sfValidatorError|boolean 
     */
    public function validateKosztJednorazowy($koszt, $decision, $decisionName) {
        $oldDecision = $this->g($decisionName, 'decision', false);
        if ($oldDecision) {
            // Jesli byla podjeta decyzja zwroc koszt
            $this->cB($koszt);
        }
        if ($decision) {
            if ($this->gB() < $koszt) {
                $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $koszt));
                return $error;
            }
            // Odejmij koszt
            $this->cB(-$koszt);
        }

        $this->s($decisionName, $decision, 'decision');
        return true;
    }

    public function validateStronaInternetowa($value) {
        if (!($this->g('kupiona_strona_internetowa', 'round'))) {
            // Nigdy nie kupiono strony, przeliczamy koszt jednorazowy
            $koszt = $this->g('strona_internetowa|koszt_jednorazowy', 'game');
            $decision = $this->g('strona_internetowa', 'decision');
            if ($decision > 0) {
                // Podjal decyzje o kupnie, to zwracamy mu koszt - wracamy do stanu brak strony
                $this->cB($koszt);
            }
            if ($value > 0) {
                if ($this->gB() < $koszt) {
                    $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $value));
                    return $error;
                }
                // Pobieramy koszt
                $this->cB(-$koszt);
            }
        }

        $this->s('strona_internetowa', $value, 'decision');
        return true;
    }

    protected function validateResearch($value, $name) {

        if ($value == 1) {

            if ($this->getGameProcess()->hasResearch($name)) {
                $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz ponownie kupić badań.', array('value' => $value));
                return $error;
            }

            $koszt = $this->getGameProcess()->getResearchCost($name);
            if ($koszt > $this->gB()) {
                $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $value));
                return $error;
            }

            $this->cB(-$koszt);
            $this->s($name, 1, 'round');
            $this->s($name, 1, 'decision');
        }

        return true;
    }

    public function validateBadanieMarketingowePopytStandard($value) {
        return $this->validateResearch($value, 'badanie_marketingowe_popyt_standard');
    }

    public function validateBadanieMarketingoweUslugiPodstawowe($value) {
        return $this->validateResearch($value, 'badanie_marketingowe_uslugi_podstawowe');
    }

    public function validateBadanieMarketingoweSezonowosc($value) {
        return $this->validateResearch($value, 'badanie_marketingowe_sezonowosc');
    }

    public function validateBadanieMarketingowePopytLux($value) {
        return $this->validateResearch($value, 'badanie_marketingowe_popyt_lux');
    }

    public function validateBadanieMarketingoweReklamaZaawansowana($value) {
        return $this->validateResearch($value, 'badanie_marketingowe_reklama_zaawansowana');
    }

    public function validateBadanieMarketingoweKonkurencja($value) {
        return $this->validateResearch($value, 'badanie_marketingowe_konkurencja');
    }

    public function validateBadanieMarketingoweUslugiZaawansowaneSegmentacja($value) {
        return $this->validateResearch($value, 'badanie_marketingowe_uslugi_zaawansowane_segmentacja');
    }

//  public function validateEventStopUmowomSmieciowym($value) {
//    if ($value && !($this->gPO() + $this->gPA()) > 0) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Musisz zatrudnić pracowników, aby uczestniczyć w wydarzeniu.', array('value' => $value, 'min' => $minZlecenieObslugi));
//      return $error;
//    }
//
//    return true;
//  }
//
//  /** Zatrudnienie */
//  public function validatePracownicyObslugiStaleLiczba($value) {
//    if ($this->g('event_stop_umowom_smieciowym', 'decision') && ($value + $this->gPOZ() + $this->gPA()) == 0) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Uczestniczysz w wydarzeniu "Stop umowom śmieciowym". Musisz mieć zatrudnionych pracowników.', array('value' => $value));
//      return $error;
//    }
//
//    $this->s('pracownicy_obslugi_stale_liczba', $value, 'decision');
//  }
//
//  public function validatePracownicyObslugiZlecenieLiczba($value) {
//    if ($this->g('event_stop_umowom_smieciowym', 'decision') && ($value + $this->gPOS() + $this->gPA()) == 0) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Uczestniczysz w wydarzeniu "Stop umowom śmieciowym". Musisz mieć zatrudnionych pracowników.', array('value' => $value));
//      return $error;
//    }
//
//    $liczbaPracownikowObslugi = $this->gPO();
//
//    $procentNaZlecenie = (1 - $this->g('eventy|stop_umowom_smieciowym', 'game'));
//    $liczbaNaZlecenieObslugi = ceil($procentNaZlecenie * $liczbaPracownikowObslugi);
//
//    if ($this->g('event_stop_umowom_smieciowym', 'decision') && $value > $liczbaNaZlecenieObslugi) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Bierzesz udział w wydarzeniu "Stop umowom śmieciowym". Liczba pracowników na zlecenie nie może być wyższa niż %min%', array('value' => $value, 'min' => $liczbaNaZlecenieObslugi));
//      return $error;
//    }
//
//    $this->s('pracownicy_obslugi_zlecenie_liczba', $value, 'decision');
//  }
//
//  public function validatePracownicyAdministracjiStaleLiczba($value) {
//    if ($this->g('event_stop_umowom_smieciowym', 'decision') && ($value + $this->gPAZ() + $this->gPO()) == 0) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Uczestniczysz w wydarzeniu "Stop umowom śmieciowym". Musisz mieć zatrudnionych pracowników.', array('value' => $value));
//      return $error;
//    }
//
//    $this->s('pracownicy_administracji_stale_liczba', $value, 'decision');
//  }
//
//  public function validatePracownicyAdministracjiZlecenieLiczba($value) {
//    if ($this->g('event_stop_umowom_smieciowym', 'decision') && ($value + $this->gPAS() + $this->gPO()) == 0) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Uczestniczysz w wydarzeniu "Stop umowom śmieciowym". Musisz mieć zatrudnionych pracowników.', array('value' => $value));
//      return $error;
//    }
//
//    $liczbaPracownikowAdministracji = $this->gPA();
//
//    $procentNaZlecenie = (1 - $this->g('eventy|stop_umowom_smieciowym', 'game'));
//    $liczbaNaZlecenieAdministracji = ceil($procentNaZlecenie * $liczbaPracownikowAdministracji);
//
//    if ($this->g('event_stop_umowom_smieciowym', 'decision') && $value > $liczbaNaZlecenieAdministracji) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Bierzesz udział w wydarzeniu "Stop umowom śmieciowym". Liczba pracowników na zlecenie nie może być wyższa niż %min%', array('value' => $value, 'min' => $liczbaNaZlecenieAdministracji));
//      return $error;
//    }
//
//    $this->s('pracownicy_administracji_zlecenie_liczba', $value, 'decision');
//  }

    public function validatePracownicyObslugiStaleWynagrodzenie($value) {
        $minimalna = $this->getGameProcess()->getPlacaMinimalnaPracownicyObslugi();
        if ($this->gPOS() > 0 && $value < $minimalna) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Wynagrodzenie pracowników na umowę o pracę musi być wyższe niż płaca minimalna.', array('value' => $value));
            return $error;
        }

        $this->s('pracownicy_obslugi_stale_wynagrodzenie', $value, 'decision');
    }

    public function validatePracownicyAdministracjiStaleWynagrodzenie($value) {
        $minimalna = $this->getGameProcess()->getPlacaMinimalnaPracownicyAdministracji();
        if ($this->gPAS() > 0 && $value < $minimalna) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Wynagrodzenie pracowników na umowę o pracę musi być wyższe niż płaca minimalna.', array('value' => $value));
            return $error;
        }

        $this->s('pracownicy_administracji_stale_wynagrodzenie', $value, 'decision');
    }

    public function validatePracownicyObslugiZlecenieWynagrodzenie($value) {
        $minimalna = 0.5 * $this->getGameProcess()->getPlacaMinimalnaPracownicyObslugi();
        if ($this->gPOZ() > 0 && $value < $minimalna) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie udało się znaleźć tylu pracowników na zlecenie za taką płacę.', array('value' => $value));
            return $error;
        }

        $this->s('pracownicy_obslugi_zlecenie_wynagrodzenie', $value, 'decision');
    }

    public function validatePracownicyAdministracjiZlecenieWynagrodzenie($value) {
        $minimalna = 0.5 * $this->getGameProcess()->getPlacaMinimalnaPracownicyAdministracji();
        if ($this->gPAZ() > 0 && $value < $minimalna) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie udało się znaleźć tylu pracowników na zlecenie za taką płacę.', array('value' => $value));
            return $error;
        }

        $this->s('pracownicy_administracji_zlecenie_wynagrodzenie', $value, 'decision');
    }

    public function validatePracownicyObslugiStaleMotywacjaProcent($value) {
        if ($this->gPOS() == 0 && $value > 0) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Brak pracowników obsługi zatrudnionych na stałe, aby można było przydzielić im motywację.', array('value' => $value));
            return $error;
        }

        $this->s('pracownicy_obslugi_stale_motywacja_procent', $value, 'decision');
    }

    public function validatePracownicyObslugiZlecenieMotywacjaProcent($value) {
        if ($this->gPOZ() == 0 && $value > 0) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Brak pracowników obsługi zatrudnionych na zlecenie, aby można było przydzielić im motywację.', array('value' => $value));
            return $error;
        }

        $this->s('pracownicy_obslugi_zlecenie_motywacja_procent', $value, 'decision');
    }

    public function validatePracownicyAdministracjiStaleMotywacjaProcent($value) {
        if ($this->gPAS() == 0 && $value > 0) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Brak pracowników administracji zatrudnionych na stałe, aby można było przydzielić im motywację.', array('value' => $value));
            return $error;
        }

        $this->s('pracownicy_administracji_stale_motywacja_procent', $value, 'decision');
    }

    public function validatePracownicyAdministracjiZlecenieMotywacjaProcent($value) {
        if ($this->gPAZ() == 0 && $value > 0) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Brak pracowników administracji zatrudnionych na zlecenie, aby można było przydzielić im motywację.', array('value' => $value));
            return $error;
        }

        $this->s('pracownicy_administracji_zlecenie_motywacja_procent', $value, 'decision');
    }

    /** Kredyty */
    public function validateKredytInwestycyjnyKwota($value) {

        $min = $this->g('kredyty|inwestycyjny|min', 'game');
        $max = $this->getGameProcess()->getZdolnoscKredytInwestycyjny();
        $aktualnaKwota = $this->g('kredyt_inwestycyjny_kwota', 'round', 0);

        if ($this->g('kredyt_inwestycyjny_kwota', 'last_round', 0) > 0) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz ponownie zaciągnąć kredytu.', array('value' => $value, 'max_wartosc' => $max));
            return $error;
        }

        if ($value < $min && $value != 0) {

            if ($min > $max) {
                $error = new sfValidatorError(new sfValidatorPass()
                        , 'Nie możesz zaciągnąć kredytu inwestycyjnego, ponieważ wartość Twojej firmy jest za mała.'
                        , array('value' => $value, 'max_wartosc' => $max));

                return $error;
            }

            $error = new sfValidatorError(new sfValidatorPass()
                    , 'Minimalna wartość kredytu inwestycyjnego to %min_wartosc%. Wpisz 0 aby spłacić kredyt inwestycyjny.'
                    , array('value' => $value, 'min_wartosc' => self::format_money_value($min, false)));

            return $error;
        }
        if ($value > $max) {

            if ($min > $max) {

                $error = new sfValidatorError(new sfValidatorPass()
                        , 'Nie możesz zaciągnąć kredytu inwestycyjnego, ponieważ wartość Twojej firmy jest za mała.'
                        , array('value' => $value, 'max_wartosc' => $max));

                return $error;
            }
            $error = new sfValidatorError(new sfValidatorPass(), 'Maksymalna wartość kredytu inwestycyjnego to %max_wartosc%.', array('value' => $value, 'max_wartosc' => self::format_money_value($max, false)));
            return $error;
        }

        if ($value < $aktualnaKwota) {
            // Chcemy zmniejszyc ilosc kredytu
            if (($aktualnaKwota - $value) > $this->gB()) {
                $error = new sfValidatorError(new sfValidatorPass(), 'Nie masz wystarczająco gotówki, aby zmniejszyć kredyt inwestycyjny.', array('value' => $value, 'max_wartosc' => self::format_money_value($max, false)));
                return $error;
            }
        }

        if ($this->g('kredyt_inwestycyjny_kwota', 'round') > 0) {
            $this->cB($value - $this->g('kredyt_inwestycyjny_kwota', 'round'));
        } else {
            $this->cB($value);
        }

        $this->s('kredyt_inwestycyjny_kwota', $value, 'round');
        $this->s('kredyt_inwestycyjny_kwota', $value, 'decision');

        return true;
    }

    public function validateKredytObrotowyKwota($value) {

        $maxValue = $this->getGameProcess()->getZdolnoscKredytObrotowy();
        $kwota = $this->g('kredyt_obrotowy_kwota', 'round');

        if (($value + $kwota) > $maxValue) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Maksymalna wartość kredytu obrotowego to %max_wartosc%.', array('value' => $value, 'max_wartosc' => self::format_money_value($maxValue, false)));
            return $error;
        }

        $this->cB($value);
        $this->s('kredyt_obrotowy_kwota', ($kwota + $value), 'round');

        return true;
    }

    public function validateKredytObrotowySplata($value) {

        $kwota = $this->g('kredyt_obrotowy_kwota', 'round');

        if (!$kwota > 0) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Nie posiadasz kredytu obrotowego, aby go spłacać.', array());
            return $error;
        }

        if ($value <= $kwota) {
            // Chcemy splacic kredyt obrotowy
            if ($value > $this->gB()) {
                // Nie mamy czym
                $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie, aby spłacić kredyt', array('value' => $value));
                return $error;
            }

            $this->s('kredyt_obrotowy_kwota', ($kwota - $value), 'round');
            $this->cB(-$value);
        } else {
            $error = new sfValidatorError(new sfValidatorPass(), 'Możesz spłacić maksymalnie %value% kredytu obrotowego.', array('value' => $kwota));
            return $error;
        }

        return true;
    }

//
//  public function validateKredytKarnySplata($value) {
//    $kwota = $this->g('kredyt_karny_kwota', 'round');
//    if ($value > $kwota) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Nie możesz spłacić więcej kredytu niż jego wartość.', array('value' => $value));
//      return $error;
//    }
//    $splata = $kwota - $value;
//    if ($splata > $this->gB()) {
//      $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $value));
//      return $error;
//    }
//
//    $this->cB(-$splata);
//    return true;
//  }

    /** Lokaty */
    public function validateLokataKwota($value) {
        $kwota = $this->g('lokata_kwota', 'round');
        // Dokladamy kase do lokaty
        if ($value > $this->gB()) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na koncie', array('value' => $value));
            return $error;
        }
        $this->s('lokata_kwota', ($kwota + $value), 'round');
        $this->cB(-$value);

        return true;
    }

    public function validateLokataSplata($value) {
        $kwota = $this->g('lokata_kwota', 'round');
        // Dokladamy kase do lokaty
        if ($value > $kwota) {
            $error = new sfValidatorError(new sfValidatorPass(), 'Za mało pieniędzy na lokacie', array('value' => $value));
            return $error;
        }
        $this->s('lokata_kwota', ($kwota - $value), 'round');
        $this->cB($value);

        return true;
    }

    /** Lokaty - Koniec */
}
