<?php

/**
 * Klasa bazowa formularza decyzji dla gry 
 */
abstract class BaseDecisionForm extends BaseForm {

  protected $gameController;

  public function setup() {
    parent::setup();

    $gameController = $this->getOption('gameController', null);
    if (!is_null($gameController)) {
      if (!($gameController instanceof BaseGameController)) {
        throw new sfException('Przekazana opcja "gameController" nie jest klasą dziedziczącą po BaseGameController.');
      }
      $this->gameController = $gameController;
    } else {
      throw new sfException('Opcja "gameController" nie została przekazana do formularza decyzji.');
    }
  }

  public function configure() {
    $this->setWidget('timestamp', new sfWidgetFormInputHidden());
    $this->setValidator('timestamp', new sfValidatorPass(array('required' => true)));
    $this->setDefault('timestamp', time());

    $this->setFieldsWithDefaults();

        $this->widgetSchema->setNameFormat('decision_form[%s]');
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);
  }

  public function isValid() {
    $isValid = false;
    
    if (parent::isValid()) {
      $isValid = true;
            $this->gameController->backupGameData();

      $error = $this->gameController->validateDecision('timestamp', $this->getValue('timestamp'));
      if ($error instanceof sfValidatorError) {
        $this->errorSchema->addError($error);
        $isValid = false;
      } else {
        $fields = $this->getWidgetSchema()->getFields();
        unset($fields['timestamp'], $fields['_csrf_token']);
        foreach ($fields as $name => $field) {
          $error = $this->gameController->validateDecision($name, $this->getValue($name));
          if ($error instanceof sfValidatorError) {
            $this->errorSchema->addError($error, $name);
            $isValid = false;
          }
        }
      }
      $this->gameController->restoreGameData();
    }

    return $isValid;
  }

  public function save($con = null) {
    $fields = $this->getWidgetSchema()->getFields();
    unset($fields['timestamp'], $fields['_csrf_token']);

    foreach ($fields as $name => $field) {
      $o = $this->getValue($name);
      if (is_object($o)) {
        if (get_class($o) === 'sfArtValidatedFile' || get_class($o) === 'sfValidatedFile') {

          $this->gameController->makeDecision($name, $o->newName);
        }
      } else {

        if ($name !== 'logo_marki')
          $this->gameController->makeDecision($name, $this->getValue($name));
      }
    }

    $this->taintedValues['timestamp'] = time();
  }

  /**
   * Ustawia pola z widgetow ktore maja byc uzupelniona wartosciami default
   */
  protected function setFieldsWithDefaults() {
    $fields = $this->getWidgetSchema()->getFields();
    
    foreach ($fields as $name => $field) {
      if ($this->gameController->e($name, 'decision')) {
        $this->setDefault($name, $this->gameController->g($name, 'decision'));
      }
    }
  }

  public function bind(array $taintedValues = null, array $taintedFiles = null) {
    $this->taintedValues = $taintedValues;
    $this->taintedFiles = $taintedFiles;
    $this->isBound = true;
    $this->resetFormFields();

    if (null === $this->taintedValues) {
      $this->taintedValues = array();
    }

    if (null === $this->taintedFiles) {
      if ($this->isMultipart()) {
        throw new InvalidArgumentException('This form is multipart, which means you need to supply a files array as the bind() method second argument.');
      }

      $this->taintedFiles = array();
    }

    try {
      $this->doBind(self::deepArrayUnion($this->taintedValues, self::convertFileInformation($this->taintedFiles)));
      $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

      unset($this->values[self::$CSRFFieldName]);
    } catch (sfValidatorErrorSchema $e) {
      $this->values = array();
      $this->errorSchema = $e;
    }
  }

}
