<?php

/**
 * Klasa bazowa walidacji decyzji z formularza dla gry 
 */
abstract class BaseGameData {
  /** Zapisanie danych po kazdej zmianie */

  const ALWAYS_SAVE = 1;
  /** Zapisanie danych tylko przy wywolaniu funkcji save(true); */
  const FORCE_SAVE = 2;

  /** Stany danych */
  const MODIFIED = 1;
  const NEED_SAVE = 2;
  const NOT_MODIFIED = 3;

  /**
   * Obiekt zespolu, zawiera przypisana gre oraz aktywna runde
   * @var Team
   */
  protected $team;

  /**
   * Obiekt rundy, zawiera ostatnia runde lub NULL
   * @var Round
   */
  protected $lastRound = null;

  /** Tablice z danymi z json w postaci tablic PHP */

  /** Kolumna game_data_json */
  public $gameData = array();

  /** Kolumna round_data_json */
  public $roundData = array();

  /** Kolumna round_decision_data_json */
  public $roundDecisionData = array();

  /** Kolumna round_raport_data_json */
  protected $roundRaportData = array();

  /** Kolumna round_data_json */
  protected $lastRoundData = array();

  /** Kolumna round_decision_data_json */
  protected $lastRoundDecisionData = array();

  /** Kolumna round_raport_data_json */
  protected $lastRoundRaportData = array();

  /** Flagi czy dany obiekt zostal zmodyfikowany */
  protected $gameModified = self::NOT_MODIFIED;
  protected $roundModified = self::NOT_MODIFIED;
  protected $lastRoundModified = self::NOT_MODIFIED;

  /** Zmienna zawierajaca logi decyzji do zapisu */
  protected $logDecision = array();

  /** Sposob zapisu danych */
  protected $mode = self::ALWAYS_SAVE;

  public function __construct($teamId, $mode = self::ALWAYS_SAVE) {
    $this->loadData($teamId);
    $this->setMode($mode);
    
    
//    var_dump(time());
  }

  public function loadData($teamId) {
    
//    var_dump(time());
    
    $data = Doctrine::getTable('Team')->getDataForGameController($teamId);

    if (!$data) {
            sfContext::getInstance()->getUser()->setAttribute('team_id', false);
      sfContext::getInstance()->getUser()->setFlash('error', 'Gra jest nie dostępna. Prosimy spróbowac później.');
      sfContext::getInstance()->getController()->forward('panelGry', 'index');
      die(); 
//      throw new sfException('Druzyna o id "' . $teamId . '" nie istnieje lub jest przypisana do nieaktywnej gry.');
    }

    $this->team = $data;

    $this->gameData = static::jsonToArray($this->getGame()->getGameDataJson());
    $this->roundData = static::jsonToArray($this->getRound()->getRoundDataJson());
    $this->roundDecisionData = static::jsonToArray($this->getRound()->getRoundDecisionDataJson());
    $this->roundRaportData = static::jsonToArray($this->getRound()->getRoundRaportDataJson());

    if ($this->hasLastRound()) {
      $this->lastRoundData = static::jsonToArray($this->getLastRound()->getRoundDataJson());
      $this->lastRoundDecisionData = static::jsonToArray($this->getLastRound()->getRoundDecisionDataJson());
      $this->lastRoundRaportData = static::jsonToArray($this->getLastRound()->getRoundRaportDataJson());
    }
  }

  public function __clone() {
    $this->team = clone $this->team;
    if (!is_null($this->lastRound)) {
      $this->lastRound = clone $this->lastRound;
    }
  }

  public function reloadData() {
    $this->loadData($this->team->getId());
    $this->gameModified = self::NOT_MODIFIED;
    $this->roundModified = self::NOT_MODIFIED;
    $this->lastRoundModified = self::NOT_MODIFIED;
  }

  public static function jsonToArray($data) {
    if (!$data) {
      return array();
    } else {
      return json_decode($data, true);
    }
  }

  public static function arrayToJson($data) {
    return json_encode($data);
  }

  public function save($force = false) {
    $save = ($this->mode == self::ALWAYS_SAVE || ($this->mode == self::FORCE_SAVE && $force));

    if ($this->gameModified == self::MODIFIED) {
      $this->getGame()->setGameDataJson(static::arrayToJson($this->gameData));
      $this->gameModified = self::NEED_SAVE;
    }
    if ($save && $this->gameModified == self::NEED_SAVE) {
      $this->getGame()->save();
      $this->gameModified = self::NOT_MODIFIED;
    }

    if ($this->roundModified == self::MODIFIED) {
      $this->getRound()->setRoundDataJson(static::arrayToJson($this->roundData));
      $this->getRound()->setRoundDecisionDataJson(static::arrayToJson($this->roundDecisionData));
      $this->getRound()->setRoundRaportDataJson(static::arrayToJson($this->roundRaportData));
      $this->roundModified = self::NEED_SAVE;
    }

    if ($save && $this->roundModified == self::NEED_SAVE) {
      $this->getRound()->save();
      $this->roundModified = self::NOT_MODIFIED;
    }

    if ($this->lastRoundModified == self::MODIFIED) {
      $this->getLastRound()->setRoundDataJson(static::arrayToJson($this->lastRoundData));
      $this->getLastRound()->setRoundDecisionDataJson(static::arrayToJson($this->lastRoundDecisionData));
      $this->getLastRound()->setRoundRaportDataJson(static::arrayToJson($this->lastRoundRaportData));
      $this->lastRoundModified = self::NEED_SAVE;
    }

    if ($save && $this->lastRoundModified == self::NEED_SAVE) {
      $this->getLastRound()->save();
      $this->lastRoundModified = self::NOT_MODIFIED;
    }

    if (!empty($this->logDecision)) {
      
      $colection = new Doctrine_Collection('LogDecision');

      foreach ($this->logDecision as $logDecision) {
        $record = new LogDecision();
        foreach ($logDecision as $field => $value) {
          $record->set($field, $value);
        }
        $colection->add($record);
      }

      $colection->save();

      $this->logDecision = array();
    }
  }

  public function getGame() {
    return $this->team->getGame();
  }

  public function getRound() {
    return $this->team->getRounds()->getFirst();
  }

  public function getRoundNumber() {
    return $this->getRound()->getRoundNumber();
  }

  public function getTeam() {
    return $this->team;
  }

  public function hasLastRound() {
    if ($this->team->getRounds()->count() < 2) {
      return false;
    } else {
      return true;
    }
  }

  public function getLastRound() {
    return $this->team->getRounds()->getLast();
  }

  public function setMode($mode) {
    if ($mode != self::ALWAYS_SAVE && $mode != self::FORCE_SAVE) {
      throw new sfException('Probujesz ustawic nieistniejący "mode".');
    }

    $this->mode = $mode;
  }

  public function getMode() {
    return $this->mode;
  }

  /**
   * Dodaje wpis logu decyzji przeznaczonej do zapisu.
   * Jesli istnieje metoda logNazwaDecyzji to wywoluje te metode
   * zamiast standardowo dodac rekord do tablicy
   * @param string $decisionName
   * @param string $value
   * @param int $userId 
   */
  public function logDecision($decisionName, $oldValue, $newValue, $userId) {
    $logFunctionName = 'log' . sfInflector::camelize($decisionName);
    if (method_exists($this, $logFunctionName)) {
      $this->$logFunctionName($decisionName, $oldValue, $newValue, $userId);
    } else {
      if ($oldValue != $newValue) {
        $this->logDecision[] = array(
            'decision' => $decisionName,
            'new_value' => $newValue,
            'old_value' => $oldValue,
            'user_id' => $userId,
            'round_id' => $this->getRound()->getId(),
        );
      }
    }
  }

  public function e($key, $from) {
    return $this->exist($key, $from);
  }

  public function g($key, $from, $default = null) {
    
    return $this->get($key, $from, $default);
  }

  public function s($key, $value, $to) {
    $this->set($key, $value, $to);
  }

  public function getValue($array, $key, $default = null) {
    $keys = explode("|", $key);
    if (!isset($array[$key])) {
      foreach ($keys as $key) {
        if (isset($array[$key])) {
          $array = $array[$key];
        } else {
          return $default;
        }
      }
      return $array; 
    } else {
      return $array[$key]; 
    }
  }
  
  public function existValue($array, $key) {
    $keys = explode("|", $key);
    if (!isset($array[$key])) {
      foreach ($keys as $key) {
        if (isset($array[$key])) {
          $array = $array[$key];
        } else {
          return false;
        }
      }
    } 
    
    return true; 
  }

  public function get($key, $from, $default = null) {

    switch ($from) {
      case 'game':
        return $this->getValue($this->gameData, $key, $default);
        break;
      case 'round':
        return $this->getValue($this->roundData, $key, $default);
        break;
      case 'decision':
        return $this->getValue($this->roundDecisionData, $key, $default);
        break;
      case 'raport':
        return $this->getValue($this->roundRaportData, $key, $default);
        break;
      case 'last_round':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        return $this->getValue($this->lastRoundData, $key, $default);
        break;
      case 'last_decision':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        return $this->getValue($this->lastRoundDecisionData, $key, $default);
        break;
      case 'last_raport':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        return $this->getValue($this->lastRoundRaportData, $key, $default);
        break;
      default:
        throw new sfException('Probujesz pobrac dane ktore nie istnieja.');
        break;
    }
  }

  public function getAll($from) {
    switch ($from) {
      case 'game':
        return $this->gameData;
        break;
      case 'round':
        return $this->roundData;
        break;
      case 'decision':
        return $this->roundDecisionData;
        break;
      case 'raport':
        return $this->roundRaportData;
        break;
      case 'last_round':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        return $this->lastRoundData;
        break;
      case 'last_decision':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        return $this->lastRoundDecisionData;
        break;
      case 'last_raport':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        return $this->lastRoundRaportData;
        break;
      default:
        throw new sfException('Probujesz pobrac dane ktore nie istnieja.');
        break;
    }
  }

  public function exist($key, $from) {
    switch ($from) {
      case 'game':
        return $this->existValue($this->gameData, $key);
        break;
      case 'round':
        return $this->existValue($this->roundData, $key);
        break;
      case 'decision':
        return $this->existValue($this->roundDecisionData, $key);
        break;
      case 'raport':
        return $this->existValue($this->roundRaportData, $key);
        break;
      case 'last_round':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        return $this->existValue($this->lastRoundData, $key);
        break;
      case 'last_decision':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        return $this->existValue($this->lastRoundDecisionData, $key);
        break;
      case 'last_raport':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        return $this->existValue($this->lastRoundRaportData, $key);
        break;
      default:
        throw new sfException('Probujesz pobrac dane ktore nie istnieja.');
        break;
    }
  }

  public function set($key, $value, $to) {
    switch ($to) {
      case 'game':
        $this->gameData[$key] = $value;
        $this->gameModified = self::MODIFIED;
        break;
      case 'round':
        $this->roundData[$key] = $value;
        $this->roundModified = self::MODIFIED;
        break;
      case 'decision':
        $this->roundDecisionData[$key] = $value;
        $this->roundModified = self::MODIFIED;
        break;
      case 'raport':
        $this->roundRaportData[$key] = $value;
        $this->roundModified = self::MODIFIED;
        break;
      case 'last_round':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        $this->lastRoundData[$key] = $value;
        $this->lastRoundModified = self::MODIFIED;
        break;
      case 'last_decision':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        $this->lastRoundDecisionData[$key] = $value;
        $this->lastRoundModified = self::MODIFIED;
        break;
      case 'last_raport':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz pobrac dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        $this->lastRoundRaportData[$key] = $value;
        $this->lastRoundModified = self::MODIFIED;
        break;
      default:
        throw new sfException('Probujesz ustawic dane ktore nie istnieja.');
        break;
    }
  }

  public function setAll($value, $to) {
    switch ($to) {
      case 'game':
        $this->gameData = $value;
        $this->gameModified = self::MODIFIED;
        break;
      case 'round':
        $this->roundData = $value;
        $this->roundModified = self::MODIFIED;
        break;
      case 'decision':
        $this->roundDecisionData = $value;
        $this->roundModified = self::MODIFIED;
        break;
      case 'raport':
        $this->roundRaportData = $value;
        $this->roundModified = self::MODIFIED;
        break;
      case 'last_round':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz ustawic dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        $this->lastRoundData = $value;
        $this->lastRoundModified = self::MODIFIED;
        break;
      case 'last_decision':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz ustawic dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        $this->lastRoundDecisionData = $value;
        $this->lastRoundModified = self::MODIFIED;
        break;
      case 'last_raport':
        if (!$this->hasLastRound()) {
          throw new sfException('Probojesz ustawic dane ktore nie istnieja. Odwolujesz sie do poprzedniej rundy ktorej nie ma');
        }
        $this->lastRoundRaportData = $value;
        $this->lastRoundModified = self::MODIFIED;
        break;
      default:
        throw new sfException('Probujesz ustawic dane ktore nie istnieja.');
        break;
    }
  }
}