<?php
/**
 * Klasa bazowa dla gry, udostepnia metody dostepowe do stanu gry oraz klas przeznaczonych
 * do zarzadzania poszczegolnymi elementami
 */
abstract class BaseGameFunctions
{
    /** Klasy obslugujace gre */
    protected $gameController = null;
    public $logger;
      
    public function __construct(BaseGameController $gameController) {
      $this->gameController = $gameController;
      $this->logger = sfContext::getInstance()->getLogger();
    }
    
    public function logP($text, $value) {
      $this->getGameLog()->logP($text, $value);
    }
    
    public function logK($text, $value) {
      $this->getGameLog()->logK($text, $value);
    }
    
    public function logI($text, $value) {
      $this->getGameLog()->logI($text, $value);
    }
    
    public function logW($text, $value) {
      $this->getGameLog()->logW($text, $value);
    }
    
    public function e($key, $from)
    {
        return $this->exist($key, $from);
    }

    public function exist($key, $from)
    {
        if (is_null($this->getGameData())) {
            throw new sfException('Brak klasy GameData');
        } else {
            return $this->getGameData()->exist($key, $from);
        }
    }

    public function g($key, $from, $default = null)
    {
        return $this->get($key, $from, $default);
    }

    public function get($key, $from, $default = null)
    {
        if (is_null($this->getGameData())) {
            throw new sfException('Brak klasy GameData');
        } else {
            return $this->getGameData()->get($key, $from, $default);
        }
    }

    public function getAll($from)
    {
        if (is_null($this->getGameData())) {
            throw new sfException('Brak klasy GameData');
        } else {
            return $this->getGameData()->getAll($from);
        }
    }

    public function s($key, $value, $to)
    {
        $this->set($key, $value, $to);
    }

    protected function set($key, $value, $to)
    {
        if (is_null($this->getGameData())) {
            throw new sfException('Brak klasy GameData');
        } else {
            $this->getGameData()->set($key, $value, $to);
        }
    }

    protected function setAll($value, $to)
    {
        if (is_null($this->getGameData())) {
            throw new sfException('Brak klasy GameData');
        } else {
            $this->getGameData()->setAll($value, $to);
        }
    }
    
    /**
     * Funkcja zwraca klase BaseGameValidator dla gry korzystajac z $gameController
     * @return object BaseGameValidator
     */
    public function getGameValidator()
    {
      return $this->gameController->getGameValidator();
    }

    /**
     * Funkcja zwraca klase BaseGameData dla gry korzystajac z $gameController
     * @return object BaseGameData
     * @throws sfException Gdy BaseGameData nie istnieje
     */
    public function getGameData()
    {
      return $this->gameController->getGameData();
    }

    /**
     * Funkcja zwraca klase BaseGameDecision dla gry korzystajac z $gameController
     * @return object BaseGameDecision
     */
    public function getGameDecision()
    {
        return $this->gameController->getGameDecision();
    }

    /**
     * Funkcja zwraca klase BaseGameProcess dla gry korzystajac z $gameController
     * @return object BaseGameProcess
     */
    public function getGameProcess()
    {
        return $this->gameController->getGameProcess();
    }

    /**
     * Funkcja zwraca klase BaseGameView dla gry korzystajac z $gameController
     * @return object BaseGameView
     */
    public function getGameView()
    {
        return $this->gameController->getGameView();
    }

    /**
     * Funkcja zwraca klase BaseGameMessage dla gry korzystajac z $gameController
     * @return object BaseGameMessage
     */
    public function getGameMessage()
    {
       return $this->gameController->getGameMessage();
    }
    
    /**
     * Funkcja zwraca klase BaseGameLog dla gry korzystajac z $gameController
     * @return object BaseGameLog
     */
    public function getGameLog()
    {
       return $this->gameController->getGameLog();
    }
}
