<?php
/**
 * Klasa bazowa logowania wydarzen (roznych nie chodzi o tylko wydarzenia w grze)
 */
abstract class BaseGameLog extends HotelGameFunctions
{
  protected $pendingLog = array();
  
  protected $events = array(
      'Popyt',
      'Koszty',
      'Wspolczynnik',
      'Inne'
  );
  
  public function save() {
    $colection = new Doctrine_Collection('LogEvent');

    foreach ($this->pendingLog as $log) {
      $logObj = new LogEvent();
      foreach ($log as $key => $value) {
        $logObj->set($key, $value);
      }

      $colection->add($logObj);
    }

    $colection->save();
    $this->pendingLog = array();
  }
  
  public function log($event, $text, $value) {
    return;
    $teamId = $this->getGameData()->getTeam()->getId();
    $userId = $this->gameController->getUserId();
    $roundId = $this->getGameData()->getRound()->getId();
    // Dopisanie do tablicy
    
    // Nie dopisujemy jako obiekt poniewaz duzo obiektow = duzo pamieci
    $this->pendingLog[] = array(
        'team_id' => $teamId,
        'user_id' => $userId,
        'round_id' => $roundId,
        'event' => $event,
        'text' => $text,
        'value' => $value
    );
  }
  
  /**
   * Loguje event zwiazany z popytem
   * @param string $text
   * @param string $value 
   */
  public function logP($text, $value) {
    $this->log($this->events[0], $text, $value);
  }
  
  /**
   * Loguje event zwiazany z kosztami
   * @param string $text
   * @param string $value 
   */
  public function logK($text, $value) {
    $this->log($this->events[1], $text, $value);
  }
  
  /**
   * Loguje event obliczania wspolczynnika
   * @param string $text
   * @param string $value 
   */
  public function logW($text, $value) {
    $this->log($this->events[2], $text, $value);
  }
  
  /**
   * Loguje event inny
   * @param string $text
   * @param string $value 
   */
  public function logI($text, $value) {
    $this->log($this->events[3], $text, $value);
  }
  
  /**
   * Zwraca wystepujace nazwy eventow
   * @return array 
   */
  public function getEvents() {
    return $this->events;
  }
}