<?php

/**
 * Klasa z metodami do obsługi widoku. Pobrania komponentów, partiali itp.
 */
sfContext::getInstance()->getConfiguration()->loadHelpers(array('ArteneoJQuery'));

class View {

  /**
   * Pobiera partial i zwraca opakowany widok.
   *
   * @param $templateName
   * @param array $vars
   * @param app, aplikacja
   * @return mixed
   */
  public static function getPartial($templateName, $vars = array(), $app = null) {
    $activeApp = sfContext::getInstance()->getConfiguration()->getApplication();

    if ($app) {
      sfContext::switchTo($app);
      $context = sfContext::getInstance();
    } else {
      $context = sfContext::getInstance();
    }

    if (false !== $sep = strpos($templateName, '/')) {
      $moduleName = substr($templateName, 0, $sep);
      $templateName = substr($templateName, $sep + 1);
    } else {
      $moduleName = $context->getActionStack()->getLastEntry()->getModuleName();
    }

    $actionName = '_' . $templateName;

    $view = new sfPartialView($context, $moduleName, $actionName, '');
    $view->setPartialVars(true === sfConfig::get('sf_escaping_strategy') ? sfOutputEscaper::unescape($vars) : $vars);

    if ($app) {
      sfContext::switchTo($activeApp);
    }

    return $view->render();
  }

  /**
   * Pobiera komponent zawraca opakowany widok.
   *
   * @param $moduleName
   * @param $componentName
   * @param array $vars
   * @return mixed
   */
  public static function getComponent($moduleName, $componentName, $vars = array()) {
    $context = sfContext::getInstance();
    $actionName = '_' . $componentName;

    $view = new artPartialView($context, $moduleName, $actionName, '');

    $view->setPartialVars(true === sfConfig::get('sf_escaping_strategy') ? sfOutputEscaper::unescape($vars) : $vars);

    if ($retval = $view->getCache()) {
      return $retval;
    }

    $allVars = View::callComponent($moduleName, $componentName, $vars);

    if (null !== $allVars) {
      $view->getAttributeHolder()->add($allVars);

      return $view->render();
    }
  }

  /**
   * Uruchamia komponent i zwraca wynik, (String).
   *
   * @param $moduleName
   * @param $componentName
   * @param $vars
   * @return array|null
   * @throws sfInitializationException
   * @throws sfConfigurationException
   */
  public static function callComponent($moduleName, $componentName, $vars) {
    $context = sfContext::getInstance();

    $controller = $context->getController();

    if (!$controller->componentExists($moduleName, $componentName)) {
      throw new sfConfigurationException(sprintf('The component does not exist: "%s", "%s".', $moduleName, $componentName));
    }

    $componentInstance = $controller->getComponent($moduleName, $componentName);

    require($context->getConfigCache()->checkConfig('modules/' . $moduleName . '/config/module.yml'));

    $componentInstance->getVarHolder()->add(true === sfConfig::get('sf_escaping_strategy') ? sfOutputEscaper::unescape($vars) : $vars);

    $componentToRun = 'execute' . ucfirst($componentName);
    if (!method_exists($componentInstance, $componentToRun)) {
      if (!method_exists($componentInstance, 'execute')) {
        throw new sfInitializationException(sprintf('sfComponent initialization failed for module "%s", component "%s".', $moduleName, $componentName));
      }

      $componentToRun = 'execute';
    }

    if (sfConfig::get('sf_logging_enabled')) {
      $context->getEventDispatcher()->notify(new sfEvent(null, 'application.log', array(sprintf('Call "%s->%s()' . '"', $moduleName, $componentToRun))));
    }

    if (sfConfig::get('sf_debug') && sfConfig::get('sf_logging_enabled')) {
      $timer = sfTimerManager::getTimer(sprintf('Component "%s/%s"', $moduleName, $componentName));
    }

    $retval = $componentInstance->$componentToRun($context->getRequest());


    if (sfConfig::get('sf_debug') && sfConfig::get('sf_logging_enabled')) {
      $timer->addTime();
    }

    return sfView::NONE == $retval ? null : $componentInstance->getVarHolder()->getAll();
  }

  /**
   * Inkluduje metody z Helpera;
   *
   * @param $helperName
   */
  public static function useHelper($helperName) {

    static $loaded = array();

    if (isset($loaded[$helperName])) {
      return;
    }

    if (is_readable(sfConfig::get('sf_symfony_lib_dir') . '/helper/' . $helperName . 'Helper.php')) {
      include_once(sfConfig::get('sf_symfony_lib_dir') . '/helper/' . $helperName . 'Helper.php');
    } else if (is_readable(sfConfig::get('sf_app_module_dir') . '/' . sfContext::getInstance()->getModuleName() . '/' . sfConfig::get('sf_app_module_lib_dir_name') . '/helper/' . $helperName . 'Helper.php')) {
      include_once(sfConfig::get('sf_app_module_dir') . '/' . sfContext::getInstance()->getModuleName() . '/' . sfConfig::get('sf_app_module_lib_dir_name') . '/helper/' . $helperName . 'Helper.php');
    } else {
      include_once('helper/' . $helperName . 'Helper.php');
    }
    $loaded[$helperName] = true;
  }

  public static function linkToRemote($name, $options = array(), $html_options = array()) {
    return jq_link_to_function($name, jq_remote_function($options), $html_options);
  }

}
