<?php

/**
 * Description of MenuCache
 *

 */
class BackendGroupMenuGenerator extends BaseGroupMenuGenerator {

  /**
   * Funkcja zwraca wartosci default dla ustawien
   * 
   * @return array
   */
  protected function getDefaultSettings() {
    return array(
      'active_class' => 'active',
      'first_class' => 'first',
      'last_class' => 'last',
      'li' => array(
        'class' => '',
      ),
      'ul' => array(
        'class' => 'nav nav-list',
      ),
      'div' => array(
        'id' => 'sidebar',
        'class' => 'nav-collapse',
      ),
      'ul_submenu' => array(
        'class' => 'submenu',
      ),
      'span' => array(
        'class' => 'menu-span',
      ),
      'a' => array(
        'class' => 'menu-a',
      ),
      'article_url' => 'article_show',
      'category_url' => 'article_list',
      'empty_url' => 'javascript:void(0);',
      'separator' => false,
    );
  }

  protected function generateItem($menuItem, $depth) {
    // Zapytac czy nie lepiej tutaj dac tez dane z JSON'a (dopisywac lub nadpisywac dane do taga)
    $content = '';

    $liOptions = $this->getSettings('li', $menuItem);
    if ($menuItem['first']) {
      // Pierwszy
      $liOptions['class'] .= ' ' . $this->getSettings('first_class', $menuItem);
    } else {
      // Generowanie separatora
      $content .= $this->generateSeparator($menuItem);
    }

    if ($menuItem['last']) {
      // Ostatni
      $liOptions['class'] .= ' ' . $this->getSettings('last_class', $menuItem);
    }

    // Musimy zastosowac tutaj taki trick, bo tag() nam escapuje znaki <?php
    $liOptions['class'] .= '%isActiveString%';
    $content .= str_replace('%isActiveString%', $this->getIsActiveString($menuItem), tag('li', $liOptions, true));

    $aOptions = $this->settings['a'];
    $aOptions['href'] = $this->getItemUrl($menuItem);
    if ($depth == 1 && $menuItem['submenu_id']) {
      $aOptions['class'] .= ' dropdown-toggle';
    }
    $content .= tag('a', $aOptions, true);

    if ($depth == 1) {
      if (isset($menuItem['json']['icon'])) {
        $content .= '<i class="' . $menuItem['json']['icon'] . '"></i>';
      } else {
        $content .= '<i class="icon-question"></i>';
      }
    }

    $content .= content_tag('span', $this->getItemTitle($menuItem));

    if ($depth == 1 && $menuItem['submenu_id']) {
      $content .= '<b class="arrow icon-angle-right"></b>';
    }
    $content .= '</a>';

    if ($menuItem['submenu_id']) {
      $content .= $this->generateSubmenu($this->dataCollector->getMenuGroup($menuItem['submenu_id']), ++$depth);
    }

    $content .= '</li>';
    return $content;
  }

  /**
   * Tworzy gore menu pierwszego poziomu
   * 
   * @return string 
   */
  protected function generateTopMenu($menuGroup) {
    $content = tag('div', $this->settings['div'], true);
    $content .= $this->actionBar->generateActionBar($this->getManagingItem($menuGroup));
    $content .= tag('ul', $this->settings['ul'], true);
    return $content;
  }

  /**
   * Tworzy dol menu pierwszego poziomu
   * 
   * @return string 
   */
  protected function generateBottomMenu() {
    return '</ul><div id="sidebar-collapse" class="visible-desktop">
            <i class="icon-double-angle-left"></i>
            </div></div>';
  }

  /**
   * Tworzy gore dla menu drugiego i nizszych poziomow
   * 
   * @return string 
   */
  protected function generateTopSubmenu() {
    $content = tag('ul', $this->settings['ul_submenu'], true);
    return $content;
  }

  /**
   * Tworzy dol dla submenu
   * @return string 
   */
  protected function generateBottomSubmenu() {
    return '</ul>';
  }

}

?>
