
<?php

class FmActionBar extends BaseFmActionBar {

  /**
   * Konstruktor przyjmuje ustawienia oraz nazwe klasy collectora.
   * 
   * @param object $object Obiekt artykulu lub kategorii
   * @param array $settings
   * @param string $dataCollectorClass 
   */
  public function __construct($object, $settings = array()) {

    artEscaper::escape($object);
    $this->initSettings($settings);
    $this->object = $object;

    // Rejestrujemy dostepne linki
    $this->registerLink('article_edit');
    
    $this->registerLink('article_photo_add');
    $this->registerLink('article_photo_list_order');
    $this->registerLink('article_photo_list');
////    $this->registerLink('article_meta_edit');
//    
//    $this->registerLink('article_add');
//    $this->registerLink('category_edit');
//    
//    $this->registerLink('comment_edit');
//    
//    $this->registerLink('article_layout');
//    $this->registerLink('category_layout');
//    $this->registerLink('article_delete');
//    $this->registerLink('comment_delete');
//    $this->registerLink('category_delete');
  }
  

  protected function getArticlePhotoListOrder() {
    if (sfContext::getInstance()->getUser()->isTranslator()) {
      $data = $this->prepareLink();
      $data['a']['onclick'] = "ManageForm.articlePhotoListOrder(this, '" . $this->object->getId() . "');";
      $data['i']['class'] .= " glyphicon glyphicon-sort";
      $data['text'] = __('Ustaw kolejność zdjęć');
      return $data;
    } else {
      return false;
    }
  }
  
  protected function getArticlePhotoList() {
    if (sfContext::getInstance()->getUser()->isTranslator()) {
      $data = $this->prepareLink();
      $data['a']['onclick'] = "ManageForm.articlePhotoList(this, '" . $this->object->getId() . "', '1');";
      $data['i']['class'] .= " glyphicon glyphicon-list";
      $data['text'] = __('Zarządzaj zdjęciami');
      return $data;
    } else {
      return false;
    }
  }
  
  protected function getArticlePhotoAdd() {
    if (sfContext::getInstance()->getUser()->isTranslator()) {
      $data = $this->prepareLink();
      $data['a']['onclick'] = "ManageForm.articlePhotoAdd(this, '" . $this->object->getId() . "');";
      $data['i']['class'] .= " glyphicon glyphicon-plus";
      $data['text'] = __('Dodaj zdjęcie');
      return $data;
    } else {
      return false;
    }
  }

    protected function checkLinks() {
    foreach ($this->links as $link) {
      if ($this->checkLink($link)) {
        return true;
      }
    }

    return false;
  }

  protected function getUser() {
    return sfContext::getInstance()->getUser();
  }

  protected function checkLink($link) {
    $method = 'get' . sfInflector::camelize($link);
    if (method_exists($this, $method)) {
//      if (!$this->getUser()->hasFmLink($link)) {
//        return false;
//      }

      $generate = $this->$method();

      if ($generate === false) {
        return false;
      } else {
        return true;
      }
    } else {
      throw new sfException('Brak metody "' . $method . '" do generowania linka.');
    }
  }
  
  
  /**
   * Funkcja zwraca wartosci default dla ustawien.
   * 
   * @return array
   */
  protected function getDefaultSettings() {
    return array(
      'blacklist' => null, // Tablica z wyłaczonymi linkami dod anego FM AcB.
      'whitelist' => null, // Tablica z właczonymi linkami dod anego FM AcB.
      'enabled' => true,
      'empty_url' => 'javascript:void(0);',
      'div' => array(
        'class' => 'options-container pa',
      ),
      'options_icon' => array(
        'class' => 'cp icon icon-cog frontend-management',
        'onclick' => 'toggleActionBar(this);',
      ),
      'ul' => array(
        'class' => 'action-bar hide actionbar-menu indicator',
      ),
      'li' => array(
        'class' => 'w100 fl',
      ),
      'span' => array(
        'class' => 'mab-link w100 fl',
      ),
      'a' => array(
        'class' => 'w100 p0 fl',
      ),
      'i' => array(
        'class' => 'fl mt2 mr5 ml5',
      ),
      'a_span' => array(
        'class' => 'link-text fl',
      ),
    );
  }

  protected function getArticleEdit() {
    $article = Doctrine::getTable('Article')->getArticleByTitle($this->object->getTitle());
    if ($article && sfContext::getInstance()->getUser()->isTranslator()) {
      $data = $this->prepareLink();
      $data['a']['onclick'] = "ManageForm.articleEdit(this, '" . $article->getId() . "');";
      $data['i']['class'] .= " glyphicon glyphicon-pencil";
      $data['text'] = __('Edytuj treść');
      return $data;
    } else {
      return false;
    }
  }
  
  /**
   * Funkcja odpowiedzialna za caly proces tworzenia ikonki i menu paska akcji.
   * Jesli 'enabled' = false lub 'app_fm_enabled' = false - nic nam nie zwroci. 
   * W przeciwnym wypadku zwraca kod HTML i PHP zawierajacy ikonke i menu paska
   * akcji.
   * 
   * @return string 
   */
  public function generateActionBar() {
    // Sprawdzamy czy jest wszystko powlaczane i czy wogule uzytkownik ma prawa
    // do wyswietlenia chociaz jednego linku
    if (!$this->settings['enabled'] || !sfConfig::get('app_fm_enabled', false) || !$this->checkLinks() || !$this->getUser()->hasAnyFmLink($this->links)) {
      // Jesli jest nie aktywny lub wylaczony w app.yml to nic nie zwracaj
      return '';
    } else {
      $content = tag('div', $this->settings['div'], true);
      $content .= tag('i', $this->settings['options_icon'], true);

      $content .= content_tag('ul', $this->generateLinks(), $this->settings['ul']);

      $content .= '</i>';
      $content .= '</div>';
      
      return $content;
    }
  }
}