<?php

/**
 *
 */
class artHotelMessageFormat extends artMessageFormat {

  /**
   * @param string $string
   * @param array $args
   * @param null $catalogue
   * @param null $charset
   * @param null $edit
   * @return string
   */
  public function format($string, $args = array(), $catalogue = null, $charset = null, $edit = false) {
    $string = (string) $string;
    if (empty($charset)) {
      $charset = $this->getCharset();
    }

    $s = $this->formatString(sfToolkit::I18N_toUTF8($string, $charset), $args, $catalogue, $edit);

    return sfToolkit::I18N_toEncoding($s, $charset);
  }

  /**
   * @param string $string
   * @param array $args
   * @param null $catalogue
   * @return string
   */
  protected function formatString($string, $args = array(), $catalogue = null, $edit = false) {

    $user = sfContext::getInstance()->getUser();
    $editp = sfContext::getInstance()->getUser()->getAttribute('i18n_edit', false);

    if (empty($args)) {
      $args = array();
    }

    if (empty($catalogue)) {
      $catalogue = empty($this->catalogue) ? 'messages' : $this->catalogue;
    }

    $this->loadCatalogue($catalogue);

    foreach ($this->messages[$catalogue] as $variant) {

      if (isset($variant[$string])) {
        $databaseId = $variant[$string][1];

        $target = $variant[$string];

        if (is_array($target)) {
          $target = array_shift($target);
        }

        if (empty($target)) {
          if ($edit === "title" && $user->isTranslator() && $editp) {
            return str_replace('"', '\'\'', $this->postscript[0]) . '" onclick="var r=confirm(__(\'Zmienić tłumaczenie ?\'))
          if (r==true)
            {
            I18n.editTitleTransaltion(' . $databaseId . ', \''.$catalogue.'\'); 
            }
          else
            {
            }"';
          }

          if ($edit) {
            return $this->postscript[0] . $this->replaceArgs($string, $args) . $this->postscript[1] . $this->editLink($databaseId, $catalogue);
          } else {
            return $this->postscript[0] . $this->replaceArgs($string, $args) . $this->postscript[1];
          }
        }

        if ($edit === "title" && $user->isTranslator() && $editp) {
          return $this->replaceArgs(str_replace('"', '\'\'', $target) . '" onclick="var r=confirm(__(\'Zmienić tłumaczenie ?\'))
          if (r==true)
            {
            I18n.editTransaltion(' . $databaseId . ', \''.$catalogue.'\'); 
            }
          else
            {
            }"', $args);
        }
        if ($edit) {
          return $this->replaceArgs($target . $this->editLink($databaseId, $catalogue), $args);
        } else {
          return $this->replaceArgs($target, $args);
        }
      }
    }

    $this->source->append($string);

    if ($edit === "title" && $user->isTranslator() && $editp) {
      return str_replace('"', '\'\'', $this->postscript[0]) . $this->replaceArgs($string, $args) . '" onclick="var r=confirm(__(\'Dodać tłumaczenie ?\'))
          if (r==true)
            {
            I18n.addTransaltion(\'' . html_entity_decode($string) . '\', \''.$catalogue.'\'); 
              return false;
            }
          else
            {
            }"';
    }

    if ($edit) {
      return $this->postscript[0] . $this->replaceArgs($string, $args) . $this->postscript[1] . $this->newLink($string, $catalogue);
    } else {
      return $this->postscript[0] . $this->replaceArgs($string, $args) . $this->postscript[1];
    }
  }

  /**
   * @param $databaseId
   * @return string
   */
  private function editLink($databaseId, $catalogue) {
    $user = sfContext::getInstance()->getUser();
    $edit = sfContext::getInstance()->getUser()->getAttribute('i18n_edit', false);

    if ($user->isTranslator() && $edit) {
      return View::linkToRemote('<i class="icon-flag"></i>', array(
                  'update' => 'modalContainer',
                  'url' => '@art_i18n_single_translation_edit?id=' . $databaseId . '&catalogue=' . $catalogue,
                  'loading' => ' I18n.modalLoading();',
                  'complete' => 'I18n.modalSuccess();',
                      ), array(
                  'class' => 'translations',
                  'title' => __('Zmień tłumaczenie'),
      ));
    }
  }

  /**
   * @return string
   */
  private function newLink($text, $catalogue) {
    $user = sfContext::getInstance()->getUser();
    $edit = sfContext::getInstance()->getUser()->getAttribute('i18n_edit', false);

    if ($user->isTranslator() && $edit) {
      return View::linkToRemote('<i class="icon-flag"></i>', array(
                  'update' => 'modalContainer',
                  'url' => '@art_i18n_single_translation_edit?text=' . html_entity_decode($text) . '&catalogue=' . $catalogue,
                  'loading' => ' I18n.modalLoading();',
                  'complete' => 'I18n.modalSuccess();',
                      ), array(
                  'class' => 'translations',
                  'title' => __('Dodaj tłumaczenie')
      ));
    }
  }

}

