<?php

class ActionBar extends BaseActionBar {

  public function generateActionBar($element, $elementData) {
    if (!$this->settings['enabled'] || !sfConfig::get('app_fm_enabled', false) || true) {
      // Jesli jest nie aktywny lub wylaczony w app.yml to nic nie zwracaj
      return;
    } else {
      // Jesli jest aktywny, wykonaj logike, zwroc HTML
      $element = $this->initElement($element, $elementData);

      $content = $this->generateOpenOptionsContainer($element, $elementData);

      $content .= $this->generateOptionsIcon($element, $elementData);

      $content .= $this->generateOptionsMenu($element, $elementData);

      $content .= $this->generateCloseOptionsContainer($element, $elementData);

      return $content;
    }
  }
  
    /**
   * Funkcja zwraca HTML i kod PHP na podstawie podanego
   * klucza linku do wygenerowania $link i przekazego elementu
   * 
   * @param string $link
   * @param array $element
   * @param array $elementData
   * @return string 
   */
  protected function generateLink($link, $element, $elementData) {
    $data = $this->getLinkData($link, $element, $elementData);
    // Sprawdzenie czy user moze widziec dany link

    $content = '<li class="'.$element['li_class'].'">';
    $content .= '<span class="'.$element['span_class'].'">';
    
    if (isset($data['url']) && $data['url']) {
      $content .= '<a href="'.url_for($data['url']).'"';  
    } else {
      $content .= '<a href="'.$element['empty_url'].'"';
    }
    
    if (isset($data['onclick']) && $data['onclick']) {
      $content .= ' onclick="'.$data['onclick'].'"';
    }
    
    $content .= ' class="'.$element['a_class'].'">';
    $content .= '<i class="'.$data['class'].'"></i>';
    $content .= '<span class="'.$element['a_text_class'].'">'.$data['text'].'</span>';
    $content .= '</a></span></li>';
    return $content;
  }
  

}
?>
