<?php

class UserActionBar extends BaseUserActionBar
{

    /**
   * Funkcja zwraca wartosci default dla ustawien linkow. Jest odlaczona od
   * getDefaultSettings(), aby mozna bylo pobrac jakie linki mamy generowac.
   * Na podstawie kluczy w zwracanej tablicy sa generowane linki przez
   * funkcje generateOptionsMenu()
   * 
   * @return array
   */
  protected function getDefaultLinksSettings() {
    return array(
        'change_password' => true,
//        'show_fm_icons' => true,
//        'hide_fm_icons' => true,
        'enable_translations' => true,
        'disable_translations' => true,
        'translations_list' => true,
        'art_configuration' => true,
        'djf_round' => true,
        'djf_decision' => true,
        'djf_raport' => true,
        'djf_last_round' => true,
        'djf_last_decision' => true,
        'djf_last_raport' => true,
        'pn' => true,
        'logout' => true,
    );
  }
  
  /**
   * Funkcja tworzy dane o linku na podstawie przekazanych elementow. Dane sa
   * wykorzystywane przez funkcje generateLink()
   * 
   * @param string $link
   * @param array $element
   * @param array $elementData
   * @return array 
   */
  protected function getLinkData($link, $element, $elementData) {
    $data = array();
    // Wszystkie URL akurat sa na onclick'u
    $data['url'] = false;
    // Dodajemy standardowe klasy zeby ladnie link wygladal
    $data['class'] = 'fl mt2 mr5 ml5 ';
    // URL miedzy aplikacjami
    $data['cross_app'] = false;
    
    switch ($link) {
      case 'change_password':
        $data['onclick'] = "changePasswordPopupOpen($(this));";
        $data['class'] .= "icon-wrench";
        $data['text'] = __('Zmień hasło');
        break;
      case 'show_fm_icons':
        $data['onclick'] = "showFMIcons();";
        $data['class'] .= "icon-eye-open";
        $data['li_class'] = $element['li_class'].' hide';
        $data['text'] = __('Pokaż ikonki');
        break;
      case 'hide_fm_icons':
        $data['onclick'] = "hideFMIcons();";
        $data['class'] .= "icon-eye-close";
        $data['text'] = __('Ukryj ikonki');
        break;
      case 'enable_translations':
        $data['onclick'] = "window.location = Routing.generate('set_i18n');";
        $data['class'] .= "icon-flag";
        $data['text'] = __('Włącz edycję tłumaczeń');
        break;
      case 'disable_translations':
        $data['onclick'] = "window.location = Routing.generate('set_i18n');";
        $data['class'] .= "icon-flag";
        $data['text'] = __('Wyłącz edycję tłumaczeń');
        break;
      case 'translations_list':
        $data['onclick'] = "I18n.showList();";
        $data['class'] .= "icon-flag";
        $data['text'] = __('Lista tłumaczeń');
        break;
      case 'art_configuration':
        $data['onclick'] = "artConfigurationList($(this));";
        $data['class'] .= "icon-cog";
        $data['text'] = __('Konfiguracja');
        break;
      case 'pn':
        $data['url'] = '@pnGame';
        $data['class'] .= "icon-cog";
        $data['text'] = __('Panel nauczyciela');
        $data['cross_app'] = true;
        break;
      case 'logout':
        $data['url'] = "sf_guard_signout";
        $data['class'] .= "icon-off";
        $data['text'] = __('Wyloguj');
        break;
      case 'djf_round':
        $data['url'] = "@data_json_form?type=round";
        $data['class'] .= "icon-cog";
        $data['text'] = __('Zmienne rundy');
        break;
      case 'djf_decision':
        $data['url'] = "@data_json_form?type=decision";
        $data['class'] .= "icon-cog";
        $data['text'] = __('Zmienne decyzji');
        break;
      case 'djf_raport':
        $data['url'] = "@data_json_form?type=raport";
        $data['class'] .= "icon-cog";
        $data['text'] = __('Zmienne raportow');
        break;
      case 'djf_last_round':
        $data['url'] = "@data_json_form?type=last_round";
        $data['class'] .= "icon-cog";
        $data['text'] = __('Zmienne rundy - Poprzednia runda');
        break;
      case 'djf_last_decision':
        $data['url'] = "@data_json_form?type=last_decision";
        $data['class'] .= "icon-cog";
        $data['text'] = __('Zmienne decyzji - Poprzednia runda');
        break;
      case 'djf_last_raport':
        $data['url'] = "@data_json_form?type=last_raport";
        $data['class'] .= "icon-cog";
        $data['text'] = __('Zmienne raportow - Poprzednia runda');
        break;
    }
    
    return $data;
  }
  
  protected function getPermissionString($link) {
    switch ($link) {
      case 'enable_translations':
        return '<?php if (!$sf_user->getAttribute(\'i18n_edit\', false) && $sf_user->hasFmLink(\'translation_edit\')) : ?>';
        break;
      case 'disable_translations':
        return '<?php if ($sf_user->getAttribute(\'i18n_edit\', false) && $sf_user->hasFmLink(\'translation_edit\')) : ?>';
        break;
      case 'translations_list':
        return '<?php if ($sf_user->hasFmLink(\'translation_edit\')) : ?>';
        break;
      case 'art_configuration':
        return '<?php if ($sf_user->isAdmin()) : ?>';
        break;
      case 'djf_round':
      case 'djf_decision':
      case 'djf_raport':
      case 'djf_last_round':
      case 'djf_last_decision':
      case 'djf_last_raport':
        return '<?php if ($sf_user->isTester()) : ?>';
        break;
      case 'pn':
        return '<?php if ($sf_user->isTeacher() || $sf_user->isTeacherDemo()) : ?>';
        break;
    }
    
    return '';
  }

}

?>
