<?php

/**
 * Klasa zawierająca funkcje do wysylania wiadomości email.
 *
 * @package    artMessangerPlugin
 */
class MessageSender extends PluginMessageSender {

  /**
   * Funkcja wysyla wiadomosc zdefiniowana w parametrach
   * 
   * @param string $from Adresat
   * @param string $to Odbiorca
   * @param string $body Tresc wiadomosci
   * @param string $title Tytul wiadomosci
   * @param array $attachments Zalaczniki (nie testowane)
   */
  public function send($from, $to, $body, $title, $attachments = array()) {
    $msg = new Swift_Message($title);
    $msg->setTo($to);
    $msg->setFrom(array('mailer@email.arteneo.pl' => 'HotelStars'));
    $msg->setBody($this->addEmbedFilesToLayout($msg, $body), "text/html");

    $this->addAttachments($msg, $attachments);

    $mailer = sfContext::getInstance()->getMailer();
    $mailer->sendNextImmediately()->send($msg);
  }

}
