<?php

/**
 * Game
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    hotel
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
class Game extends BaseGame {

  const INACTIVE = 0;
  const ACTIVE = 1;
  const ARCHIVE = 2;
  const PREPARED = 3;

  public function isPrepared() {
    return $this->getStatus() == self::PREPARED;
  }

  public function isActive() {
    return $this->getStatus() == self::ACTIVE;
  }
  
  public function canManageTeams() {
    return $this->isInactive() || $this->isPrepared();
  }

  public function hasNextRound() {
    return ($this->isActive() && $this->getRoundNum() < HotelGameProcess::LAST_ROUND);
  }

  public function hasTeams() {
    $teams = $this->getUsersCount();

    return $teams > 0;
  }

  public function canBeReversed() {
    return ($this->isActive()) && ($this->getRoundNum() > HotelGameProcess::FIRST_ROUND);
  }
  
  public function canBeArchived() {
    return $this->getRoundNum() >= HotelGameProcess::LAST_ROUND;
  }

  public function canBeActivated() {
    return $this->isPrepared() || $this->isInactive();
  }

  public function isInactive() {
    return $this->getStatus() == self::INACTIVE;
  }

  public function isArchive() {
    return $this->getStatus() == self::ARCHIVE;
  }

  public function getTeacherName() {

    return $this->getTeacher()->getFirstAndLastName();
  }

  /**
   * Sprawdza, czy ustawione są prawa 'teacher_demo', w celu ustalenia, czy 
   * powinien się pokazywać przycisk "Nowy" na liście gier.
   * @return boolean
   */
  public function isTeacherDemoNew() {
    return false;
  }

  public function getStatusText() {
    $statuses = self::returnAvailableStatus();
    
    return $statuses[$this->getStatus()];
  }

  public function getUsersCount() {
    $id = $this->getId();
      
//    $count = Doctrine_Core::getTable('UserTeam')->createQuery('ut')
//            ->leftJoin('ut.Team t')
//            ->where('t.game_id = ?', $id)
//            ->count();
    
    $teams = $this->getTeams();

    $count = 0; 
    foreach ($teams as $team){
      $count += $team->getUserHasTeams()->count(); 
    }
    
    return $count;
  }

  public function getTeamsCount() {
    return $this->getTeams()->count();
  }
  /**
   * Zwraca dostępne statusy do formularzy. 
   * 
   * @return array
   */
  public static function returnAvailableStatus() {
    return array(
        0 => __('Nieaktywna'),
        1 => __('Aktywna'),
        2 => __('Archiwum'),
        3 => __('Przygotowana')
    );
  }

  public function getRoundNum() {
    
//    return 1;
    
    $team = $this->getTeams()->getFirst();
//    $team = Doctrine::getTable('Team')->findOneByGameId($this->getId());

    if (isset($team) && $team) {
//      $activeRound = Doctrine::getTable('Round')
//              ->createQuery('r')
//              ->where('r.team_id = ?', $team->getId())
//              ->andWhere('r.status = ?', Round::ACTIVE)
//              ->fetchOne();

      $activeRound = $this->getTeams()->getFirst()->getRounds()->getLast();
//              ->getFirst(); 
              
              
              
      if (isset($activeRound) && $activeRound) {
        return $activeRound->getRoundNumber();
      }
      else
        return 0;
    }
  }

}