<?php

/**
 * GameTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class GameTable extends artDoctrineTable {

  /**
   * Returns an instance of this class.
   *
   * @return object GameTable
   */
  public static function getInstance() {
    return Doctrine_Core::getTable('Game');
  }

  /**
   * Ustawia filtr na statusie klasy.
   * 
   * @return ;
   */
  public static function setStatusFilter($query, $value) {
    $rootAlias = $query->getRootAlias();

    $query->andWhereIn($rootAlias . '.status', $value);

    return $query;
  }

  /**
   * Pobiera listę gier dla danego nauczyciela. GENERATOR
   * 
   * @return ;
   */
  public function getGamesForTeacher($teacherId = false) {
    if ($teacherId) {
      $teacherId = sfContext::getInstance()->getUser()->getId();
    }
    return Doctrine_Core::getTable('Game')->createQuery('g')
            ->leftJoin('g.Teacher t')
            ->leftJoin('g.teams gt')
            ->leftJoin('gt.rounds gr')
            ->leftJoin('gt.user_has_teams guht')
            ->where('g.teacher_id = ?', $teacherId);
  }

  /**
   * Pobiera listę gier dla danego nauczyciela. GENERATOR
   * 
   * @return ;
   */
  public function getPanelGames() {
    $user = sfContext::getInstance()->getUser();
    if ($user->isTeacher()) {
      $teacherId = $user->getId();
    } else {
      $teacherId = -1;
    }
    return $this->createQuery('g')
            ->select('g.id, g.name, g.created_at, g.status, t.id, gt.id, gr.id, gr.round_number, gr.status')
            ->leftJoin('g.Teacher t')
            ->leftJoin('g.teams gt')
            ->leftJoin('gt.rounds gr')
            ->where('g.teacher_id = ?', $teacherId)
            ->andWhere('g.status <> ?', Game::ARCHIVE);
  }
  
  /**
   * Pobiera listę gier zarchiwizowanych dla danego nauczyciela. GENERATOR
   * 
   * @return ;
   */
  public function getPanelGamesArchive() {
    $user = sfContext::getInstance()->getUser();
    if ($user->isTeacher()) {
      $teacherId = $user->getId();
    } else {
      $teacherId = -1;
    }
    return $this->createQuery('g')
            ->select('g.id, g.name, g.created_at, g.status, t.id ')
            ->leftJoin('g.Teacher t')
            ->leftJoin('g.teams gt')
            ->leftJoin('gt.rounds gr')
            ->where('g.teacher_id = ?', $teacherId)
            ->andWhere('g.status = ?', Game::ARCHIVE);
  }

  /**
   * Zlicza ilość gier dla nauczyciela - przydatne dla konta TEACHER_DEMO,
   * gdzie dostępna jest tylko jedna gra. 
   * 
   * @return int liczba gier;
   */
  public function getGamesCountForTeacher($teacherId = false) {
    if ($teacherId) {
      $teacherId = sfContext::getInstance()->getUser()->getId();
    }
    return Doctrine_Core::getTable('Game')->createQuery('g')
            ->where('g.teacher_id = ?', $teacherId)
            ->count();
  }

  /**
   * Pobiera listę wszystkich gier dla administratora. GENERATOR
   * 
   * @return ;
   */
  public function getGamesForAdmin() {
    return Doctrine_Core::getTable('Game')->createQuery('g')
            ->leftJoin('g.Teacher teach')
            ->leftJoin('g.teams t')
            ->leftJoin('t.rounds r')
            ->leftJoin('t.rounds r2 ON (t.id = r2.team_id AND r2.round_number > r.round_number)')
            ->andWhere('r2.team_id IS NULL')
    ;
  }

}
