<?php

/**
 * LogDecision
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    hotel
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
class LogDecision extends BaseLogDecision
{
  
  public function getValueString($decision, $value) {
    
    $badania = array(
      'badanie_marketingowe_popyt_standard',
      'badanie_marketingowe_uslugi_podstawowe',
      'badanie_marketingowe_sezonowosc',
      'badanie_marketingowe_popyt_lux',
      'badanie_marketingowe_reklama_zaawansowana',
      'badanie_marketingowe_konkurencja',
      'badanie_marketingowe_uslugi_zaawansowane_segmentacja'
    );
    
    $takNie = array(
      'taxi',
      'sejf',
      'budzenie',
      'rejestracja_na_stronie_www',
      'wspolpraca_urzad_pracy',
      'wspolpraca_biurami_podrozy',
      'mozliwosc_odebrania_gosci',
      'ochronka_dla_dzieci',
      'business_lounge',
      'sala_konferencyjna',
      'automaty_vendingowe',
      'ekspresy_czajniki',
      'pokoj_zabaw_dla_dzieci',
      'golf',
      'wyciag_narciarski',
      'plaza',
      'event_festiwal_filmowy',
      'event_zimowisko',
      'event_podjazd_dla_niepelnosprawnych',
      'event_pralnia_ekologiczna',
      'event_akcja_charytatywna',
      'event_stop_umowom_smieciowym',
      'event_mikolajkowy_ekspres',
      'event_szkolenie',
      'wybor_loga'
    );
    
    $procent = array(
      'pracownicy_obslugi_motywacja_procent',
      'pracownicy_administracji_motywacja_procent'
    );
    
    if (in_array($decision, $badania)) {
      if ($value) {
        return 'Kupiono';
      } else {
        return 'Brak';
      }
    }
    
    if (in_array($decision, $takNie)) {
      if ($value) {
        return 'Tak';
      } else {
        return 'Nie';
      }
    }
    
    if (in_array($decision, $procent)) {
      if (empty($value)) {
        return '0 %';
      } else {
        return $value.' %';
      }
    }
    
    if ($decision == 'event_sadzenie_drzew') {
      $decyzje = HotelGameDecision::getSadzenieDrzew();
      if (isset($decyzje[$value])) {
        return $decyzje[$value];
      } else {
        return 'Brak';
      }
    }
    if ($decision == 'strona_internetowa') {
      $decyzje = HotelGameDecision::getStronaInternetowa();
      if (isset($decyzje[$value])) {
        return $decyzje[$value]['log_label'];
      } else {
        return 'Brak';
      }
    }
    if ($decision == 'event_kierowniczka') {
      $decyzje = HotelGameDecision::getKierowniczka();
      if (isset($decyzje[$value])) {
        return $decyzje[$value];
      } else {
        return 'Brak';
      }
    }
    if ($decision == 'wybor_lokalizacji') {
      $decyzje = HotelGameDecision::getLokalizacje();
      if (isset($decyzje[$value])) {
        return $decyzje[$value]['log_label'];
      } else {
        return 'Brak';
      }
    }
    if ($decision == 'pokoje_standard_wyposazenie') {
      $decyzje = HotelGameDecision::getWyposazenieStandard();
      if (isset($decyzje[$value])) {
        return $decyzje[$value]['log_label'];
      } else {
        return 'Brak';
      }
    }
    if ($decision == 'pokoje_lux_wyposazenie') {
      $decyzje = HotelGameDecision::getWyposazenieLux();
      if (isset($decyzje[$value])) {
        return $decyzje[$value]['log_label'];
      } else {
        return 'Brak';
      }
    }
    
    if ($decision == 'komiks') {
      if ($value) {
        return 'Przeczytany';
      } else {
        return 'Nie przeczytany';
      }
    }
    
    if ($decision == 'nazwa_marki') {
      if ($value) {
        return $value;
      } else {
        return 'Brak';
      }
    }
    
    return $value;
  }
}
