<?php

/**
 * LogEventTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class LogEventTable extends artDoctrineTable
{
    /**
     * Returns an instance of this class.
     *
     * @return object LogEventTable
     */
    public static function getInstance()
    {
        return Doctrine_Core::getTable('LogEvent');
    }
    
    public function getBackendLogEvent() {
      $gameId = sfContext::getInstance()->getUser()->getAttribute('game_id', false);
      
      $query = $this->getInstance()
              ->createQuery('le')
              ->leftJoin('le.Round r')
              ->leftJoin('le.Team t')
              ->leftJoin('le.User u')
              ->leftJoin('t.Game g');
      if ($gameId) {
        $query->where('g.id = ?', $gameId);
      }
      
      return $query;
    }
    
    
    public function deleteByGameId($gameId) {
       $logEvents = $this->createQuery('le')
              ->select('le.id')
              ->leftJoin('le.Team t')
              ->leftJoin('t.Game g')
              ->where('g.id = ?', $gameId)
              ->execute(array(), Doctrine_Core::HYDRATE_SINGLE_SCALAR);
       
        return $this->createQuery('le')
               ->delete()
               ->whereIn('le.id', $logEvents)
               ->execute();
    }
}