<?php

/**
 * MessageTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class MessageTable extends artDoctrineTable {

  /**
   * Returns an instance of this class.
   *
   * @return object MessageTable
   */
  public static function getInstance() {
    return Doctrine_Core::getTable('Message');
  }

  /**
   * Zwraca listę wiadomości w Grze dla Użytkownika. (EVENTY + WIADOMOŚCI)
   *
   * @param $teamId, id zespołu do którego należy użytkownik.
   * @param $userId, id użytkownika.
   *
   * @return Doctrine_Collection, Kolekcja z wiadomosciami.
   */
  public function getUserMessages($teamId, $userId, $status = null, $filters = null) {

    $query = $this->createQuery('m')
            ->where('m.user_id = ?', $userId)
            ->andWhere('m.team_id = ?', $teamId);

    if (!is_null($filters)) {

      if ($filters === 'message') {
        $query->andWhereIn('m.category', array(HotelGameMessage::CATEGORY));
      }

      if ($filters === 'event') {
        $query->andWhereIn('m.category', array(HotelGameMessage::EVENT_CATEGORY));
      }
    } else {
      $query->andWhereIn('m.category', array(HotelGameMessage::CATEGORY, HotelGameMessage::EVENT_CATEGORY));
    }

    if (!is_null($status)) {
      $query->andWhere('m.status = ? ', $status);
    }

    $query->orderBy('m.created_at DESC');
    return $query->execute();
  }

  /**
   * 
   * @param type $roundId
   * @param type $teamId
   * @param type $userId
   * 
   * @return type
   */
  public function getUserUnreadMessagesForRoundId($roundId, $teamId, $userId) {

    $query = $this->createQuery('m')
            ->where('m.user_id = ?', $userId)
            ->andWhere('m.team_id = ?', $teamId);
    
    $query->andWhereIn('m.category', array(HotelGameMessage::CATEGORY, HotelGameMessage::EVENT_CATEGORY));
    
    $query->andWhere('m.status = ?', HotelGameMessage::NOT_READ);
    
    $query->andWhere('m.round_id = ?', $roundId);
    
    return $query->execute();
  }

  /**
   * Zwraca listę eventów w Grze dla Użytkownika.
   *
   * @param $teamId, id zespołu do którego należy użytkownik.
   * @param $userId, id użytkownika.
   *
   * @return Doctrine_Collection, Kolekcja z wiadomosciami.
   */
  public function getUserEvents($teamId, $userId, $round, $status = null) {
    $query = $this->createQuery('m')
            ->leftJoin('m.Round r')
            ->where('m.user_id = ?', $userId)
            ->andWhere('m.team_id = ?', $teamId)
            ->andWhere('m.category = ?', HotelGameMessage::EVENT_CATEGORY);

    if (!is_null($status)) {
      $query->andWhere('m.status = ?', $status);
    }
    $query->orderBy('m.created_at DESC');
    return $query->execute();
  }

  /**
   * Funkcja usuwa wszystkie wiadomosci dla danej gry. Wiadomosci sa wyszukiwane po
   * polaczeniu Message - Team - Game.
   * @param int $gameId ID Gry
   */
  public function deleteByGameId($gameId) {
    $messages = $this->getInstance()->createQuery('m')
            ->select('id')
            ->leftJoin('m.Team t')
            ->where('t.game_id = ?', $gameId)
            ->execute(array(), Doctrine::HYDRATE_SINGLE_SCALAR);

    if (count($messages) > 0) {
      $this->getInstance()->createQuery('m')
              ->delete()
              ->whereIn('m.id', $messages)
              ->execute();
    }
  }

}