<?php

/**
 * RoundTable
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 */
class RoundTable extends artDoctrineTable {
  //public function getTeacherRounds() {
//
//$gameId = sfContext::getInstance()->getUser()->getAttribute('game_id', false);
//
//return Doctrine_Query::create()
//->select('name')
////                    ->distinct()
//->from('Round')
//->leftJoin('Team t')
//->andWhere('t.game_id = ? ', $gameId)
//->groupBy('name')
//->execute();
//
//
//$gameId = sfContext::getInstance()->getUser()->getAttribute('game_id', false);
//
//
//$teams = Doctrine::getTable('Team')->getTeacherTeams();
//
//$ids = array();
//
//foreach ($teams->toArray() as $array){
//$ids[] = $array['id'];
//}
//
//return Doctrine_Query::create()
//->select('*')
//->from('Round')
//->leftJoin('Team t')
//->andWhere('t.game_id = ?', $gameId)
//->andWhereIn('t.id', $ids)
//->execute();
//}
//}

  /**
   * Returns an instance of this class.
   *
   * @return object RoundTable
   */
  public static function getInstance() {
    return Doctrine_Core::getTable('Round');
  }

  /**
   * Funkcja usuwa wszystkie rundy dla danej gry. Rundy sa wyszukiwane po
   * polaczeniu Round - Team - Game.
   * @param int $gameId ID Gry
   */
  public function deleteByGameId($gameId) {
    $rounds = $this->getInstance()->createQuery('r')
            ->select('id')
            ->leftJoin('r.Team t')
            ->where('t.game_id = ?', $gameId)
            ->execute(array(), Doctrine::HYDRATE_SINGLE_SCALAR);

    if (count($rounds) > 0) {
      $this->getInstance()->createQuery('r')
              ->delete()
              ->whereIn('r.id', $rounds)
              ->execute();
    }
  }

  /**
   * Funkcja pobiera aktywna runde dla danej gry
   * @param int $gameId ID Gry
   */
  public function getActiveRoundByGameId($gameId) {
    $round = $this->getInstance()->createQuery('r')
            ->leftJoin('r.Team t')
            ->where('r.status = ?', Round::ACTIVE)
            ->andWhere('t.game_id = ?', $gameId)
            ->fetchOne();

    return $round;
  }

  public static function getRoundsForGame($gameId = null) {
    $query = Doctrine::getTable('round')->createQuery('r')
            ->leftJoin('r.Team t')
            ->where('t.game_id = ?', $gameId);

    return $query->execute();
  }

}